<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
    <cv:cvMessages bundle="localization.users"></cv:cvMessages>
    <cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
</script>

<div>
    <div class="row">
        <div class="col-xs-12 padding-bottom-20">
            <h1 class="page-title"><cv:msg key="label.serviceCommcellProperties" bundle="commcell" /></h1>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-md-6">
            <cv-tile-component ac-id="serviceCommcellDetails-serviceCommcellInfo" title="Commcell info" data-loader="servCommDetails.commcellProperties">
                <ul class="list-style-secondary">
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="label.commcellName" bundle="commcell" /></span>
                        <span data-ng-if="servCommDetails.commcellProperties.commcellType != 5" class="pageDetailColumn" ng-bind="servCommDetails.commcellProperties.commcellName"></span>
                        <span data-ng-if="servCommDetails.commcellProperties.commcellType == 5" class="pageDetailColumn"> <cv:msg key="label.nav.Metallic" bundle="navJs" /></span>
                    </li>
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="label.webconsoleUrl" bundle="users" /></span>
                        <a href="{{ servCommDetails.commcellProperties.webconsoleUrl }}" title="{{ servCommDetails.commcellProperties.webconsoleUrl }}" class="pageDetailColumn" ng-bind="servCommDetails.commcellProperties.webconsoleUrl"></a>
                    </li>
                    <li class="group" ng-if="servCommDetails.commcellProperties.csVersionInfo">
                        <span class="pageDetailColumn"><cv:msg key="header.Version" bundle="clients" /></span>
                        <span class="pageDetailColumn" ng-bind="servCommDetails.commcellProperties.csVersionInfo | getVersionString"></span>
                    </li>
                    <li class="group" data-ng-if="servCommDetails.commcellProperties">
                        <span class="pageDetailColumn"><cv:msg key="label.serviceCommcellUseGlobalCC" bundle="commcell" /></span>
                        <cv-toggle toggle-name="globalWebConsoleConfigured" property="servCommDetails.commcellProperties.isGlobalWebConsoleConfigured" is-disabled="true"></cv-toggle>
                    </li>
                    <li class="group" data-ng-if="servCommDetails.commcellProperties.isGlobalWebConsoleConfigured && servCommDetails.commcellProperties.globalWebconsoleStatusMessage.length > 0">
                        <span class="pageDetailColumn"><cv:msg key="label.serviceCommcellStatusForUniversalCC" bundle="commcell" /></span>
                        <span class="pageDetailColumn" ng-bind="servCommDetails.commcellProperties.globalWebconsoleStatusMessage"></span>
                    </li>
                </ul>
                <div class="page-details-box-links" ng-if="servCommDetails.isEditOptionAvailable"><a href="" data-ng-click="servCommDetails.showEditCommcellPropertiesModal()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
            </cv-tile-component>
        </div>
    </div>
    <cv-kendo-grid ng-if="servCommDetails.commcellAssociations" cv-grid-options="servCommDetails.gridOptions"></cv-kendo-grid>
</div>