<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.commcell.add" bundle="commcell"></cv:msg>
	</h1>
</div>
<form name="registerRouterCommcell" cv-hide-api data-cv-submit="regCcCtrl.registerCommcell()" novalidate autocomplete="off">
	<div class="bootstrap-wrapper">
		<div class="text-center {{regCcCtrl.model.serverMessage.type}} col-sm-12" data-ng-if="regCcCtrl.model.serverMessage.message"
				data-ng-bind="regCcCtrl.model.serverMessage.message"></div>
		<div class="panel-body">
			<div class="padding-left-20 padding-right-20">
				<div class="select-icon-longDesc">
					<label class="row select-oneType" ng-click="regCcCtrl.registerAsGlobalIdP(false)" ng-class="{ 'checked': !regCcCtrl.model.isGlobalIDPCommcell }">
						<div class="col-md-2">
							<div class="commcell-icon-container" ng-bind-html="regCcCtrl.routerCommcellIcon"></div>
						</div>
						<div class="col-md-10 select-desc">
							<h4 class="margin-top-0"><cv:msg key="header.routerCommcellOption" bundle="commcell" /></h4>
							<span><cv:msg key="description.routerCommcellOption" bundle="commcell" /></span>
						</div>
					</label>
					<label class="row select-oneType" ng-click="regCcCtrl.registerAsGlobalIdP(true)" ng-class="{ 'checked': regCcCtrl.model.isGlobalIDPCommcell }">
						<div class="col-md-2">
							<div class="commcell-icon-container" ng-bind-html="regCcCtrl.idpCommcellIcon"></div>
						</div>
						<div class="col-md-10 select-desc">
							<h4 class="margin-top-0"><cv:msg key="header.idpCommcellOption" bundle="commcell" /></h4>
							<span><cv:msg key="description.idpCommcellOption" bundle="commcell" /></span>
						</div>
					</label>
				</div>
			</div>
			<div class="padding-left-20 padding-right-20 margin-top-10">
				<div class="form-group row margin-top-10">
					<div class="col-sm-5">
						<label for="commcellHostName"><cv:msg key="label.serviceCommcellHostName" bundle="commcell"></cv:msg></label>
					</div>
					<div class="col-sm-7">
						<input type="text" data-ng-model="regCcCtrl.model.commcellHostname" id="commcellHostName" name="commcellHostname" autofocus required/>
						<span class="help-block" data-ng-show="cv.registerRouterCommcell.needsAttention(registerRouterCommcell.commcellHostname)"><cv:msg key="error.specifyCommcellName" bundle="commcell" /></span>
					</div>
				</div>
				<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for register commcell-->
				<input data-ng-hide="true" type="text" name="fakeusernameremembered"/>
				<input data-ng-hide="true" type="password" name="fakepasswordremembered"/>

				<div class="form-group row">
					<div class="col-sm-5">
						<label for="userName"><cv:msg key="label.register.username" bundle="commcell"/>
					</div>
					<div class="col-sm-7">
						<input type="text" name="userName" id="userName" data-ng-model="regCcCtrl.model.username" autoCompleteType="disable" autocomplete="none" required/>
						<span class="help-block" data-ng-show="cv.registerRouterCommcell.needsAttention(registerRouterCommcell.userName)"><cv:msg key="error.userName" bundle="servers" /></span>
					</div>
				</div>

				<div class="form-group row">
					<div class="col-sm-5">
						<label for="password"><cv:msg key="label.password" bundle="servers"/>
					</div>
				<div class="col-sm-7">
					<input type="password" name="password" id="password" data-ng-model="regCcCtrl.model.password" autoCompleteType="disable" autocomplete="off" />
					</div>
				</div>
				<div class="form-group row" ng-if="${cvConfig.isMCCDynamicAppEnabled()} && regCcCtrl.model.isGlobalIDPCommcell">
					<div class="col-xs-12 margin-top-15">
						<cv-toggle toggle-name="enableGlobalCC"
							toggle-label="label.configureAsGlobalCC"
							value="regCcCtrl.model.isGlobalWebConsoleConfigured"
							help-text="'label.configureAsGlobalCC.helpText'"
							help-direction="top"
							is-disabled="!(regCcCtrl.enabledCCForGlobalCC && regCcCtrl.enabledCCForGlobalCC.length > 0) || !regCcCtrl.model.isGlobalIDPCommcell"
						></cv-toggle>
						<label data-ng-show="regCcCtrl.enabledCCForGlobalCC && regCcCtrl.enabledCCForGlobalCC.length > 0 && !regCcCtrl.model.isGlobalIDPCommcell">
								<cv-help-component help-text="<cv:msg key="help.configureAsGlobalCC.IDPNotEnabled" bundle="commcell"/>" help-placement="right"></cv-help-component>
						</label>

						<label data-ng-show="!(regCcCtrl.enabledCCForGlobalCC && regCcCtrl.enabledCCForGlobalCC.length > 0)">
							<span>
									<a href="" data-ng-click="regCcCtrl.openConfigureGlobalCCModal()"><cv:msg key="label.selectConfigureAsGlobalCC" bundle="commcell" /></a>
								</span>
								<cv-help-component help-text="<cv:msg key="help.configureAsGlobalCC.noGlobalCCsConfigured" bundle="commcell"/>" help-placement="right"></cv-help-component>
						</label>
					</div>
				</div>
			</div>
		</div>
      	<div class="modal-footer">
			<button id="registerRouterCommcell_button_#6598" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="regCcCtrl.close()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="registerRouterCommcell_button_#4360" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button>
		</div>
</div>
</form>