import 'modules/commcellRegistration/js/factory/serviceCommcell.constant.js';

import { acAppSecurityModule } from 'common/js/modules';

var commcellRegistrationMod = acAppSecurityModule;

commcellRegistrationMod.service('commcellRegistrationService', [
	'$http',
	'serviceCommcellConstants',
	function($http, serviceCommcellConstants) {
		this.getRegisteredCommcells = function() {
			return $http.get('getRegisteredCommcells.do');
		};

		this.registerCommcell = function(param) {
			return $http.post('registerRemoteCommcell.do', {
				commcellHostname: param.commcellHostname,
				username: param.username,
				password: Base64.encode(param.password),
				isGlobalIDPCommcell: param.isGlobalIDPCommcell,
				enableRoutingFlag: param.enableRoutingFlag,
				isGlobalWebConsoleConfigured: param.isGlobalWebConsoleConfigured
			});
		};

		this.unRegisterCommcell = function(request) {
			return $http.post(
				cv.contextPath + '/proxy/UnRegisterCommCell',
				JSON.stringify(request),
				httpHeader.jsonDefaultHeader
			);
		};

		this.syncUsersFromServiceCommcell = function(csGuid) {
			return $http.get(cv.contextPath + '/api/RouterCommcell/SyncUserSpace?commcellGUID=' + encodeURIComponent(csGuid));
		};

		this.getCommcellAssociations = function() {
			return $http.get(`${cv.contextPath}/api/Security/MultiCommcell`);
		};

		this.setCommcellAssociations = function(associations, serviceCommcellId, organizationId) {
			return $http.post(
				`${cv.contextPath}/api/Security/MultiCommcell`,
				JSON.stringify({
					associations,
					associationsOperationType: serviceCommcellConstants.OPERATION_TYPE_MODIFY,
					serviceCommcellId,
					organizationId
				}),
				{
					headers: {
						'Content-Type': 'application/json',
						Accept: 'application/json'
					}
				}
			);
		};

		this.getCommcellProperties = commcellId => {
			return $http.get(`${cv.contextPath}/proxy/ServiceCommcell/Properties?commcellId=${commcellId}`);
		};

		this.synchronizeDynamicApps = function(associations, serviceCommcellId, organizationId) {
			return $http.post('synchronizeDynamicApps.do');
		};

		this.saveCommcellProperties = properties => {
			return $http.post('proxy/ServiceCommcell/Properties', JSON.stringify(properties), httpHeader.jsonDefaultHeader);
		};
	}
]);

export default commcellRegistrationMod;
