export const syncStatusLabels = {
	FAILED_SHORT: 'syncStatus.short.failed',
	SUCCESS_SHORT: 'syncStatus.short.successful',
	NOT_SYNCED: 'label.notSynced',
	NOT_APPLICABLE: 'label.notApplicable',
	FAILED_FULL: 'syncStatus.complete.failed',
	SUCCESS_FULL: 'syncStatus.complete.successful'
};

export const commonMarkupUtils = {
	getStatusClass: status => {
		switch (status) {
			case -1:
				return 'red-font';
			case 0:
				return '';
			case 1:
				return 'green-font';
		}
	},
	getLocalizedStatus: (cvLoc, status, isSyncApplicable = true) => {
		if (!isSyncApplicable) {
			return cvLoc(syncStatusLabels.NOT_APPLICABLE);
		} else {
			if (_.isUndefined(status)) return cvLoc(syncStatusLabels.NOT_SYNCED);
			switch (status) {
				case -1:
					return cvLoc(syncStatusLabels.FAILED_SHORT);
				case 0:
					return cvLoc(syncStatusLabels.NOT_SYNCED);
				case 1:
					return cvLoc(syncStatusLabels.SUCCESS_SHORT);
			}
		}
	},
	getCompleteStatus: (cvLoc, status) => {
		if (_.isUndefined(status)) return cvLoc('label.notSynced');
		switch (status) {
			case -1:
				return cvLoc(syncStatusLabels.FAILED_FULL);
			case 0:
				return cvLoc(syncStatusLabels.NOT_SYNCED);
			case 1:
				return cvLoc(syncStatusLabels.SUCCESS_FULL);
		}
	}
};

export const serviceCommcellCallouts = {
	getSyncStatusTemplate: (cvLoc, syncStatus, time) => `
            <div class="interactive-tooltip-model">
                <div class="list-call-out">
                    <h4 class="margin-bottom-0 margin-left-5 subtitle ${commonMarkupUtils.getStatusClass(
											syncStatus.status
										)}">
                        ${commonMarkupUtils.getCompleteStatus(cvLoc, syncStatus.status)}
                    </h4>
                    <ul class="list-style-secondary list-container padding-left-0 padding-right-0">
                        <li class="group margin-left-5">
                            <span class="pageDetailColumn padding-0">${cvLoc('header.lastSyncWithIDP')}</span>
                            <span class="pageDetailColumn padding-0 text-muted">${time}</span>
                        </li>
                        ${
													syncStatus.entityErrorResponses && syncStatus.entityErrorResponses.length > 0
														? serviceCommcellCallouts.getFailureReasonsTemplate(cvLoc, syncStatus.entityErrorResponses)
														: ''
												}
                    </ul>
                </div>
            </div>
        `,
	getFailureReasonsTemplate: (cvLoc, entityErrorResponses) => {
		let header = `<h5
                            class="titleForBoxOrList margin-bottom-5 margin-top-5 padding-left-5"
                        >
                            ${cvLoc('header.failureReasons')}
                        </h5>`,
			template = ``;
		entityErrorResponses.forEach(entityErrorResponse => {
			let entityName = entityErrorResponse.entity.entityTypeName;
			let failureReason = entityErrorResponse.entityErrorMessage;
			template = `${template}
                    <li class="group">
                        <span class="pageDetailColumn">${entityName}</span>
                        <span class="pageDetailColumn">${failureReason}</span>
                    </li>
                `;
		});

		return `${header}<div class="margin-left-5">${template}</div>`;
	}
};
