import 'dlo/js/constants/serviceType.constant.js';
import 'modules/commcellRegistration/js/controllers/editCommcellProperties.ctrl.js';

import { acAppSecurityModule } from 'common/js/modules';

var commcellRegistrationMod = acAppSecurityModule;

class serviceCommcellDetails {
	constructor(
		cvBreadcrumbsTabsFactory,
		cvLoc,
		settingsService,
		cvToaster,
		$dialogs,
		$modal,
		commcellRegistrationFactory,
		commcellRegistrationService,
		$state,
		serviceCommcellConstants,
		serviceType,
		multiCommcellFactory,
		commcellRole
	) {
		this.cvBreadcrumbsFactory = cvBreadcrumbsTabsFactory;
		this.cvLoc = cvLoc;
		this.cvToaster = cvToaster;
		this.$dialogs = $dialogs;
		this.$modal = $modal;
		this.settingsService = settingsService;
		this.commcellRegistrationFactory = commcellRegistrationFactory;
		this.commcellRegistrationService = commcellRegistrationService;
		this.serviceCommcellConstants = serviceCommcellConstants;
		this.$state = $state;
		this.commcellId = parseInt($state.params.id);
		this.serviceType = serviceType;
		this.multiCommcellFactory = multiCommcellFactory;
		this.commcellRole = commcellRole;

		this._setBreadCrumbs();
		this._initPage();
	}

	_setBreadCrumbs() {
		let breadCrumbs = [];

		breadCrumbs.push(
			{
				title: this.cvLoc('label.nav.system'),
				link: '#nav/settings'
			},
			{
				title: 'Service commcells',
				link: '#serviceCommcells'
			}
		);

		this.cvBreadcrumbsFactory.addBreadCrumbs(breadCrumbs);
	}

	_initPage() {
		this.settingsService
			.getCommserveDetails()
			.success(response => {
				this.commservDetails = response;
			})
			.error(e => {
				this.cvToaster.showErrorMessage({
					message: _.get(e, 'errorMessage') || e || this.cvLoc('generic_error'),
					ttl: '5000'
				});
			});

		this.commcellRegistrationService.getCommcellProperties(this.commcellId).success(response => {
			this.commcellProperties = _.get(response, 'properties');
			this.commcellAssociations = _.get(response, 'associations', []);
			this._initGrid();
			this._setFlags();
		});
	}

	_initGrid() {
		let self = this;
		this.gridOptions = {
			gridTitle: this.cvLoc('header.associatedUsers'),
			tableName: 'commcellAssociatedCompanies',
			hasDefaultView: true,
			enablePaging: true,
			enableCheckBoxColumn: false,
			pageSize: 20,
			cvOnGridEmpty: this.cvLoc('info.noSecurityAssociationsDefined'),
			columns: this._getColumnDefinitions(),
			url: this._getGroupedAssociations.bind(this),
			beforeGridInitialize: ({ grid }) => {
				self.grid = grid;
			},
			gridToolbarMenu: [
				{
					id: 'addEditSecurity',
					label: this.cvLoc('label.editClientGroupAssociations'),
					hidden: !cv.isMspAdmin,
					onSelect: event => {
						self.commcellRegistrationFactory
							.editAssociations(
								self.commcellRegistrationFactory.registeredCommcellList,
								self.commcellAssociations,
								self.commcellId,
								_.get(self.commcellProperties, 'commcellName')
							)
							.then(data => {
								self.$state.forceReload();
							});
					}
				}
			]
		};
	}

	_getColumnDefinitions() {
		return {
			name: {
				title: this.cvLoc('label.name'),
				width: '30%',
				template: dataItem => {
					let anchorTagTemplate;
					switch (dataItem.userOrGroup._type_) {
						case this.serviceCommcellConstants.USER_GROUP_TYPE:
							anchorTagTemplate = `<a href="\#/userGroup/${dataItem.userOrGroup.userGroupId}">${dataItem.userOrGroup.userGroupName}</a>`;
							break;
						case this.serviceCommcellConstants.USER_TYPE:
							anchorTagTemplate = `<a href="\#/users/${dataItem.userOrGroup.userId}">${dataItem.userOrGroup.userName}</a>`;
							break;
						default:
							let stateUrl = this.commcellRegistrationFactory.getUrlForProviderType(
								dataItem.userOrGroup,
								dataItem.providerType
							);
							anchorTagTemplate = `<a href="\#/${stateUrl}">${dataItem.userOrGroup.providerDomainName}</a>`;
					}
					return `<span class="crop">${anchorTagTemplate}</span>`;
				}
			},
			entityType: {
				title: this.cvLoc('label.type'),
				type: 'string',
				width: '30%'
			}
		};
	}

	_getGroupedAssociations(options) {
		_.forEach(this.commcellAssociations, association => {
			association.name =
				association.userOrGroup.userGroupName ||
				association.userOrGroup.userName ||
				association.userOrGroup.providerDomainName ||
				'';
			switch (association.userOrGroup._type_) {
				case this.serviceCommcellConstants.USER_GROUP_TYPE:
					association.entityType = this.cvLoc('label.userGroup');
					break;
				case this.serviceCommcellConstants.USER_TYPE:
					association.entityType = this.cvLoc('label.user');
					break;
				default:
					association.entityType = this.commcellRegistrationFactory.getProviderEntityTypeName(association.providerType);
			}
		});

		options.success(this.commcellAssociations);
	}

	_setFlags() {
		// Allowing edit option only for service commcells registered for IdP routing
		this.isEditOptionAvailable = this.multiCommcellFactory.checkRoleExist(
			this.commcellProperties.commcellRoleInt,
			this.commcellRole.IDPCOMMCELL_SERVICECOMMCELL
		);
	}

	showEditCommcellPropertiesModal() {
		let modalInstance = this.$modal.open({
			templateUrl: appUtil.appRoot + 'modules/commcellRegistration/partials/editCommcellProperties.jsp',
			windowClass: 'small-size',
			controller: 'editCommcellPropertiesController',
			controllerAs: 'editCCProperties',
			resolve: {
				commcellProperties: () => this.commcellProperties,
				commcellId: () => this.commcellId
			}
		});

		modalInstance.result.then(updatedProperties => {
			// Only service provider endpoint update is available now, hence only that is being set here
			this.commcellProperties.webconsoleUrl = updatedProperties.webconsoleUrl;
		});
	}
}

serviceCommcellDetails.$inject = [
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'settingsService',
	'cvToaster',
	'$dialogs',
	'$uibModal',
	'commcellRegistrationFactory',
	'commcellRegistrationService',
	'$state',
	'serviceCommcellConstants',
	'serviceType',
	'multiCommcellFactory',
	'commcellRole'
];

commcellRegistrationMod.controller('serviceCommcellDetails', serviceCommcellDetails);

export default commcellRegistrationMod;
