import { acAppSecurityModule } from 'common/js/modules';

class EditAssociationsController {
	constructor(
		subscriptionId,
		associatedCommcells,
		cvLoc,
		commcellRegistrationService,
		serviceCommcellConstants,
		ENTITY_TYPES,
		$modalInstance,
		subscriptionName,
		cvUtil
	) {
		this.subscriptionId = parseInt(subscriptionId);
		this.subscriptionName = subscriptionName;
		this.associatedCommcells = associatedCommcells;
		this.cvLoc = cvLoc;
		this.commcellRegistrationService = commcellRegistrationService;
		this.serviceCommcellConstants = serviceCommcellConstants;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.$modalInstance = $modalInstance;
		this.cvUtil = cvUtil;

		this.serverMessage = {};

		this._fetchCommcells();
		this._initModal();
	}

	_initModal() {
		this.labelConfigCommcell = {
			nothingSelected: this.cvLoc('label.selectCommcellForDropdown')
		};

		this.serverMessage = this.cvUtil.infoMsg('Loading');
	}

	_fetchCommcells() {
		this.commcellsList = [];

		this.groupedCommcells = _.groupBy(this.associatedCommcells, commcell => commcell.commCellId);
		this.commcellRegistrationService
			.getRegisteredCommcells()
			.then(response => {
				if (response.data) {
					_.forEach(response.data.commcellsList, commcell => {
						commcell.selected = !!this.groupedCommcells[_.get(commcell, 'commCell.commCellId', -1)];
						commcell.isGlobalIDPCommcell && this.commcellsList.push(commcell);
					});
				}

				this.serverMessage = this.cvUtil.emptyMsg();
			})
			.catch(err => {
				this.serverMessage = {
					type: 'error',
					message: this.cvLoc('generic_error')
				};
			});
	}

	saveAssociations() {
		let self = this;
		this.serverMessage = {};
		let associationObject = _.map(this.selectedCommcells, commcell => {
			return {
				entity: {
					entityName: commcell.commCell.commCellName,
					entityId: commcell.commCell.commCellId,
					entityType: self.serviceCommcellConstants[self.ENTITY_TYPES.SERVICE_COMMCELL_ENTITY],
					_type_: self.serviceCommcellConstants.COMMCELL_TYPE
				},
				properties: {
					role: {
						roleId: self.serviceCommcellConstants.VIEW_ROLE,
						roleName: self.serviceCommcellConstants.VIEW_ROLE_NAMESPACE
					}
				},
				userOrGroup: {
					providerDomainName: self.subscriptionName,
					providerId: self.subscriptionId,
					_type_: self.serviceCommcellConstants.PROVIDER_TYPE
				}
			};
		});

		this.commcellRegistrationService
			.setCommcellAssociations(associationObject, undefined, this.subscriptionId)
			.then(response => {
				self.$modalInstance.close(self.selectedCommcells);
			})
			.catch(err => {
				this.serverMessage = {
					type: 'error',
					message: self.cvLoc('generic_error')
				};
			});
	}

	dismissModal() {
		this.$modalInstance.dismiss();
	}
}

EditAssociationsController.$inject = [
	'subscriptionId',
	'associatedCommcells',
	'cvLoc',
	'commcellRegistrationService',
	'serviceCommcellConstants',
	'ENTITY_TYPES',
	'$uibModalInstance',
	'subscriptionName',
	'cvUtil'
];

acAppSecurityModule.controller('EditAssociationsController', EditAssociationsController);

export default acAppSecurityModule;
