(function() {
	'use strict';

	var cvCommon = angular.module('cvCommon');

	cvCommon.constant('GLOBAL_CACHE_FIELDS', {
		DEVICE: [
			{
				name: 'clientName',
				dataField: 'subClient.clientName',
				type: 0
			},
			{
				name: 'isClientDeconfigured',
				dataField: 'isClientDeconfigured',
				type: 5
			},
			{
				name: 'backupSize',
				dataField: 'backupSize',
				type: 6
			},
			{
				name: 'totalBackupSize',
				dataField: 'totalBackupSize',
				type: 6
			},
			{
				name: 'lastDataProtectedTime_time',
				dataField: 'lastDataProtectedTime.time',
				type: 5
			},
			{
				name: 'nextBackupTime_time',
				dataField: 'nextBackupTime.time',
				type: 5
			},
			{
				name: 'planName',
				dataField: 'plan.planName',
				type: 0
			},
			{
				name: 'planId',
				dataField: 'plan.planId',
				type: 0
			},
			{
				name: 'owners',
				dataField: 'clientOwners.owners',
				type: 0
			},
			{
				name: 'Data Source',
				dataField: 'Data Source',
				type: 0
			}
		],
		CLIENT: [
			{
				name: 'displayName',
				dataField: 'client.clientEntity.displayName',
				type: 0
			},
			{
				name: 'hostName',
				dataField: 'client.clientEntity.hostName',
				type: 0
			},
			{
				name: 'IsDeletedClient',
				dataField: 'clientProps.IsDeletedClient',
				type: 1
			},
			{
				name: 'idaList',
				dataField: 'client.idaList',
				type: 0
			},
			{
				name: 'OSName',
				dataField: 'client.osInfo.OsDisplayInfo.OSName',
				type: 0
			},
			{
				name: 'formattedBkt',
				dataField: 'client.idaList[0].summary.lastBackupTime',
				type: 6
			},
			{
				name: 'applicationSize',
				dataField: 'client.idaList[0].summary.size',
				type: 6
			},
			{
				name: 'slaStatus',
				dataField: 'clientProps.slaStatus',
				type: 6
			},
			{
				name: 'planName',
				dataField: 'client.idaList[0].summary.defaultBackupset.planEntity.planName',
				type: 0
			},
			{
				name: 'version',
				dataField: 'client.versionInfo.version',
				type: 0
			},
			{
				name: 'UpdateStatus',
				dataField: 'client.versionInfo.UpdateStatus',
				type: 5
			},
			{
				name: 'Data Source',
				dataField: 'Data Source',
				type: 0
			}
		],
		COMPANY: [
			{
				name: 'connectName',
				dataField: 'connectName',
				type: 0
			},
			{
				name: 'primaryContacts',
				dataField: 'primaryContacts',
				type: 0
			},
			{
				name: 'Data Source',
				dataField: 'Data Source',
				type: 0
			}
		],
		DB_INSTANCES: [
			{
				name: 'backupsetName',
				dataField: 'backupset.backupsetName',
				type: 0
			},
			{
				name: 'isCloudDB',
				dataField: 'isCloudDB',
				type: 0
			},
			{
				name: 'instanceName',
				dataField: 'instance.instanceName',
				type: 0
			},
			{
				name: 'clientName',
				dataField: 'instance.clientName',
				type: 0
			},
			{
				name: 'appName',
				dataField: 'instance.appName',
				type: 0
			},
			{
				name: 'sqlRecoveryModel',
				dataField: 'sqlRecoveryModel',
				type: 0
			},
			{
				name: 'noDBs',
				dataField: 'noDBs',
				type: 6
			},
			{
				name: 'clientType',
				dataField: 'clientType',
				type: 6
			},
			{
				name: 'instanceId',
				dataField: 'instance.instanceId',
				type: 6
			},
			{
				name: 'clientId',
				dataField: 'instance.clientId',
				type: 6
			},
			{
				name: 'applicationId',
				dataField: 'instance.applicationId',
				type: 6
			},
			{
				name: 'companyName',
				dataField: 'instance.entityInfo.companyName',
				type: 0
			},
			{
				name: 'status',
				dataField: 'status',
				type: 0
			},
			{
				name: 'backupSize',
				dataField: 'backupSize',
				type: 6
			},
			{
				name: 'applicationSize',
				dataField: 'applicationSize',
				type: 6
			},
			{
				name: 'backupTime',
				dataField: 'backupTime',
				type: 6
			},
			{
				name: 'slaStatus',
				dataField: 'slaStatus',
				type: 6
			},
			{
				name: 'sla',
				dataField: 'sla',
				type: 0
			},
			{
				name: 'planName',
				dataField: 'plan.planName',
				type: 0
			},
			{
				name: 'isSnapEnabled',
				dataField: 'isSnapEnabled',
				type: 0
			},
			{
				name: 'cloudVendorType',
				dataField: 'cloudVendorType',
				type: 6
			},
			{
				name: 'lastBackupJobInfo',
				dataField: 'lastBackupJobInfo.startTime.time',
				type: 5
			}
		],
		DB_CLONES: [
			{
				name: 'sourceInstance_instanceName',
				dataField: 'sourceInstance.instanceName',
				type: 0
			},
			{
				name: 'sourceInstance_clientName',
				dataField: 'sourceInstance.clientName',
				type: 0
			},
			{
				name: 'targetInstance_instanceName',
				dataField: 'targetInstance.instanceName',
				type: 0
			},
			{
				name: 'targetInstance_clientName',
				dataField: 'targetInstance.clientName',
				type: 0
			},
			{
				name: 'cloneJobId',
				dataField: 'cloneJobId',
				type: 6
			},
			{
				name: 'cloneStatus_name',
				dataField: 'cloneStatus.name',
				type: 0
			},
			{
				name: 'sourceDBSize',
				dataField: 'sourceDBSize',
				type: 6
			},
			{
				name: 'cloneCreationTime',
				dataField: 'cloneCreationTime',
				type: 6
			},
			{
				name: 'cloneExpiryTime',
				dataField: 'cloneExpiryTime',
				type: 6
			},
			{
				name: 'databaseAsOfTime',
				dataField: 'databaseAsOfTime',
				type: 6
			}
		],
		CLOUDSTORAGE_ACCOUNTS: [
			{
				name: 'instanceName',
				dataField: 'instance.instanceName',
				type: 0
			},
			{
				name: 'clientName',
				dataField: 'instance.displayName',
				type: 0
			},
			{
				name: 'vendorType',
				dataField: 'vendorType',
				type: 6
			},
			{
				name: 'status',
				dataField: 'status',
				type: 6
			},
			{
				name: 'backupSize',
				dataField: 'backupSize',
				type: 6
			},
			{
				name: 'backupTime',
				dataField: 'backupTime',
				type: 6
			},
			{
				name: 'sla',
				dataField: 'sla',
				type: 0
			},
			{
				name: 'companyName',
				dataField: 'instance.entityInfo.companyName',
				type: 0
			},
			{
				name: 'planName',
				dataField: 'plan.planName',
				type: 0
			},
			{
				name: 'vendorDisplayName',
				dataField: 'vendorDisplayName',
				type: 0
			},
			{
				name: 'applicationSize',
				dataField: 'applicationSize',
				type: 6
			},
			{
				name: 'environmentType',
				dataField: 'salesforceProps.salesforceAccount.environmentType',
				type: 0
			}
		]
	});
})();
