<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="bootstrap-wrapper no-padding">
	<div class="form-group" data-ng-if="serverMessage.message">
		<div class="col-xs-12">
			<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
		</div>
	</div>
	<div class="form-group">
		<label for="alertName" class="col-md-3"><cv:msg key="label.alertName" bundle="alerts" /></label>
		<div class="col-md-9">
			<input type="text" autofocus name="alertName" data-ng-model="alertDetails.alertName" id="alertName"  maxlength="128" required />
			<span class="help-block" data-ng-show="addAlertDefinitionForm.alertName.$dirty && addAlertDefinitionForm.alertName.$error.required"><cv:msg key="error.alertName" bundle="alerts" /></span>
			<span class="help-block" data-ng-show="addAlertDefinitionForm.alertName.$dirty && addAlertDefinitionForm.alertName.$error.maxlength"><cv:msg key="error.maxLength" bundle="alerts" /></span>
		</div>
	</div>
	<div class="add-alert-criteria form-group">
		<label for="alertDetails.alertCriteria" class="col-md-3"><cv:msg key="label.alertType" bundle="alerts"/></label>
		<div class="col-md-9">
			<isteven-multi-select
				input-model="alertCriteriaList"
				output-model="alertDetails.alertCriteriaArr"
				button-label="localizedName"
				item-label="localizedName"
				tick-property="selected"
				selection-mode="single"
				helper-elements=""
				id="alertTypeCriteriaList"
				class="isteven-multi-select full-width"
				on-item-click="getEntityListforAlert()"
				translation="alertTypeSelTrans"
				name="alertType"
				max-height="250px">
			</isteven-multi-select>
			<span class="help-block" data-ng-show="showAlertTypeError"><cv:msg key="error.selectAlertType" bundle="alerts" /></span>
		</div>
	</div>
	<div data-ng-if="alertDetails.isShowParam" class="form-group">
		<label for="alertParam" class="col-md-3"><cv:msg key="label.alertParam" bundle="alerts" /></label>
		<div class="col-md-9">
			<input type="number" class="full-width" name="alertParam" data-ng-model="alertDetails.paramList[0].value" id="alertParam" data-ng-class="{'has-error': cv.addAlertDefinitionForm.needsAttention(addAlertDefinitionForm.alertParam)}"  maxlength="10"  min = "{{alertDetails.paramList[0].minValue}}" max = "{{alertDetails.paramList[0].maxValue== -1 ? false: alertDetails.paramList[0].maxValue}}" required />
			<span class="help-block" data-ng-show="addAlertDefinitionForm.alertParam.$error.required"><cv:msg key="error.selectParam" bundle="alerts" /></span>
			<span class="help-block" data-ng-show="addAlertDefinitionForm.alertParam.$error.maxlength"><cv:msg key="error.maxLength" bundle="alerts" /></span>
			<span class="help-block" data-ng-show="addAlertDefinitionForm.alertParam.$dirty && (addAlertDefinitionForm.alertParam.$error.required || addAlertDefinitionForm.alertParam.$error.maxlength)"><cv:msg key="error.validValue" bundle="alerts" /></span>
		</div>
	</div>
	<div class="add-alert-notif-individual form-group">
		<label class="col-xs-12 padding-top-10" for="alertNotifIndividual">
			<toggle-control id="alertNotifIndividual" status="alertDetails.alertNotifIndividual ? 'enabled-activity' : 'disabled-activity'" data-ng-click="alertDetails.alertNotifIndividual = !alertDetails.alertNotifIndividual" title="Enable/Disable <cv:msg key="label.alertNotifIndividual" bundle="alerts" />"></toggle-control>
			<cv:msg key="label.alertNotifIndividual" bundle="alerts" />
		</label>
	</div>
</div>
<div class="cv-wizard-default-actions add-alert-wizard-actions row">
	<div class="col-xs-12">
		<div class="col-xs-3 col-xs-offset-9 col-md-2 col-md-offset-10">
			<cv-wizard-button data-cv-type="next"
					data-cv-disabled="addAlertDefinitionForm.alertName.$error.required || addAlertDefinitionForm.alertName.$error.maxlength || alertDetails.alertCriteriaArr.length == 0">
			</cv-wizard-button>
		</div>
	</div>
</div>