import { cvModuleAlertsModule } from 'common/js/modules';
const serverMod = cvModuleAlertsModule;

/*
	Places the selected alert token on the carrot position in console & eventviewer textarea
* */
serverMod.directive('cvAlertText', [
	function() {
		return {
			link: function(scope, element, attrs) {
				if (attrs.listenOn)
					scope.$on(attrs.listenOn, function(e, val) {
						let editorTextArea = element[0];
						if (document.selection) {
							editorTextArea.focus();
							let sel = document.selection.createRange();
							sel.text = val;
							editorTextArea.focus();
						} else if (editorTextArea.selectionStart || editorTextArea.selectionStart === 0) {
							let startPos = editorTextArea.selectionStart;
							let endPos = editorTextArea.selectionEnd;
							let scrollTop = editorTextArea.scrollTop;
							editorTextArea.value =
								editorTextArea.value.substring(0, startPos) +
								val +
								editorTextArea.value.substring(endPos, editorTextArea.value.length);
							editorTextArea.focus();
							editorTextArea.selectionStart = startPos + val.length;
							editorTextArea.selectionEnd = startPos + val.length;
							editorTextArea.scrollTop = scrollTop;
						} else {
							editorTextArea.value += val;
							editorTextArea.focus();
						}

						//textView is updated outside angular context
						editorTextArea.dispatchEvent(new Event('input', { bubbles: true }));
						if (!e.defaultPrevented) e.defaultPrevented = true;
					});
			}
		};
	}
]);

export default serverMod;
