import 'modules/alerts/js/factories/alertUI.factory.js';
import 'modules/alerts/js/services/alerts.svc.js';
import 'modules/settings/js/services/settings.svc.js';
import { cvModuleAlertsModule } from 'common/js/modules';
import CvWizard from 'common/js/directives/cv-wizard/cvWizard.js';
import CvWizardStep from 'common/js/directives/cv-wizard/cvWizardStep.js';

var appModule = cvModuleAlertsModule;

class AddAlertStepTemplateController {
	static $inject = ['$scope', 'cvUtil', 'cvLoc', 'alertUIFactory', 'settingsService', 'ALERTS_SUPPORTED'];
	constructor($scope, cvUtil, cvLoc, alertUIFactory, settingsService, ALERTS_SUPPORTED) {
		const model = $scope.$cvWizardStepInstance.getModel();
		$scope.alertDetails = model.alertDetails;
		$scope.alertNotifTypes = model.alertNotifTypes;
		$scope.alertNotifObject = model.alertNotifObject;
		$scope.locale = model.locale;
		$scope.template = model.template;
		$scope.hideKendoEditor = false;
		$scope.isConsoleTemplHTML = false;
		$scope.listeners = {
			ev: 'evText',
			console: 'consoleJson'
		};

		Object.defineProperty($scope, 'htmlTemplateActive', {
			get() {
				return model.htmlTemplateActive;
			},
			set(value) {
				model.htmlTemplateActive = value;
			}
		});

		const _activateAlert = alertType => {
			Object.keys($scope.alerts).forEach(function(aType) {
				$scope.alerts[aType].isActive = alertType === aType;
				if (
					$scope.alerts[aType].isActive &&
					(alertType === ALERTS_SUPPORTED.EMAIL ||
						(alertType === ALERTS_SUPPORTED.CONSOLE && $scope.isConsoleTemplHTML))
				)
					model.editor.textEditor.setText($scope.alerts[aType].template);
			});
		};

		const hideKendoEditor = () => {
			return $scope.alerts.eventViewer.isActive || ($scope.alerts.console.isActive && !$scope.isConsoleTemplHTML);
		};

		$scope.updateModelTemplates = () => {
			model.template.html = $scope.alerts.email.getActiveTemplate();
			model.template.json = $scope.alerts.console.getActiveTemplate();
			model.template.text = $scope.alerts?.eventViewer?.template;
		};

		settingsService
			.getLocalelist()
			.success(function(data) {
				model.locale.alertLocaleList = data;
				let currentLocale = alertUIFactory.getCurrentLocale();
				model.locale.alertLocaleList.forEach(locale => {
					if (locale.localeName == currentLocale.localeName) {
						locale.selected = true;
						model.locale.lastSelectedLocaleName = locale.localeName;
					} else {
						locale.selected = false;
					}
				});
				$scope.serverMessage = cvUtil.emptyMsg();
			})
			.error(function(e) {
				$scope.serverMessage = cvUtil.errMsg(e === '' || e == null ? cvLoc('error.alertLocaleload') : e);
			});

		$scope.tokenSelected = function(selectedToken) {
			if (selectedToken) {
				const sendToListener = $scope.alerts.console.isActive ? $scope.listeners.console : $scope.listeners.ev;
				$scope.$broadcast(sendToListener, selectedToken);
			}
		};

		$scope.alertLocaleChange = function() {
			alertUIFactory.alertLocaleChange(model.locale, function() {
				model.getTemplate(true);
			});
		};

		$scope.viewTemplate = function(alertType) {
			if (alertType && alertType !== $scope.currentActive) {
				$scope.updateModelTemplates();
				model.currentActiveAlertType = alertType;
				_activateAlert(alertType);
				$scope.hideKendoEditor = hideKendoEditor();
				$scope.currentActive = alertType;
			}
		};

		$scope.$cvWizardStepInstance.on(CvWizardStep.EVENT.STEP_ENTER, event => {
			let isPrimaryTabSet = false;
			$scope.isConsoleTemplHTML = !alertUIFactory.verifyJSON(model.template.json);
			$scope.alerts = {
				email: {
					isActive: false,
					isSelected: $scope.isEmailSelected,
					template: model.template.html,
					getActiveTemplate: function() {
						this.template = this.isActive ? model.editor.textEditor.getText() : this.template;
						return this.template;
					}
				},
				console: {
					isActive: false,
					isSelected: $scope.isCASelected,
					template: model.template.json,
					getActiveTemplate: function() {
						this.template = $scope.isConsoleTemplHTML
							? this.isActive
								? model.editor.textEditor.getText()
								: this.template
							: this.template;
						return this.template;
					}
				},
				eventViewer: {
					isActive: false,
					isSelected: $scope.isEVSelected,
					template: model.template.text
				}
			};

			if (
				$scope.alerts.eventViewer.isSelected() ||
				($scope.alerts.console.isSelected() && !$scope.isConsoleTemplHTML)
			) {
				$scope.tokens = $scope?.tokensList?.length ? $scope.tokensList : [];
			}

			//initialize defaults and tabs
			Object.keys($scope.alerts).forEach(function(alert) {
				if (
					(alert === ALERTS_SUPPORTED.EVENTVIEWER ||
						(alert === ALERTS_SUPPORTED.CONSOLE && !$scope.isConsoleTemplHTML)) &&
					$scope.alerts[alert].isSelected()
				) {
					$scope.$watch(
						`alerts.${alert}.template`,
						function(nVal, oVal) {
							if (nVal) $scope.updateModelTemplates();
						},
						true
					);
				}

				if ($scope.alerts[alert].isSelected() && !isPrimaryTabSet) {
					$scope.alerts[alert].isActive = true;
					$scope.currentActive = alert;
					isPrimaryTabSet = true;
					model.currentActiveAlertType = alert;
				}
			});

			$scope.hideKendoEditor = hideKendoEditor();
			if (!$scope.hideKendoEditor) {
				alertUIFactory.enableToolbar();
				model.editor.textEditor.setText($scope.alerts[$scope.currentActive].template);
			}
		});

		$scope.$cvWizardStepInstance.on(CvWizard.EVENT.PREVIOUS, event => {
			$scope.serverMessage = cvUtil.emptyMsg();
			//Save current editor text before moving to previous page
			$scope.updateModelTemplates();
		});

		$scope.$on('localeChangeComplete', function(evnt, data) {
			$scope.alerts.eventViewer.template = model.template.text;
			$scope.alerts.console.template = model.template.json;
			$scope.alerts.email.template = model.template.email;
			$scope.tokens = $scope.tokensList;
		});

		$scope.$cvWizardStepInstance.on(CvWizard.EVENT.FINISH, event => {
			model.submitAttempted = true;
		});
	}
}

appModule.controller('addAlertStepTemplateController', AddAlertStepTemplateController);

export default appModule;
