import 'modules/alerts/js/services/alerts.svc.js';
import { cvModuleAlertsModule } from 'common/js/modules';
import CvWizard from 'common/js/directives/cv-wizard/cvWizard.js';

var appModule = cvModuleAlertsModule;

class AddAlertStepGeneralController {
	static $inject = ['$scope', '$filter', '$dialogs', 'cvUtil', 'cvLoc', 'definitionsService'];
	constructor($scope, $filter, $dialogs, cvUtil, cvLoc, definitionsService) {
		const model = $scope.$cvWizardStepInstance.getModel();
		$scope.alertDetails = model.alertDetails;
		$scope.alertCriteriaList = [];
		$scope.lastSelectedAlertType = '';
		$scope.isEntitiesInitialized = true;

		//Translation to set the placeholder value for Alert Type selection dropdown
		$scope.alertTypeSelTrans = cvUtil.getIStevenLocLabels();
		$scope.alertTypeSelTrans.nothingSelected = cvLoc('label.selectAlertTypePlaceholder');

		$scope.serverMessage = cvUtil.infoMsg(cvLoc('Loading'));

		definitionsService
			.getAlertsCriteriaList()
			.success(function(data) {
				if (angular.isArray(data)) {
					$scope.alertCriteriaList = $filter('orderBy')(data, 'localizedName');
				}
				$scope.serverMessage = cvUtil.emptyMsg();
			})
			.error(function(e) {
				$scope.serverMessage = cvUtil.errMsg(e === '' || e == null ? cvLoc('error.alertcriteriaload') : e);
			});

		$scope.resetNotificationTypes = function() {
			model.isNotifTypesInitialized = true;
			model.alertNotifTypesError.error = cvUtil.emptyMsg();
		};

		$scope.updateParamList = function() {
			$scope.lastSelectedAlertType = $scope.alertDetails.alertCriteria;

			if (
				$scope.alertDetails.alertCriteria &&
				$scope.alertDetails.alertCriteria.paramsList &&
				$scope.alertDetails.alertCriteria.paramsList.length > 0
			) {
				$scope.alertDetails.isShowParam = true;
				$scope.alertDetails.paramList = $scope.alertDetails.alertCriteria.paramsList; // only single param alerts are present now, may need to support multiparams later
				$scope.alertDetails.paramList[0].value = $scope.alertDetails.alertCriteria.paramsList[0].defaulValue;
			} else {
				$scope.alertDetails.paramList = [];
				$scope.alertDetails.isShowParam = false;
			}
		};

		$scope.getEntityListforAlert = function() {
			//Show warning in case user try to update the alert type after changing the entities or the notification types.
			$scope.alertDetails.alertCriteria = $scope.alertDetails.alertCriteriaArr[0];
			if ($scope.lastSelectedAlertType == '' || $scope.lastSelectedAlertType == $scope.alertDetails.alertCriteria) {
				$scope.updateParamList();
			} else {
				let callBackFunctions = {
					yesFunction: function() {
						$scope.resetTree();
						$scope.resetNotificationTypes();
						$scope.updateParamList();
						$scope.isEntitiesInitialized = true;
					},
					noFunction: function() {
						let selectedIndex = -1;
						for (let i = 0; i < $scope.alertCriteriaList.length; i++) {
							let alertType = $scope.alertCriteriaList[i];
							if (
								alertType.alertCategory == $scope.lastSelectedAlertType.alertCategory &&
								alertType.alertCriteria == $scope.lastSelectedAlertType.alertCriteria &&
								alertType.alertType == $scope.lastSelectedAlertType.alertType &&
								alertType.localizedName == $scope.lastSelectedAlertType.localizedName
							) {
								selectedIndex = i;
							}
							alertType.selected = false;
						}
						$scope.alertCriteriaList[selectedIndex].selected = true;
					}
				};
				let dialogMsg;
				if (
					$scope.lastSelectedAlertType.alertType != $scope.alertDetails.alertCriteria.alertType ||
					$scope.lastSelectedAlertType.alertStatus.processDiscoveredVMs !=
						$scope.alertDetails.alertCriteria.alertStatus.processDiscoveredVMs
				) {
					//Don't show dialog if user is changing the alert type again and again without changing the entities or notification types
					if (model.isNotifTypesInitialized && $scope.isEntitiesInitialized) {
						$scope.updateParamList();
						return;
					} else {
						dialogMsg = cvLoc('label.entityNotifInitMsg');
					}
				} else if (!model.isNotifTypesInitialized) {
					dialogMsg = cvLoc('label.notifInitMsg');
				} else {
					$scope.updateParamList();
					return;
				}
				$dialogs.confirm(cvLoc('label.confirmInit'), dialogMsg, callBackFunctions);
			}
		};

		$scope.$cvWizardStepInstance.on(CvWizard.EVENT.NEXT, event => {
			// On next step
			if (
				model.addAlertDefinitionForm.alertParam &&
				(model.addAlertDefinitionForm.alertParam.$error.required || model.addAlertDefinitionForm.alertParam.$error.min)
			) {
				event.preventDefault();
				return;
			}
			$scope.alertDetails.alertCriteria = $scope.alertDetails.alertCriteriaArr[0];
			$scope.isEntitiesInitialized = false;
			$scope.serverMessage = cvUtil.emptyMsg();
		});
	}
}

appModule.controller('addAlertStepGeneralController', AddAlertStepGeneralController);

export default appModule;
