import 'modules/alerts/js/directives/cv-browse-servers-collection-content-directive.js';
import 'adminConsole/js/directives/cv-entity-selection-tree-component.js';
import 'adminConsole/js/factories/cvEntitySelectionTreeComponent.factory.js';
import { cvModuleAlertsModule } from 'common/js/modules';
import CvWizard from 'common/js/directives/cv-wizard/cvWizard.js';
import CvWizardStep from 'common/js/directives/cv-wizard/cvWizardStep.js';

var appModule = cvModuleAlertsModule;

class AddAlertStepEntitiesController {
	static $inject = ['$scope', 'cvUtil'];
	constructor($scope, cvUtil) {
		const model = $scope.$cvWizardStepInstance.getModel();
		$scope.alertDetails = model.alertDetails;
		$scope.isWizard = true;
		$scope.isTenantAdmin = cv.isTenantAdmin;

		$scope.wasSubmitAttempted = () => {
			return model.submitAttempted;
		};

		$scope.$cvWizardStepInstance.on(CvWizardStep.EVENT.STEP_ENTER, event => {
			if (event.details.oldStepId === 'step-general') {
				// On step enter from general step
				$scope.selectedAlert = {
					alertId: $scope.alertDetails.alertCriteria.alertType,
					isVM: $scope.alertDetails.alertCriteria.alertStatus.processDiscoveredVMs
				};
				$scope.treeParams.showVMsonly = $scope.alertDetails.alertCriteria.alertStatus.processDiscoveredVMs;
			}
		});

		$scope.$cvWizardStepInstance.on(CvWizard.EVENT.NEXT, event => {
			// On next step
			if (model.isNotifTypesInitialized) {
				model.getTemplate();
			}
			model.isNotifTypesInitialized = false;
			$scope.serverMessage = cvUtil.emptyMsg();
		});
	}
}

appModule.controller('addAlertStepEntitiesController', AddAlertStepEntitiesController);

export default appModule;
