import { cvModuleAlertsModule } from 'common/js/modules';

import 'common/js/directives/cv-wizard/cv-wizard.directive.js';
import 'modules/ida/js/directives/cv-browse-directives.js';
import 'modules/alerts/js/factories/alertUI.factory.js';
import 'modules/alerts/js/services/alerts.svc.js';
import 'modules/alerts/js/controllers/addAlertStepGeneral.ctrl.js';
import 'modules/alerts/js/controllers/addAlertStepEntities.ctrl.js';
import 'modules/alerts/js/controllers/addAlertStepTarget.ctrl.js';
import 'modules/alerts/js/controllers/addAlertStepTemplate.ctrl.js';

var appModule = cvModuleAlertsModule;

class AddAlertDefinitionController {
	static $inject = [
		'$scope',
		'$window',
		'$location',
		'$dialogs',
		'cvUtil',
		'cvLoc',
		'cvToaster',
		'cvBreadcrumbsTabsFactory',
		'cvEntitySelectionTreeComponent',
		'alertUIFactory',
		'definitionsService',
		'ALERTS_SUPPORTED'
	];
	constructor(
		$scope,
		$window,
		$location,
		$dialogs,
		cvUtil,
		cvLoc,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		cvEntitySelectionTreeComponent,
		alertUIFactory,
		definitionsService,
		ALERTS_SUPPORTED
	) {
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.alertDefinitions'),
				link: '#/alertsDefinitions'
			}
		]);

		$scope.steps = [
			{
				template: appUtil.appRoot + 'modules/alerts/partials/addAlertStepGeneral.jsp',
				name: cvLoc('label.nav.general')
			},
			{
				template: appUtil.appRoot + 'modules/alerts/partials/addAlertStepEntities.jsp',
				name: cvLoc('heading.entities')
			},
			{
				template: appUtil.appRoot + 'modules/alerts/partials/addAlertStepTarget.jsp',
				name: cvLoc('label.alertTarget')
			},
			{
				template: appUtil.appRoot + 'modules/alerts/partials/addAlertStepTemplate.jsp',
				name: cvLoc('label.alertTemplate')
			}
		];

		const model = {
			alertDetails: {
				entityList: [],
				userList: [],
				externalGroupList: [],
				nonGalaxyUserList: [],
				selEntityList: [],
				alertNotifTokenList: {}
			},
			emailSubject: {
				message: ''
			},
			isNotifTypesInitialized: true,
			locale: {
				alertLocaleList: [],
				lastSelectedLocaleName: ''
			},
			template: {
				html: '',
				text: '',
				json: ''
			},
			editor: {
				textEditor: null,
				textEditorTemplate: null
			},
			alertNotifTypesError: {
				error: cvUtil.emptyMsg()
			},
			alertNotifTypes: alertUIFactory.getAlertNotifTypes(),
			alertNotifObject: alertUIFactory.getAlertNotifObject(),
			submitAttempted: false,
			get addAlertDefinitionForm() {
				return $scope.addAlertDefinitionForm;
			},
			getTemplate: getTemplate
		};
		$scope.model = model;

		$scope.firstLoad = true;

		$scope.treeParams = {
			initialSelections: [],
			initialExclusions: [],
			result: {},
			mode: 'edit',
			noExclusions: true,
			hideIndexAnalytics: true
		};

		$scope.resetTree = function() {
			$scope.treeParams.resetTree();
		};

		$scope.treeParams.isNodeApplicable = function(node) {
			if (node.entity.entityTypeName == 'CLIENT_ENTITY') {
				//remove this after mongoDB filter for server gets fixed
				if (
					_.includes(node.entity.clientName, 'IndexServer') ||
					_.includes(node.entity.clientName, 'AnalyticsServer')
				) {
					// Workaround for avoiding Index Server and Analytic Servers coming due to Mongo issue
					return false;
				}
				node.noChild = false;
				node.childrenLoaded = false;
			}
			if (node.entity.entityTypeName == 'CLIENT_GROUP_ENTITY' || node.entity.entityTypeName == 'SUBCLIENT_ENTITY') {
				node.noChild = true;
				node.childrenLoaded = true;
			}
			return true;
		};

		var isLeaving = false; //this is required because after confirm dialog is clicked yes, locationchangestart is fired again
		$scope.$on('$locationChangeStart', function(event, next, current) {
			if (
				!isLeaving &&
				(model.alertDetails.alertName ||
					(model.alertDetails.alertCriteriaArr || []).length > 0 ||
					model.alertDetails.alertNotifIndividual)
			) {
				$dialogs.confirm(cvLoc('label.confirmNavigation'), cvLoc('label.navigationMsg'), {
					yesFunction: function() {
						isLeaving = true;
						$window.location.href = next;
					},
					noFunction: function() {
						event.preventDefault();
					}
				});
				event.preventDefault();
				return;
			}
		});

		$scope.isEVSelected = function() {
			return model.alertNotifTypes[model.alertNotifObject.ev.index].selected;
		};

		$scope.isEmailSelected = function() {
			return model.alertNotifTypes[model.alertNotifObject.email.index].selected;
		};

		$scope.isCASelected = function() {
			return model.alertNotifTypes[model.alertNotifObject.console.index].selected;
		};

		function startEditor() {
			// starts the editor after the end of the digest cycle
			let watch = $scope.$watch(undefined, function() {
				// Wait for the end of the digest cycle for the ng-if to render
				if ($('#cv-editor')[0]) {
					watch(); // unregister the watch
					// retrieve the template and render the text editor
					alertUIFactory.startEditor(model.editor, $scope.tokensList);
					model.htmlTemplateActive = true;
				}
			});
		}

		function getTemplate(isLocaleChange = false) {
			let localeId =
				(model.locale.selectedLocale && model.locale.selectedLocale.length) > 0
					? model.locale.selectedLocale[0].localeId
					: alertUIFactory.getCurrentLocale().localeId;
			definitionsService
				.getDefaultTemplateAndTokenList(
					model.alertDetails.alertCriteria.alertType,
					model.alertDetails.alertCriteria.alertCriteria,
					localeId
				)
				.success(function(data) {
					let result = alertUIFactory.getTemplatesAndTokensFromResp(data);
					if (result == null) {
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: cvLoc('error.templateTokenError')
						});
					}
					model.emailSubject.message = result.emailSubject;
					model.template.html = result.defaultHTMLTemplate;
					model.template.text = result.defaultTextTemplate;
					const jsonTemplate = alertUIFactory.verifyJSON(result.defaultJSONTemplate);
					$scope.isHtmlConsoleTemplate = !jsonTemplate;
					model.template.json = $scope.isHtmlConsoleTemplate ? result.defaultJSONTemplate : jsonTemplate;
					$scope.tokensList = result.tokenList;
					model.subjectBeginTokenFormat = result.subjectBeginTokenFormat;
					model.subjectEndTokenFormat = result.subjectEndTokenFormat;
					if (isLocaleChange) {
						$scope.$broadcast('localeChangeComplete', { localeId });
						model.htmlTemplateActive
							? model.editor.textEditor.setText(model.template.html)
							: model.editor.textEditor.setText(model.template.text);
						model.editor.textEditor.setTokens(alertUIFactory.processTokens($scope.tokensList));
					} else {
						let alertNotifObject = alertUIFactory.getAlertNotifObject();
						alertUIFactory.updateNotifTypesAllowed(model.alertNotifTypes, result.notifTypesSupported, [
							alertNotifObject.email.value,
							alertNotifObject.console.value,
							alertNotifObject.ev.value
						]);
						//Need to set empty data first time so that width of input field can be re-computed and placeholder don't get truncated
						if ($scope.firstLoad) {
							$scope.firstLoad = false;
							setTimeout(function() {
								$('#toUserList').select2('data', null);
								$('#ccUserList').select2('data', null);
								$('#bccUserList').select2('data', null);
							}, 10);
						}
						startEditor();
					}
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: cvLoc('error.templateTokenError') + '\n' + e
					});
				});
		}

		$scope.createAlertDefinition = function() {
			//check if editor text is safe before proceeding to save.

			const showErrorMsg = errStr => {
				errStr = errStr ? '\n' + errStr : '';
				cvToaster.showErrorMessage({
					ttl: '5000', //5 sec
					message: cvLoc('error.addAlertDefError') + errStr
				});
			};
			if ($scope.isEmailSelected() && model.editor.textEditor.isTextSecure() === false) {
				showErrorMsg(cvLoc('editor.msg.error.unsecureEditorText'));
				return;
			}

			if (
				$scope.isCASelected() &&
				model.template.json &&
				!$scope.isHtmlConsoleTemplate &&
				!alertUIFactory.verifyJSON(model.template.json)
			) {
				showErrorMsg(cvLoc('editor.msg.error.invalidJson'));
				return;
			}
			model.template.text = $scope.isEVSelected() ? $.trim(model.template.text) : model.template.text;

			let associations = [];
			associations = cvEntitySelectionTreeComponent.getAssociations($scope.treeParams);

			if (model.htmlTemplateActive) {
				const alertMode =
					$scope.isHtmlConsoleTemplate && model.currentActiveAlertType === ALERTS_SUPPORTED.CONSOLE ? 'json' : 'html';
				model.template[alertMode] = model.editor.textEditor.getText();
			} else {
				model.template.text = model.editor.textEditor.getText();
			}

			$scope.alertDef = {
				alertrule: { alertName: model.alertDetails.alertName },
				alertType: model.alertDetails.alertCriteria.alertType,
				notifType: alertUIFactory.getSelectedNotifTypes(model.alertNotifTypes).selectedNotifTypes,
				alertStatus: {
					isSendIndividualNotificationSelected: model.alertDetails.alertNotifIndividual,
					processDiscoveredVMs: model.alertDetails.alertCriteria.alertStatus.processDiscoveredVMs
				},
				recipientUserList: [],
				recipientUserGroupList: [],
				recipientadUserGroupList: [],
				nonGalaxyList: { nonGalaxyUserList: [] },
				locale: {
					localeID: model.locale.selectedLocale[0].localeId,
					localeName: model.locale.selectedLocale[0].localeName
				},
				criteria: {
					paramsList: model.alertDetails.paramList,
					criteria: model.alertDetails.alertCriteria.alertCriteria
				},
				EntityList: {
					associations: associations
				},
				alertContent: {
					jsonMessage: encodeURIComponent(
						$scope.isHtmlConsoleTemplate ? model.template.json : model.template.json.replace(/^\s+|\s+$/g, '')
					),
					textMessage: encodeURIComponent(model.template.text),
					htmlMessage: encodeURIComponent(
						model.subjectBeginTokenFormat +
							model.emailSubject.message +
							model.subjectEndTokenFormat +
							model.template.html
					)
				}
			};

			if ($scope.isEmailSelected() || $scope.isCASelected()) {
				alertUIFactory.getUsers($scope.alertDef, $('#toUserList'), 'TO');
			}
			if ($scope.isEmailSelected()) {
				alertUIFactory.getUsers($scope.alertDef, $('#ccUserList'), 'CC');
				alertUIFactory.getUsers($scope.alertDef, $('#bccUserList'), 'BCC');
			}

			definitionsService
				.createAlertDefinition($scope.alertDef)
				.success(function(data) {
					isLeaving = true;
					$location.path('alertDetails/' + data);
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: cvLoc('error.addAlertDefError') + '\n' + e
					});
				});
		};
	}
}

appModule.controller('addAlertDefinitionController', AddAlertDefinitionController);

export default appModule;
