<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="title.physicalClientSelection" bundle="browse" />
	</h1>
</div>
<div class="bootstrap-wrapper">
	<form name="physicalClientSelectionForm" cv-hide-api novalidate cv-submit="closeDialogBox(selectedClient)">
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-lg-5" for="physicalClient">
					<cv:msg key="label.physicalClient" bundle="browse"/>
				</label>
				<div class="col-xs-12 col-lg-7">
					<cv-isteven-single-select id-name="physicalClient"
						input-model="physicalClientList"
						binding-model="selectedClient"
						track-field="clientId"
						label="clientName"
						tick-property="selected"
						place-holder='<cv:msg key="placeholder.physicalClient" bundle="browse"/>'
						help-text='<cv:msg key="placeholder.physicalClient" bundle="browse"/>'
						required = "true" >
					</cv-isteven-single-select>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="physicalClientSelectionCloseButton" type="button" class="btn btn-default"data-ng-click="closeDialogBox()">
				<cv:msg key="label.close" bundle="messagesJs" />
			</button>
			<button id="physicalClientSelectionSaveButton" type="submit" class="btn btn-primary cvBusyOnAjax" >
				<cv:msg key="action.save" bundle="profiles"/>
			</button>
		</div>
	</form>
</div>