<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper custom-jobs-view-modal">
	<div class="setup-title">
		<h1><cv:msg key="header.customJobsView" bundle="job" /></h1>
	</div>
	<div class="setup-content">
		<form class="form-horizontal" cv-hide-api data-cv-submit="ctrl.submit()" novalidate autocomplete="off">
			<div class="panel-body">
				<div class="form-group row">
					<div class="col-xs-4">
						<label><cv:msg key="Operation" bundle="job" /></label>
					</div>
					<div class="col-xs-8">
						<isteven-multi-select id="customJobsViewModal_isteven-multi-select_#6640" 
								input-model="ctrl.operationTypeInput"
								output-model="ctrl.operationTypeOutput"
								button-label="label"
								item-label="label"
								tick-property="selected"
								helper-elements=""
								class="isteven-multi-select user-group-select">
						</isteven-multi-select>
					</div>
				</div>
				<div class="form-group row">
					<div class="col-xs-4">
						<label><cv:msg key="Status" bundle="job" /></label>
					</div>
					<div class="col-xs-8">
						<isteven-multi-select id="customJobsViewModal_isteven-multi-select_#2648" 
								input-model="ctrl.statusInput"
								output-model="ctrl.statusOutput"
								button-label="label"
								item-label="label"
								tick-property="selected"
								helper-elements=""
								class="isteven-multi-select user-group-select">
						</isteven-multi-select>
					</div>
				</div>
			</div>
			<div class="time-range-accordion">
				<uib-accordion>
					<div uib-accordion-group data-is-open="ctrl.useRange">
						<uib-accordion-heading>
							<input id="use-range-{{$id}}" name="useRange" type="checkbox"
									data-ng-checked="ctrl.useRange" data-ng-click="$event.preventDefault();" />
							<label for="use-range-{{$id}}" class="checkbox-label" data-ng-click="$event.preventDefault();">
								<cv:msg key="label.timeRange" bundle="job" />
							</label>
						</uib-accordion-heading>
						<div class="form-group row">
							<div class="col-xs-4">
								<label><cv:msg key="Start Time" bundle="job" /></label>
							</div>
							<div class="col-xs-8">
								<div class="calendar-wrapper date-picker">
									<input type="text" class="date-box" data-datetime-picker="MM/dd/yyyy HH:mm"
											data-ng-model="ctrl.datepicker.from.value" data-is-open="ctrl.datepicker.from.open"
											data-datepicker-options="ctrl.datepicker.from.dateOptions" data-timepicker-options="ctrl.datepicker.from.timeOptions" />
									<button id="customJobsViewModal_button_#2105" type="button" class="btn btn-primary" data-ng-click="ctrl.openFrom()"> 
										<i class="glyphicon glyphicon-calendar"></i>
									</button>
								</div>
							</div>
						</div>
						<div class="form-group row">
							<div class="col-xs-4">
								<label><cv:msg key="End Time" bundle="job" /></label>
							</div>
							<div class="col-xs-8">
								<div class="calendar-wrapper date-picker">
									<input type="text" class="date-box" data-datetime-picker="MM/dd/yyyy HH:mm"
											data-ng-model="ctrl.datepicker.to.value" data-is-open="ctrl.datepicker.to.open"
											data-datepicker-options="ctrl.datepicker.to.dateOptions" data-timepicker-options="ctrl.datepicker.to.timeOptions" />
									<button id="customJobsViewModal_button_#8961" type="button" class="btn btn-primary" data-ng-click="ctrl.openTo()"> 
										<i class="glyphicon glyphicon-calendar"></i>
									</button>
								</div>
							</div>
						</div>
					</div>
				</uib-accordion>
			</div>
			<div class="button-container">
				<button id="customJobsViewModal_button_#5645" class="btn btn-default" type="button" data-ng-click="ctrl.dismiss()"> 
					<cv:msg key="action.cancel" bundle="settings"/>
				</button>
				<button id="customJobsViewModal_button_#2583" class="btn btn-primary" type="submit"> 
					<cv:msg key="action.apply" bundle="settings"/>
				</button>
			</div>
		</form>
	</div>
</div>