<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.job">
<div ng-repeat='job in jobs' ng-if='job.showProgress' class='job-directive__wrapper group'>
	<span class='pageDetailColumn add-padding'>
		<a href='#jobs/{{job.jobSummary.jobId}}?serverId={{job.jobSummary.serverId}}&collectionId={{job.jobSummary.collectionId}}&serverName={{job.jobSummary.destClientName}}&collectionName={{job.jobSummary.subclientName}}'>
			<fmt:message key="Job ID" />
			{{job.jobSummary.jobId}}
		</a>
		<div class='jobDetails'>
			<fmt:message key="Status" />
			{{job.jobSummary.status}}
		</div>
	</span>
	<span class='pageDetailColumn add-padding'>
		<div class='jobProgressBarContainer' jobprogress val='{{job.jobSummary.percentComplete}}' status='{{job.jobSummary.status}}'>
		</div>
		<div class='job-actions' ng-show="{{capability}}">
			<a class='jobKill' ng-if='job.kill' href='' ng-click='jobAction("JOB_KILL",$index)' title="Kill job">
			</a>
			<a class='jobSuspend' ng-if='job.suspend' href='' ng-click='jobAction("JOB_SUSPEND",$index)' title="Suspend job">
			</a>
			<a class='jobResume' ng-if='job.resume' href='' ng-click='jobAction("JOB_RESUME",$index)' title="Resume job">
			</a>
		</div>
		<div class='jobDetails'>
			<span class='jobDetail'>
				<fmt:message key="TotalSize" />
			</span> 
			{{job.jobSummary.sizeOfApplication | capacity}}<br>
			<!-- 
			<span class='jobDetail'>" + cvLoc('NoofFiles') + </span>
			{{job.jobSummary.totalNumOfFiles}}<br>
			-->
			<span class='jobDetail'>
				<fmt:message key="Elapsed Time" />
			</span> {{job.jobSummary.jobElapsedTime | elapsedTime}}<br>
		</div>
	</span>
	
	<span data-ng-if="job.jobSummary.pendingReasonErrorCode" class='pageDetailColumnFull'><a class="jobDetails crop" title="{{job.jobSummary.pendingReasonErrorCode}}" data-ng-bind-html="job.jobSummary.pendingReasonErrorCode" data-uib-tooltip-html="job.jobSummary.pendingReason"  tooltip-placement="bottom" target="_blank" data-ng-href="{{getJPRLink(job.jobSummary)}}"></a><span> - </span><span class="jobDetails crop" title="{{job.jobSummary.pendingReason | extractTextFromHtml}}" data-ng-bind-html="job.jobSummary.pendingReason"></span></span>
	<span data-ng-hide="job.jobSummary.pendingReasonErrorCode" data-ng-if="job.jobSummary.pendingReason" class='pageDetailColumnFull'><div class="jobDetails crop" title="{{job.jobSummary.pendingReason}}" data-ng-bind-html="job.jobSummary.pendingReason"></div></span>
</div>
</fmt:bundle>
</div>