<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div >
      <script nonce="${sessionScope.cspNonce}" >
            <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
            <cv:cvMessages bundle="localization.job"></cv:cvMessages>
            <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
            <cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
            <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
            <cv:cvMessages bundle="localization.events"></cv:cvMessages>
            <cv:cvMessages bundle="localization.dr"></cv:cvMessages>
            <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
            <cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
            <cv:cvMessages bundle="localization.users"></cv:cvMessages>
            <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
            <cv:cvEnum name="JobManager.CVQinetixUpdateCategory"></cv:cvEnum>
            <cv:cvEnum name="JobManager.VMClientBkupStatus"></cv:cvEnum>
            <cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
            <cv:cvEnum name="Api.VirtualAppJobPhaseType"></cv:cvEnum>
            <cv:cvEnum name="Api.VirtualAppPhaseState"></cv:cvEnum>
            <cv:cvEnum name="JobManager.AgingType"></cv:cvEnum>
            <cv:cvEnum name="JobManager.VerificationTypes"></cv:cvEnum>
            <cv:cvEnum name="JobManager.DDBVerificationLevel"></cv:cvEnum>
            <cv:cvEnum name="JobManager.CVLMStatus"></cv:cvEnum>
            <cv:cvEnum name="JobManager.CVLMJobStatusCategory"></cv:cvEnum>
            <cv:cvEnum name="JobManager.ExchDatabaseStatusFlags"></cv:cvEnum>
            <cv:cvEnum name="JobManager.SQLDatabasePhase"></cv:cvEnum>
            <cv:cvEnum name="JobManager.SQLDBStatus"></cv:cvEnum>
            <cv:cvEnum name="JobManager.SQLInitiatedFrom"></cv:cvEnum>
      </script>
      <fmt:bundle basename="localization.job">
			<div class="row">
                  <div class="col-xs-12 flex-detail-header padding-bottom-20">
                        <h1 class="page-title"><fmt:message key="JobDetailHeader" />
                              {{jobId}} - <span data-ng-if="job.jobDetail.generalInfo.operationType">{{"[" + job.jobDetail.generalInfo.operationType + "]"}}</span>
                              <span data-ng-hide="isJobPresent" >
                                    <img class="job-log-loader" src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
                              </span>
                        </h1>
                        <div  class="flex-page-actions"  data-ng-if="isJobPresent">
                              <job-action-menues job-obj="job" job-id="jobId" vendor="vendor" job-cap="jobCap" restore-url="restoreUrl" perform-jobact="performJobaction(action)"></job-action-menues>
                        </div>
                  </div>
            </div>
            <span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
            <div data-ng-if="isJobPresent">
                  <div class="row">
                        <div class="col-md-6">
                              <cv-tile-component data-title='<fmt:message key="Job Summary"/>' loader="job" enable-accordion="true">
                                    <job-summary-info job="job"> </job-summary-info>
                              </cv-tile-component>
                              </div>
				<div class="col-md-6">
                              <cv-tile-component data-ac-id="jobDetails-label_clientStatus-job" data-ng-if="clientStatusApplicable && !hideClientStatusCard" data-title='<cv:msg key="label.clientStatus" bundle="job"/>' loader="job">
                                    <ul class="list-style-secondary">
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.totalClient" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.totalClients}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.clientUpToDate" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.clientsAlreadyUpdated}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.successfulClient" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.successfullClients}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.skippedClient" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.skippedClients}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.pendingClient" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.pendingClients}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.failedClient" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.failedClients}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.partiallySuccessful" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.partialSuccessClients}}</span></li>
                                          <li class="group">
                                                <span class="pageDetailColumn"><fmt:message key="label.inProgress" /></span>
                                                <span class="pageDetailColumn">{{clientInfo.totalInProgressClients}}</span></li>
                                    </ul>
                              </cv-tile-component>
                        </div>
                        <div class="col-md-6">
                              <cv-tile-component data-ng-if="jobDetailFields.length" data-title='<fmt:message key="Job Details"/>' loader="job" enable-accordion="true">
                                   <job-detail-info obj="jobDetailFields" client-id="job.jobDetail.generalInfo.subclient.clientId" backupset-id="job.jobDetail.generalInfo.subclient.backupsetId"></job-detail-info>
                              </cv-tile-component>
                        </div>
                  </div>
                  <div class="row" data-ng-if='!(job.jobDetail.progressInfo.reasonForJobDelay=="" || job.jobDetail.progressInfo.reasonForJobDelay == undefined)'>
                        <div class="col-md-12">
                              <cv-tile-component data-title='<fmt:message key="label.errorDescription" />'>
                              <ul class="list-style-secondary">
                                    <li class="group"><span data-ng-bind-html="job.jobDetail.progressInfo.reasonForJobDelay | parseUrl:true" ></span></li>
                              </ul>
                              </cv-tile-component>
                        </div>
                  </div>
                  <!-- Logic to build tabs needs to be rewritten to use loader and maintaining count of tables that need to be displayed.
                  As discussed with dev-design team, this is already a to do item and should not be implemented so close to freeze.
                  It will need regression.
                  Here it is assumed that exchange database status tab can be displayed with Events tab only -->
                  <div class="row" data-ng-if="multitabs">
                        <div class="col-md-12">
                        <uib-tabset active="active" data-ng-if="eventLength || ((clientStatusApplicable)) || showExchDBBackupStatus || showSqlDBBackupStatus || showInputsTab || isCaseManagerIndexCopyJob || showOffice365BackupStatus">
                              <uib-tab index="0" heading="{{vmListTitle}}" data-ng-if="vmList.length > 0">
                                    <div class="page-details-list col-md-12" data-ng-controller="jobDetailVmListController">
                                          <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                                    </div>
                              </uib-tab>
                              <uib-tab index="1" heading="<cv:msg key='header.events' bundle='events'/>">
                                          <div class="page-details-list col-md-12" data-ng-controller="eventsListController">
                                                <cv-kendo-grid class="eventsGrid" data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                                          </div>
                              </uib-tab>
                              <uib-tab index="2" heading="<cv:msg key='label.clients' bundle='job'/>" data-ng-if="job.jobDetail.generalInfo.operationType && clientStatusApplicable && showClientsTab">
                                    <div class="page-details-list col-md-12" data-ng-controller="jobDetailClientListController">
                                          <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                                    </div>
                              </uib-tab>
                              <uib-tab index="3" heading="{{exchDBBackupInfoGridOptions.cvGridTitle}}" data-ng-if="showExchDBBackupStatus">
                                    <div class="page-details-list col-md-12" data-ng-controller="jobDetailExchDbbInfoController">
                                       <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                                    </div>
                              </uib-tab>
                              <uib-tab index="4" heading="<cv:msg key='label.databaseStatus' bundle='job'/>" data-ng-if="showSqlDBBackupStatus">
                                    <div class="page-details-list col-md-12" data-ng-controller="JobDetailSQLDBBInfoController">
                                       <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                                    </div>
                              </uib-tab>
                              <uib-tab index="5" heading="<cv:msg key='Status' bundle='job'/>" data-ng-if="showOffice365BackupStatus">
                                    <div class="page-details-list col-md-12" data-ng-controller="jobDetailOffice365InfoController">
                                          <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                                    </div>
                              </uib-tab>
                              <uib-tab index="6" heading="<fmt:message key="inputs"/>" data-ng-if="showInputsTab">
                                    <div class="page-details-list col-md-12">
                                         <cv-grid cv-grid-options="inputsGridOptions"></cv-grid>
                                    </div>
                              </uib-tab>
                              <uib-tab index="7" heading="{{'label.details' | cvLoc }}" data-ng-if="isCaseManagerIndexCopyJob">
                                    <div>
                                          <cv-grid cv-grid-options="indexCopyStatusGridOptions" cv-is-page-title="false"></cv-grid>
                                    </div>
                              </uib-tab>
                         </uib-tabset>
                        </div>
                  </div>
                  <div class="row" data-ng-if="!multitabs">
                        <div class="page-details-list col-md-12" data-ng-controller="eventsListController">
                               <cv-kendo-grid data-cv-grid-options="kendoGridOptions" class="eventsGrid"></cv-kendo-grid>
                        </div>
                        <div class="page-details-list col-md-12" >
                              <div data-ng-if="gridOptions.gridOptions.totalItemsOriginal" data-ng-controller="jobDetailVmListController">
                                    <cv-kendo-grid data-cv-grid-options="kendoGridOptions" cv-is-page-title="false"></cv-kendo-grid>
                              </div>
                              <div data-ng-if="job.jobDetail.generalInfo.operationType && clientStatusApplicable" data-ng-controller="jobDetailClientListController">
                                    <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                              </div>
                              <!-- List of databases that are part of the job  and details for each are listed here -->
                              <div data-ng-controller="jobDetailExchDbbInfoController" data-ng-if="showExchDBBackupStatus">
                                    <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                              </div>
                              <div data-ng-controller="jobDetailOffice365InfoController" data-ng-if="showOffice365BackupStatus">
                                    <cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
                              </div>
                        </div>
                  </div>
                  <div data-ng-if="job.jobDetail.generalInfo.operationType === 'DR Orchestration' || job.jobDetail.generalInfo.operationType === 'Virtual Machine Management'" data-ng-controller="drJobsController as drJobsController">
                        <div class="row">
                              <div class="page-details-list col-sm-12">
                                    <cv-kendo-grid data-ng-if="drJobsController.showGrid" cv-grid-options="drJobsController.gridOptions"></cv-kendo-grid>
                              </div>
                        </div>
                  </div>
            </div>
      </fmt:bundle>
</div>
