<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.job"></cv:cvMessages>
    <cv:cvMessages bundle="localization.events"></cv:cvMessages>
    <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
    <cv:cvEnum name="JobManager.CVQinetixUpdateCategory"></cv:cvEnum>
    <cv:cvEnum name="JobManager.VMClientBkupStatus"></cv:cvEnum>
    <cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
    <cv:cvEnum name="Api.VirtualAppJobPhaseType"></cv:cvEnum>
    <cv:cvEnum name="Api.VirtualAppPhaseState"></cv:cvEnum>
    <cv:cvEnum name="JobManager.AgingType"></cv:cvEnum>
    <cv:cvEnum name="JobManager.VerificationTypes"></cv:cvEnum>
    <cv:cvEnum name="JobManager.DDBVerificationLevel"></cv:cvEnum>
    <cv:cvEnum name="JobManager.CVLMStatus"></cv:cvEnum>
    <cv:cvEnum name="JobManager.CVLMJobStatusCategory"></cv:cvEnum>
    <cv:cvEnum name="JobManager.ExchDatabaseStatusFlags"></cv:cvEnum>
    <cv:cvEnum name="JobManager.SQLDatabasePhase"></cv:cvEnum>
    <cv:cvEnum name="JobManager.SQLDBStatus"></cv:cvEnum>
    <cv:cvEnum name="JobManager.SQLInitiatedFrom"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1 class="margin-top-10 margin-bottom-10">
		{{ jobId }} -
		<span data-ng-if="job.jobDetail.generalInfo.operationType">{{
			'[' + job.jobDetail.generalInfo.operationType + ']'
		}}</span>
		<span data-ng-hide="isJobPresent">
			<img class="job-log-loader" src="${pageContext.request.contextPath}/common/img/ajax-loader.gif" />
		</span>
	</h1>
</div>
<div class="bootstrap-wrapper padding-bottom-50">
	<span class="col-xs-12 server-message {{ serverMessage.type }}">{{ serverMessage.message }}</span>
	<div class="col-xs-12" data-ng-if="isJobPresent">
		<job-action-menues
			job-obj="job"
			job-id="jobId"
			vendor="vendor"
			job-cap="jobCap"
			restore-url="restoreUrl"
			perform-jobact="performJobaction(action)"
			is-quick-view-modal="isQuickViewModal"
		></job-action-menues>
	</div>

	<div class="plain-accordion" data-ng-if="isJobPresent">
		<div class="cv-accordion-header">
			<span class="cv-accordion-text"><cv:msg key="Job Summary" bundle="job" /></span>
		</div>
		<div class="vertical-label-style job-summary-section half-parts padding-left-15 padding-right-15">
			<job-summary-info job="job" obj="jobDetailFields" is-job-present="isJobPresent"></job-summary-info>
		</div>
	</div>
	<div
		class="plain-accordion"
		data-ng-if='isJobPresent && !(job.jobDetail.progressInfo.reasonForJobDelay=="" || job.jobDetail.progressInfo.reasonForJobDelay ==
	undefined)'
	>
		<div class="cv-accordion-header">
			<span class="cv-accordion-text">
				<cv:msg key="label.errorSummary" bundle="job" />
			</span>
		</div>
		<div class="vertical-label-style job-summary-section half-parts padding-15">
	        <a data-ng-if="jprErrCode" class="ngCellText" data-ng-href="{{ jprLink }}" target="_blank" data-ng-bind="jprErrCode"></a>
			<span data-ng-bind-html="job.jobDetail.progressInfo.reasonForJobDelay | parseUrl:true"></span>
		</div>
	</div>
	<div
		class="plain-accordion"
		data-ng-if="isJobPresent && (eventLength || (fullVMList.length) || ((clientStatusApplicable)) || showExchDBBackupStatus || showExchMBBackupStatus || showSqlDBBackupStatus)"
		data-ng-class="{'single-tab': !multitabs, 'margin-top-15': !jobDetailFields.length }"
	>
		<div class="cv-accordion-header quick-view-tab">
			<div
				data-ng-click="changeGridshown(0)"
				class="cv-main-bar-tab text-center"
				data-ng-class="{selected: whichGrid === 0}"
				data-ng-show="fullVMList.length"
			>
				<div class="cv-accordion-text" data-ng-bind="vmListTitle"></div>
			</div>
			<div
				data-ng-click="changeGridshown(1)"
				class="cv-main-bar-tab text-center"
				data-ng-class="{selected: whichGrid === 1}"
			>
				<div class="cv-accordion-text"><cv:msg key="header.events" bundle="events" /></div>
			</div>
			<div
				data-ng-click="changeGridshown(2)"
				class="cv-main-bar-tab text-center"
				data-ng-class="{selected: whichGrid === 2}"
				data-ng-if="clientStatusApplicable && showClientsTab"
			>
				<div class="cv-accordion-text"><cv:msg key="label.clients" bundle="job" /></div>
			</div>
			<div
				data-ng-click="changeGridshown(3)"
				class="cv-main-bar-tab text-center"
				data-ng-class="{selected: whichGrid === 3}"
				data-ng-if="showExchDBBackupStatus"
			>
				<div class="cv-accordion-text" data-ng-bind="exchDBBackupInfoGridOptions.cvGridTitle"></div>
			</div>
			<div
				data-ng-click="changeGridshown(4)"
				class="cv-main-bar-tab text-center"
				data-ng-class="{selected: whichGrid === 4}"
				data-ng-if="showExchMBBackupStatus"
			>
				<div class="cv-accordion-text" data-ng-bind="exchMBBackupInfoGridOptions.cvGridTitle"></div>
			</div>
			<div
				data-ng-click="changeGridshown(5)"
				class="cv-main-bar-tab text-center"
				data-ng-class="{selected: whichGrid === 5}"
				data-ng-if="showSqlDBBackupStatus"
			>
				<div><cv:msg key="label.databaseStatus" bundle="job" /></div>
			</div>
		</div>
		<div data-ng-switch="whichGrid">
			<div data-ng-switch-when="0" class="quick-view-table" data-ng-controller="jobDetailVmListController">
				<cv-kendo-grid cv-grid-options="kendoGridOptions"></cv-kendo-grid>
			</div>
			<div data-ng-switch-when="1" class="quick-view-table" data-ng-controller="eventsListController">
				<cv-kendo-grid cv-grid-options="kendoGridOptions" class="eventsGrid"></cv-kendo-grid>
			</div>
			<div data-ng-switch-when="2" class="quick-view-table" data-ng-controller="jobDetailClientListController">
				<cv-kendo-grid cv-grid-options="kendoGridOptions"></cv-kendo-grid>
			</div>
			<div data-ng-switch-when="3" class="quick-view-table" data-ng-controller="jobDetailExchDbbInfoController">
				<cv-kendo-grid cv-grid-options="kendoGridOptions"></cv-kendo-grid>
			</div>
			<div data-ng-switch-when="4" class="quick-view-table">
				<cv-grid cv-grid-options="exchMBBackupInfoGridOptions" cv-is-page-title="false" cv-max-columns="4"></cv-grid>
			</div>
			<div data-ng-switch-when="5" class="quick-view-table" data-ng-controller="JobDetailSQLDBBInfoController">
				<cv-kendo-grid cv-grid-options="kendoGridOptions"></cv-kendo-grid>
			</div>
		</div>
	</div>

	<div class="button-container">
   		<button id="job_button_#5709" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"><cv:msg key="label.close" bundle="messagesJs" /></button>
    </div>
</div>
