import { acAppEventsModule } from 'common/js/modules';

var eventsMod = acAppEventsModule;

eventsMod.service('eventService', [
	'$http',
	'$interval',
	function($http, $interval) {
		this.pollPromise = null;
		this.eventIds = [];
		this.events = {};
		this.getAllEvents = function(successcallBack, errorCallBack) {
			var service = this;
			return $http
				.get('allEvents.do')
				.success(function(data) {
					//service.updateRunningevents(data.events);
					successcallBack(data);
				})
				.error(errorCallBack);
		};

		this.getEvents = function(params, ignoreLoadingBar) {
			var request = $http.get('events.do', {
				params: params,
				ignoreLoadingBar: ignoreLoadingBar
			});
			return request;
		};

		this.destroy = function() {
			if (this.pollPromise) {
				$interval.cancel(this.pollPromise);
				this.pollPromise = null;
				this.eventIds = [];
				this.events = {};
			}
		};

		this.updateRunningevents = function(eventsArray) {
			this.eventIds = [];
			this.events = {};
			for (var i = 0; i < eventsArray.length; i++) {
				var event = eventsArray[i]['eventSummary'];
				if (this.isActiveevent(event['status'])) {
					this.events[event['eventId']] = event;
					this.eventIds.push(event['eventId']);
				}
			}
		};

		// get params is an accessor function which returns the current params
		this.startPollingEvents = function(getParams, successCallBack, errorCallBack) {
			var delay = 60000;
			var service = this;

			this.pollPromise = $interval(function() {
				service.refreshEvents(getParams(), successCallBack, errorCallBack);
			}, delay);
		};

		this.loadEvent = function(eventId) {
			return $http.get('eventDetails.do?eventId=' + eventId);
		};
		this.refreshEvents = function(params, successCallBack, errorCallBack) {
			var service = this;
			var endTime = Math.ceil(new Date().getTime() / 1000);
			var startTime = endTime - 60;
			var _params = angular.extend({}, params, {
				startTime: startTime,
				endTime: endTime
			});
			this.getEvents(_params, successCallBack, errorCallBack, true);
		};
	}
]);

export default eventsMod;
