export const getColumnTemplate = function(angularLibs, hideJobIdColumn, isModal) {
	const columnList = [
		getSeverity(angularLibs.cvLoc),
		getEventId(angularLibs.cvLoc),
		cv.isCometApp ? getCommcellName(angularLibs.cvLoc) : undefined,
		getJobId(angularLibs.cvLoc, hideJobIdColumn),
		getTimeSource(angularLibs.cvLoc),
		getSubSystem(angularLibs.cvLoc),
		getEventClientName(angularLibs.cvLoc),
		getEventCode(angularLibs.cvLoc),
		getEventDescription(angularLibs.cvLoc)
	].filter(column => column);

	if (hideJobIdColumn) {
		columnList.splice(2, 1);
	}
	if (isModal) {
		columnList.splice(2, 4);
	}
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getSeverity = function(cvLoc) {
	return {
		severity: {
			title: cvLoc('Severity'),
			template:
				'<div class="eventsIconSelector">' +
				'<div cv-toggle="toolTip" cv-toggle-content="#:severityText#" class="#:severityClass#">#:severityText#</div>' +
				'</div>',
			type: 'string',
			searchField: 'severity',
			filterType: 'checkboxmultiselect',
			width: '10%',
			data: [
				{
					value: '0',
					label: cvLoc('label.info')
				},
				{
					value: '3',
					label: cvLoc('label.minor')
				},
				{
					value: '6',
					label: cvLoc('label.major')
				},
				{
					value: '9',
					label: cvLoc('label.critical')
				}
			],
			filterQueryParam: 'severity'
		}
	};
};

export const getEventId = function(cvLoc) {
	return {
		id: {
			title: cvLoc('Event ID'),
			type: 'number',
			width: '10%',
			template: getEventIdTemplate(),
			attributes: {
				class: 'event-id-column'
			}
		}
	};
};

export const getJobId = function(cvLoc) {
	return {
		jobId: {
			title: cvLoc('Job ID'),
			template:
				'<span class="crop" cv-toggle="toolTip" cv-toggle-content="#:jobId#"><a href="#:jobUrl#" target="#:target#">#:jobId ? jobId : ""#</a></span>',
			width: '7%'
		}
	};
};

export const getTimeSource = function(cvLoc) {
	return {
		timeSource: {
			title: cvLoc('Date'),
			template:
				'<span class="time crop" cv-toggle="toolTip" cv-toggle-content="#:formattedTimeSource#">#:formattedTimeSource#</span>',
			width: '10%'
		}
	};
};

export const getSubSystem = function(cvLoc) {
	return {
		subsystem: {
			title: cvLoc('Program'),
			template: '<span class="crop" cv-toggle="toolTip" cv-toggle-content="#:subsystem#">#:subsystem#</span>',
			width: '10%'
		}
	};
};

export const getEventClientName = function(cvLoc) {
	return {
		'clientEntity.clientName': {
			title: cvLoc('Computer'),
			template:
				'<span class="crop" cv-toggle="toolTip" cv-toggle-content="#:clientEntity.clientName#">#:clientEntity.clientName#</span>',
			width: '10%'
		}
	};
};

export const getEventCode = function(cvLoc) {
	return {
		eventCodeString: {
			title: cvLoc('Event Code'),
			template:
				'<span class="crop" cv-toggle="toolTip" cv-toggle-content="#:eventCodeString#">#:eventCodeString#</span>',
			width: '7%'
		}
	};
};

export const getEventDescription = function(cvLoc) {
	return {
		description: {
			title: cvLoc('Description'),
			template: `<div><span class="crop"  cv-toggle="callout" 
					data-content='<div class="max-width-200">#:description#</div>' data-placement="auto">#=description#</span></div>`,
			width: '36%',
			attributes: {
				class: 'no-tooltip'
			}
		}
	};
};

export const getCommcellName = cvLoc => {
	const filterData = _.map(_.keys(cv.commcellUrls || []), commcellName => ({
		label: commcellName,
		value: commcellName
	}));
	return {
		'clientEntity.commCellName': {
			title: cvLoc('label.nav.commCell'),
			type: 'string',
			template: `#if(clientEntity.commCellName) {#<span cv-toggle-content="#:clientEntity.commCellName#" cv-toggle="tooltip" class="crop">#:clientEntity.commCellName#</span>#}#`,
			width: '10%',
			filterType: 'checkboxmultiselect',
			data: filterData,
			searchField: 'clientEntity.commCellName',
			filterQueryParam: 'commCellName'
		}
	};
};

function getEventIdTemplate() {
	return '<span class="crop" cv-toggle="toolTip" cv-toggle-content="#:id#"><a href="#:eventDetailsUrl#" target="#:target#">#:id#</a> </span>';
}
