<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.installUpdates" bundle="schedule"/></h1>
</div>
<form name="installUpdateJob" novalidate autocomplete="off" >
	<div class="serverMessage {{installCtrl.errorMessage.type}}" data-ng-bind-html="installCtrl.errorMessage.message"></div>		
	<div class="bootstrap-wrapper form-horizontal">
		<h4 class="modal-list text-left"><cv:msg key="label.selectServers" bundle="schedule"/></h4>
		<div data-ng-if="installCtrl.treeParams" data-ng-click="installCtrl.clearErrorMessage()" class="modal-body" >
			 <cv-entity-selection-tree-component
				data-mode="edit"
				data-tree-options="installCtrl.treeParams">
			</cv-entity-selection-tree-component>	
		</div>
		<div class="modal-body">
			<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
		</div>
	</div>
	<div class="modal-footer">
		<button id="installUpdateJob_button_#0482" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="installCtrl.cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
	 	<button id="installUpdateJob_button_#4053" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="installCtrl.runInstallUpdateJob()" ><cv:msg key="action.run" bundle="schedule"/></button> 
	</div>
</form>
