<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.schedule">
	<div>
		<div class="setup-title">
			<h1><fmt:message key="header.schedules" /></h1>
		</div>
		<div class="setup-content">
			<ul data-ng-controller='allShowSchedulesController' class="scheduleList">
				<li data-ng-repeat="scheduleIdent in sch.identifierList">
					<a class="btn" data-ng-click="loadSchedule(scheduleIdent)" ng-class="{'selectedVal': sch.current.identifier == scheduleIdent}">{{scheduleIdent.name}}</a>
				</li>
			</ul>
			<div >
			<form ng-init="setFormScope(this)" data-ng-controller='allEditSchedulesController' name="scheduleForm" novalidate class='schedules-form' cv-submit="saveSchedule()" autocomplete ="off">
				<div data-ng-bind="serverMessage.message" class="server-message" ></div>
				<div data-ng-show="sch.current.isEditing()" class="mainFormContent">
					<label for="name"><fmt:message key="label.name" />
						<input id="name" type="text" size=50 name="name" data-ng-model="sch.current.data.name"  data-ng-maxlength="108" required
							ng-class="{'has-error': cv.scheduleForm.needsAttention(scheduleForm.name)}" />
						<span class="help-block" ng-show="scheduleForm.name.$error.required && cv.scheduleForm.needsAttention(scheduleForm.name)">
							<fmt:message key="error.name" />
						</span>
						<span class="help-block" ng-show="scheduleForm.name.$error.maxlength && cv.scheduleForm.needsAttention(scheduleForm.name)">
							<fmt:message key="error.name.length" />
						</span>
					</label>	
					<div class="backup-options-wrapper">
						<label><fmt:message key="label.backupLevel" /></label>
						<div class="frequency"> <!-- !!! Style -->
							<label for="btIncremental">
								<input id="btIncremental" type="radio" name="backupLevel" value="INCREMENTAL"
									data-ng-model="sch.current.data.backupLevel" /><fmt:message key="option.incremental" />
							</label>
							<label for="btFull">
								<input id="btFull" type="radio" name="backupLevel" value="FULL"
									data-ng-model="sch.current.data.backupLevel" /><fmt:message key="option.full" />
							</label>
						</div>				
					</div>			
					<label><fmt:message key="label.frequency" /></label>
					<div class="frequency">
						<label for="ftDaily">
							<input id="ftDaily" type="radio" name="freqType" value="DAILY"
								data-ng-model="sch.current.data.freqType" /><fmt:message key="option.daily" />
						</label>
						<label for="ftWeekly">
							<input id="ftWeekly" type="radio" name="freqType" value="WEEKLY"
								data-ng-model="sch.current.data.freqType" /><fmt:message key="option.weekly" />
						</label>
					</div>
					<div data-ng-show="sch.current.data.freqType === 'AUTOMATIC_SCHEDULE'">
						<fmt:message key="label.min.interval" />
						<input type="text" size=4 name="minBackupIntervalHours" data-ng-model="sch.current.data.minBackupIntervalHours"/><fmt:message key="label.hours" />
						<input type="text" size=4 name="minBackupIntervalMinutes" data-ng-model="sch.current.data.minBackupIntervalMinutes"/><fmt:message key="label.minutes" />
						<br />
						<fmt:message key="label.max.interval" />
						<input type="text" size=4 name="maxBackupIntervalHours" data-ng-model="sch.current.data.maxBackupIntervalHours"/><fmt:message key="label.hours" />
						<input type="text" size=4 name="maxBackupIntervalMinutes" data-ng-model="sch.current.data.maxBackupIntervalMinutes"/><fmt:message key="label.minutes" />
					</div>
					<label><fmt:message key="label.time" /></label>
					<div data-ng-show="sch.current.data.freqType === 'DAILY' || sch.current.data.freqType === 'WEEKLY'" class="timePickerContainer">
		       			<div uib-timepicker data-ng-model="sch.current.data.activeStartTimeDate"  hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></div>
						<div data-ng-show="sch.current.data.freqType === 'WEEKLY'">
							<input id="day0" name="day0"  type="checkbox" data-ng-model="sch.current.data.daysToRun[0]" data-ng-required='!sch.current.daysValid()' />
							<label for="day0"><fmt:message key="label.day.mon" /></label>
							<input id="day1" name="day1" type="checkbox" data-ng-model="sch.current.data.daysToRun[1]" data-ng-required='!sch.current.daysValid()' />
							<label for="day1"><fmt:message key="label.day.tue" /></label>
							<input id="day2" name="day2" type="checkbox" data-ng-model="sch.current.data.daysToRun[2]" data-ng-required='!sch.current.daysValid()' />
							<label for="day2"><fmt:message key="label.day.wed" /></label>
							<input id="day3" name="day3" type="checkbox" data-ng-model="sch.current.data.daysToRun[3]" data-ng-required='!sch.current.daysValid()' />
							<label for="day3"><fmt:message key="label.day.thu" /></label>
							<input id="day4" name="day4" type="checkbox" data-ng-model="sch.current.data.daysToRun[4]" data-ng-required='!sch.current.daysValid()' />
							<label for="day4"><fmt:message key="label.day.fri" /></label>
							<input id="day5" name="day5" type="checkbox" data-ng-model="sch.current.data.daysToRun[5]" data-ng-required='!sch.current.daysValid()' />
							<label for="day5"><fmt:message key="label.day.sat" /></label>
							<input id="day6" name="day6" type="checkbox" data-ng-model="sch.current.data.daysToRun[6]" data-ng-required='!sch.current.daysValid()' />
							<label for="day6"><fmt:message key="label.day.sun" /></label>
							<span class="help-block" ng-show="!sch.current.daysValid() &&
									(cv.scheduleForm.needsAttention(scheduleForm.day0) || cv.scheduleForm.needsAttention(scheduleForm.day1)
									|| cv.scheduleForm.needsAttention(scheduleForm.day2) || cv.scheduleForm.needsAttention(scheduleForm.day3)
									|| cv.scheduleForm.needsAttention(scheduleForm.day4) || cv.scheduleForm.needsAttention(scheduleForm.day5)
									|| cv.scheduleForm.needsAttention(scheduleForm.day6))">
								<fmt:message key="label.selectDay" />
							</span>
						</div>
					</div>
					
						
					
					<div class="">
						<button id="addScheduleModalBody_button_#1356" style="float:right;" type="button" class="btn btn-default" data-ng-click="deleteSchedule()" data-ng-disabled="!sch.current.isEditing()"><fmt:message key="action.deleteSchedule" /></button> 
						<button id="addScheduleModalBody_button_#7996" style="float:right;" type="submit"  class="btn btn-primary" 
							data-ng-disabled="!sch.current.isEditing()"><fmt:message key="action.saveSchedule" /></button>														
					</div>
					<span style="clear:both;"></span>
				</div>
					<div class="button-container">
						<button id="addScheduleModalBody_button_#5982" type="button" class="btn btn-default" data-ng-click="cancel()" data-ng-disabled="!sch.current.isEditing()">Done</button> 
						
					</div>
				<a class="btn addSchedule" data-ng-click="cv.scheduleForm.setAttempted(false); addSchedule()" data-ng-disabled="sch.current.isEditingNew()"><fmt:message key="action.addNewSchedule" /></a>
			
			</form>
			</div>
		</div>
	</div>
</fmt:bundle>
