<div >
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.HeaderLanguages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<c:choose>
	<c:when test="${cookie.locale != null}">
		<c:set var="currentLocale" scope="session" value="${cookie.locale.value}" />
	</c:when>
    <c:when test="${pageContext.request.locale != null}">
		<c:set var="currentLocale" scope="session" value="${pageContext.request.locale}" />
	</c:when>
	<c:otherwise>
		<c:set var="currentLocale" scope="session" value="'en'" />
	</c:otherwise>
</c:choose>
<div data-ng-init="ctrl.init(${loginContext.forcePasswordChange}, ${sessionScope.ACCOUNT_SESSION_LOCKED || false})" id="user-account-toggle">
    <a class="header-menu-item use-before-pesudo">
		<span class="header-menu-small-size margin-right-5 header-svg">
            <svg xmlns="http://www.w3.org/2000/svg" fill="curentColor" viewBox="0 0 18 18"><path d="M9 8.24a3.453 3.453 0 10-3.453-3.453A3.453 3.453 0 009 8.24zm0-6.497a3.044 3.044 0 11-3.044 3.044A3.048 3.048 0 019 1.743zM15.845 15.485a7.138 7.138 0 00-6.846-6.349 7.136 7.136 0 00-6.844 6.331 1 1 0 00.932 1.18h.007c.641-.004 1.54-.006 2.568-.006 3.083 0 7.324.016 9.247.024h.004a1.001 1.001 0 00.932-1.18zm-.553.589a.501.501 0 01-.382.183c-1.738-.008-6.119-.025-9.248-.025-1.11 0-1.974.003-2.575.007a.5.5 0 01-.38-.184.658.658 0 01-.148-.528 7.312 7.312 0 012.201-4.273 6.11 6.11 0 018.483.006 7.314 7.314 0 012.197 4.284.662.662 0 01-.149.53z"/></svg>
        </span>
        <span class="header-menu-no-small-size">${loginContext.userEntity.userName}</span>
        <span data-ng-show="!ctrl.allDropDownItemsAreHidden" class="k-icon k-i-arrow-60-down header-menu-no-small-size header-menu-arrow"></span>
	</a>
</div>
    <ul id="user-header-dropdown" class="header-dropdown">
	<c:if test="${sessionScope.showLanguageSelectionDropdown != false}">
    <li >
        <a id="user-header-lang" data-context-menu-option="lang">
            <span class="header-svg"><svg viewBox="0 0 512 512" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="m373.851562 308.296875c-1.445312-4.820313-7.390624-7.074219-13.496093-7.074219-5.945313 0-11.890625 2.253906-13.335938 7.074219l-31.011719 101.0625c-.160156.644531-.320312 1.285156-.320312 1.605469 0 5.144531 7.550781 8.675781 13.175781 8.675781 3.535157 0 6.265625-1.121094 7.070313-4.175781l6.101562-21.371094h36.796875l6.109375 21.371094c.800782 3.054687 3.53125 4.175781 7.066406 4.175781 5.625 0 13.175782-3.691406 13.175782-8.675781 0-.480469-.160156-.964844-.320313-1.605469zm-27.476562 69.40625 13.976562-49.324219 13.984376 49.324219zm0 0"/><path d="m456.835938 208.867188h-153.707032v-65.648438l49.953125-35.679688c3.941407-2.816406 6.28125-7.359374 6.28125-12.203124 0-4.847657-2.339843-9.390626-6.28125-12.207032l-50.554687-36.109375c-3.949219-26.570312-26.914063-47.019531-54.5625-47.019531h-192.796875c-30.421875 0-55.167969 24.746094-55.167969 55.167969v192.800781c0 30.417969 24.746094 55.164062 55.167969 55.164062h153.703125v65.648438l-49.953125 35.679688c-3.941407 2.816406-6.28125 7.363281-6.28125 12.207031s2.339843 9.390625 6.28125 12.203125l50.554687 36.109375c3.949219 26.570312 26.914063 47.019531 54.5625 47.019531h192.800782c30.417968 0 55.164062-24.75 55.164062-55.167969v-192.796875c0-30.421875-24.746094-55.167968-55.164062-55.167968zm-401.667969 64.265624c-13.878907 0-25.167969-11.289062-25.167969-25.167968v-192.800782c0-13.875 11.289062-25.164062 25.167969-25.164062h192.796875c13.875 0 25.164062 11.289062 25.164062 25.164062 0 4.847657 2.339844 9.394532 6.28125 12.207032l39.144532 27.960937-39.144532 27.960938c-3.941406 2.816406-6.28125 7.363281-6.28125 12.207031v73.367188h-9.09375c-30.417968 0-55.164062 24.746093-55.164062 55.164062v9.101562zm426.832031 183.699219c0 13.878907-11.289062 25.167969-25.164062 25.167969h-192.800782c-13.875 0-25.164062-11.289062-25.164062-25.167969 0-4.84375-2.339844-9.390625-6.28125-12.203125l-39.144532-27.960937 39.144532-27.960938c3.941406-2.816406 6.28125-7.363281 6.28125-12.207031v-112.464844c0-13.878906 11.289062-25.167968 25.164062-25.167968h24.054688.039062.039063 168.667969c13.875 0 25.164062 11.289062 25.164062 25.167968zm0 0"/><path d="m197.652344 138.277344c4.667968 0 8.457031-3.789063 8.457031-8.460938s-3.789063-8.460937-8.457031-8.460937h-37.628906v-20.539063c0-4.671875-3.789063-8.460937-8.460938-8.460937-4.667969 0-8.457031 3.789062-8.457031 8.460937v20.539063h-37.628907c-4.667968 0-8.457031 3.789062-8.457031 8.460937s3.789063 8.460938 8.457031 8.460938h11.660157c1.863281 17.863281 9.566406 34.007812 21.152343 46.511718-9.605468 5.75-20.824218 9.070313-32.8125 9.070313-4.667968 0-8.457031 3.785156-8.457031 8.457031s3.789063 8.460938 8.457031 8.460938c17.117188 0 32.996094-5.351563 46.085938-14.453125 13.09375 9.101562 28.972656 14.453125 46.089844 14.453125 4.667968 0 8.457031-3.789063 8.457031-8.460938s-3.789063-8.457031-8.457031-8.457031c-11.988282 0-23.207032-3.3125-32.8125-9.070313 11.585937-12.503906 19.289062-28.648437 21.152344-46.511718zm-46.089844 35.941406c-9.253906-9.605469-15.539062-22.078125-17.378906-35.941406h34.761718c-1.839843 13.863281-8.125 26.335937-17.382812 35.941406zm0 0"/></svg></span>
            <span><cv:msg key="label.language" /></span>
        </a>
        <ul>
            <c:forTokens items="en,es,es_MX,de,fr,fr_CA,ja,ko,ru,zh,zh_TW" delims="," var="langId">
                <li data-ng-class="{'selected': ctrl.curLocal.localeName === '${langId}'}" class="lang-dropdown"><a id="${langId}" data-context-menu-option="${langId}">
					<fmt:bundle basename="localization.HeaderLanguages">
						<fmt:message key="${langId}" var="curLangWord" />
					</fmt:bundle>
					<fmt:setLocale value="${langId}" scope="request" />
					<fmt:bundle basename="localization.HeaderLanguages">
						<fmt:message key="${langId}" var="nativeLangWord" />
					</fmt:bundle>
					<fmt:setLocale value="${curLocale}" scope="request" />
					${curLangWord}
					<c:if test="${curLangWord != nativeLangWord}" >
						-&nbsp;${nativeLangWord}
					</c:if>
				</a></li>
			</c:forTokens>
        </ul>
    </li>
   	</c:if>
    <li >
        <a id="user-header-userPreference" href="#/userPreference">
            <span class="header-svg"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M21.8 11.6l2.5-1a12 12 0 0 0-2-5l-2.5 1.1-1.5-1.5 1.1-2.5a12 12 0 0 0-4.8-2l-1 2.5h-2.2l-1-2.5a12 12 0 0 0-4.8 2l1 2.5-1.4 1.5-2.5-1.1a12 12 0 0 0-2 5l2.5 1v2l-2.5 1a12 12 0 0 0 2 4.8l2.6-1 1.4 1.4-1 2.5a12 12 0 0 0 4.8 2l1-2.5h2.2l1 2.5a12 12 0 0 0 4.9-2l-1.1-2.4 1.4-1.4 2.5 1.1a12 12 0 0 0 2-4.9l-2.4-1v-2.1zM12.5 18a5.5 5.5 0 1 1 5.5-5.5 5.5 5.5 0 0 1-5.5 5.5z"/><circle cx="12.5" cy="12.5" r="3.5"/></svg></span>
			<cv:msg key="label.userPreference" bundle="navJs"/>
        </a>
    </li>
    <li >
        <a id="user-header-license" href="#/license">
			<span class="header-svg"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M15.6.8v5h5l-5-5zM14.5 20.2h1v1h-1z"/><path d="M14.5 6.9V.7H4.3v23.6h8.2v-4.1h2v-1h-2v-1h-1v-1h1v-1h-1v-1h1V14h2v-1h1v1h2v1h1v1h-1v1h1v1h-1v1h-2v1h2v4h3V7zm4.1 4.1H6.4v-1h12.2zm0-2H6.4V8h12.2z"/><path d="M15.6 23.2v-1h-1v1h-1v1h3v-1h-1z"/></svg></span>
			<cv:msg key="label.license"/>
		</a>
    </li>
    <li >
        <a id="user-header-accessibilityOff" href="" data-context-menu-option="accessibilityOff">
            <span class="header-svg">
            	<span class="off"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M21 9A13.6 13.6 0 0 0 12.4 6c-7.3 0-11.3 5.4-11.3 6.4 0 .5 1 2 2.9 3.6a13.6 13.6 0 0 0 8.4 2.8 13.6 13.6 0 0 0 8.4-2.8c2-1.5 3-3.1 3-3.6s-1-2-3-3.6zm-8.5 8.2a4.8 4.8 0 0 1-4.9-4.7 4.8 4.8 0 0 1 4.9-4.7 4.8 4.8 0 0 1 4.9 4.7 4.8 4.8 0 0 1-4.9 4.7z"/><path d="M14.9 11.6l-.2.2a1 1 0 0 1-.8.4 1.1 1.1 0 0 1-1.1-1.1 1.1 1.1 0 0 1 .4-.8l.2-.2h-.2a3 3 0 0 0-.7-.1 2.5 2.5 0 1 0 2.5 2.5 3 3 0 0 0-.1-.7z"/></svg></span>
            </span>
			<span class="off text"><cv:msg key="label.turnonaccessibility" /></span>
        </a>
    </li>
    <li >
        <a id="user-header-accessibilityOn" href="" data-context-menu-option="accessibilityOn">
            <span class="header-svg">
				<span class="on"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M24 12.1c0-.5-1-2.1-3-3.6a14 14 0 0 0-8.6-3 14.3 14.3 0 0 0-5 1h-.1L4 3.3 2.8 4.6l2.8 2.8-.3.2-.9.5-.5.4-.8.6-.5.5-.6.7a6.8 6.8 0 0 0-.4.6 4.4 4.4 0 0 0-.5.8 1.1 1.1 0 0 0-.1.4c0 .5 1 2.1 3 3.6a13.6 13.6 0 0 0 5 2.5l1.2.2a13 13 0 0 0 1.5.2H14l.8-.2a10 10 0 0 0 1.2-.2l.4-.1 3.6 3.6 1.3-1.3-3-3c3.8-1.7 5.7-4.6 5.7-5.3zM5.4 7.7l.4-.1.8.8 1.3 1.3-.1.4-1.4-1.4-1-.9zm-1 .8l.2-.2 1 1L7.4 11a2.6 2.6 0 0 0-.1.4 3 3 0 0 0 0 .4L5.2 9.8 4 8.7zm-1.2 6.3l-.7-.7a11.7 11.7 0 0 1-.7-.9 3 3 0 0 1-.6-1 .7.7 0 0 1 0-.3l.9.9L6.3 17a13.1 13.1 0 0 1-3-2.2zm5.4 3l-5.7-5.6L1.8 11c0-.2.2-.3.4-.5l1 1L9.8 18a10 10 0 0 1-1.1-.1zm2.8.6L4 11 2.8 9.8l.5-.5 1.1 1.1 3 3a5.2 5.2 0 0 0 3.4 3.4l1.5 1.5h-1zm2.8 0h-.5L12.5 17a3.4 3.4 0 0 0 .5 0h.4l1.2 1.1zm1.6-.3l-1.3-1.3a3.5 3.5 0 0 0 .3-.1l1.4 1.3zm-1.5-1.5a5 5 0 0 1-1 .3 5.3 5.3 0 0 1-.8 0h-.2a5.2 5.2 0 0 1-1.8-.3A5 5 0 0 1 8 13.9a4.7 4.7 0 0 1-.3-1.7 4.9 4.9 0 0 1 .4-2 4 4 0 0 1 .2-.3l1.8 1.8a2.5 2.5 0 0 0 2.5 3h.4l1.8 1.8-.3.2zm1.9-1.3l-1.7-1.6a2.5 2.5 0 0 0 .5-2.3v-.2l-.2.2a1.1 1.1 0 0 1-.9.4 1.1 1.1 0 0 1-1.1-1.1 1.1 1.1 0 0 1 .4-.9l.2-.1h-.2a3.1 3.1 0 0 0-.7-.2 2.6 2.6 0 0 0-1.6.6L9.2 8.4h.1a5 5 0 0 1 3.2-1 4.9 4.9 0 0 1 5 4.7 4.7 4.7 0 0 1-1.3 3.2z"/></svg></span>
            </span>
                <span class="on text"><cv:msg key="label.turnoffaccessibility" /></span>
        </a>
    </li>
    <li >
        <a id="user-header-about" href="" data-context-menu-option="about" >
			<span class="header-svg"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M20.6 4.4a11.5 11.5 0 1 0 3.4 8.1 11.5 11.5 0 0 0-3.4-8.1zm-6.5.6l-.4 9.8h-2.3L11 5zm-.4 14a1.6 1.6 0 0 1-1.1.4 1.6 1.6 0 0 1-1.2-.4 1.4 1.4 0 0 1-.4-1.1 1.4 1.4 0 0 1 .4-1.1 1.6 1.6 0 0 1 1.2-.4 1.6 1.6 0 0 1 1.1.4 1.5 1.5 0 0 1 0 2.1z"/></svg></span>
			<cv:msg key="label.about" bundle="clients" />
		</a>
    </li>
    <li >
        <a id="user-header-help" data-ng-href="{{ctrl.helpLink}}" target="_blank">
		    <span class="header-svg"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M20.6 4.4a11.5 11.5 0 1 0 3.4 8.1 11.5 11.5 0 0 0-3.4-8.1zm-7.2 14.8a1.6 1.6 0 0 1-1.2.4 1.6 1.6 0 0 1-1.1-.4 1.4 1.4 0 0 1-.5-1 1.4 1.4 0 0 1 .5-1.1 1.8 1.8 0 0 1 2.2 0 1.4 1.4 0 0 1 .5 1 1.4 1.4 0 0 1-.4 1.1zm3-8.7a6.5 6.5 0 0 1-1.3 1.6l-.8.8a2.7 2.7 0 0 0-.9 1.7v.6H11a5.7 5.7 0 0 1 .3-2.2 4.4 4.4 0 0 1 1.3-1.6 6.5 6.5 0 0 0 1.1-1.3 2 2 0 0 0 .3-1c0-1-.5-1.6-1.5-1.6a1.5 1.5 0 0 0-1.2.4 1.7 1.7 0 0 0-.4 1.2H8a3.8 3.8 0 0 1 1.2-3 4.7 4.7 0 0 1 3.2-1 4.7 4.7 0 0 1 3.2 1 3.6 3.6 0 0 1 1.2 2.8 3.4 3.4 0 0 1-.4 1.6z"/></svg></span>
			<cv:msg key="label.help"/>
		</a>
    </li>
    <li data-ng-show="ctrl.showFeedback">
        <a id="user-header-feedback" data-ng-click="ctrl.goToFeedback()">
		    <span class="header-svg feedback-icon-aligned"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M23.4 12.5C23.4 5.7 18.8.2 13 .2a10 10 0 0 0-7.8 4A8.2 8.2 0 0 1 1.6.9 14.6 14.6 0 0 0 3 8.4a13.7 13.7 0 0 0-.6 4.1C2.4 19.3 7 24.8 13 24.8s10.5-5.5 10.5-12.3zM11 6.3a1.6 1.6 0 1 1 3.1 0 1.6 1.6 0 0 1-3.1 0zm0 6.2a1.6 1.6 0 1 1 1.6 1.6 1.6 1.6 0 0 1-1.6-1.6zm0 6.2a1.6 1.6 0 1 1 1.6 1.6 1.6 1.6 0 0 1-1.6-1.6z"/></svg></span>
			<cv:msg key="label.feedback"/>
		</a>
    </li>
    <li >
		<a id="user-header-support" data-ng-href="{{ctrl.customerSupportLink}}" target="_blank">
			<span class="header-svg"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><path d="M14.49,5.5A1.1,1.1,0,0,1,14,4.75a6.32,6.32,0,0,0-12.21.13,1,1,0,0,1-.38.54A3,3,0,0,0,.13,8a3.9,3.9,0,0,0,.42,2,2.32,2.32,0,0,0,2,1.56c1.28,0,2.31-1.41,2.31-3.15A3.45,3.45,0,0,0,3.61,5.6,3.24,3.24,0,0,1,3.9,4.44a4.54,4.54,0,0,1,7.28-1.08,3.53,3.53,0,0,1,1.1,2.13,3.42,3.42,0,0,0-1.22,2.76A3.4,3.4,0,0,0,12.29,11a2.25,2.25,0,0,1-.46,1,4.71,4.71,0,0,1-2.71,1.85,1.2,1.2,0,0,0-1.63-.62,1.57,1.57,0,0,0-.84,1.18,1.64,1.64,0,0,0,.79,1.26,1.09,1.09,0,0,0,.54.14,1.39,1.39,0,0,0,1.13-.69.63.63,0,0,1,.32-.19,6.13,6.13,0,0,0,4-3.36.47.47,0,0,1,.14-.18,2.14,2.14,0,0,0,1.53-1A2.36,2.36,0,0,0,15.63,9C15.75,8,15.92,6.41,14.49,5.5Z"/></svg></span>
			<cv:msg key="label.customerSupport"/>
		</a>
	</li>
    <li >
        <a id="user-header-changePassword" href="#/changePassword">
            <span class="header-svg"><svg fill="currentColor"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M15 13h-.6v-1.5a2 2 0 0 0-4.2 0v1.6h-.5a.5.5 0 0 0-.5.5v3.6a.5.5 0 0 0 .5.6H15a.5.5 0 0 0 .5-.6v-3.6a.5.5 0 0 0-.5-.5zm-1.6 0h-2.1v-1.5a1 1 0 1 1 2 0z"/><path d="M12.1 24a10.4 10.4 0 1 1 0-20.8h.6v-3a.2.2 0 0 1 .1-.1h.2l4 4a.1.1 0 0 1 0 .2l-4 4a.2.2 0 0 1-.1 0 .2.2 0 0 1-.2-.2V5h-.6a8.5 8.5 0 1 0 8.5 8.5 8.4 8.4 0 0 0-2-5.5.2.2 0 0 1 0-.2l1.1-1.1a.2.2 0 0 1 .1 0 .2.2 0 0 1 .2 0A10.4 10.4 0 0 1 12 24z"/></svg></span>
            <cv:msg key="label.changePassword"/>
        </a>
    </li>
    <li >
        <a id="user-header-lock" data-context-menu-option="lock">
            <span class="header-svg"><svg fill="currentColor"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M20 10.8h-1.5V6.4a6 6 0 0 0-12 0v4.4H5a1.5 1.5 0 0 0-1.4 1.5v10.4A1.5 1.5 0 0 0 5 24.3h15a1.5 1.5 0 0 0 1.5-1.5V12.3a1.5 1.5 0 0 0-1.5-1.5zm-4.5 0h-6V6.4a3 3 0 0 1 3-3.1 3 3 0 0 1 3 3z"/></svg></span>
            <cv:msg key="label.lock"/>
        </a>
    </li>
    <li >
        <a id="user-header-logout" href="logout.do">
            <span class="header-svg"><svg fill="currentColor"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M20 10.8h-1.5V6.4a6 6 0 0 0-12 0v4.4H5a1.5 1.5 0 0 0-1.4 1.5v10.4A1.5 1.5 0 0 0 5 24.3h15a1.5 1.5 0 0 0 1.5-1.5V12.3a1.5 1.5 0 0 0-1.5-1.5zm-4.5 0h-6V6.4a3 3 0 0 1 3-3.1 3 3 0 0 1 3 3z"/></svg></span>
            <cv:msg key="label.logout"/>
        </a>
    </li>
</ul>
</div>
