<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.training" bundle="ediscovery" /></h1>
</div>
<div class="setup-content">
	<span class="{{ serverMessage.type }}" ng-bind="serverMessage.message" ng-if="serverMessage"></span>
	<form
		name="trainingForm"
		autocomplete="off"
		cv-submit="startTraining()"
		class="form-horizontal bootstrap-wrapper"
		novalidate
	>
		<div class="loading-data margin-top-15 margin-left-15 margin-right-15" ng-if="dataLoading">
			<div class="loader-skeleton tile-style margin-bottom-15 full-width"></div>
			<div class="loader-skeleton tile-style margin-bottom-15 full-width"></div>
			<div class="loader-skeleton tile-style margin-bottom-5 full-width"></div>
		</div>
		<div ng-if="!dataLoading">
			<div class="form-group margin-top-10">
				<label class="col-lg-4 margin-left-20" for="displayName"><cv:msg key="label.tag" bundle="ediscovery" /> </label>
				<div class="col-xs-12 col-lg-7">
					<isteven-multi-select
						id="trainClassifier_isteven-multi-select_#6888"
						directive-id="trainClassifier_isteven-multi-select_#6888"
						input-model="tags"
						output-model="tc.selectedTag"
						button-label="label"
						item-label="label"
						selection-mode="single"
						tick-property="checked"
						class="isteven-multi-select user-group-select"
						translation="localLang"
						on-close="selectTag()"
					>
					</isteven-multi-select>
					<input type="text" name="selectedTag" id="selectedTag" ng-model="tc.selectTag" ng-hide="true" required />
					<div class="help-block" ng-show="cv.trainingForm.needsAttention(trainingForm.selectedTag)">
						<i class="ion-alert-circled"></i>
						<span><cv:msg key="error.selectTag" bundle="ediscovery" /></span>
					</div>
				</div>
			</div>
			<div class="form-group margin-top-10">
				<label class="col-lg-4 margin-left-20" for="description"
					><cv:msg key="label.entity" bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-lg-7">
					<isteven-multi-select
						id="trainClassifier_isteven-multi-select_#6889"
						directive-id="trainClassifier_isteven-multi-select_#6889"
						input-model="entities"
						output-model="tc.selectedEntity"
						button-label="label"
						item-label="label"
						selection-mode="single"
						tick-property="checked"
						class="isteven-multi-select user-group-select"
						translation="localLang"
						on-close="selectEntity()"
					>
					</isteven-multi-select>
					<input
						type="text"
						name="selectedEntity"
						id="selectedEntity"
						ng-model="tc.selectEntity"
						ng-hide="true"
						required
					/>
					<div class="help-block" ng-show="cv.trainingForm.needsAttention(trainingForm.selectedEntity)">
						<i class="ion-alert-circled"></i>
						<span><cv:msg key="error.selectAnEntity" bundle="ediscovery" /></span>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button
				id="trainClassifier_button_#01"
				type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				ng-click="closeDialog()"
			>
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="trainClassifier_button_#02" type="submit" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="label.start" bundle="job" />
			</button>
		</div>
	</form>
</div>
