<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editPlan" bundle="profiles"/></h1>
</div>
<div class="padding-top-10 setup-content">
	<div data-ng-class="editPlanServerMessage.type" class="serverMessage" data-ng-bind="editPlanServerMessage.message"></div>
	<form id="editPlanForm" name="editPlanForm" data-cv-submit="savePlanForSubclient()" novalidate autocomplete="off">
		<div class="cv-modal-wrapper" data-ng-show="planList && planList.length">
			<label class="cv-label"><cv:msg key="label.profile" bundle="profiles" /></label>
			<div class="cv-inline-wrapper">
				<div class="padding-right-20">
					<cv-plan-summary-dropdown
						input-model="planList"
						output-model="selectedPlanList"
						item-label="'planName'"
						button-label="'planName'"
						tick-property="'selected'"
						max-labels="1"
						group-property="'msGroup'"
						selection-mode="'single'"
						helper-elements="'filter'"
						directive-id="'plans'"
						show-none="true"
						on-close="parseIStevenOutput()">
					</cv-plan-summary-dropdown>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="editPlanSubclient_button_#2030" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="editPlanSubclient_button_#3704" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!selectedPlanList.length || planId==selectedPlan"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>
