<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1 data-ng-if="!editMode"><cv:msg key="label.createView" bundle="messagesJs" /></h1>
		<h1 data-ng-if="editMode"><cv:msg key="label.editView" bundle="messagesJs" /> - <span>{{model.viewName | decodeURIComponent}}</span></h1>
	</div>
	<div class="setup-content">
		<form name="createViewform" cv-hide-api novalidate data-cv-submit="createView()" autocomplete="off" class="create-view-form" id="create-view-form">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div>
				<div class="cv-modal-wrapper">
					<label class="cv-label grid-view" for="viewName"><cv:msg key="label.saveViewName" bundle="messagesJs" /></label>
					<div class="cv-inline-wrapper grid-view">
						<input type="text" name="viewName" id="viewName" data-ng-model="model.viewName" required data-ng-class="{'has-error': cv.createViewform.needsAttention(createViewform.viewName)}" autofocus/>
						<input name="chkSetAsDefault" id="chkSetAsDefault" type="checkbox" data-ng-model="model.isDefault" >
						<label for="chkSetAsDefault" class="cv-checkbox-label"><cv:msg key="label.setAsDefault" bundle="messagesJs" /></label>
					</div>
					<span class="help-block" data-ng-show="cv.createViewform.needsAttention(createViewform.viewName)"><cv:msg key="error.name" bundle="messagesJs" /></span>
				</div>
				<hr />
			</div>

			<div class="cv-modal-wrapper">
				<h4 class="text-left section-heading"><cv:msg key="label.rules" bundle="messagesJs" /></h4>
			</div>

			<div id="rules-widget-wrapper">
				<ul class="list-inline" data-ng-repeat="rule in modifiedRules track by $index">
					<li>
						<label for="rule-{{$index}}" class="select-label">
							<select name="rule-{{$index}}" id="rule-{{$index}}" class="rule-column-name" data-options-class="{ 'hidden' : disabled, 'show': !disabled }" data-ng-model="rule.colIndex" data-ng-options="columns.indexOf(column) as column.displayName for (idx, column) in columns" data-ng-change="changeRule($index, rule.colIndex)">
							</select>
						</label>
					</li>
					<li data-ng-if="rule.column" class="ruleCondition">
						<label for="ruleCondition-{{$index}}" class="select-label">
							<select name="ruleCondition-{{$index}}" id="ruleCondition-{{$index}}" class="override-select rule-condition" data-ng-disabled="!isTextFilter(rule.column)" data-ng-model="rule.filterCondition">
								<option value="contains"><cv:msg key="label.contains" bundle="messagesJs" /></option>
								<option value="equals" data-ng-hide='rule.filterCondition=="contains"'><cv:msg key="label.equals" bundle="messagesJs" /></option>
							</select>
						</label>
					</li>
					<li class="grid-rule-filter">
						<span id="ruleFilter-{{$index}}" class="grid-column-field-filter rule-filter"></span>
					</li>
					<li data-ng-if="rule.column">
						<span class="glyphicon glyphicon-remove rule-remove" data-ng-click="removeRule($index)" title="<cv:msg key="label.remove" bundle="messagesJs" /> {{rule.column.displayName}}"></span>
					</li>
				</ul>
				<p class="text-center" data-ng-if="!modifiedRules.length"><cv:msg key="label.noRulesAdded" bundle="messagesJs" /></p>
			</div>

				<div class="cv-button-wrapper">
					<button id="createView_button_#8274" data-ng-disabled="!columns.length" type="button" class="btn btn-default" data-ng-click="addNewRule()"><cv:msg key="label.addRule" bundle="messagesJs" /></button>
				</div>
<%-- 					<div class="cv-modal-wrapper">
						<label for="selectedColumn-sortDirection" class="select-label">
							<cv:msg key="label.sort" bundle="messagesJs"/>
							<select name="selectedColumn-sortDirection" id="selectedColumn-sortDirection" data-ng-model="selectedColumn.sort.direction" data-ng-disabled="selectedColumn.enableSorting === false">
								<option value=""></option>
								<option value="asc">Ascending</option>
								<option value="desc">Descending</option>
							</select>
						</label>
					</div>
					<div class="cv-modal-wrapper" data-ng-show="selectedColumn.enableFiltering !== false">
						<label class="cv-label" for="viewName"><cv:msg key="label.filterBy" bundle="messagesJs" /></label>
						<div class="cv-inline-wrapper">
							<div id="selectedColumn-filter" class="grid-column-field-filter"></div>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<!-- Detect if the filter is input field -->
						<label for="selectedColumn-filterCondition" class="select-label">
							<cv:msg key="label.filterCondition" bundle="messagesJs"/>
							<select name="selectedColumn-filterCondition" id="selectedColumn-filterCondition" data-ng-model="selectedColumn.filters[0].condition" data-ng-disabled="selectedColumn.enableFiltering === false">
								<option value=""></option>
								<option value="2">Starts with</option>
								<option value="4">Ends with</option>
								<option value="8">Exact</option>
								<option value="16">Contains</option>
							</select>
						</label>
					</div>
					<div class="cv-modal-wrapper" data-ng-show="selectedColumn.enableHiding !== false">
						<label for="selectedColumn-IsVisibile" class="cv-inline-checkbox create-view-checkbox">
							<input name="selectedColumn-IsVisibile" id="selectedColumn-IsVisibile" type="checkbox" data-ng-model="selectedColumn.visible" >
							<label for="selectedColumn-IsVisibile" class="cv-checkbox-label" style="float:left"><cv:msg key="label.visible" bundle="messagesJs" /></label>

							<div style="margin:0 20px; float: right;">
								<button id="createView_button_#8635" type="button" class="btn btn-default" data-ng-click="addModification(selectedColumn)"><cv:msg key="Add" /></button>
							</div>
						</label>
					</div> --%>

			<%-- <div class="grid-columns-fields">
				<fieldset class="create-view-fieldset" data-ng-repeat="col in columns" data-ng-if="col.displayName && col.enableFiltering !== false">
					<!-- <legend class="create-view-legend">{{col.displayName}}</legend> -->
					<span for="{{$index}}-isVisible" class="cv-inline-checkbox">
						<input name="{{$index}}-isVisible" id="{{$index}}-isVisible" type="checkbox" data-ng-model="col.visible" data-ng-checked="{{col.visible}}" data-ng-disabled="col.colDef.enableHiding == false" />
						<label for="{{$index}}-isVisible" class="cv-checkbox-label"><cv:msg key="label.visible" bundle="messagesJs" /></label>
					</span>
					<fieldset class="create-view-fieldset create-view-sort-section" data-ng-class="{'invisible':!col.enableSorting}">
						<legend class="create-view-legend"><cv:msg key="label.sort" bundle="messagesJs" /></legend>
						<label for="{{$index}}-sortDirection" class="select-label create-view-sort-label">
							<cv:msg key="label.sort.direction" bundle="messagesJs"/>
							<select name="{{$index}}-sortDirection" class="create-view-sort-direction" data-ng-model="col.sort.direction" data-ng-change="col.sort.priority = col.sort.direction=='' ? undefined : 0">
								<option value="">None</option>
								<option value="asc">asc</option>
								<option value="desc">desc</option>
							</select>
						</label>
						<label for="{{$index}}-sortPriority" class="create-view-sort-label">
							<cv:msg key="label.sort.priority" bundle="messagesJs"/>
							<input type="number" name="{{$index}}-sortPriority" class="create-view-sort-priority" data-ng-model="col.sort.priority" min="0" data-ng-disabled="!col.sort.direction || col.sort.direction==''" />
						</label>
					</fieldset>
					<span class="cv-inline-checkbox">
						{{col.displayName}}
					</span>
					<div id="{{$index}}-filter" class="grid-column-field-filter"></div>
				</fieldset>
			</div> --%>
			<div class="button-container">
				<%-- <button id="createView_button_#9766" type="button" class="btn btn-default cvBusyOnAjax pull-left" data-ng-if="editMode" data-ng-click="reset()"><cv:msg key="label.reset" /></button> --%>
				<button id="createView_button_#8518" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
				<button id="createView_button_#7409" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="modifiedRules.length === 0"><cv:msg key="Save" /></button>
			</div>
		</form>
	</div>
</div>