/**
 * When the main thread is idle we want to schedule tasks.
 * Shouldn't interrupt main thread.
 *
 * @author ssubash
 */
export const idleMainThreadTaskScheduler = task => {
	if ('requestIdleCallback' in window) {
		requestIdleCallback(task);
	} else {
		window.requestIdleCallback = function(cb) {
			var start = Date.now();
			return setTimeout(function() {
				cb({
					didTimeout: false,
					timeRemaining: function() {
						return Math.max(0, 50 - (Date.now() - start));
					}
				});
			}, 1);
		};
		requestIdleCallback(task);
	}
};
