/**
 * @author ssubash
 */

import {getSubclientEntity, getClientEntityLink} from '../jobs.svc';

describe('Testing Subclient GetEntityLink', () => {
	it('EXCHANGE_DB get entity link subclient', () => {
		const obj = {
			applicationId: 53, // EXCHANGE_DB
			subclientId: 2,
			clientId: 3
		};
		expect(getSubclientEntity(obj)).to.be.equals('#dagSubclientDetails/2');
	});

	it('VMWare get entity link subclient', () => {
		const obj = {
			applicationId: 106, // VMWARE
			subclientId: 2,
			clientId: 3
		};
		expect(getSubclientEntity(obj)).to.be.equals('#collectionDetails/3/2');
	});

	it('Oracle get entity link subclient', () => {
		const obj = {
			applicationId: 22, // Oracle
			subclientId: 2,
			clientId: 3
		};
		expect(getSubclientEntity(obj)).to.be.equals('#dbCollectionDetails/2');
	});

	it('NAS get entity link subclient', () => {
		const obj = {
			applicationId: 13, // NAS
			subclientId: 2,
			clientId: 3
		};
		expect(getSubclientEntity(obj)).to.be.equals('#fsSubclientDetails/2');
	});

	it('Exchange mailbox setup get entity link subclient', () => {
		const obj = {
			applicationId: 137, // EXCHANGE_MAILBOX
			subclientId: 2,
			clientId: 3,
			backupSetId: 1,
			backupsetName: 'abc'
		};
		expect(getSubclientEntity(obj)).to.be.equals(
			'#mailboxBackupSetDetails/3/1/2/abc'
		);
	});

	it('Default case getEntity Link subclient', () => {
		const obj = {
			applicationId: -1, // DEFAULT
			subclientId: 2,
			clientId: 3,
			backupSetId: 1,
			backupsetName: 'abc'
		};
		expect(getSubclientEntity(obj)).to.be.equals('#subclientDetails/2');
	});
});

describe('Testing client GetEntityLink', () => {
	it('NAS get entity link client', () => {
		const obj = {
			applicationId: 13, // NAS
			subclientId: 2,
			clientId: 3
		};
		expect(getClientEntityLink(obj)).to.be.equals('#nasClientDetails/3');
	});

	it('Some application ID get entity link client', () => {
		const obj = {
			applicationId: 20,
			subclientId: 2,
			clientId: 3
		};
		expect(getClientEntityLink(obj)).to.be.equals('#clientDetails/3');
	});
});
