export const reorderViews = function($modal, userPrefService, grid) {
	const modalInstance = $modal.open({
		templateUrl: appUtil.appRoot + 'common/partials/reorderView.jsp',
		backdrop: 'static',
		windowClass: 'reorder-view-modal',
		controller: [
			'$scope',
			'$uibModalInstance',
			'views',
			'hiddenViewIds',
			function($scope, $modalInstance, views, hiddenViewIds) {
				$scope.views = views;
				$scope.views.forEach(view => {
					view.hidden = hiddenViewIds.has(view.id);
				});

				$scope.saveOrder = function() {
					// pass view order here
					$modalInstance.close(
						$scope.views.map(function(view) {
							return view.id;
						})
					);
				};

				$scope.cancel = function() {
					$modalInstance.dismiss();
				};
			}
		],
		resolve: {
			views: function() {
				// create a new array to issolate scope
				return grid
					.getViewSvc()
					.getTablePrefs()
					.viewOrder.map(viewId => {
						return grid.getViewSvc().getView(viewId);
					})
					.filter(view => {
						return view !== undefined;
					});
			},
			hiddenViewIds: () => {
				return grid.getViewSvc().hiddenViewIds;
			},
		}
	});

	return modalInstance.result.then(viewOrder => {
		if (viewOrder) {
			return userPrefService.setViewOrder(grid.getViewSvc().getTablePrefs().name, viewOrder).then(() => {
				// update the tablePrefs object
				grid.getViewSvc().getTablePrefs().viewOrder = viewOrder;
				grid.getViewSvc().updateTablePrefs(false, null);
			});
		}
	});
};
