import KendoGrid from './kendoGrid';
import * as GridConstants from './grid.constants';

import { cvCommonModule } from '../modules';

cvCommonModule.directive('cvKendoGrid', [
	function() {
		return {
			restrict: 'E',
			transclude: true,
			templateUrl: appUtil.appRoot + 'common/partials/cv-kendo-grid.jsp',
			controllerAs: 'ctrl',
			bindToController: true,
			scope: {
				cvGridOptions: '='
			},
			controller: [
				'$scope',
				'$location',
				'$filter',
				'$uibModal',
				'cvLoc',
				'cvToaster',
				'userPrefService',
				'$compile',
				function($scope, $location, $filter, $modal, cvLoc, cvToaster, userPrefService, $compile) {
					this.$onInit = () => {
						$scope.initialize = ($grid, $gridEmptySvg) => {
							this.$grid = $grid;
							this.gridEmptySvg = $gridEmptySvg.html().trim();
							if (!this.cvGridOptions.rowDetailTemplateId && this.cvGridOptions.detailGridOptions) {
								this.cvGridOptions.detailInit = _detailInit;
							}
							this.kendoGrid = new KendoGrid(
								{
									gridEmptySvg: this.gridEmptySvg,
									...this.cvGridOptions
								},
								this.$grid,
								{
									$scope: $scope,
									$location: $location,
									$filter: $filter,
									$modal: $modal,
									userPrefService: userPrefService,
									cvToaster: cvToaster,
									cvLoc: cvLoc
								}
							);

							$scope.$on('$destroy', () => {
								this.kendoGrid.destroy();
							});

							$scope.$watch(
								() => this.cvGridOptions.gridTitle,
								title => {
									this.kendoGrid.setTitle(title);
								}
							);

							this.kendoGrid.build().finally(() => {
								this.kendoGrid.callbacks.afterGridInitialize.call(this.kendoGrid, {
									grid: this.kendoGrid
								});

								if (this.kendoGrid.options.showCompanyColumnAndFilter && !this.kendoGrid.options.hideCompanyFilter) {
									_setCompanyFilter(this.kendoGrid);
								}

							});
						};

						let _detailInit = e => {
							$scope.$apply(() => {
								let _detailSc = $scope.$new(true);
								_detailSc.gridOptions = angular.copy(this.cvGridOptions.detailGridOptions);
								/**
								 * Do not remove this, views are limited to pages which doesn't have duplicated named grid's
								 * Since detail grid have multiple grid's in a parent grid with same name, views are disabled
								 */
								_detailSc.gridOptions.hasViews = false;
								/**
								 * This enables detail grid url handler to have parent row data as first parameter
								 * Ex: _fetchData(parentRow, options) {}
								 */
								_detailSc.gridOptions.url = _detailSc.gridOptions.url.bind(null, e.data);
								e.detailCell.html($compile('<cv-kendo-grid cv-grid-options="gridOptions"></cv-kendo-grid>')(_detailSc));
							});
						};

						const _setCompanyFilter = (grid) => {

							const companyFilterScope = $scope.$new(true);

							companyFilterScope.onCompanySelect = (selectedCompany, index) => {
								cv.gridCompanyId = selectedCompany.key;
								companyFilterScope.currentIndex = index;
								grid.getDataSrc().companyId = selectedCompany.key;

								if ($location.search().companyId >= 0) {
									$location.search('companyId', null);
								}
								if (grid.options.enableVirtualization) {
									grid.gridDataSrc.applyFilters(!grid.options.enableServerLoading);
								} else {
									grid.refreshData();
								}
							};

							companyFilterScope.companyFilters = [{
								key: -1,
								label: cvLoc('label.company.all'),
								action: companyFilterScope.onCompanySelect,
								cssClass: `all`,
								rank: 1
							}];
							//CommCell(companyId= 0 ) filtering  only works for mongoDb cached API calls
							grid.options.showCommCellInCompanyFilter && companyFilterScope.companyFilters.push({
								key: 0,
								label: cvLoc('label.company.commcell'),
								action: companyFilterScope.onCompanySelect,
								cssClass: 'all comm-cell',
								rank: 2
							});

							companyFilterScope.companyFilters.push(
								..._.map([...cv.providers, ...cv.deactivatedProviders], company => ({
									key: company.first,
									label: company.second,
									action: companyFilterScope.onCompanySelect
								}))
							);
							companyFilterScope.currentIndex = 0;

							const queryParams = $location.search();
							if (_.get(queryParams, 'companyId') >= 0) {
								companyFilterScope.currentIndex = _.findIndex(companyFilterScope.companyFilters, ['key', _.toNumber(queryParams.companyId)]);
							}

							companyFilterScope.searchOptions = {
								showSearch: true,
								searchInputPlaceholder: cvLoc('label.search.company'),
								emptySearchMessage: cvLoc('label.noCompaniesFound')
							};

							$compile(
								`<cv-server-filter filter-label="${cvLoc('label.company')}" toolbar-template-class="cv-entity-filter" search-options="searchOptions"
									filter-list="companyFilters" scroll-threshold="400" width-limit="255" filter-current="currentIndex"></cv-server-filter>`)(companyFilterScope);

						};

					};
				}
			],
			link: function(scope, element, attrs, ctrl, transclude) {
				let $gridEmptySvg = $(document.createElement("div"));
				transclude(scope, function(clone) {
					$gridEmptySvg.append(clone);
				});
				const $grid = $(element).find('[cv-kendo-grid-container]');
				scope.initialize($grid, $gridEmptySvg);
			}
		};
	}
]);

export default cvCommonModule;
