<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}" >

	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>

<div>
	<div class="setup-title">
		<h1 data-ng-if="!editMode"><cv:msg key="label.createView" bundle="messagesJs" /></h1>
		<h1 data-ng-if="editMode"><cv:msg key="label.editView" bundle="messagesJs" /> - <span>{{model.viewName}}</span></h1>
	</div>
	<div class="setup-content">
		<form name="createViewform" cv-hide-api novalidate data-cv-submit="createView()" autocomplete="off" class="create-view-form" id="create-view-form">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div>
				<div class="cv-modal-wrapper">
					<label class="cv-label grid-view" for="viewName"><cv:msg key="label.saveViewName" bundle="messagesJs" /></label>
					<div class="cv-inline-wrapper grid-view">
						<input type="text" name="viewName" id="viewName" data-ng-model="model.viewName" required data-ng-class="{'has-error': cv.createViewform.needsAttention(createViewform.viewName)}" autofocus/>
						<input name="chkSetAsDefault" id="chkSetAsDefault" type="checkbox" data-ng-model="model.isDefault" >
						<label for="chkSetAsDefault" class="cv-checkbox-label"><cv:msg key="label.setAsDefault" bundle="messagesJs" /></label>
					</div>
					<span class="help-block" data-ng-show="cv.createViewform.needsAttention(createViewform.viewName)"><cv:msg key="error.name" bundle="messagesJs" /></span>
				</div>
				<hr />
			</div>
			
			<div class="cv-modal-wrapper">
				<h4 class="text-left section-heading"><cv:msg key="label.rules" bundle="messagesJs" /></h4>
			</div>
			
			<div id="rules-widget-wrapper">
				<ul class="list-inline" data-ng-repeat="rule in modifiedRules">
					<li>
						<label for="rule-{{rule.id}}" class="select-label">
							<select name="rule-{{rule.id}}" id="rule-{{rule.id}}" class="rule-column-name"
									data-ng-model="selectedItems[rule.id]"
									data-ng-options="column.displayName for column in columns | filter:isRuleOptionVisible(rule.id)"
									data-ng-change="changeRule(rule)">
							</select>
						</label>
					</li>
					<li data-ng-if="rule.column" class="ruleCondition">
						<label for="ruleCondition-{{rule.id}}" class="select-label">
							<select name="ruleCondition-{{rule.id}}" id="ruleCondition-{{rule.id}}" class="override-select rule-condition"
									data-ng-model="rule.filterCondition" data-ng-disabled="rule.filterConditionOptions.length <= 1"
									data-ng-options="condition.value as (condition.label | cvLoc) for condition in rule.filterConditionOptions">
							</select>
						</label>
					</li>
					<li class="grid-rule-filter">
                        <div id="ruleFilter-{{rule.id}}_wrapper">
						    <div id="ruleFilter-{{rule.id}}"></div>
                        </div>
					</li>
					<li data-ng-if="rule.column">
						<span class="glyphicon glyphicon-remove rule-remove" data-ng-click="removeRule(rule)" title="<cv:msg key="label.remove" bundle="messagesJs" /> {{rule.column.displayName}}"></span>
					</li>
				</ul>
				<p class="text-center" data-ng-if="!modifiedRules.length"><cv:msg key="label.noRulesAdded" bundle="messagesJs" /></p>
			</div>
			
				<div class="cv-button-wrapper">
					<button data-ng-disabled="!columns.length || addRuleDisabled" type="button" class="btn btn-default" data-ng-click="addNewRule()"><cv:msg key="label.addRule" bundle="messagesJs" /></button>
				</div>

			<div class="button-container">
				<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
				<button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="modifiedRules.length === 0"><cv:msg key="Save" /></button>
			</div>
		</form>
	</div>
</div>