import Menu from '../menu';
import * as utils from '../componentUtils/utils';

// TODO merge this class with other ContextMenu
export default class ContextMenu extends Menu {
	/**
	 * @param {boolean} [args.alignToAnchor=true]
	 * @param {boolean} [args.filter]
	 * @param {number} [args.maxHeight]
	 * @param {function} [args.onOpen]
	 * @param {function} [args.onOptionVisibilityChange]
	 * @param {Object[]} args.options
	 * @param {string} [args.options[].content]
	 * @param {string} [args.options[].cssClass]
	 * @param {string} args.options[].id
	 * @param {string} args.options[].label
	 * @param {function} [args.options[].onSelect]
	 * @param {Object[]} [args.options[].subOptions]
	 * @param {string} [args.options[].url]
	 * @param {boolean} [args.options[].openNewTab]
	 * @param {string} [args.showOn=contextmenu]
	 * @param {string} [args.target]
	 */
	constructor(args) {
		super(args);
	}

	_buildOptionText(option) {
		return `<a id="${option.id}" data-context-menu-option="" ${option.url ? `href="${option.url}" target="${option.openNewTab  ? '_blank' : '_self'}"` : ''}>${
			option.label
		}</a>`;
	}

	initialize(args) {
		const definedByElement = !!args.element;
		super.initialize({
			...args,
			element: args.element || $('<ul>'),
			options: definedByElement ? undefined : args.options
		});
		if (definedByElement) {
			delete this.dataSource;
		}
		if (args.cssClass) {
			this.element.addClass(args.cssClass);
		}

		if(_.isFunction(args.onClose)) {
			this.onClose = args.onClose;
		}

		this.element.attr('data-cv-k-context-menu', 'data-cv-k-context-menu');
		this.alignToAnchor = utils.getArg(args, 'alignToAnchor', true);
		this.filter = args.filter;
		this.onOpen = utils.getArg(args, 'onOpen', () => {});
		this.showOn = args.showOn;
		this.target = args.target;
		this.direction = args.direction || 'default';
		this.popupCollision = args.popupCollision || 'fit';
		this.maxHeight = args.maxHeight;
	}

	build() {
		const self = this;
		this.element.kendoContextMenu({
			alignToAnchor: this.alignToAnchor,
			copyAnchorStyles: false,
			dataSource: this.dataSource,
			filter: this.filter,
			showOn: this.showOn,
			target: this.target,
			open: self._onOpen.bind(this),
			close: self._onClose.bind(this),
			direction : this.direction,
			popupCollision: this.popupCollision,
			select: event => {
				this._onOptionSelect(event);
			}
		});
		this.kendoMenu = this.element.getKendoContextMenu();
	}

	_onOpen(event) {
		if (!this.element.is(event.item)) {
			// Do nothing on submenu open
			return;
		}

		const self = this;
		const target = $(event.target);
		const rowUid =
			target.parents('tr').first().attr('data-uid') ||
			target.parents('li').attr('data-uid') || target.attr('data-uid');
		self.onOpen({
			contextMenu: self,
			rowUid: rowUid
		});

		if (this.maxHeight) {
			this.element.css('max-height', this.maxHeight);
		}
	}

	_onClose(event) {
		if (event.event && this.element.is(event.event.target)) {
			// When clicking on the dropdown element itself (occurs when scrolling),
			// do not close the context menu
			event.preventDefault();
		}

		if(this.onClose) this.onClose.call(this,event);
	}

	_onOptionSelect(event) {
		const self = this;
		const element = $(event.item).find('[data-context-menu-option]');
		const id = element.attr('id');
		const target = $(event.target);
		const rowUid = target.parents('tr').first().attr('data-uid') ||
		target.parents('li').attr('data-uid') || target.attr('data-uid');
		if (_.isFunction(this.onSelect) && !this.isDisabled(id)) {
			this.onSelect.call(this, {
				contextMenu: self,
				rowUid: rowUid,
				optionId: id
			});
		}
		const option = self.optionsMap[id];
		if (option && _.isFunction(option.onSelect) && !this.isDisabled(id)) {
			option.onSelect.call(self, {
				contextMenu: self,
				rowUid: rowUid,
				optionId: id
			});
		}
	}

	refreshDisplay() {
		// Apply alternating colors to menu items:
		this.element
			.find('ul.k-menu')
			.addBack('ul.k-menu')
			.each((index, ul) => {
				let odd = true;
				let visibleCount = 0;
				let visibleItem = null;
				$(ul)
					.children('li.k-item')
					.each((index, li) => {
						if (
							!li.classList.contains('k-separator') &&
							!li.classList.contains('hidden') &&
							!li.classList.contains('toolbar-menu-item')
						) {
							visibleItem = li;
							visibleCount += 1;
							if (odd) {
								li.classList.add('context-menu-alt');
							} else {
								li.classList.remove('context-menu-alt');
							}
							odd = !odd;
						}
					});
				if (visibleCount === 1) {
					// Do not use the alternate color if only 1 option is visible
					visibleItem.classList.remove('context-menu-alt');
				}
			});
	}

	open(x, y) {
		this.kendoMenu.open(x, y);
	}
}
