/**
 * Copyright (c) 2009 Sergiy Kovalchuk (serg472@gmail.com)
 * 
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *  
 * Following code is based on Element.mask() implementation from ExtJS framework (http://extjs.com/)
 *
 */
/**
 * Custom edited for CV
 */
window.cvCustomMask = true;
;
(function($) {

	/**
	 * Displays loading mask over selected element(s). Accepts both single and multiple selectors.
	 * 
	 * @param label
	 *            Text message that will be displayed on top of the mask besides a spinner (optional). If not
	 *            provided only mask will be displayed without a label or a spinner.
	 * @param delay
	 *            Delay in milliseconds before element is masked (optional). If unmask() is called before the
	 *            delay times out, no mask is displayed. This can be used to prevent unnecessary mask display
	 *            for quick processes.
	 */
	$.fn.mask = function(label, delay, cancelCallBackup, runAsBackgroundCallBack) {
		$(this).each(function() {
			if (delay !== undefined && (delay > 0)) {
				var element = $(this);
				element.data("_mask_timeout", setTimeout(function() {
					$.maskElement(element, label, cancelCallBackup, runAsBackgroundCallBack);
				}, delay));
			} else {
				$.maskElement($(this), label, cancelCallBackup, runAsBackgroundCallBack);
			}
		});
	};

	/**
	 * Removes mask from the element(s). Accepts both single and multiple selectors.
	 */
	$.fn.unmask = function() {
		$(this).each(function() {
			$.unmaskElement($(this));
		});
	};

	/**
	 * Checks if a single element is masked. Returns false if mask is delayed or not displayed.
	 */
	$.fn.isMasked = function() {
		return this.hasClass("masked");
	};

	$.maskElement = function(element, label, cancelCallBack, runAsBackGroundCallBack) {

		//if this element has delayed mask scheduled then remove it and display the new one
		if (element.data("_mask_timeout") !== undefined) {
			clearTimeout(element.data("_mask_timeout"));
			element.removeData("_mask_timeout");
		}

		if (element.isMasked()) {
			$.unmaskElement(element);
		}

		if (element.css("position") == "static") {
			element.addClass("masked-relative");
		}

		element.addClass("masked");

		var maskDiv = $('<div class="loadmask"></div>');

		//auto height fix for IE
		if (navigator.userAgent.toLowerCase().indexOf("msie") > -1) {
			maskDiv.height(element.height() + parseInt(element.css("padding-top"))
					+ parseInt(element.css("padding-bottom")));
			maskDiv.width(element.width() + parseInt(element.css("padding-left"))
					+ parseInt(element.css("padding-right")));
		}

		//fix for z-index bug with selects in IE6
		if (navigator.userAgent.toLowerCase().indexOf("msie 6") > -1) {
			element.find("select").addClass("masked-hidden");
		}

		element.append(maskDiv);

		if (label !== undefined) {
			var maskMsgDiv = $('<div class="loadmask-msg" style="display:none;"></div>');
			var labelDiv = $('<div>' + label + '</div>');
			maskMsgDiv.append(labelDiv);
			element.append(maskMsgDiv);
			if (typeof cancelCallBack != 'undefined') {
				var cancelBtn = $('&nbsp;<a href="#">Cancel</a>');
				labelDiv.append(cancelBtn);
				var cancelFunc = function(e) {
					e.preventDefault();
					$.unmaskElement(element);
					cancelCallBack(e);
				};
				$(document).keypress(function(event) {
					var keycode = (event.keyCode ? event.keyCode : event.which);
					if (keycode == '27') {
						cancelFunc(event);
					}
				});
				cancelBtn.click(cancelFunc);
			}
			if (typeof runAsBackGroundCallBack != 'undefined') {
				var backgroundBtn = $('&nbsp;<a href="#">Run As Background</a>');
				labelDiv.append(backgroundBtn);
				backgroundBtn.click(function(e) {
					e.preventDefault();
					$.unmaskElement(element);
					runAsBackGroundCallBack(e);
				});
			}

			//calculate center position
			if (element.attr('id') == 'content') {
				maskMsgDiv.css("position", 'fixed');
				if (element.height() > $(window).height()) {
					maskMsgDiv.css("top", "50%");
				} else {
					var top = Math.round(element.height()
							/ 2
							- (maskMsgDiv.height() - parseInt(maskMsgDiv.css("padding-top")) - parseInt(maskMsgDiv
									.css("padding-bottom"))) / 2);
					if (top < maskMsgDiv.height() / 2) {
						top = maskMsgDiv.height() / 2;
					}
					maskMsgDiv.css("top", top + "px");
				}
				maskMsgDiv.css("left", Math.round($(window).width()
						/ 2
						- (maskMsgDiv.width() - parseInt(maskMsgDiv.css("padding-left")) - parseInt(maskMsgDiv
								.css("padding-right"))) / 2)
						+ "px");
			} else {
				maskMsgDiv.css("top", Math.round(element.height()
						/ 2
						- (maskMsgDiv.height() - parseInt(maskMsgDiv.css("padding-top")) - parseInt(maskMsgDiv
								.css("padding-bottom"))) / 2)
						+ "px");
				maskMsgDiv.css("left", Math.round(element.width()
						/ 2
						- (maskMsgDiv.width() - parseInt(maskMsgDiv.css("padding-left")) - parseInt(maskMsgDiv
								.css("padding-right"))) / 2)
						+ "px");
			}
			maskMsgDiv.show();
		}

	};

	$.unmaskElement = function(element) {
		//if this element has delayed mask scheduled then remove it
		if (element.data("_mask_timeout") !== undefined) {
			clearTimeout(element.data("_mask_timeout"));
			element.removeData("_mask_timeout");
		}

		element.find(".loadmask-msg,.loadmask").remove();
		element.removeClass("masked");
		element.removeClass("masked-relative");
		element.find("select").removeClass("masked-hidden");
	};

})(jQuery);