import { cvCommonModule } from "common/js/modules";

const activeServerIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128"><path d="M6.42 115.288h33.834v5.384H6.42z" fill="#061a28"/><g fill="#0b2e44"><path d="M40.323 115.288v5.384h8.422l-.432-5.384z"/><path d="M40.255 115.288h.068v5.384h-.068z"/></g><path d="M40.323 115.288h8l-.233-2.907H6.42v2.907h33.834z" fill="#ff4a6a"/><path d="M4.004 123.094V4.906h72.502v42.746l1.156-3.394a1.86 1.86 0 0 1 .943-1.074 1.96 1.96 0 0 1 .317-.119V3.7A1.7 1.7 0 0 0 77.225 2H3.284a1.7 1.7 0 0 0-1.697 1.701v120.6a1.7 1.7 0 0 0 1.697 1.701h45.89l-.233-2.906H4.004z" fill="#061a28"/><path d="M65.124 57.33h-24.87v7.75H64.53zm-1.282 16.7l.4-5.083H40.255v14.508a1.45 1.45 0 0 1 .967 1.364v6.78a1.45 1.45 0 0 1-.967 1.364v4.013c2.44.246 4.35 2.286 4.35 4.795s-1.9 4.55-4.35 4.795v5.805h7.825L45 74.04h18.842zm4.462-55.57v3.875h-28.05v7.862h28.05v3.875h-28.05v7.75h28.05v3.875h-28.05v7.75H65.42l.12-1.547a1.87 1.87 0 0 1 2.003-1.72l6.546.504V7.328H40.255v11.14h28.05z" fill="#0b2e44"/><path d="M40.255 106.576c-.16.016-.318.05-.483.05a4.84 4.84 0 1 1 0-9.688c.166 0 .322.032.483.05v-4.013c-.152.054-.313.09-.483.09a1.45 1.45 0 0 1-1.45-1.453v-6.78a1.45 1.45 0 0 1 1.45-1.453c.17 0 .33.035.483.09V68.956h-28.02V65.08h28.02v-7.75h-28.02v-3.875h28.02v-7.75h-28.02V41.83h28.02v-7.75h-28.02v-3.875h28.02v-7.862h-28.02V18.47h28.02V7.328H6.42V112.38h33.834v-5.805z" fill="#061a28"/><path d="M53.67 126l-3.926-48.88h43.475c.758 0 1.522.244 2.164.752a3.48 3.48 0 0 1 1.235 1.932l.39 1.63h8.697c1.054 0 2.114.37 2.966 1.128s1.347 1.765 1.474 2.816L115.038 126H53.67z" fill="#db9e23" stroke="#fbb03b" stroke-width=".75" stroke-miterlimit="10"/><path d="M124.82 62.966c-.207-.422-.564-.737-1.008-.89l-7.985-2.732a1.75 1.75 0 0 0-1.558-1.323l-2.98-.23-28.59-9.783a1.74 1.74 0 0 0-1.34.085 1.75 1.75 0 0 0-.888 1.01l-2.096 6.152-7.424-.572a1.76 1.76 0 0 0-1.884 1.618l-2.6 33.906-5.17 15.177a1.75 1.75 0 0 0 .086 1.343c.207.422.565.737 1.008.89l2.672.914-.542 7.067a1.75 1.75 0 0 0 .417 1.279c.305.357.73.572 1.197.61l32.392 2.496 4.98 1.704c.187.064.378.094.565.094a1.76 1.76 0 0 0 1.661-1.19l.018-.052 3.702.285.143.005c.416-.001.814-.15 1.133-.423.356-.306.572-.732.607-1.2l1.49-19.44 12.08-35.457c.153-.444.122-.92-.084-1.343zm-59.626 43.802l-2.255-.772c-.02-.007-.036-.038-.028-.058l3.03-8.89-.746 9.72zm16.892-57.1c.006-.017.028-.03.047-.03l22.33 7.64-24.332-1.875 1.954-5.734zm27.544 69.416c-.002.02-.023.037-.05.042l-43.318-3.338c-.022-.002-.044-.027-.042-.05l4.55-59.295c.002-.024.022-.043.046-.043l43.322 3.338c.026.002.044.024.042.05l-4.55 59.296zm3.72-26.147l2.44-31.787 7.47 2.557c.02.007.036.038.03.058l-9.94 29.172z" fill="#061a28"/><path d="M114.137 59.728L70.818 56.4c-.027 0-.047.02-.05.043l-4.55 59.295c-.002.022.02.048.042.05l43.318 3.338c.027-.005.048-.02.05-.042l4.55-59.296c.003-.024-.015-.047-.04-.05zM75.96 62.9l10.973.846a.57.57 0 0 1 .524.613.57.57 0 0 1-.565.527c-.015 0-.03 0-.046-.002l-10.973-.846a.57.57 0 0 1-.524-.613c.023-.314.288-.55.61-.525zm-.27 3.513l10.974.846a.57.57 0 0 1 .524.613.57.57 0 0 1-.565.527c-.015 0-.03 0-.046-.002l-10.974-.846a.57.57 0 0 1-.524-.613c.023-.314.294-.55.61-.525zm-1.52 6.84l32.852 2.53a.57.57 0 0 1 .524.613.57.57 0 0 1-.565.527c-.015 0-.03 0-.046-.002l-32.85-2.53a.57.57 0 0 1-.524-.613c.022-.314.287-.555.6-.525zm-.41 5.995l9.757.752a.57.57 0 0 1 .524.613.57.57 0 0 1-.565.527c-.015 0-.03 0-.046-.002l-9.757-.752a.57.57 0 0 1-.524-.613c.023-.314.293-.553.61-.525zm-.5 6.516l12.703.98a.57.57 0 0 1 .524.613.57.57 0 0 1-.565.527c-.015 0-.03 0-.046-.002l-12.703-.98a.57.57 0 0 1-.524-.613.56.56 0 0 1 .611-.525zm8.795 19.73c-.015 0-.03 0-.046-.001l-10.974-.526c-.313-.015-.548-.185-.524-.38s.297-.342.612-.326l10.974.526c.313.015.548.185.524.38-.023.185-.272.326-.566.327zm7.443-10.78c-.015 0-.03 0-.046-.002l-16.78-1.293a.57.57 0 0 1-.524-.612c.025-.314.293-.553.612-.525l16.78 1.293a.57.57 0 0 1 .524.612.57.57 0 0 1-.566.527zm16.172-5.36c-.015 0-.03 0-.046-.002l-15.697-1.21a.57.57 0 0 1-.524-.613c.024-.313.3-.552.612-.525l15.697 1.2a.57.57 0 0 1 .524.613.57.57 0 0 1-.566.526zm1.578-6.383c-.016 0-.032 0-.048-.002L87.07 81.33a.57.57 0 0 1-.521-.615c.026-.314.302-.544.613-.523l20.13 1.638a.57.57 0 0 1 .521.615.57.57 0 0 1-.565.524zm.432-13.265c-.015 0-.03 0-.046-.002l-10.974-.846a.57.57 0 0 1-.524-.613c.024-.314.295-.55.612-.525l10.974.846a.57.57 0 0 1 .524.613.57.57 0 0 1-.566.527zm.27-3.513c-.015 0-.03 0-.046-.002l-10.973-.846a.57.57 0 0 1-.524-.613c.024-.314.288-.55.612-.525l10.973.846a.57.57 0 0 1 .524.613.57.57 0 0 1-.566.527z" fill="#fff"/><path d="M75.87 64.037l11.02.848a.57.57 0 0 0 .565-.527.57.57 0 0 0-.524-.613L75.958 62.9c-.323-.025-.588.2-.612.525a.57.57 0 0 0 .525.613zm-.268 3.513l11.02.848a.57.57 0 0 0 .565-.527.57.57 0 0 0-.524-.613l-10.974-.846c-.317-.026-.588.2-.612.525a.57.57 0 0 0 .525.613z" fill="#ff4a6a"/><path d="M82.097 104.783l-10.974-.526c-.315-.016-.588.13-.612.326s.21.366.524.38l11.02.527c.294-.001.543-.142.565-.328.026-.194-.21-.365-.523-.38z" fill="#ffbf3c"/><path d="M73.673 80.384l9.803.754a.57.57 0 0 0 .565-.527.57.57 0 0 0-.524-.613l-9.757-.752c-.318-.028-.588.2-.612.525a.57.57 0 0 0 .525.613zm15.867 13.19L72.76 92.28c-.32-.028-.587.2-.612.525a.57.57 0 0 0 .524.612l16.825 1.295a.57.57 0 0 0 .565-.527.57.57 0 0 0-.523-.612zM73.173 86.9l12.75.98a.57.57 0 0 0 .565-.527.57.57 0 0 0-.524-.613l-12.703-.98c-.324-.025-.588.2-.612.525a.57.57 0 0 0 .525.613zm.91-12.5l32.897 2.533a.57.57 0 0 0 .565-.527.57.57 0 0 0-.524-.613l-32.85-2.53a.56.56 0 0 0-.612.525.57.57 0 0 0 .524.612zm31.63 13.823l-15.697-1.2c-.322-.027-.588.2-.612.525a.57.57 0 0 0 .524.613l15.743 1.2a.57.57 0 0 0 .565-.527.57.57 0 0 0-.523-.612zm1.58-6.383l-20.13-1.638c-.3-.02-.588.208-.613.523a.57.57 0 0 0 .521.615l20.18 1.64a.57.57 0 0 0 .565-.524.57.57 0 0 0-.521-.616z" fill="#061a28"/><path d="M107.992 65.05l-10.973-.846c-.323-.025-.588.2-.612.525a.57.57 0 0 0 .524.613l11.02.848a.57.57 0 0 0 .565-.527.57.57 0 0 0-.523-.613zm-.27 3.514l-10.974-.846c-.317-.026-.588.2-.612.525a.57.57 0 0 0 .524.613l11.02.848a.57.57 0 0 0 .565-.527.57.57 0 0 0-.523-.613z" fill="#ffbf3c"/><path d="M61.227 85.56L53.67 126h61.37l8.174-40.44z" fill="#fbae17"/><path d="M115.038 86.86H62.614l-7.308 37.12c-.001 0 20.063-29.418 59.732-37.12z" fill="#fbb03b"/></svg>`;
const windowsIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M1.1 4.3l9.3-1.2v9H1.1zm9.3 8.8v9l-9.3-1.4V13zm1.1-10.2L24 1.1V12l-12.3.1zM24 13.1V24l-12.3-1.7v-9z"/></svg>`;
const windowsColorIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path style="fill:#2fa6df;" d="M1.1 4.3l9.3-1.2v9H1.1zm9.3 8.8v9l-9.3-1.4V13zm1.1-10.2L24 1.1V12l-12.3.1zM24 13.1V24l-12.3-1.7v-9z"/></svg>`;
const linuxIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M22.1 20.3a3.3 3.3 0 0 1-1.5-3 9.2 9.2 0 0 0-2-6.5 9.8 9.8 0 0 1-2.4-6.5 4 4 0 0 0-.7-2.4A3.9 3.9 0 0 0 11.2.5C9.7.9 9 1.9 9 3.7a27.2 27.2 0 0 0 .2 3.4 2.9 2.9 0 0 1-.8 2.6c-1.7 1.7-2 4.2-3.3 6.2a1.3 1.3 0 0 0 0 .7v.2a1.8 1.8 0 0 1-1.7 2c-1 .2-1.3.6-1 1.6a4.3 4.3 0 0 1 0 1.1c-.6 1.2.4 1.5 1.4 1.7a17.6 17.6 0 0 1 3.6 1.2 1.9 1.9 0 0 0 2-.3c1.9-1.3 4-.7 6-.6l.3.3a2 2 0 0 0 2.6.5 1.2 1.2 0 0 0 .3-.2A17.9 17.9 0 0 1 22 22c1-.5 1-1 .1-1.6zM13 3.8h.1a.8.8 0 0 1 1 .2 1.6 1.6 0 0 1 .2 1.9.3.3 0 0 1-.4.2c-.2 0-.2-.2 0-.4.2-.4.3-.9-.3-1s-.7.3-1 .8v-.2a1.1 1.1 0 0 1 .4-1.5zm-1.1 2.7l1.6.6a.9.9 0 0 1 .1.1l-1.8 1a.4.4 0 0 1-.3 0 2.8 2.8 0 0 1-1.1-.9l1.1-.8a.4.4 0 0 1 .4 0zM9.9 4h.1a.6.6 0 0 1 .8 0 1.5 1.5 0 0 1 .4 1.7c-.5-.2-.3-1-.9-1s-.1.8-.5 1.2A1.5 1.5 0 0 1 10 4zM7.3 23.3a9 9 0 0 1-1.2-.5 6.5 6.5 0 0 0-1.6-.4H4c-.2 0-.2-.2-.2-.4v-.2a2 2 0 0 0 0-1.2c0-.2 0-.3.3-.3l.7-.2a.9.9 0 0 0 .6-.5 3.6 3.6 0 0 1 .2-.4s.2-.2.3 0a3.7 3.7 0 0 1 .6.6l.7 1.1c.3.3.4.7.6 1a1.3 1.3 0 0 1 .4.6.7.7 0 0 1-.6.8.7.7 0 0 1-.3 0zm9.8-6.3c0 .2 0 .6-.2.6-1.2.1-.8 1-.8 1.7a1.7 1.7 0 0 1-.9 1.4 5.3 5.3 0 0 1-4.4 1.1c-1-.2-1.2-.6-.6-1.3v-.1a.7.7 0 0 0-.1-1l-1.3-1c-1.5-1-1.8-1.6-1-3.2a20.5 20.5 0 0 1 2-4.5c.3-.4.1-.9.3-1.5 1.2 1.5 2.4 1.1 3.6.3.5-.4.8-.4 1 .2.7 1.4 1.2 2.8 1.9 4A6 6 0 0 1 17 17zm3.2 4.5l-1.3.7a8 8 0 0 0-.9.7 2.3 2.3 0 0 1-.4.3.4.4 0 0 1-.6-.2 1.3 1.3 0 0 1-.1-.8l.2-1.7a5 5 0 0 0 0-.8c.2.7.8.8 1.4.6a1.4 1.4 0 0 0 1-.6l.1.7a1 1 0 0 0 .5.6l.5.3z"/></svg>`;
const nasIcon = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 128 128"><defs ><path id="nasE" d="M125.195 45.12h-121a1.5 1.5 0 0 0-1.5 1.5v31a1.5 1.5 0 0 0 1.5 1.5h121a1.5 1.5 0 0 0 1.5-1.5v-31a1.5 1.5 0 0 0-1.5-1.5zm-18.5 27a9 9 0 1 1 0-18 9 9 0 1 1 0 18z"/><path id="nasF" d="M100.58 119.958c0 .698.566 1.263 1.263 1.263h9.474c.698 0 1.263-.566 1.263-1.263v-2.463h-12v2.463z"/></defs><path d="M125.195 7.153h-121a1.5 1.5 0 0 0-1.5 1.5v31a1.5 1.5 0 0 0 1.5 1.5h121a1.5 1.5 0 0 0 1.5-1.5v-31a1.5 1.5 0 0 0-1.5-1.5zm-18.5 27a9 9 0 1 1 0-18 9 9 0 0 1 9 9c0 4.97-4.03 9-9 9z" fill="#199fbc"/><use xlink:href="#nasE" fill="#199fbc"/><use xlink:href="#nasE" y="37.238" fill="#199fbc"/><g fill="#0b2e44"><use xlink:href="#nasF"/><use xlink:href="#nasF" x="-83.77"/></g></svg>`;
const serverIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M5 1v23h15V1H5zm8 19h-2v-2h2v2zm5-11H7V8h11v1zm0-2H7V6h11v1zm0-2H7V4h11v1z"/></svg>`;
const qumuloIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path id="Combined-Shape" d="M12.3871,7.74194H9.4388A1.69687,1.69687,0,0,1,7.74194,6.04507V1.69686A1.69686,1.69686,0,0,1,9.4388,0H13.787a1.69686,1.69686,0,0,1,1.69686,1.69686v3.114a2.93106,2.93106,0,0,0,2.93106,2.93106h9.601a4.24214,4.24214,0,0,1,4.24215,4.24215V20.274a4.24215,4.24215,0,0,1-4.24215,4.24216H19.726A4.24216,4.24216,0,0,1,15.48387,20.274V11.98409l.00022-.0434-.00022-1.102A3.09677,3.09677,0,0,0,12.3871,7.74194Z" style="fill: #00a3ca;fill-rule: evenodd"/><path id="Combined-Shape-2" data-name="Combined-Shape" d="M27.6129,32.25806h2.9483a1.69687,1.69687,0,0,1,1.69686,1.69687v4.34821A1.69686,1.69686,0,0,1,30.5612,40H26.213a1.69686,1.69686,0,0,1-1.69686-1.69686v-3.114a2.93106,2.93106,0,0,0-2.93106-2.93106h-9.601a4.24214,4.24214,0,0,1-4.24215-4.24215V19.726a4.24215,4.24215,0,0,1,4.24215-4.24216H20.274A4.24216,4.24216,0,0,1,24.51613,19.726v8.28988l-.00022.0434.00022,1.102A3.09677,3.09677,0,0,0,27.6129,32.25806Z" style="fill: #007cac;fill-rule: evenodd"/><path id="Combined-Shape-3" data-name="Combined-Shape" d="M15.48387,15.48387H20.274A4.24216,4.24216,0,0,1,24.51613,19.726v4.7901H19.726A4.24216,4.24216,0,0,1,15.48387,20.274Z" style="fill: #1f4e84;fill-rule: evenodd;opacity: 0.75;isolation: isolate"/></svg>`;
const nutanixIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path style="fill:#d5e040;" d="M25,30.2,11.2,42l-.5.2H.8a1,1,0,0,1-.8-.5.8.8,0,0,1,.3-.9L19,25.1.3,9.2A.8.8,0,0,1,0,8.3a1,1,0,0,1,.8-.5h9.4l.5.2,7.7,6.4v.2L30.8,25.2l-5.7,5Z"/><path style="fill:#20519e;" d="M27.9,17.5,39.3,8l.5-.2h9.4a1,1,0,0,1,.8.5.8.8,0,0,1-.3.9L33.9,22.6ZM49.7,40.8,34,27.6l-5.9,5.2L38.9,42l.5.2h9.8a1,1,0,0,0,.8-.5A.8.8,0,0,0,49.7,40.8Z"/></svg>`;
const clusterIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128"><path d="M118.783 100.246c0 .968.786 1.754 1.754 1.754s1.754-.786 1.754-1.754v-30.4h-3.508v30.4zm-28.646-38c-.968 0-1.754.785-1.754 1.754s.786 1.754 1.754 1.754h27.4v-3.508h-27.4zM122.3 27.754c0-.97-.786-1.754-1.754-1.754s-1.754.785-1.754 1.754v30.4h3.508v-30.4z" fill="#0b2e44"/><path d="M122.86 58.154h-4.648c-.374 0-.676.303-.676.676v10.34c0 .374.303.676.676.676h4.648c.373 0 .676-.303.676-.676V58.83c.001-.373-.302-.676-.676-.676z" fill="#ff4a6a"/><path d="M90.964 2h-85c-.828 0-1.5.683-1.5 1.525v120.95c0 .842.672 1.525 1.5 1.525h85c.828 0 1.5-.683 1.5-1.525V3.525c0-.842-.672-1.525-1.5-1.525zm-2 119.31c0 .658-.44 1.19-.98 1.19H8.943c-.54 0-.98-.534-.98-1.19V96.69c0-.658.44-1.19.98-1.19h79.04c.54 0 .98.533.98 1.19v24.618zm0-30c0 .658-.44 1.19-.98 1.19H8.943c-.54 0-.98-.534-.98-1.19V66.69c0-.658.44-1.19.98-1.19h79.04c.54 0 .98.533.98 1.19V91.31zm0-30c0 .658-.44 1.19-.98 1.19H8.943c-.54 0-.98-.534-.98-1.19V36.69c0-.658.44-1.19.98-1.19h79.04c.54 0 .98.533.98 1.19V61.31zm0-30c0 .658-.44 1.19-.98 1.19H8.943c-.54 0-.98-.534-.98-1.19V6.69c0-.658.44-1.19.98-1.19h79.04c.54 0 .98.533.98 1.19V31.31z" fill="#c9cfd3"/><path d="M87.984 5.5H8.943c-.54 0-.98.534-.98 1.19V31.31c0 .658.44 1.19.98 1.19h79.04c.54 0 .98-.534.98-1.19V6.69c.001-.658-.438-1.19-.98-1.19zm-67.52 19a6 6 0 1 1 0-12 6 6 0 1 1 0 12zm48-3.5h-30v-5h30v5z" fill="#199fbc"/><path d="M87.984 35.5H8.943c-.54 0-.98.534-.98 1.19V61.31c0 .658.44 1.19.98 1.19h79.04c.54 0 .98-.534.98-1.19V36.69c.001-.658-.438-1.19-.98-1.19zm-67.52 20a6 6 0 1 1 0-12 6 6 0 1 1 0 12zm48-3.5h-30v-5h30v5z" fill="#199fbc"/><path d="M87.984 65.5H8.943c-.54 0-.98.534-.98 1.19V91.31c0 .658.44 1.19.98 1.19h79.04c.54 0 .98-.534.98-1.19V66.69c.001-.658-.438-1.19-.98-1.19zm-67.52 20a6 6 0 1 1 0-12 6 6 0 1 1 0 12zm48-3.5h-30v-5h30v5z" fill="#199fbc"/><path d="M87.984 95.5H8.943c-.54 0-.98.534-.98 1.19v24.618c0 .658.44 1.19.98 1.19h79.04c.54 0 .98-.534.98-1.19V96.69c.001-.658-.438-1.19-.98-1.19zm-67.52 20a6 6 0 1 1 0-12 6 6 0 1 1 0 12zm48-3.5h-30v-5h30v5z" fill="#199fbc"/><path d="M8.007 122.518v-117h81z" opacity=".46" fill="#fff"/></svg>`;
const ibmiIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M20,.75775A19.24225,19.24225,0,1,1,.75774,20,19.264,19.264,0,0,1,20,.75775M20,0A20,20,0,1,0,40,20,20,20,0,0,0,20,0Z" style="fill: #4485cb"/><circle cx="20" cy="20" r="17.74233" style="fill: #4485cb"/><path d="M7.54066,29.42337V27.139H7.21553v-.39049h.32513v-.134A1.54238,1.54238,0,0,1,7.81084,25.54a.65747.65747,0,0,1,.60455-.17074,1.15591,1.15591,0,0,1,.5584.27689l-.23536.32765a.43937.43937,0,0,0-.53532-.13844c-.184.0891-.15556.33057-.15556.76175v.15141h.68164V27.139H8.04755v2.28436Z" style="fill: #fff"/><path d="M11.51051,28.13514a1.22134,1.22134,0,0,1-1.34095,1.36125,1.13187,1.13187,0,0,1-1.23714-1.2932c0-.94377.50285-1.5187,1.28353-1.5187A1.2892,1.2892,0,0,1,11.51051,28.13514ZM9.451,28.18582c0,.61761.24072.92606.74163.92606.48953,0,.79337-.32441.79337-.95938,0-.47757-.17577-1.08351-.7817-1.08351C9.59863,27.069,9.451,27.6499,9.451,28.18582Z" style="fill: #fff"/><path d="M11.96284,27.62825l0-.63883a1.6031,1.6031,0,0,1,1.05984-.388,1.04187,1.04187,0,0,1,.49949.18605l-.167.398c-.26367-.09775-.88542-.11739-.88542.29685v1.94114h-.50689Z" style="fill: #fff"/><path d="M14.891,25.79155a4.577,4.577,0,0,1,.92612-.11818,1.46544,1.46544,0,0,1,.97521.25228.9705.9705,0,0,1,.38149.763.84315.84315,0,0,1-.61672.82516v.01166a.86643.86643,0,0,1,.768.88246.98906.98906,0,0,1-.33587.75428,1.83469,1.83469,0,0,1-1.31186.406,1.59834,1.59834,0,0,1-.78637-.22429Zm.5785,1.51054h.38832c.5362,0,.72132-.27977.72132-.6583.0118-.27133-.22013-.4657-.73271-.4657a1.40033,1.40033,0,0,0-.37693.035Zm0,1.68538a1.79491,1.79491,0,0,0,.35359.02334c.52425,0,.95082-.31283.91541-.56687.01771-.49555-.36782-.69623-.92138-.69623h-.34762Z" style="fill: #fff"/><path d="M19.92123,29.02791c0,.08749-.17464.2445-.30853.30853a1.82155,1.82155,0,0,1-.86178.18628c-.44285,0-1.0545-.1353-1.0545-1.12545V26.74852H18.209v1.56137c0,.53592.09343.74713.55962.74713.34353,0,.51776-.03032.60531-.193a1.62754,1.62754,0,0,0,.04667-.38531V26.74852h.50063Z" style="fill: #fff"/><path d="M20.563,28.88986a.6343.6343,0,0,0,.503.18862c.37284,0,.59914-.14784.59914-.38093,0-.24448-.17834-.30248-.55687-.44223-.50689-.18072-.76323-.40564-.76323-.74347a.86952.86952,0,0,1,.9728-.82736,1.24356,1.24356,0,0,1,.65426.22674l-.15163.31066a.86566.86566,0,0,0-.5143-.1529c-.30282,0-.47188.17476-.47188.38451,0,.2331.18661.28326.55347.423.48953.18642.736.41632.736.83583,0,.49522-.39806.77815-1.068.77815a1.1866,1.1866,0,0,1-.67761-.21969Z" style="fill: #fff"/><path d="M23.27678,25.85675a.334.334,0,0,1-.66806,0,.32862.32862,0,0,1,.33717-.33688A.32006.32006,0,0,1,23.27678,25.85675Z" style="fill: #fff"/><rect x="22.6213" y="26.73745" width="0.54151" height="2.68594" style="fill: #fff"/><path d="M26.8617,28.28641a.77254.77254,0,0,0,.83516.76867,1.50469,1.50469,0,0,0,.65429-.21544l.11171.44417a1.59583,1.59583,0,0,1-.8192.21012,1.2555,1.2555,0,0,1-1.28511-1.26026c0-.87019.34649-1.54918,1.16788-1.54918a1.19463,1.19463,0,0,1,1.16519,1.32827,2.732,2.732,0,0,1-.01736.27365Zm1.3347-.45747a.71791.71791,0,0,0-.68573-.74207c-.39364.00532-.643.22874-.643.74207Z" style="fill: #fff"/><path d="M29.18817,28.88986a.63433.63433,0,0,0,.503.18862c.37284,0,.59914-.14784.59914-.38093,0-.24448-.17833-.30248-.55686-.44223-.50689-.18072-.76323-.40564-.76323-.74347a.86952.86952,0,0,1,.9728-.82736,1.24356,1.24356,0,0,1,.65426.22674l-.15164.31066a.86562.86562,0,0,0-.51429-.1529c-.30283,0-.47189.17476-.47189.38451,0,.2331.18661.28326.55347.423.48953.18642.736.41632.736.83583,0,.49522-.398.77815-1.068.77815a1.18657,1.18657,0,0,1-.67761-.21969Z" style="fill: #fff"/><path d="M31.27769,28.88986a.63433.63433,0,0,0,.503.18862c.37284,0,.59914-.14784.59914-.38093,0-.24448-.17833-.30248-.55686-.44223-.50689-.18072-.76323-.40564-.76323-.74347a.86952.86952,0,0,1,.9728-.82736,1.24356,1.24356,0,0,1,.65426.22674l-.15164.31066a.86562.86562,0,0,0-.51429-.1529c-.30283,0-.47189.17476-.47189.38451,0,.2331.18661.28326.55347.423.48953.18642.736.41632.736.83583,0,.49522-.39805.77815-1.068.77815a1.18657,1.18657,0,0,1-.67761-.21969Z" style="fill: #fff"/><path d="M21.57171,8.23155a1.51181,1.51181,0,0,1-3.02352,0,1.48725,1.48725,0,0,1,1.526-1.52464A1.44851,1.44851,0,0,1,21.57171,8.23155Z" style="fill: #fff"/><rect x="18.82198" y="11.57458" width="2.52074" height="8.20104" style="fill: #fff"/><path d="M30.71322,21.45032a21.73337,21.73337,0,0,1-2.98971,2.93512c-6.09483-2.438-16.09152-2.57434-19.34676-2.92983l-.0476-.00528Z" style="fill: #fff"/><path d="M23.71732,27.14437c0-.08749.17464-.24449.30853-.30853a1.82167,1.82167,0,0,1,.86178-.18628c.44285,0,1.0545.1353,1.0545,1.12545v1.64875h-.51258V27.86239c0-.53592-.09343-.74713-.55962-.74713-.34353,0-.51776.03032-.6053.193a1.6274,1.6274,0,0,0-.04668.38531v1.73014h-.50063Z" style="fill: #fff"/></svg>`;
const gpfsIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M20.02954,10.0637l8.63462,4.9852v9.97041l-8.63462,4.9852-8.63463-4.9852V15.0489l8.63463-4.9852m0-3.04135L8.761,13.52822V26.54l11.26852,6.50588L31.29805,26.54V13.52822L20.02954,7.02235Z" style="fill: #8ec641"/><polygon points="25.234 23.039 25.234 17.029 20.03 14.024 14.825 17.029 14.825 23.039 20.03 26.044 25.234 23.039" style="fill: #8ec641"/><polygon points="14.214 6.382 20 3.041 25.822 6.403 27.139 4.122 20 0 12.898 4.101 14.214 6.382" style="fill: #8ec641"/><polygon points="28.896 8.177 34.687 11.521 34.687 18.219 37.321 18.219 37.321 10 30.213 5.896 28.896 8.177" style="fill: #8ec641"/><polygon points="5.313 18.219 5.313 11.521 11.141 8.156 9.824 5.875 2.679 10 2.679 18.219 5.313 18.219" style="fill: #8ec641"/><polygon points="34.687 21.769 34.687 28.479 28.901 31.82 30.218 34.101 37.321 30 37.321 21.769 34.687 21.769" style="fill: #8ec641"/><polygon points="11.136 31.841 5.313 28.479 5.313 21.769 2.679 21.769 2.679 30 9.819 34.122 11.136 31.841" style="fill: #8ec641"/><polygon points="25.827 33.594 20 36.959 14.209 33.615 12.892 35.896 20 40 27.144 35.875 25.827 33.594" style="fill: #8ec641"/></svg>`;
const openVMSIcon = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 128 128"><g fill="#0c75b2"><ellipse cx="45.132" cy="23.736" rx="3.465" ry="3.454"/><ellipse cx="103.809" cy="51.998" rx="3.465" ry="3.454"/><ellipse cx="101.348" cy="20.176" rx="3.465" ry="3.454"/></g><g fill="#97c84b"><ellipse cx="54.654" cy="28.304" rx="2.722" ry="2.714"/><ellipse cx="92.726" cy="25.591" rx="2.722" ry="2.714"/><ellipse cx="72.888" cy="15.978" rx="2.722" ry="2.714"/></g><ellipse cx="72.832" cy="5.454" rx="3.465" ry="3.454" fill="#0c75b2"/><ellipse cx="94.172" cy="47.745" rx="2.722" ry="2.714" fill="#97c84b"/><g fill="#d5e037"><ellipse cx="62.561" cy="32.165" rx="2.104" ry="2.097"/><ellipse cx="86.253" cy="43.798" rx="2.104" ry="2.097"/><ellipse cx="73.383" cy="24.556" rx="2.104" ry="2.097"/><ellipse cx="85.758" cy="30.477" rx="2.104" ry="2.097"/></g><g fill="#fbda26"><use xlink:href="#openD"/><path d="M79.818 36.15a1.73 1.73 0 0 0 1.732-1.727 1.73 1.73 0 1 0-3.464 0 1.73 1.73 0 0 0 1.732 1.727z"/><use xlink:href="#openD" x="-5.135" y="3.133"/><use xlink:href="#openD" x="6.25" y="8.551"/></g><path d="M32.387 41.875v3.404l7.2 2.4 2.683-2.992-9.883-2.812z" fill="#0a6699"/><path d="M60.826 117.948c5.066.425 9.586-1.314 13.94-3.698 3.376-1.848 6.227-4.42 8.8-7.248 4.505-4.973 7.213-10.733 6.58-17.774-.33-3.66-3.135-7.584-7.288-7.17a6.22 6.22 0 0 0-.507.076c-.068 2.263.06 4.577-.423 6.732-2.518 11.25-12.548 21.414-25.684 21.52-2.762.022-5.947-.03-8.8-.157.17.458.176.592.5.99 3.35 4.117 7.694 6.293 12.9 6.73z" fill="#a36287"/><g fill="#fff"><path d="M59.517 114.344l-.24.8-.525-.001.898-2.784h.65l.9 2.788-.546-.001-.25-.8-.885-.002zm.798-.382l-.218-.687-.14-.52h-.007l-.133.52-.217.686.715.002zm1.14-1.812l.5-.042.237 2.924-.5.042-.238-2.924zm1.21 1.503l-.117-.66.442-.067.07.303.008-.001c.113-.247.327-.4.63-.455.458-.07.898.265.993.886.1.72-.3 1.136-.745 1.205-.25.038-.474-.037-.6-.18l-.008.001.157 1.03-.503.076-.326-2.138zm.58.418c.007.05.018.093.038.136a.46.46 0 0 0 .495.284c.32-.05.467-.343.407-.736-.054-.352-.27-.612-.592-.562-.208.032-.378.212-.393.44-.006.043-.007.1-.001.13l.046.308zm1.455-2.363l.497-.126.295 1.162.008-.002c.037-.107.097-.204.188-.286a.69.69 0 0 1 .314-.173c.333-.085.737.047.896.672l.292 1.15-.493.125-.277-1.094c-.072-.285-.23-.47-.503-.4-.192.048-.296.2-.3.373-.006.044.003.097.018.153l.296 1.166-.497.126-.723-2.845zm4.23 1.806l-.106-.2-.01.004a.75.75 0 0 1-.471.452c-.382.135-.694-.066-.796-.354-.17-.48.17-.87.872-1.116l-.01-.03c-.044-.125-.168-.313-.503-.195a1.07 1.07 0 0 0-.461.321l-.204-.278c.1-.135.326-.304.626-.4.608-.216.92.108 1.066.52l.243.686c.06.17.128.336.2.446l-.433.153zm-.4-.905c-.34.112-.64.3-.537.6.066.187.217.23.37.176a.41.41 0 0 0 .281-.393.36.36 0 0 0-.02-.11l-.092-.26zm1.2.088a1.13 1.13 0 0 0 .53-.078c.204-.1.257-.214.203-.335s-.16-.155-.422-.133c-.414.036-.653-.094-.745-.3-.145-.325.01-.697.437-.888a1.19 1.19 0 0 1 .536-.108l.056.37c-.1-.01-.274-.005-.436.068s-.222.194-.17.307.164.135.435.114c.386-.028.617.074.742.344.15.332-.004.7-.492.907-.223.1-.447.136-.616.12l-.058-.377zm1.806-1.292c.186.312.5.313.794.158a1.5 1.5 0 0 0 .445-.348l.234.272c-.118.145-.302.308-.556.447-.572.314-1.102.148-1.398-.392-.27-.5-.224-1.112.34-1.422.572-.314 1.02.053 1.232.44.046.084.074.152.1.197l-1.18.648zm.604-.737c-.086-.165-.305-.393-.602-.23-.275.15-.254.465-.173.656l.775-.426zm.717-.598l-.368-.535.37-.24.224.313.014-.01c-.073-.293.046-.543.227-.66.04-.027.068-.04.107-.055l.262.402a.75.75 0 0 0-.133.067c-.205.133-.257.355-.17.57.018.043.04.092.072.14l.568.873-.426.277-.747-1.143z"/><path d="M74.052 108.483l.88.6.415.317.01-.008-.2-.483-.37-1.004.426-.327.615 2.065-.397.304-1.82-1.142.438-.333zm2.383-.446c.254.262.57.187.8-.03.175-.158.278-.297.353-.442l.3.2c-.082.17-.223.37-.438.564-.484.44-1.04.4-1.452-.057-.375-.414-.476-1.03.002-1.464.484-.438 1.004-.184 1.3.143.064.07.107.13.132.17l-.998.906zm.417-.857c-.122-.14-.388-.312-.64-.085-.233.2-.14.5-.016.678l.656-.593zm.556-.745l-.48-.438.306-.32.3.255.01-.012c-.137-.27-.078-.54.07-.695.034-.036.057-.054.092-.078l.346.332a.63.63 0 0 0-.115.096c-.17.176-.17.404-.038.595a.88.88 0 0 0 .102.12l.752.722-.352.367-.984-.946zm2.274-1.165c.127-.047.322-.17.436-.313.14-.174.13-.308.027-.4s-.213-.065-.436.075c-.352.222-.623.217-.804.066-.278-.222-.3-.624-.02-1a1.18 1.18 0 0 1 .427-.341l.218.302c-.093.037-.245.12-.356.26s-.108.274-.01.35.208.045.44-.1c.33-.2.582-.217.817-.035.284.227.312.615-.02 1.032a1.34 1.34 0 0 1-.492.4l-.225-.308z"/><path d="M79.734 102.684l1.092.322.386.134.007-.01-.263-.316-.7-.874.313-.447.834 1.2c.456.66.624 1.003.655 1.32.03.265-.033.472-.093.586l-.418-.152a.88.88 0 0 0 .056-.324c.004-.113-.03-.274-.1-.41-.02-.038-.035-.065-.056-.08s-.043-.025-.098-.033l-1.935-.46.32-.46z"/><path d="M81.984 102.132c.12-.06.3-.208.395-.363.117-.2.092-.322-.02-.392s-.22-.038-.424.127c-.322.263-.592.3-.79.163-.302-.187-.384-.583-.138-.98.118-.2.27-.325.383-.4l.254.274c-.088.047-.23.15-.322.3s-.074.285.032.35.212.02.424-.15c.304-.24.55-.286.807-.133.3.19.385.573.104 1.027-.128.208-.293.363-.44.447l-.263-.28z"/><path d="M81.35 99.044l.502.278.234-.423.332.184-.234.423.777.43c.213.118.357.123.45-.047.042-.076.063-.14.075-.186l.344.18c-.01.08-.057.205-.135.345-.1.163-.22.27-.357.303-.153.038-.336-.007-.567-.135l-.828-.46-.14.253-.332-.184.14-.253-.397-.22.135-.49z"/><path d="M83.434 98.788c.332.15.6-.037.74-.326.104-.212.15-.378.165-.54l.35.088a1.9 1.9 0 0 1-.199.685c-.288.586-.818.754-1.37.482-.5-.246-.822-.782-.538-1.36.288-.586.866-.542 1.262-.347l.186.1-.596 1.2zm.072-.95c-.165-.086-.476-.147-.626.158-.14.282.06.527.235.636l.4-.794zm.236-.91l-.56-.2.166-.406.284.094.005-.01c-.108-.15-.2-.4-.083-.704a.58.58 0 0 1 .556-.376l.003-.008c-.077-.107-.122-.215-.14-.325a.68.68 0 0 1 .042-.421c.127-.3.466-.538 1.063-.293l1.1.45-.188.46-1.03-.42c-.3-.127-.538-.095-.63.13-.066.16.001.326.114.43.04.03.094.066.148.087l1.118.457-.188.46-1.08-.442c-.26-.106-.487-.078-.576.14-.072.176.017.35.13.447a.43.43 0 0 0 .142.089l1.103.45-.188.46-1.3-.536z"/></g><path d="M79.54 113.327l-.052.043-3.535 2.373c-5.83 3.664-12 5.3-18.696 3.602-3.317-.84-6.17-2.72-8.962-4.727l-1.707-1.112c-.017-.06-.045-.112-.065-.17l-2.6-1.66-1.464-.956c-3.297 1.613-5.277 3.674-5.277 5.92 0 5.17 10.473 9.36 23.393 9.36s23.393-4.19 23.393-9.36c0-1.682-1.112-3.26-3.053-4.623l-.924.875-.45.436z" fill="#fbd70a"/><path d="M46.52 114.24c-.2-.538-.586-1-.785-1.33a20.59 20.59 0 0 1-3.045-8.993c-.664-7.12.896-13.773 4.47-20.003 2.74-4.777 6.486-8.71 9.882-12.946.48-.598.656-1.004 1.432-1.67.012-.01.025-.023.035-.034 1.572-1.756 1.482-1.674 1.643-1.77a2.62 2.62 0 0 0 .315-.227l2.466-2.46a.28.28 0 0 1 .032-.028l1.943-1.5 4.958-4.025 5.926-4.003c.42-.085.92-.768 1.395-1.076.137-.09.308-.05.41.064l11.018 3.376-12.95-22.548-43.278 6.808 9.883 2.81-2.683 2.992c-4.47 5.072-12.753 14.872-15.5 20.858-3.847 8.35-5.33 21.13.76 29.33 3.69 4.968 11.557 10.237 17.62 13.945l1.464.888 2.6 1.542z" fill="#4996ce"/><path d="M92.634 90.026c-.213-4.492-2.115-7.306-6.44-9.454-.906-.45-2.235-.814-3.37-1.214-.012-.004-.024-.002-.035-.004l.187.12.203.136c-9.428 0-13.672 7.937-14.773 10.43-.205.464-.3.74-.3.74l-.127-.063c.034.065.086.12.158.154.718.326 1.428.722 2.128 1.04.165.075.362-.005.438-.17 2.247-4.83 5.537-8.353 10.754-8.833.106-.03.21-.048.314-.07a6.65 6.65 0 0 1 .268-.052c.167-.03.333-.058.495-.074 4.057-.4 6.798 3.392 7.12 6.927.62 6.803-2.026 12.368-6.427 17.174-2.504 2.734-5.29 5.218-8.587 7.003-4.254 2.303-8.67 3.983-13.62 3.573-5.076-.42-9.32-2.524-12.59-6.5-.317-.385-.324-.515-.49-.958l-.036-.097a1.89 1.89 0 0 0-.06-.132c-.046-.097-.108-.22-.172-.346l-.254-.5c-.454-1.06-1.027-2.04-1.27-3.147-1.542-7.033-.173-13.67 3.45-19.696 5.665-9.423 12.91-17.496 21.61-24.167 1.972-1.512 4.13-2.775 5.992-4a.33.33 0 0 1 .278-.039l.774.237c.058.018.114.024.167.024l11.33 3.51-.973-3.916-.155-.048-11.02-3.378c-.104-.114-.275-.153-.41-.064-.475.308-.976.99-1.395 1.076l-5.926 4.003c-.008.006-.016.01-.024.018L64.9 63.277l-1.943 1.5c-.01.01-.022.018-.032.028l-2.466 2.46a2.39 2.39 0 0 1-.315.227c-.16.095-.07.013-1.643 1.77a.28.28 0 0 1-.035.034c-.776.666-.952 1.072-1.432 1.67-3.396 4.235-7.14 8.17-9.882 12.946-3.574 6.23-5.134 12.883-4.47 20.003a20.59 20.59 0 0 0 3.045 8.993c.2.318.575.79.785 1.33.02.053.048.103.065.157h0l1.707 1.033c2.792 1.863 5.645 3.608 8.962 4.39 6.697 1.576 12.866.058 18.696-3.345 1.198-.7 2.358-1.466 3.535-2.203.017-.013.035-.026.052-.04l.45-.404.924-.813c1.582-1.384 3.186-2.747 4.6-4.297 4.764-5.256 7.48-11.305 7.13-18.69z" fill="#0a6699"/><g fill="#4996ce"><path d="M69.567 81.747c-.2.22-.085.492.046.637l.56-.615c-.126-.12-.392-.258-.606-.022zm-5.93.303l-.597-.214-.006.008.415.478.52.668.48-.7-.8-.25z"/><path d="M84.18 79.96l-.196-.12c-1.875-1.15-9.933-5.736-16.07-3.615-6.987 2.416-9.028 7.758-9.538 10.186l10.202 4.856s.1-.276.316-.74c1.155-2.493 5.607-10.43 15.497-10.43 0 .001-.076-.05-.212-.135zm-20.125-.358l.752.13c.227.04.4.076.6.12l.006-.008c-.108-.194-.182-.337-.278-.54l-.323-.69.418-.544.685 1.733 1.937.23-.42.547-.733-.115a12.08 12.08 0 0 1-.688-.118l-.01.012c.104.177.19.352.31.61l.32.655-.417.543-.723-1.78-1.852-.245.416-.543zm-.41 6.375l-3.33-.893.355-.547 1.493.434c.416.12.796.238 1.18.382l.006-.01a13.02 13.02 0 0 1-.814-.927l-1-1.215.347-.535 2.136 2.734-.374.576zm-1.205-4.114l.435-.627 3.3.996-.367.527-.932-.287-.594.855.602.762-.352.507-2.093-2.733zm3.906 6.107c-.147.176-.32.3-.47.358l-.206-.294a1.05 1.05 0 0 0 .416-.286c.135-.16.13-.288.034-.368s-.2-.065-.412.062c-.336.202-.59.192-.758.047-.257-.214-.28-.594.002-.93.134-.16.293-.267.408-.313l.2.29a.85.85 0 0 0-.341.237c-.11.132-.106.256-.017.33s.194.046.415-.085c.315-.183.55-.193.77-.016.263.217.283.584-.04.97zm1.39-.38l-.378-.18a.83.83 0 0 0 .081-.299.84.84 0 0 0-.058-.393c-.014-.038-.028-.064-.045-.08s-.038-.028-.088-.04l-1.772-.6.34-.4.994.398c.114.047.25.1.35.16l.008-.01-.218-.32-.578-.88.333-.39.674 1.2c.37.658.495.995.497 1.293.006.25-.073.438-.14.54zm.884-2.29c-.15.173-.327.293-.477.348l-.2-.298c.122-.04.31-.15.422-.278.138-.158.134-.285.04-.367s-.198-.07-.412.054c-.34.194-.595.18-.76.03-.252-.22-.268-.6.02-.93.138-.16.3-.26.415-.305l.194.293c-.09.03-.236.105-.346.23s-.112.253-.024.33.194.05.417-.076c.32-.177.556-.182.77-.001.257.224.27.6-.06.97zm1.187-1.352c-.116.13-.258.203-.4.205-.15.004-.308-.075-.494-.24l-.667-.592-.18.204-.268-.237.18-.204-.32-.284.226-.424.405.36.302-.34.268.237-.302.34.626.556c.172.152.304.186.425.048a.68.68 0 0 0 .106-.155l.28.237c-.026.07-.094.177-.195.3zM70.84 82.8c-.414.454-.937.468-1.365.077-.388-.354-.54-.923-.13-1.37.414-.454.924-.263 1.232.017a1.11 1.11 0 0 1 .139.148l-.854.938c.26.222.55.123.756-.102.15-.164.234-.302.3-.446l.292.17c-.063.165-.177.366-.36.568zm2.343-2.54l-.752-.727c-.227-.218-.436-.27-.596-.105-.113.117-.113.285-.05.416.025.04.06.09.098.127l.816.79-.324.335-.788-.762c-.2-.184-.397-.238-.55-.08-.124.13-.107.313-.042.435.02.047.054.1.093.128l.805.778-.325.335-.955-.924c-.157-.15-.29-.275-.416-.38l.286-.296.215.18.008-.01c-.04-.17-.048-.414.173-.643.173-.18.41-.22.616-.134l.005-.006c-.03-.12-.03-.23-.008-.333a.64.64 0 0 1 .183-.352c.22-.226.595-.307 1.03.115l.803.775-.325.337zm1.034-.942a1.23 1.23 0 0 1-.512.295l-.167-.317c.125-.026.324-.115.45-.232.154-.142.164-.27.08-.36s-.19-.1-.416.01c-.358.157-.6.115-.758-.05-.228-.245-.203-.624.12-.924a1.12 1.12 0 0 1 .445-.259l.162.31c-.092.02-.245.08-.368.193s-.14.24-.06.325.188.07.423-.03c.335-.14.572-.122.765.08.234.252.207.618-.162.96z"/></g><path d="M44.9 49.396l1.012-1.017.724-.74 2.36 1.667c.987.697 1.96.955 2.922.77s1.892-.732 2.792-1.645c.915-.933 1.368-1.81 1.36-2.635s-.486-1.57-1.433-2.24c-.82-.58-1.753-.822-2.798-.727s-1.95.537-2.718 1.325l-3.37-2.382.033-.11c1.43-1.533 2.974-2.103 5.084-2.22s4.33.233 6.207 1.558 2.952 2.883 3.227 4.67-.42 3.533-2.09 5.235c-.828.833-1.867 1.44-3.116 1.822s-2.555.435-3.916.16c.73 1.16.982 2.317.754 3.472s-.817 2.223-1.766 3.204c-1.773 1.787-3.752 2.718-5.934 2.792s-4.266-.59-6.25-1.992c-1.788-1.264-2.863-2.812-3.223-4.646s.803-3.2 2.462-4.815l-.46-.28L40.2 52.9c-.853.867-1.25 1.743-1.19 2.63s.562 1.664 1.5 2.334a4.36 4.36 0 0 0 3.063.819c1.104-.117 2.128-.652 3.072-1.605 1.087-1.114 1.62-2.083 1.6-2.908s-.58-1.624-1.674-2.397l-2.36-1.667.7-.72z" fill="#1973b5"/><path d="M73.703 47.217c-2.138-1.343-4.393-1.77-6.765-1.28s-4.828 2.068-7.366 4.732l-4.212 4.398c-2.35 2.457-3.517 4.76-3.498 6.908s1.006 3.837 2.96 5.065c1.48.93 3.02 1.412 4.612 1.46.024-.013.05-.024.075-.035a1.66 1.66 0 0 1 .319-.279c-.202.13.03-.058.074-.102a3.72 3.72 0 0 1 .332-.28c.227-.175.47-.314.714-.463l.583-.362 5.194-4.68c2.59-2.154 5.872-4.136 8.785-6.22.744-1.31 1.13-2.576 1.127-3.79-.003-2.153-.98-3.843-2.935-5.07zm-.525 4.5c-.16 1.092-1.09 2.516-2.8 4.27l-5.44 5.614c-1.598 1.642-3.085 2.684-4.46 3.126s-2.576.344-3.6-.29c-1.12-.695-1.608-1.59-1.46-2.7s1.085-2.533 2.81-4.303l5.438-5.614c1.567-1.617 3.045-2.645 4.436-3.085s2.597-.342 3.62.293c1.122.694 1.603 1.587 1.443 2.68z" fill="#1973b5"/><g fill="#fff"><path d="M28.968 77.875l3.367 3.13-.408.43-3.367-3.13.408-.43zm2.346.705l-.673-.6.365-.386.423.347.01-.01c-.117-.333-.08-.82.295-1.216.314-.332 1-.662 1.83.1l1.444 1.342-.412.436-1.394-1.296c-.4-.362-.85-.52-1.24-.1-.272.288-.278.7-.103 1.003.036.07.102.15.177.22l1.454 1.352-.412.436-1.764-1.64z"/><use xlink:href="#openE"/><path d="M36.285 74.58c.604.543 1.205.394 1.617-.043.295-.312.42-.552.503-.78l.385.218c-.075.22-.244.556-.605.938-.698.74-1.605.725-2.334.047s-.9-1.64-.24-2.338c.74-.784 1.632-.346 2.076.067.1.084.15.16.19.205l-1.593 1.687zm.894-1.572c-.275-.265-.822-.55-1.286-.06-.417.44-.2 1.016.082 1.334l1.204-1.275z"/><path d="M39.065 69.077l.646.638 1.404 1.305c.554.516.8.94.78 1.37-.001.437-.25.84-.535 1.142-.272.287-.642.54-.954.613l-.23-.42a1.87 1.87 0 0 0 .855-.528c.422-.446.496-.992-.113-1.558l-.27-.25-.01.01c.098.343.035.768-.317 1.14-.562.595-1.475.547-2.144-.075-.82-.762-.783-1.724-.262-2.275.393-.416.83-.44 1.127-.358l.01-.01-.346-.36.36-.382zm.528 1.34c-.075-.07-.145-.125-.223-.16-.33-.157-.74-.14-1.04.178-.394.416-.32 1.044.24 1.564.475.44 1.094.57 1.54.1.253-.268.313-.67.122-1.023a1.02 1.02 0 0 0-.202-.253l-.434-.404zm.872-1.322l-.773-.682.36-.382.5.427.02-.02c-.222-.4-.178-.864.098-1.157.047-.05.085-.08.132-.1l.415.386c-.052.035-.1.075-.155.135-.3.307-.262.744.012 1.1a1.63 1.63 0 0 0 .186.21l1.3 1.198-.408.432-1.665-1.547zm.573-3.46c.155.134.17.355.007.53a.372.372 0 1 1-.535-.516c.155-.164.373-.157.528-.013zm2.638 3.367l-2.418-2.25.412-.436 2.418 2.25-.412.436z"/><use xlink:href="#openE" x="9.11" y="-9.642"/><path d="M44.097 63.75l1.926.803.64.306.01-.01-.36-.623-.97-1.795.436-.46 1.105 2.257c.534 1.084.757 1.692.736 2.23a1.61 1.61 0 0 1-.221.801l-.473-.235a1.58 1.58 0 0 0 .146-.582c.017-.207-.012-.514-.143-.822-.026-.062-.047-.11-.072-.133a.52.52 0 0 0-.143-.077l-3.067-1.184.45-.476z"/><use xlink:href="#openF"/><path d="M50.527 59.508c.604.543 1.205.394 1.617-.042.295-.312.42-.552.503-.78l.385.218c-.075.22-.244.556-.605.938-.698.74-1.605.725-2.334.046s-.9-1.64-.24-2.338c.74-.783 1.632-.346 2.076.068.1.084.15.16.19.206l-1.593 1.684zm.894-1.572c-.275-.265-.822-.55-1.286-.06-.417.44-.2 1.016.082 1.334l1.204-1.275z"/><use xlink:href="#openG"/><path d="M53.16 54.16l1.804.793.802.383.014-.015c-.148-.24-.282-.496-.427-.78l-.92-1.73.43-.456 1.528 3.2-.393.416-3.28-1.336.44-.467zm3.57-1.22c.604.543 1.205.394 1.617-.042.295-.312.42-.552.503-.78l.385.218c-.075.22-.244.556-.605.938-.698.74-1.605.725-2.334.046s-.9-1.64-.24-2.338c.74-.783 1.632-.346 2.076.068.1.084.15.16.2.206L56.73 52.94zm.895-1.572c-.275-.265-.822-.55-1.286-.06-.417.44-.2 1.016.082 1.334l1.204-1.275z"/><use xlink:href="#openG" x="6.198" y="-6.558"/><use xlink:href="#openF" x="11.947" y="-12.643"/></g><defs ><path id="openD" d="M74.063 30.067a1.73 1.73 0 0 0-1.732 1.727 1.73 1.73 0 1 0 3.464 0 1.73 1.73 0 0 0-1.732-1.727z"/><path id="openE" d="M33.042 74.07l.694.646.6-.624.335.31-.6.625 1.304 1.212c.3.28.55.353.78.1a1.35 1.35 0 0 0 .209-.28l.35.287c-.045.116-.146.274-.306.442-.192.203-.412.307-.63.3-.247.003-.504-.152-.79-.417l-1.32-1.226-.35.372-.335-.312.35-.37-.58-.54.29-.535z"/><path id="openF" d="M49.06 62.41c.207-.05.512-.194.718-.413.3-.317.28-.615.08-.8-.2-.195-.442-.178-.866.033-.563.287-.994.268-1.284-.002-.4-.363-.414-.972.073-1.488.23-.243.5-.39.707-.45l.217.406c-.15.038-.393.138-.604.36-.244.258-.23.54-.05.708.2.186.426.126.84-.075.554-.268.965-.286 1.325.048.425.395.415 1-.124 1.57-.248.263-.543.445-.802.52l-.232-.418z"/><path id="openG" d="M52.11 56.768l-.773-.682.36-.382.49.427.02-.02c-.222-.41-.178-.864.098-1.157a.64.64 0 0 1 .132-.11l.415.386c-.052.035-.1.075-.155.135-.29.307-.262.744.012 1.1.05.066.11.14.186.2l1.29 1.2-.408.43-1.665-1.547z"/></defs></svg>`;
const lustreIcon = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 128 128" xml:space="preserve"> <g> <path d="M123.341,50.238c-1.933,0-3.5,1.567-3.5,3.5s1.567,3.5,3.5,3.5s3.5-1.567,3.5-3.5S125.274,50.238,123.341,50.238z M123.341,56.713c-1.64,0-2.975-1.335-2.975-2.975c0-1.64,1.335-2.975,2.975-2.975c1.64,0,2.975,1.335,2.975,2.975 C126.316,55.378,124.982,56.713,123.341,56.713z"/> <path d="M123.954,53.869v-0.017c0.324-0.118,0.666-0.448,0.666-0.929c0-0.347-0.123-0.61-0.347-0.789 c-0.269-0.213-0.66-0.297-1.22-0.297c-0.453,0-0.861,0.034-1.136,0.079v3.722h0.846v-1.483h0.257 c0.347,0.005,0.509,0.134,0.61,0.604c0.111,0.465,0.202,0.772,0.263,0.879h0.873c-0.073-0.146-0.191-0.638-0.308-1.063 C124.362,54.227,124.217,53.976,123.954,53.869z M123.098,53.539h-0.336v-1.041c0.062-0.011,0.179-0.028,0.386-0.028 c0.392,0.005,0.627,0.179,0.627,0.526C123.775,53.326,123.523,53.539,123.098,53.539z"/> <polygon style="fill:#F15A24;" points="5.177,49.888 1.242,49.888 1.242,78.972 19.339,78.972 19.339,75.66 5.177,75.66 	"/> <path style="fill:#F15A24;" d="M37.733,68.959c0,2.13-0.562,3.812-1.685,5.045c-1.123,1.234-2.653,1.851-4.588,1.851 c-1.61,0-2.818-0.516-3.623-1.549c-0.805-1.032-1.208-2.581-1.208-4.646V56.589h-3.584v13.208c0,3,0.649,5.279,1.948,6.838 c1.299,1.558,3.201,2.338,5.708,2.338c1.519,0,2.854-0.322,4.003-0.964c1.149-0.643,2.159-1.627,3.029-2.951v3.351h3.584V56.589 h-3.584V68.959z"/> <path style="fill:#F15A24;" d="M56.906,65.92l-1.227-0.273c-1.922-0.429-3.201-0.88-3.838-1.354c-0.636-0.474-0.955-1.127-0.955-1.958 c0-1.091,0.445-1.909,1.334-2.454c0.889-0.545,2.224-0.818,4.003-0.818c1.169,0,2.299,0.13,3.39,0.39 c1.091,0.26,2.143,0.65,3.156,1.169v-3.39c-0.987-0.39-2.065-0.682-3.234-0.877c-1.169-0.195-2.416-0.292-3.74-0.292 c-2.676,0-4.74,0.558-6.195,1.675c-1.455,1.117-2.182,2.701-2.182,4.753c0,1.688,0.493,3.016,1.48,3.984 c0.987,0.968,2.591,1.685,4.812,2.153l1.247,0.292c2.221,0.481,3.659,0.981,4.315,1.5c0.656,0.52,0.984,1.266,0.984,2.24 c0,1.052-0.455,1.867-1.364,2.445c-0.909,0.578-2.208,0.867-3.896,0.867c-1.26,0-2.532-0.172-3.818-0.516 c-1.286-0.344-2.591-0.86-3.916-1.549v3.701c1.403,0.455,2.737,0.796,4.003,1.023c1.266,0.227,2.484,0.341,3.653,0.341 c2.805,0,5.009-0.591,6.614-1.773c1.604-1.182,2.406-2.786,2.406-4.812c0-1.779-0.536-3.166-1.607-4.159 C61.26,67.235,59.451,66.466,56.906,65.92z"/> <path style="fill:#F15A24;" d="M73.673,50.959h-3.604v6.195h-2.63v2.786h2.63v11.844c0,2.727,0.526,4.607,1.578,5.64 c1.052,1.032,2.961,1.549,5.727,1.549h3.682v-3h-3.682c-1.494,0-2.484-0.253-2.971-0.76c-0.487-0.507-0.731-1.649-0.731-3.429 V59.94h7.383v-2.786h-7.383V50.959z"/> <path style="fill:#F15A24;" d="M97.881,56.677c-0.299-0.032-0.572-0.049-0.818-0.049c-1.727,0-3.195,0.321-4.403,0.964 c-1.208,0.643-2.188,1.627-2.941,2.951v-3.39h-3.604v21.818h3.604V67.479c0-2.467,0.542-4.36,1.627-5.679 c1.084-1.318,2.64-1.977,4.666-1.977c0.571,0,1.094,0.055,1.568,0.166c0.474,0.111,0.912,0.282,1.315,0.516l-0.019-3.682 C98.511,56.758,98.18,56.709,97.881,56.677z"/> <path style="fill:#F15A24;" d="M111.716,56.063c-3.273,0-5.873,1.049-7.802,3.146c-1.929,2.097-2.893,4.932-2.893,8.503 c0,3.455,1.016,6.195,3.049,8.221c2.032,2.026,4.789,3.039,8.269,3.039c1.389,0,2.76-0.143,4.11-0.429 c1.35-0.286,2.669-0.701,3.954-1.247v-3.39c-1.273,0.675-2.555,1.182-3.847,1.519c-1.292,0.338-2.627,0.507-4.003,0.507 c-2.377,0-4.231-0.646-5.562-1.938c-1.331-1.292-2.075-3.172-2.231-5.64h16.48v-1.753c0-3.247-0.854-5.815-2.562-7.705 C116.972,57.008,114.651,56.063,111.716,56.063z M104.879,65.569c0.182-2.052,0.873-3.643,2.075-4.773 c1.201-1.13,2.802-1.695,4.802-1.695c1.766,0,3.185,0.584,4.256,1.753c1.071,1.169,1.62,2.734,1.646,4.695L104.879,65.569z"/> </g> </svg>`;
const glusterFSIcon = `<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 121.061 124"><g id="layer5"><path id="path968" style="fill:#5a3700;" d="M98.281,69.918c.292,6.055-1.311,10.888-8.067,17.61-.343.474-.686.608-1.029-.047a17.225,17.225,0,0,0-5.371-4.067,28.607,28.607,0,0,0,14.467-13.5Z" transform="translate(-3.47 -2)"/></g><g id="layer6"><path id="path972" style="fill:#9aca20;" d="M3.945,96.6C15.262,84.194,24.472,82.324,33.93,79.21l51,4.348c4.626,2.956,7.3,7,9.783,11.143.928,3.98,1.5,7.629-.906,8.515.349,2.952,2.176,5.325-2.717,10.328-5.934,8.55-16.474,11.617-29.623,12.23-11.647,1.3-25.648-3.02-40.676-11.868-5.407-4.054-10.474-6.9-17.031-16.012-.371-.532-.47-.435.182-1.291Z" transform="translate(-3.47 -2)"/></g><g id="layer8"><path id="path982" style="fill:#87a443;" d="M6.753,96.785a209.539,209.539,0,0,1,27.811-1.812c-1.909-4.662-6.477-8-11.233-11.233C30.113,86.1,34.453,91.2,37.01,94.61L58.3,96.06,47.609,80.025l13.5,16.216,15.582,2.174c-1.818-5.852-7-11.479-10.6-17.212,4.466,5.51,8.6,7.226,13.5,17.665,7.3,1.552,9.169,2.741,13.226,4.077-5.112-.795-8.737-2.226-15.4-2.356-8.464,6.924-16.955,13.84-22.828,21.47a175.318,175.318,0,0,1,19.748-21.832L59.114,98.234c-9.982,5.245-16.679,12.242-23.1,19.386,6-6.643,10.512-13.286,20.564-19.93l-18.934-1c-6.837,3.528-13.659,7.068-17.665,12.954,2.567-4.74,8.861-8.949,14.676-13.226Z" transform="translate(-3.47 -2)"/></g><g id="layer9"><path id="path853" style="fill:#283212;opacity:0.915;isolation:isolate;" d="M46.375,100.648c10.311-3.957,22.994-6.135,36-8.071,6.029-1.763,7.85-4.173,5-7.3a4.512,4.512,0,0,0-3.2-.9l-26.392.9L44.838,83.609c-.069,5.68-1.251,11.359,1.537,17.039Z" transform="translate(-3.47 -2)"/></g><g id="layer3"><path id="path936" style="fill:#855704;stroke:#855704;stroke-miterlimit:15.118;stroke-width:1.205px;" d="M43.559,98.239c-5.516-8.714-8.208-15.778-9.459-24.822-.3-2.2-1.01-6.947-.951-7.007.022-.021.591.421.987.6l.722.319.5-.734a17.172,17.172,0,0,0,.92-1.566A55.952,55.952,0,0,0,38.51,59a38.429,38.429,0,0,1,7.319-13.5,41.335,41.335,0,0,1,4.828-4.818c.328-.247.581-.506.561-.577a12.323,12.323,0,0,0-2.678-1.929,13.441,13.441,0,0,0-5-.93c-.207,0-.331.124-.331.053,0-.326,3.685-3.218,5.858-4.463l1.453-.832.292.292a4.08,4.08,0,0,0,.847.575,2.052,2.052,0,0,0,1.363.218c1.7-.136,2.985-1.18,2.985-2.425a2.773,2.773,0,0,1,.035-.616c.02,0,.985-.2,2.146-.44a37.716,37.716,0,0,1,9.669-1.03c3.763,0,4.364.055,6.776.651a20.928,20.928,0,0,1,4.265,1.653c.041.067-.348.211-.532.542-.659,1.179-.519,2.356.333,2.8a5.629,5.629,0,0,0,3.252.117l1.225-.231.345-.614.345-.615.579.335A33,33,0,0,1,97.7,47.41a33.6,33.6,0,0,1,2.318,6.408,22.3,22.3,0,0,1,.863,6.4c0,3.135-.386,4.883-1.974,8.922a16.8,16.8,0,0,1-1.772,3.587c-5.105,7.679-12.96,12.543-25.822,15.99A119.439,119.439,0,0,0,46.974,99.163c-1.126.672-2.049,1.222-2.052,1.222s-.616-.966-1.363-2.146Zm33.75-30.456a7.445,7.445,0,0,0,3.029-3.43,7.782,7.782,0,0,0,.989-4.516c-.135-2.707-.895-4.61-2.393-6-2.361-2.182-5.225-2.482-7.5-.785a9.66,9.66,0,0,0-3.022,4.086,13.529,13.529,0,0,0-.448,4.245,7.308,7.308,0,0,0,4.822,6.555,5.151,5.151,0,0,0,2.309.252A4.031,4.031,0,0,0,77.309,67.783Z" transform="translate(-3.47 -2)"/></g><g id="layer2"><path id="path827" style="fill:none;" d="M42.98,36.911c-5.339.607-8.126,2.949-11.4,6.726-5.986,7.653-4.815,12.606-3.972,16.4a10.576,10.576,0,0,0,7.175,7.046,28.856,28.856,0,0,0,3.459-7.3c1.37-4.906,3.339-10.194,8.007-15.246a25.938,25.938,0,0,1,4.932-4.292,10.185,10.185,0,0,0-8.2-3.331Z" transform="translate(-3.47 -2)"/><path id="path829" style="fill:none;" d="M62.133,44.406c6.733-6.3,10.47-5.949,16.014-4.228,4.91,3.131,7.546,7.307,7.559,12.555a22.5,22.5,0,0,1-5.381,14.99,16.88,16.88,0,0,1-15.5,7.43C56.841,73.687,55.277,68.206,54.7,62.47c.082-6.518,2.914-12.229,7.431-18.064Z" transform="translate(-3.47 -2)"/><path id="path859" style="fill:#f6f6f6;" d="M33.8,66.809a10.276,10.276,0,0,1-5.363-5.721,17.209,17.209,0,0,1-1-7.1c.351-3.7,2.361-7.754,5.554-11.21a15.755,15.755,0,0,1,7.964-5.143,9.519,9.519,0,0,1,2.938-.3,8.083,8.083,0,0,1,4.356.9,11.007,11.007,0,0,1,2.754,2.086,13.44,13.44,0,0,1-1.546,1.3,31.275,31.275,0,0,0-7.531,9.052c-1.273,2.263-2.049,4.218-3.679,9.272-.261.81-.757,2.143-1.1,2.962a24.636,24.636,0,0,1-2.255,4.3,9.275,9.275,0,0,1-1.091-.4Z" transform="translate(-3.47 -2)"/><path id="path874" style="fill:none;" d="M68.667,56.256c3.056-5.572,7.176-5,9.737-3.01,2.713,1.8,3.4,5.947,2.946,8.776-1.477,4.972-3.945,6.548-6.79,6.341,0,0-4.562.124-6.406-5.124a11.339,11.339,0,0,1,.513-6.983Z" transform="translate(-3.47 -2)"/><path id="path878" style="fill:none;" d="M33.884,51.068a5.04,5.04,0,0,1,3.843-2.306,4.953,4.953,0,0,1,3.866,2.283,49.712,49.712,0,0,0-3.325,8.632c-2.322.3-3.3-.593-4.448-2.139C33.427,57.119,32.177,53.423,33.884,51.068Z" transform="translate(-3.47 -2)"/><path id="path884" style="fill:#1d1d1d;" d="M36.806,59.455a4.39,4.39,0,0,1-2.239-1.712,4.512,4.512,0,0,1-.823-1.908,8.811,8.811,0,0,1-.125-2.627,5.028,5.028,0,0,1,2.951-3.88,6.331,6.331,0,0,1,1.72-.41,5.09,5.09,0,0,1,3.241,1.775l.276.351-.6,1.227A43.9,43.9,0,0,0,38.744,58.8l-.215.753-.707-.006a5.435,5.435,0,0,1-1.016-.09Z" transform="translate(-3.47 -2)"/><path id="path861" style="fill:#f6f6f6;" d="M64.971,74.917a11.992,11.992,0,0,1-5.914-2.47c-2.005-1.655-3.244-4.145-3.892-7.828-.916-5.2,1.085-11.644,5.588-18a12.266,12.266,0,0,1,2.792-3.2c4.753-4.051,8.16-4.916,13.392-3.4A9.728,9.728,0,0,1,80.965,42.6a14.4,14.4,0,0,1,4.14,6.777,12.3,12.3,0,0,1,.3,3.844,17.656,17.656,0,0,1-.286,4.1,21.672,21.672,0,0,1-1.815,5.4,27.678,27.678,0,0,1-7.441,9.262A16.789,16.789,0,0,1,64.971,74.917Z" transform="translate(-3.47 -2)"/><path id="path882" style="fill:#1d1d1d;" d="M73.6,68.105a7.284,7.284,0,0,1-5.6-7.46,11.239,11.239,0,0,1,.6-3.863,10.994,10.994,0,0,1,2.148-3.06,6.029,6.029,0,0,1,2.566-1.546,5.6,5.6,0,0,1,2.738.039A7.773,7.773,0,0,1,79.5,54.494a9.025,9.025,0,0,1,1.775,5,7.61,7.61,0,0,1-.327,3.246c-1.084,3.115-2.7,4.924-4.784,5.367a9.431,9.431,0,0,1-2.567-.006Z" transform="translate(-3.47 -2)"/></g><g id="layer4"><path id="path958" style="fill:none;" d="M50.6,31.979c1.031,2.047,3.037,1.033,5.252-.641l-.608-11.722L54.692,8.922c.027-1.41-.179-.968-1.1-.556a107.8,107.8,0,0,1-14.324,5.228c-7.083,3.128-15.353,5.9-14.413,8.2.883,1.842,11.977-1.444,14.413-2.755A88.1,88.1,0,0,0,53.421,9.687c.871,6.9-.939,14.928-2.818,22.292Z" transform="translate(-3.47 -2)"/><path id="path961" style="fill:none;" d="M77.891,32.3c-.022,2.729,2.6,2.145,5.253,1.537,5.236-9.864,9.4-19.729,13.836-29.594,11.279,29.454,24.577,34.41,26.2,34.911.887.116,1.578.065,1.282-.833-4.5-6.726-10.676-12.107-16.143-19.665A95.582,95.582,0,0,1,97.044,2c-3.916,9.58-11.819,20.222-19.153,30.3Z" transform="translate(-3.47 -2)"/><path id="path963" style="fill:#2c2c2c;" d="M122.917,38.886a23.4,23.4,0,0,1-6.676-4.195,51.027,51.027,0,0,1-5.86-6.117c-4.662-5.813-8.957-13.563-12.589-22.718-.354-.893-.682-1.71-.73-1.816l-.086-.192-.1.224c-.242.565-4.948,11.1-5.864,13.132-2.6,5.762-4.657,10.064-6.753,14.132L83.309,33.9l-1.017.261a7.168,7.168,0,0,1-2.08.217,5.01,5.01,0,0,1-1.8-.1,1.188,1.188,0,0,1-.558-1.414l.194-.5.8-1.564c3.018-3.443,13.752-18.4,18.13-28.218l.084-.187.372.7a95.5,95.5,0,0,0,9.5,14.1c.585.731,1.466,1.862,1.958,2.513,1.98,2.626,3.422,4.345,7.442,8.872,3.519,3.963,4.885,5.588,6.391,7.6,1.355,1.813,1.658,2.28,1.635,2.514-.038.386-.645.467-1.446.2Z" transform="translate(-3.47 -2)"/><path id="path965" style="fill:#2c2c2c;" d="M51.71,32.872a3.385,3.385,0,0,1-1.163-.893c-.084-.161.255-.158.606-1.562A88.7,88.7,0,0,0,53.634,17.14a40.578,40.578,0,0,0-.1-7.622c-.035-.056-.42.205-1.29.876a81.679,81.679,0,0,1-8.8,6.086c-1.663,1-3.946,2.274-4.677,2.617a48.42,48.42,0,0,1-10.217,2.917,10.674,10.674,0,0,1-3,.067c-.844-.246-.786-1,.143-1.848,1.215-1.108,3.064-2.03,9.484-4.727,1.624-.682,3.214-1.355,3.534-1.5s1.07-.4,1.666-.585c2.81-.857,5.272-1.689,7.681-2.6,1.858-.7,5.454-2.212,6.156-2.588.232-.125.251-.126.292-.021a2.775,2.775,0,0,1,.049.59c.005.487,1.559,21.137,1.3,21.974l.081.617-.833.753a3.505,3.505,0,0,1-3.392.718Z" transform="translate(-3.47 -2)"/></g></svg>`
const deviceIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M23 19v-1h-1v-1h-1V5H4v12H3v1H2v1H1v1h23v-1h-1zM5 6h15v10H5V6zm15 13h-1v-1h-1v1h-1v-1h-1v1h-1v-1h-1v1h-1v-1h-1v1h-1v-1h-1v1H9v-1H8v1H7v-1H6v1H5v-1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v1z"/></svg>`;
const vmIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M11 8h2v1h-2zM10 12H6v5h11v-2h-7v-3z"/><path d="M10 7h3V4H3v5h7V7z"/><path d="M22 1H3a2.1 2.1 0 0 0-2 2.1v14.8A2.1 2.1 0 0 0 3 20h8v2H5v2h15v-2h-6v-2h8a2.1 2.1 0 0 0 2-2.1V3.1A2.1 2.1 0 0 0 22 1zm1 14h-5v3H5v-7h5v-1H2V3h12v4h9v8z"/><path d="M14 10h-3v1h7v3h4V8h-8v2z"/><path d="M11 12h6v2h-6z"/></svg>`;

const userIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M22.8 19.3c-.9-2-3-2.6-4.5-3.1-1.3-.4-2.6-1-3-1.6v-1c.2 0 1.1-1.1 1.3-2 .3-1 .5-1.1.5-1.1 1-1.4.2-2.4.2-2.4V5.2 5c0-2.3-2.2-4.1-4.7-4.1C10 1 7.8 2.9 7.8 5.2V8S7 9 8 10.5c0 0 .3.2.5 1 .2 1 1.1 2 1.4 2.2v.7c-.3.7-1.7 1.3-3.2 1.8-1.5.5-3.6 1-4.5 3-1 2-.5 3.4-.3 3.6.5.4 3.9.9 6.6 1a40.3 40.3 0 0 0 6.6 0c2.8.1 7.4-.6 8-1 .2-.2.6-1.5-.3-3.5z"/></svg>`;
const companyIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path d="M14.1,15c0-.3-.1-.3-.4-.3s-.2,0-.2-.2V5.6l-.2-.3L9.2,2.8H8.8l-2.9,1-3.1,1c-.3.1-.3.2-.3.4v9.3c0,.3,0,.3-.3.3H2.1c-.1,0-.2.1-.2.3v.3c0,.2,0,.2.2.2H14C14.1,15.4,14.1,15.2,14.1,15ZM4,5.8l.2-.3,2.6-.7.5-.2h.1c.1,0,.2.2.2.3v.4h0v.3h0a.3.3,0,0,1-.3.3l-2.9.8H4.2A.2.2,0,0,1,4,6.5ZM4,9.2,4.2,9l1.1-.2,1.5-.3h.5a.3.3,0,0,1,.3.3V9h0v.4h0c0,.1-.1.2-.3.2L5,10H4.2c-.1,0-.2-.2-.2-.3Zm3.6,3.9a.3.3,0,0,1-.3.3h-3a.3.3,0,0,1-.3-.3v-.6c0-.2,0-.2.2-.2l3-.3c.3,0,.4.1.4.4Zm-.3-1.5-3,.2c-.2,0-.3,0-.3-.2v-.7H4a.2.2,0,0,1,.2-.2l1.6-.2,1.4-.2c.3,0,.4,0,.4.3v.3h0v.4h0A.3.3,0,0,1,7.3,11.6Zm0-3.8-2.7.5H4.3c-.2,0-.3,0-.3-.2V7.5c0-.2.1-.3.2-.3l2.1-.4.8-.2h.3c.1,0,.2.1.2.3v.3h0v.4h0A.3.3,0,0,1,7.3,7.8Zm5.8,6.7c0,.2,0,.2-.3.2H9.2c-.2,0-.2,0-.2-.2V3.2l.7.4,3.2,2c.1.1.2.2.2.3Z"/><path d="M3.9,4C4,4,4,4,4,3.9V3.4c0-.5,0-.5.4-.6L8.8,1.1a.2.2,0,0,1,.3,0l.9.6,1.8,1.4c.1,0,.2.1.1.3v.5a.3.3,0,0,0,.1.2.5.5,0,0,0,.4.2h0V3c0-.1,0-.1-.1-.2L9.1.5H8.9L6.3,1.6l-2.5.9c-.2.1-.2.2-.2.3V4h.3Z"/></svg>`
const SAMLIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path class="a" d="M6.9,11.6a4.6,4.6,0,0,1-2.6,0c-1.6-.3-2-1.6-2-3.1a12,12,0,0,1,.6-3.2A40.2,40.2,0,0,1,5.1.6h0A30.8,30.8,0,0,0,0,12.8c1.8.4,7.8-.7,9.4-1.7Z"/><path class="a" d="M7.6,0C6.4,1.4,4.5,7.1,4.5,9l.8-2.4A6.5,6.5,0,0,1,6.6,4.3c1.1-1.2,2.3-.9,3.6-.1a8.2,8.2,0,0,1,2.5,2,30.3,30.3,0,0,1,3.1,4.2H16A32.1,32.1,0,0,0,7.6,0Z"/><path class="a" d="M9.3,6l1.6,2.1a5.1,5.1,0,0,1,1,2.4c.4,1.6-.6,2.4-2,3a8.4,8.4,0,0,1-3.1.8,30.1,30.1,0,0,1-5.2,0H1.3a30.7,30.7,0,0,0,13.5-.6C14.4,12,10.9,7.1,9.3,6Z"/></svg>`
const LDAPIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path class="a" d="M5.6,12.2h7L9.1,6.1Z"/><path class="a" d="M4,5.2.5,11.3h5l1-1.8Z"/><polygon class="a" points="8.1 6.6 6.5 3.8 5.2 6.2 6.8 9 8.1 6.6"/><polygon class="a" points="12 5.1 10.5 7.6 12.7 11.3 15.5 11.3 12 5.1"/></svg>`

const fileServersIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40"><path d="M5,20H35V13H5Zm1-6H34v5H6Z"/><path d="M5,3.9v7H35v-7Zm29,6H6v-5H34Z"/><path d="M5,29.1H19.5v5.8H8.5v1h23v-1h-11V29.1H35v-7H5Zm1-6H34v5H6Z"/><rect x="8" y="7" width="4" height="1"/><rect x="8" y="16" width="4" height="1"/><rect x="8" y="25" width="4" height="1"/></svg>`;
const virtualizationIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24">	<path d="M14,3v8H1V3H14m1-1H0V12H15V2h0Z"></path><path d="M17,15v8H4V15H17m1-1H3V24H18V14h0Z"></path><path d="M23,8v8H9V8H23m1-1H8V17H24V7h0Z"></path></svg></span>`
const endPointIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"><path d="M11.91,16.4c0-3.24,1.52-4.45,4.74-4.76V1H1.72V23.86H13.85C11.36,23,11.86,19.08,11.91,16.4Zm-8.58-13H14.6v1H3.33Zm0,2.05H14.6v1H3.33Zm0,2.05H14.6v1H3.33Zm6.15,12.3H7.43V17.71H9.48Zm3.14.17v1.28a1.8,1.8,0,0,0,.61,1.26A6.87,6.87,0,0,0,17.95,24a6.87,6.87,0,0,0,4.73-1.51,1.8,1.8,0,0,0,.59-1.26V19.94a7.6,7.6,0,0,1-5.33,1.76A7.6,7.6,0,0,1,12.62,19.94Zm5.33-7.54c2.95,0,5.33,1.24,5.33,2.76s-2.39,2.76-5.33,2.76-5.33-1.24-5.33-2.76S15,12.4,18,12.4Zm0,6.29a7.6,7.6,0,0,1-5.33-1.76v1.26c0,1.51,2.39,2.76,5.33,2.76s5.31-1.26,5.31-2.77V16.92A7.6,7.6,0,0,1,18,18.68Z"/></svg>`
const dbsIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"> <path d="M.4,12.4,0,12v2.6a2.5,2.5,0,0,0,.3,1.1c.7,1.4,2.8,2.5,5.5,3h.3V14.7H5.9A10.5,10.5,0,0,1,.4,12.4Zm4.7,5.1c-1.9-.5-3.4-1.3-3.9-2.3a1.5,1.5,0,0,1-.2-.7v-.5a12.6,12.6,0,0,0,4.1,1.5Z" /><path d="M1,7.7.4,7.3,0,6.9V9.4c0,1.9,2.3,3.6,5.8,4.1h.3V9.5H5.9A11.3,11.3,0,0,1,1,7.7Zm4.1,4.7C2.7,11.8,1,10.6,1,9.4V9a12.6,12.6,0,0,0,4.1,1.5Z" /><path d="M15.6,19.9c-3.3,0-6.3-.9-8-2.4l-.4-.4v2.6a2.5,2.5,0,0,0,.3,1.1c1,1.9,4.3,3.2,8.1,3.2s7.2-1.3,8.1-3.2a2.5,2.5,0,0,0,.3-1.1V17.1l-.4.4C21.9,19,18.9,19.9,15.6,19.9Zm7.4-.3a1.4,1.4,0,0,1-.2.7C22,21.9,19,23,15.6,23s-6.4-1.1-7.2-2.6a1.5,1.5,0,0,1-.2-.7v-.5a14.6,14.6,0,0,0,7.4,1.8A14.6,14.6,0,0,0,23,19.2Z" /><path d="M23,12.8a13.1,13.1,0,0,1-7.4,2,13.1,13.1,0,0,1-7.4-2l-.6-.5L7.1,12v2.6c0,2.4,3.7,4.3,8.4,4.3S24,17,24,14.6V12l-.4.4Zm0,1.7c0,1.8-3.5,3.3-7.4,3.3s-7.4-1.6-7.4-3.3v-.5a14.6,14.6,0,0,0,7.4,1.8A14.6,14.6,0,0,0,23,14.1Z" /><path d="M7.1,9.4c0,2.4,3.7,4.3,8.4,4.3S24,11.9,24,9.4s-3.7-4.3-8.4-4.3S7.1,7,7.1,9.4ZM23,9.4c0,1.8-3.5,3.3-7.4,3.3S8.2,11.2,8.2,9.4s3.5-3.3,7.4-3.3S23,7.7,23,9.4Z" /><path d="M15.6,4.1h1.3V3.8C16.3,1.6,12.7,0,8.4,0S0,1.9,0,4.3,2.4,8,6,8.5h.2V8.3C7.2,5.8,11,4.1,15.6,4.1ZM5.6,7.4C2.9,6.9,1,5.6,1,4.3S4.5,1,8.4,1s5.6.8,6.8,2C10.6,3.2,6.9,4.8,5.6,7.4Z" /></svg>`
const exchangeIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"><path d="M15.21,19.8V18c.65.07,1-.41,1.29-.84a18,18,0,0,0,2.28-3.5c-.06-.12-.13-.2-.22-.23L16.94,15.1q-.6.6-1.18,1.22a.49.49,0,0,1-.53.16V13l1.11.62c.25.14.26.13.46-.14L15.4,12a.51.51,0,0,1-.2-.38c0-1,0-2,0-3,.28,0,.56-.11.81.1s.39.37.6.57a4.6,4.6,0,0,0,.53-.72c.09-.12,0-.21-.07-.3L16,7.25c-.21-.21-.5-.06-.75-.16V5.39c.11-.1.24-.06.36-.06h7.9c.89,0,1.26.39,1.26,1.3q0,5.89,0,11.78c0,1-.35,1.4-1.37,1.4H15.21Zm6.3-3.27H20.34a4,4,0,0,1-1.61-.69l-.47.63c-.13.16-.08.28.05.41.33.31.66.62,1,.94a.68.68,0,0,0,.51.22h2.69c.42,0,.51-.11.51-.54,0-.84,0-1.67,0-2.51a1,1,0,0,0-.36-.84A20.4,20.4,0,0,0,19,11.56c-.22-.12-.38-.13-.5.2a3.13,3.13,0,0,1,.29.24l2.46,2.48c.1.1.23.19.23.36,0,.54,0,1.07,0,1.69m-.64-5,.63.46c.15.12.26.07.37-.05l1-1.08a.56.56,0,0,0,.13-.41Q23,9,23,7.57c0-.3-.12-.44-.42-.44H19.85a.64.64,0,0,0-.5.23,19,19,0,0,0-2.69,3.87c-.12.22-.07.36.1.41.83-.82,1.66-1.59,2.43-2.42a1.65,1.65,0,0,1,1.43-.6c.9.05.88,0,.91.95,0,.72,0,1.42-.63,1.88,0,0,0,0,0,.08"/><path d="M13.94,24.53.25,22V3L13.94.47ZM6.34,12.93H9V11l-.48,0-1.88,0c-.2,0-.3,0-.29-.29,0-.49,0-1,0-1.48a1.14,1.14,0,0,1,.06-.55H9.52v-2l-5.27.37V17l5.17.6V15.45l-3.09-.26Z"/></svg>`
const archivingIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40"><path d="M35.746,5.271a2.175,2.175,0,0,0-1.863-1.262H6.085A2.128,2.128,0,0,0,4.326,5.227L1,11.76V32.185A2.862,2.862,0,0,0,3.906,35H36.094A2.862,2.862,0,0,0,39,32.185V11.764ZM33.8,6.007c.054,0,.1.037.14.123L36.381,11H23.714L22.288,6.007ZM6.131,6.092a.148.148,0,0,1,.1-.083l11.481,0L16.286,11H3.631ZM37,32.185a.865.865,0,0,1-.906.815H3.906A.865.865,0,0,1,3,32.185V13H16v9h8V13H37Z"/></svg>`
const cloudAppsIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"><path d="M22,9a4,4,0,0,0-.11-.5,3.54,3.54,0,0,0-.62-1.22l-.19-.22-.2-.21A3.55,3.55,0,0,0,17.51,6a3.66,3.66,0,0,0-1.37.71,4,4,0,0,0-.44.41l-.25,0a4.9,4.9,0,0,0-3.51-1.5h-.09A5.09,5.09,0,0,0,7.92,7.52,4,4,0,0,0,6,7H6a3.88,3.88,0,0,0-3.83,3.38A4,4,0,0,0,3.95,18H15.13a4,4,0,0,0,3.4-2h1.82A3.72,3.72,0,0,0,24,12.28,3.71,3.71,0,0,0,22,9Zm-4.15,6a3,3,0,0,1-2.77,2H4a3,3,0,0,1-3-3,3,3,0,0,1,1.9-2.81.38.38,0,0,0,.21-.34A2.86,2.86,0,0,1,6,8H6a3,3,0,0,1,1.85.64.35.35,0,0,0,.22.08h.06a.35.35,0,0,0,.24-.16,4,4,0,0,1,3.46-1.94h.1a3.93,3.93,0,0,1,3.93,3.85c0,.11,0,.21,0,.31a.33.33,0,0,0,.23.34A3,3,0,0,1,17.89,15Zm4.55-1.08A2.68,2.68,0,0,1,20.34,15H18.92a4,4,0,0,0-2.06-4.61s0-.07,0-.1A4.9,4.9,0,0,0,16.13,8a.32.32,0,0,0,.18-.1,2.88,2.88,0,0,1,1.46-1h0a2.54,2.54,0,0,1,.69-.1,2.58,2.58,0,0,1,1.78.72l.13.14.14.17a2.69,2.69,0,0,1,.55,1.55.33.33,0,0,0,.21.31A2.73,2.73,0,0,1,23,12.29,2.67,2.67,0,0,1,22.44,13.93Z"/></svg>`
const oracleEBSIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"><path d="M11.91,16.4c0-3.24,1.52-4.45,4.74-4.76V1H1.72V23.86H13.85C11.36,23,11.86,19.08,11.91,16.4Zm-8.58-13H14.6v1H3.33Zm0,2.05H14.6v1H3.33Zm0,2.05H14.6v1H3.33Zm6.15,12.3H7.43V17.71H9.48Zm3.14.17v1.28a1.8,1.8,0,0,0,.61,1.26A6.87,6.87,0,0,0,17.95,24a6.87,6.87,0,0,0,4.73-1.51,1.8,1.8,0,0,0,.59-1.26V19.94a7.6,7.6,0,0,1-5.33,1.76A7.6,7.6,0,0,1,12.62,19.94Zm5.33-7.54c2.95,0,5.33,1.24,5.33,2.76s-2.39,2.76-5.33,2.76-5.33-1.24-5.33-2.76S15,12.4,18,12.4Zm0,6.29a7.6,7.6,0,0,1-5.33-1.76v1.26c0,1.51,2.39,2.76,5.33,2.76s5.31-1.26,5.31-2.77V16.92A7.6,7.6,0,0,1,18,18.68Z"/></svg>`
const sharePointIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24"><path d="M16.5,4.9a1.4,1.4,0,0,1,1.4,1.4V6.8l-0.2.3a1.4,1.4,0,0,1-1.1.6H16.1V5h0.5m6.1,6.1a1.4,1.4,0,1,1,0,2.7H22l-0.3-.2a1.4,1.4,0,0,1,0-2.1l0.3-.2h0.6m-6.1,6.2a1.4,1.4,0,0,1,1.1.6l0.2,0.3v0.5A1.4,1.4,0,0,1,16.5,20H16.1V17.3h0.5m0-13.3a2.4,2.4,0,0,0-1.5.5V8.2a2.4,2.4,0,0,0,3.4-.5,5.4,5.4,0,0,1,2.7,2.9,2.4,2.4,0,0,0,0,3.7,5.4,5.4,0,0,1-2.7,3,2.4,2.4,0,0,0-3.4-.5v3.7a2.4,2.4,0,0,0,3.8-1.9,2.4,2.4,0,0,0,0-.3,6.5,6.5,0,0,0,3.3-3.6h0.5a2.4,2.4,0,1,0,0-4.7H22.1a6.5,6.5,0,0,0-3.3-3.5,2.4,2.4,0,0,0-2.3-2.7h0Z"/><path d="M12.8,2V23L1,20.9V4.1L12.8,2m-8,12L5,14.2a4.1,4.1,0,0,1,.9.8,3.4,3.4,0,0,1-1.4-.7L2.9,13v2.1c0,0.7,0,1.4.1,2.1v0.7L3.6,18a6.7,6.7,0,0,0,2.5.6,3.7,3.7,0,0,0,2.2-.7,3.8,3.8,0,0,0,1.4-3.2,3.9,3.9,0,0,0-1.6-3l-0.8-.5-0.8-.7H6.7l1,0.3H8.1l1.3,0.4V7.1H6.8a4,4,0,0,0-2.2.6A3.9,3.9,0,0,0,3,10.7,3.9,3.9,0,0,0,4.7,14m9-13.2L0,3.3V21.7l13.8,2.5V0.8h0ZM5.9,16a1.2,1.2,0,0,0,.8-0.3c0.7-1.2-.7-1.9-1.5-2.5a3.1,3.1,0,0,1-.1-5,3,3,0,0,1,1.7-.4L8.4,7.9V9.9a6.1,6.1,0,0,0-1.7-.4,1.3,1.3,0,0,0-1,.5c-0.5,1.3,1.1,1.8,1.9,2.5a3,3,0,0,1,.2,4.6,2.7,2.7,0,0,1-1.6.5A5.9,5.9,0,0,1,4,17.1C4,16.4,4,15.7,4,15a3.7,3.7,0,0,0,2,.9h0Z"/></svg>`
const governanceAppsIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40"><path clip-path="url(#SVGID_2_)" d="M19.796,12.308c-1.568,0-2.839,1.271-2.839,2.836v1.973h5.676v-1.973 C22.633,13.578,21.354,12.308,19.796,12.308L19.796,12.308z M19.796,12.308"/><path clip-path="url(#SVGID_2_)" d="M36.188,6.089c-1.771-1.198-4.416-4.316-4.416-4.316s-2.447,1.526-5.773,1.526c-3.325,0-6.209-1.799-6.209-1.799s-2.881,1.799-6.206,1.799S7.819,1.773,7.819,1.773S5.165,4.885,3.401,6.089 c0.725,1.034,4.643,7.125,1.923,15.128c-2.599,7.653-2.131,9.565,1.558,12.403c4.048,3.117,7.842,0.825,12.908,5.195c5.069-4.37,8.869-2.071,12.92-5.195c3.686-2.838,4.156-4.75,1.556-12.403C31.545,13.214,35.457,7.13,36.188,6.089L36.188,6.089z M27.092,26.848c0,0.666-0.552,1.21-1.216,1.21h-12.16c-0.673,0-1.219-0.544-1.219-1.21v-8.514c0-0.672,0.546-1.217,1.219-1.217h1.115v-1.973c0-2.737,2.227-4.97,4.965-4.97c2.736,0,4.963,2.232,4.963,4.97v1.973h1.117c0.664,0,1.216,0.545,1.216,1.217V26.848z M27.092,26.848"/></svg>`
const activeDirectoryIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24"><path d="M17.64,14.51a2.53,2.53,0,0,1-1.18-2A2.26,2.26,0,0,1,17,10.93c.19-.23.14-.37,0-.59C15.86,8.65,14.76,7,13.65,5.24A.44.44,0,0,0,13.11,5,7,7,0,0,1,11.9,5a.48.48,0,0,0-.36.13C10.33,7,9.14,8.8,8,10.59a7.13,7.13,0,0,1,.58,1.18,2.28,2.28,0,0,1-.82,2.51.44.44,0,0,0-.17.57c.56,1.52,1.09,3,1.62,4.57.08.2.15.31.41.31a2.43,2.43,0,0,1,.83,4.72A2.43,2.43,0,0,1,8.2,20.19L8.37,20c-.58-1.65-1.15-3.29-1.74-4.92a.54.54,0,0,0-.43-.25.46.46,0,0,0-.38.24c-.57,1.57-1.1,3.15-1.67,4.71-.11.31.09.37.24.5a2.32,2.32,0,0,1,.76,2.46A2.28,2.28,0,0,1,3.3,24.52a2.42,2.42,0,1,1-.53-4.78c.35,0,.45-.14.55-.43q.73-2.22,1.53-4.41a.47.47,0,0,0-.17-.64,2.27,2.27,0,0,1-.77-2.57A2.33,2.33,0,0,1,6,10a1.46,1.46,0,0,1,.72,0c.36.14.53,0,.71-.3C8.52,8,9.67,6.21,10.84,4.42a2.56,2.56,0,0,1-.69-2.16A2.45,2.45,0,0,1,11.07.74,2.4,2.4,0,0,1,14.26,1c1,.94,1,2.19,0,3.47q1.15,1.8,2.34,3.6c.4.62.81,1.24,1.21,1.87a.35.35,0,0,0,.47.18,2.41,2.41,0,0,1,2.13,4.19.46.46,0,0,0-.17.63c.54,1.51,1.06,3,1.57,4.54.08.21.16.3.41.3a2.43,2.43,0,1,1-1.62.68l.41-.35c-.38-1.09-.76-2.2-1.15-3.31-.18-.52-.37-1-.54-1.55-.07-.23-.16-.37-.46-.37s-.36.15-.43.36c-.52,1.49-1,3-1.58,4.45a.49.49,0,0,0,.17.67A2.4,2.4,0,0,1,16,24.51a2.42,2.42,0,1,1-.52-4.78c.25,0,.38-.06.46-.3C16.48,17.8,17.06,16.18,17.64,14.51Z"/></svg>`
const bigDataAppsIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"><path d="M12.1,1.9a2.5,2.5,0,0,1,2.5,2.5,2.5,2.5,0,0,1-5,0A2.5,2.5,0,0,1,12.1,1.9ZM19,19.4a2.5,2.5,0,1,0,2.5-2.5A2.5,2.5,0,0,0,19,19.4ZM1,19.3a2.5,2.5,0,0,0,2.5,2.5,2.5,2.5,0,0,0,0-5A2.5,2.5,0,0,0,1,19.3Zm7.6-6.2v-.7l.4-.2h.2l-1.1-.7V6.8L9.5,6a2.1,2.1,0,0,1-.4-1.1L6.9,6.1v5.3L2.3,14.1v2.4a3.5,3.5,0,0,1,1.2-.3V14.8l3.9-2.3Zm8.1,8.6-4-2.3V18h-.2l-.5.3-.4-.3h-.1v1.4l-4,2.3-1.4-.8a2.6,2.6,0,0,1-.9.9l2.3,1.3,4.6-2.7,4.6,2.7,2.6-1.5a5.3,5.3,0,0,1-.6-1Zm.6-10.3V6.1L15.1,4.9A3.6,3.6,0,0,1,14.7,6l1.4.8v4.6l-1.2.7H15l.5.2v.8l1.2-.7,4,2.3v1.7h1.2V14.1Zm-5.2,2.3L14,12.6l-1.7-1h-.6l-1.6,1Zm.6,1.1V17l1.6-.9.3-.2V13.7Zm-1.2,0-2-1.2v2.3l.3.2,1.7.9Z"/></svg>`

const companiesGridEmpty =  `<svg class="add-new-placeholder" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M11.3,18A6.3,6.3,0,0,1,17,11.7V1H2V24H15.5A6.3,6.3,0,0,1,11.3,18ZM4,4H15V5H4ZM4,6H15V7H4ZM4,8H15V9H4Zm6,12H8V18h2Zm11.8-2.4,1.1-.4a5.4,5.4,0,0,0-.9-2.2l-1.1.5-.7-.7.5-1.1a5.4,5.4,0,0,0-2.2-.9l-.4,1.1h-.9l-.4-1.1a5.4,5.4,0,0,0-2.2.9l.5,1.1-.7.7-1.1-.5a5.4,5.4,0,0,0-.9,2.2l1.1.4v.9l-1.1.4a5.4,5.4,0,0,0,.9,2.2l1.1-.5.7.7-.5,1.1a5.4,5.4,0,0,0,2.2.9l.4-1.1h.9l.4,1.1a5.4,5.4,0,0,0,2.2-.9l-.5-1.1.7-.7,1.1.5a5.4,5.4,0,0,0,.9-2.2l-1.1-.4Zm-4.2,2.9a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,17.6,20.4Zm1.6-2.5a1.6,1.6,0,1,1-1.6-1.6A1.6,1.6,0,0,1,19.2,17.9Z"/></svg>`
const copySoftwareIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75"><path d="M59.96,24.046a22.782,22.782,0,0,0-26.176-12.71,24.827,24.827,0,0,1,8.565,7.032A15.42,15.42,0,0,1,54.605,32.49H52.667a13.476,13.476,0,0,0-8.61-11.61,24.731,24.731,0,0,1-5.809,31.864c-.135.109-.276.212-.414.318a24.87,24.87,0,0,1-4.041,2.514A22.773,22.773,0,0,0,59.96,24.046ZM56.927,32.49A17.734,17.734,0,0,0,40.181,15.748V13.816A19.681,19.681,0,0,1,58.868,32.49Z"/><path d="M43.531,24.046A22.791,22.791,0,1,0,32.2,54.2,22.784,22.784,0,0,0,43.531,24.046ZM21.819,53.1A19.716,19.716,0,0,1,4.871,41.583l1.76-.8A17.728,17.728,0,0,0,21.819,51.165Zm0-4.256A15.457,15.457,0,0,1,8.745,39.825l1.76-.8a13.483,13.483,0,0,0,11.314,7.881ZM28.5,34.423a5.849,5.849,0,0,1-.29,1.072,5.764,5.764,0,1,1-5.426-7.834h0a5.833,5.833,0,0,1,5.279,3.4,5.82,5.82,0,0,1,.432,1.427A5.7,5.7,0,0,1,28.5,34.423Zm7.739-1.933A13.5,13.5,0,0,0,23.752,20.005V18.072A15.426,15.426,0,0,1,38.176,32.49Zm4.259,0A17.73,17.73,0,0,0,23.752,15.748V13.816A19.681,19.681,0,0,1,42.439,32.49Z"/></svg>`
const downloadSoftwareIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="42" viewBox="0 0 62 75"><path d="M54.309,38.731A23.715,23.715,0,0,0,43.275,27.28l-2.451,2.452A20.554,20.554,0,0,1,53.167,47.566H51.135A18.52,18.52,0,0,0,39.28,31.275l-1.907,1.908A16.121,16.121,0,0,1,48.707,47.566H46.678A14.106,14.106,0,0,0,35.73,34.825l-1.5,1.5L32.6,37.952l-1.629-1.629-9.049-9.049A23.832,23.832,0,1,0,54.309,38.731Zm-22.717,30.4A20.59,20.59,0,0,1,12.04,49.588h2.031A18.554,18.554,0,0,0,31.592,67.105Zm0-4.452A16.143,16.143,0,0,1,16.5,49.588h2.028A14.123,14.123,0,0,0,31.592,62.651Zm6.989-15.086a6.152,6.152,0,0,1-.3,1.122,6.032,6.032,0,1,1-5.677-8.2h0a6.046,6.046,0,0,1,5.976,5.053A5.994,5.994,0,0,1,38.581,49.588Z"></path><polygon points="32.603 34.694 49.894 17.403 40.013 17.403 40.013 2.583 25.193 2.583 25.193 17.403 15.313 17.403 32.603 34.694"></polygon></svg>`
const installUpdateIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75"><path d="M15.138,41.963h-4.68c.229.672.479,1.3.758,1.919a21.781,21.781,0,0,0,19.8,12.756A21.733,21.733,0,0,0,51.537,41.972l.572-1.661-3.515-6.089-1.732-3h5.547A21.731,21.731,0,0,0,30.986,13.177,21.736,21.736,0,0,0,9.866,29.9l-.494,2.078,4.034,6.988ZM29.144,18.157h3.523V33.971l9.727,6.7-2,2.9-11.25-7.753Z"/><path d="M53.428,42.622A23.716,23.716,0,0,1,9.394,44.708a23.947,23.947,0,0,1-1.036-2.732q-.158-.5-.293-1.007c-.089-.335-.172-.67-.246-1.006h3.855L7.4,32.551l-1.558-2.7L4.391,32.358,0,39.963H4.742c.065.335.132.671.21,1.006s.164.672.256,1.007A26.741,26.741,0,0,0,31.014,61.657a26.752,26.752,0,0,0,24.337-15.7l-.932-1.613Z"/><path d="M57.615,32.216c-.035-.336-.072-.672-.12-1.007A26.785,26.785,0,0,0,30.986,8.157a26.728,26.728,0,0,0-25.132,17.7l1.727,2.99.339.589a23.721,23.721,0,0,1,46.514,1.774c.053.336.1.671.139,1.007s.072.671.1,1.006H50.326l3.864,6.694,1.973,3.417.468-.81L62,33.222H57.7Q57.667,32.718,57.615,32.216Z"/></svg>`
const drBackupIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75"><path d="M35.921,67.7l-.441-.074.284-.078A10.1,10.1,0,0,1,32.8,59.915c0-.078.036-1.946.174-3.313a4.841,4.841,0,0,0-.117-1.433L31.9,51.207l3.04,1.254a24.183,24.183,0,0,0,.07-3.9l-.3-4.2,3.459,2.288a14.929,14.929,0,0,0-.067-3.929l-.5-3.976,2.849,1.518V23.978a1.734,1.734,0,0,0-1.729-1.729H30.832v3.593H18.67V22.249h-8.3a1.734,1.734,0,0,0-1.729,1.729v42.88a1.734,1.734,0,0,0,1.729,1.729H36.991c-.047-.033-.1-.062-.142-.1A11.547,11.547,0,0,1,35.921,67.7ZM12.377,29.27H36.715v1.037H12.377Zm0,4.15H36.715v1.037H12.377Zm0,4.149H36.715v1.038H12.377Zm0,4.15H36.715v1.037H12.377Zm12.169,18.5A2.757,2.757,0,1,1,27.3,57.465,2.756,2.756,0,0,1,24.546,60.221Z"/><polygon points="28.756 15.757 34.095 15.757 24.751 6.413 15.407 15.757 20.747 15.757 20.747 23.766 28.756 23.766 28.756 15.757"/><path d="M55.113,57.831c-.343,1.5-1.175,1.7-1.175,1.7A3.785,3.785,0,0,1,54,57.635a11.433,11.433,0,0,0,.538-1.91C55,50.536,53.35,49.41,53.35,49.41c-.568,2.745-1.4,2.79-1.449,2.79h0c-1.518-8.257-3.15-8.486-3.15-8.486a6.261,6.261,0,0,1-.7,3.3,11.576,11.576,0,0,0-2.5-5.01,8.2,8.2,0,0,1-1.73-4.08c-1,1.583-.685,3.133-.8,5.026a4.183,4.183,0,0,1-.62,2.432,5.373,5.373,0,0,0-2.236-2.921,16.28,16.28,0,0,1-.212,6.054c-.343,1.665-.686,2.954-.686,2.954a7.79,7.79,0,0,0-2.186-3.052,29.716,29.716,0,0,1-.6,7.736,3.575,3.575,0,0,0-1.6-1.469,6.849,6.849,0,0,1,.165,2.138c-.131,1.289-.164,3.133-.164,3.133a7.975,7.975,0,0,0,3.232,6.887,4.894,4.894,0,0,0,2.83.7,9.864,9.864,0,0,0,1.364-.092c-4.749-1.73-4.668-7.654-4.668-7.654a1.141,1.141,0,0,0,.93.438c.1,0,.207-.006.327-.014.522-.032.408-1.485.408-1.485.049-2.285.8-2.5.8-2.5.718,5.761,2.48,6.349,2.48,6.349-1.7-3.9-.049-6.463-.049-6.463a8.415,8.415,0,0,0,1.861,3.737c2.089-2.4,1.224-8.029,1.224-8.029,2.905,2.938,1.827,7.213,1.827,7.213a3.778,3.778,0,0,0,2.122-2.986,5.156,5.156,0,0,1,.147,4.308,4.144,4.144,0,0,1,1.207-.653c-.163,5.875-5.8,7.426-5.8,7.426a14.486,14.486,0,0,0,2.393.211,6.87,6.87,0,0,0,3.9-.9A7.568,7.568,0,0,0,55.113,57.831Z"/></svg>`
const httpProxyIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75"><path d="M32.936,55.34V49.862h10.2V16.514a2,2,0,0,0-2-2H8.368a2,2,0,0,0-2,2V66.077a2,2,0,0,0,2,2H41.143a2,2,0,0,0,2-2v-.965H32.868v2.635l-1.875-1.082-2.98-1.721-2.789-1.61-1.875-1.083,1.875-1.082,5.769-3.331,1.875-1.083v2.88H43.141V55.34h-10.2ZM10.69,22.63H38.82v1.2H10.69Zm0,4.8H38.82v1.2H10.69Zm0,4.8H38.82v1.2H10.69ZM24.755,58.406a3.187,3.187,0,1,1,3.187-3.187A3.187,3.187,0,0,1,24.755,58.406ZM10.69,38.219v-1.2H38.82v1.2Z"/><polygon points="34.186 54.09 49.862 54.09 49.862 56.054 55.631 52.723 52.842 51.112 52.841 51.112 49.862 49.392 49.862 51.112 34.186 51.112 34.186 54.09"/><polygon points="31.618 58.921 25.849 62.251 28.638 63.862 28.638 63.862 31.618 65.582 31.618 63.862 46.698 63.862 46.698 60.885 31.618 60.885 31.618 58.921"/></svg>`
const internetOptionsIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75"><path d="M38.457,63.3,39,62.094l-1.214.546-1.365.613-.871-1.216c-.283-.395-.54-.8-.781-1.216-.569.521-1.15,1.026-1.756,1.5-.316.027-.633.053-.952.069V49.638c.38.014.757.036,1.133.061a14.77,14.77,0,0,1,.559-1.788c-.56-.045-1.124-.082-1.692-.1V38.052h12.8c-.007.18-.022.358-.031.538.141-.028.281-.059.424-.083l1.423-.24c0-.072.009-.143.012-.215h9.693a25.8,25.8,0,0,1-.294,2.774c.128.087.259.169.385.26l1.219.871-.614,1.367-.564,1.253,1.247-.561,1.371-.617.281.4a29.493,29.493,0,0,0,.821-5.743c.019-.429.065-.851.065-1.285s-.046-.855-.065-1.284A29.346,29.346,0,0,0,57.183,23.63h.011c-.113-.226-.239-.444-.357-.666-.082-.154-.163-.308-.247-.46-.15-.271-.3-.54-.462-.806-.081-.137-.166-.271-.25-.407q-.438-.709-.914-1.391c-.088-.126-.175-.253-.265-.378q-.279-.385-.569-.763c-.091-.118-.185-.234-.278-.35-.175-.219-.342-.444-.523-.659-.39-.461-.8-.908-1.213-1.345A29.42,29.42,0,0,0,34.987,7.569c-.961-.137-1.937-.23-2.926-.273-.248-.01-.494-.028-.74-.043-.181-.011-.361-.022-.544-.022h-.011c-.183,0-.364.011-.544.022-.246.015-.492.033-.74.043-.989.043-1.965.136-2.926.273A29.42,29.42,0,0,0,9.427,16.405c-.417.437-.824.884-1.213,1.345-.181.215-.348.44-.523.659-.093.116-.187.232-.278.35q-.291.377-.569.763c-.091.125-.178.253-.266.379q-.476.681-.912,1.389c-.084.136-.17.271-.252.408q-.237.4-.461.806c-.084.152-.165.306-.247.46-.118.222-.244.44-.357.666H4.36A29.346,29.346,0,0,0,1.306,35.483c-.019.429-.065.851-.065,1.284s.046.856.065,1.285A29.373,29.373,0,0,0,8.225,55.784c.389.462.8.909,1.212,1.345a29.589,29.589,0,0,0,8.5,6.2v0c.051.025.1.046.153.071.166.079.334.155.5.231.187.085.376.17.565.251.17.073.342.144.513.213.2.08.394.159.593.235.164.062.329.124.494.183.217.079.436.154.655.228.15.05.3.1.45.148.248.078.5.152.748.224.127.037.253.074.381.109.293.08.589.154.887.226l.265.065c.38.087.763.168,1.149.24l.029.006q.612.115,1.234.2,1.441.207,2.926.274c.248.01.494.028.74.043.18.011.361.022.544.022h.011c.183,0,.363-.011.544-.022.246-.015.492-.033.74-.043q1.483-.065,2.926-.274.621-.088,1.234-.2l.028-.006c.386-.072.77-.153,1.15-.24l.265-.065c.3-.072.594-.146.887-.226l.047-.013-.757-.539ZM56.385,35.483H46.692A36.028,36.028,0,0,0,44.269,23.63h.011c-.052-.134-.1-.271-.153-.4a33.878,33.878,0,0,0,6.106-3.159A25.551,25.551,0,0,1,56.385,35.483Zm-7.4-16.776A32.07,32.07,0,0,1,43.4,21.553a32.432,32.432,0,0,0-6.994-9.806A25.593,25.593,0,0,1,48.983,18.707ZM32.061,11.15c.319.016.636.042.952.069a29.929,29.929,0,0,1,8.67,10.96A34.572,34.572,0,0,1,32.061,23.9Zm0,14.575a36.186,36.186,0,0,0,10.35-1.868c.307.757.581,1.534.834,2.323.069.218.139.436.2.656a34.632,34.632,0,0,1,1.415,8.647h-12.8ZM25.135,11.747a32.432,32.432,0,0,0-6.994,9.806,32.07,32.07,0,0,1-5.581-2.846A25.593,25.593,0,0,1,25.135,11.747ZM11.31,20.067a33.878,33.878,0,0,0,6.106,3.159c-.054.133-.1.27-.153.4h.011a36.028,36.028,0,0,0-2.423,11.853H5.158A25.551,25.551,0,0,1,11.31,20.067ZM5.158,38.052h9.693a36.184,36.184,0,0,0,1.971,10.637v.028c.187.537.383,1.069.595,1.592-.236.093-.464.2-.7.3v.005a33.6,33.6,0,0,0-5.405,2.862A25.545,25.545,0,0,1,5.158,38.052Zm19.431,23.6c-.131-.032-.263-.063-.393-.1-.205-.054-.408-.113-.61-.172-.124-.036-.248-.072-.371-.11-.206-.063-.412-.129-.616-.2-.109-.036-.217-.074-.325-.112-.216-.076-.432-.152-.645-.234-.052-.019-.1-.04-.153-.06q-1.152-.447-2.248-1l-.189-.095c-.225-.116-.447-.234-.667-.356l-.17-.095a25.7,25.7,0,0,1-5.642-4.3,32.07,32.07,0,0,1,5.581-2.846,32.432,32.432,0,0,0,6.994,9.806C24.952,61.747,24.771,61.7,24.589,61.655Zm4.893.73c-.319-.016-.636-.042-.952-.069a29.929,29.929,0,0,1-8.67-10.96,34.536,34.536,0,0,1,9.622-1.718Zm0-14.576a36.234,36.234,0,0,0-10.351,1.869q-.516-1.276-.929-2.615c-.02-.063-.04-.126-.059-.189-.125-.41-.241-.824-.351-1.241-.023-.088-.045-.176-.067-.264-.108-.425-.211-.852-.3-1.285l0-.008a34.888,34.888,0,0,1-.741-6.024h12.8Zm0-12.326h-12.8a34.631,34.631,0,0,1,1.414-8.647c.066-.22.136-.438.2-.656.253-.789.527-1.566.833-2.323a36.2,36.2,0,0,0,10.351,1.868Zm0-11.586a34.572,34.572,0,0,1-9.622-1.718,29.929,29.929,0,0,1,8.67-10.96c.316-.027.633-.053.952-.069Z"/><path d="M57.985,54.471V52.2l2.774-1.053a13.094,13.094,0,0,0-2.245-5.463l-2.721,1.224L54.186,45.3l1.227-2.727a13.109,13.109,0,0,0-5.456-2.264l-1.063,2.8H46.623l-1.063-2.8A13.115,13.115,0,0,0,40.1,42.573L41.331,45.3l-1.607,1.606L37,45.683a13.12,13.12,0,0,0-2.245,5.463L37.532,52.2v2.272l-2.766,1.05a13.118,13.118,0,0,0,2.27,5.451l2.688-1.209,1.607,1.606-1.207,2.683A13.118,13.118,0,0,0,45.582,66.3l1.041-2.743h2.271L49.935,66.3a13.1,13.1,0,0,0,5.458-2.251l-1.207-2.683,1.607-1.606,2.688,1.209a13.118,13.118,0,0,0,2.27-5.451Zm-10.227,4.7a6.132,6.132,0,1,1,6.132-6.131A6.131,6.131,0,0,1,47.758,59.17Z"/></svg>`
const webdomainsIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75"><path d="M36.016,48.086a15.692,15.692,0,0,0-4.372-.78V53.1c.145-.008.289-.02.432-.032A13.6,13.6,0,0,0,36.016,48.086Z"/><path d="M36.769,46.136l.027-.086c.057-.186.109-.374.159-.564.011-.04.021-.08.031-.12.049-.193.1-.387.138-.584v0a15.913,15.913,0,0,0,.337-2.739H31.644v4.434a16.456,16.456,0,0,1,4.7.849C36.5,46.937,36.643,46.54,36.769,46.136Z"/><path d="M22.783,49.664a11.677,11.677,0,0,0,2.564,1.952l.077.043q.15.084.3.162l.086.044q.5.25,1.022.454l.069.028c.1.037.2.071.293.106l.148.051c.092.031.186.061.28.09l.168.05c.092.026.184.053.277.078l.179.044c.082.02.165.042.248.06a14.748,14.748,0,0,1-3.178-4.455A14.6,14.6,0,0,0,22.783,49.664Z"/><path d="M36.818,36.945c-.029-.1-.061-.2-.093-.3-.115-.358-.239-.711-.378-1.055a16.491,16.491,0,0,1-4.7.849v4.433h5.817A15.709,15.709,0,0,0,36.818,36.945Z"/><path d="M30.04,53.066c.143.012.287.024.432.032V47.306a15.692,15.692,0,0,0-4.372.78A13.6,13.6,0,0,0,30.04,53.066Z"/><path d="M24.992,44.778v0c.042.2.089.391.138.584.01.04.02.08.031.12.05.19.1.378.159.564l.027.086c.125.4.266.8.422,1.188a16.456,16.456,0,0,1,4.7-.849V42.041H24.655A15.878,15.878,0,0,0,24.992,44.778Z"/><path d="M33.619,52.826c.083-.018.165-.04.248-.06l.179-.044c.093-.025.185-.052.277-.078l.168-.05c.094-.029.188-.059.28-.09l.148-.051c.1-.035.2-.069.293-.106l.069-.028q.524-.2,1.022-.454l.086-.044q.153-.078.3-.162l.077-.043a11.7,11.7,0,0,0,2.564-1.952A14.6,14.6,0,0,0,36.8,48.371,14.748,14.748,0,0,1,33.619,52.826Z"/><path d="M37.2,35.488h0a16.4,16.4,0,0,1,1.1,5.386h4.4a11.612,11.612,0,0,0-2.795-7,15.415,15.415,0,0,1-2.775,1.435C37.151,35.366,37.172,35.428,37.2,35.488Z"/><path d="M39.333,33.252a11.638,11.638,0,0,0-5.714-3.163A14.752,14.752,0,0,1,36.8,34.545,14.6,14.6,0,0,0,39.333,33.252Z"/><path d="M32.076,29.85c-.143-.013-.287-.025-.432-.032V35.61a15.693,15.693,0,0,0,4.372-.781A13.587,13.587,0,0,0,32.076,29.85Z"/><path d="M37.4,46.875v.012c-.085.244-.175.486-.271.723.107.043.211.091.317.135v0a15.321,15.321,0,0,1,2.456,1.3,11.611,11.611,0,0,0,2.8-7.007h-4.4A16.457,16.457,0,0,1,37.4,46.875Z"/><path d="M24.673,47.747v0c.106-.044.21-.092.317-.135-.1-.237-.186-.479-.271-.723v-.012a16.457,16.457,0,0,1-.9-4.834h-4.4a11.611,11.611,0,0,0,2.8,7.007A15.321,15.321,0,0,1,24.673,47.747Z"/><path d="M25.391,36.647c-.032.1-.064.2-.093.3a15.709,15.709,0,0,0-.643,3.929h5.817V36.441a16.491,16.491,0,0,1-4.7-.849C25.63,35.936,25.505,36.289,25.391,36.647Z"/><path d="M24.925,35.488h0c.024-.06.045-.122.07-.183a15.415,15.415,0,0,1-2.775-1.435,11.612,11.612,0,0,0-2.795,7h4.4A16.4,16.4,0,0,1,24.925,35.488Z"/><path d="M28.5,30.089a11.638,11.638,0,0,0-5.714,3.163,14.6,14.6,0,0,0,2.536,1.293A14.752,14.752,0,0,1,28.5,30.089Z"/><path d="M30.472,35.61V29.818c-.145.007-.289.019-.432.032a13.587,13.587,0,0,0-3.94,4.979A15.693,15.693,0,0,0,30.472,35.61Z"/><path d="M59.66,14H0V62.352H62V14ZM2.34,16.34H59.66v5.849H2.34Zm42.106,25.7A13.343,13.343,0,0,1,41.3,50.1c-.177.21-.361.413-.551.611a13.438,13.438,0,0,1-3.862,2.816v0l-.07.032c-.075.036-.151.07-.227.105s-.171.077-.258.114l-.232.1-.27.107-.224.083c-.1.036-.2.07-.3.1-.068.023-.136.046-.2.067-.113.036-.226.07-.34.1l-.173.05c-.134.037-.268.07-.4.1l-.121.029q-.26.06-.522.109l-.013,0c-.186.035-.372.066-.561.093a13.2,13.2,0,0,1-1.329.124c-.113.005-.224.013-.336.02-.082,0-.164.01-.248.01h0c-.084,0-.166-.005-.248-.01-.112-.007-.223-.015-.336-.02a13.2,13.2,0,0,1-1.329-.124c-.189-.027-.375-.058-.561-.093l-.013,0q-.262-.05-.522-.109l-.121-.029c-.135-.033-.269-.066-.4-.1l-.173-.05c-.114-.032-.227-.066-.34-.1-.068-.021-.136-.044-.2-.067-.1-.033-.2-.067-.3-.1l-.224-.083-.27-.107-.233-.1c-.086-.037-.171-.075-.257-.114s-.152-.069-.227-.105l-.07-.032v0a13.438,13.438,0,0,1-3.862-2.816c-.19-.2-.374-.4-.551-.611a13.343,13.343,0,0,1-3.144-8.057c-.009-.2-.03-.386-.03-.583s.021-.389.03-.584a13.335,13.335,0,0,1,1.388-5.386h0c.051-.1.108-.2.162-.3.037-.07.074-.14.112-.209q.1-.184.21-.366c.037-.063.076-.124.114-.186q.2-.321.414-.631c.04-.057.08-.115.121-.172.085-.117.171-.232.259-.347.041-.053.084-.106.126-.159.079-.1.156-.2.238-.3.177-.21.361-.412.551-.611a13.367,13.367,0,0,1,7.783-4.015c.436-.062.88-.1,1.329-.124.113,0,.224-.013.336-.02.082,0,.164-.009.248-.009h0c.084,0,.166,0,.248.009.112.007.223.015.336.02.449.02.893.062,1.329.124a13.367,13.367,0,0,1,7.783,4.015c.19.2.374.4.551.611.082.1.159.2.238.3.042.053.085.106.126.159.088.115.174.23.259.347.041.057.08.115.12.172.145.207.283.417.415.632.038.061.077.123.114.185q.108.182.21.366c.038.069.075.139.112.209.054.1.111.2.162.3h-.005a13.335,13.335,0,0,1,1.388,5.386c.009.2.03.387.03.584S44.455,41.846,44.446,42.041Z"/><rect x="4.387" y="18.192" width="2.34" height="2.34"/><rect x="9.066" y="18.192" width="2.34" height="2.34"/><rect x="13.745" y="18.192" width="15.792" height="2.34"/></svg>`
export const protectedIcon = `<svg class="protected" viewBox="0 0 1024 1024" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M868.67 180.13a58.5 58.5 0 0 0-43.4-15.05c-.8.04-10.08.6-24.61.6-24.08 0-71.07-1.6-115.56-12.3-57.47-13.78-123.8-77.8-143.13-90.42a58.52 58.52 0 0 0-32.1-9.53 58.81 58.81 0 0 0-32.1 9.5c-2.32 1.53-71.77 74.15-139.72 90.45-44.46 10.7-92.33 12.3-116.38 12.3-14.54 0-23.82-.56-24.73-.6a58.77 58.77 0 0 0-43.34 15.1 55.94 55.94 0 0 0-18.33 41.24v141.24c0 522.15 349.55 589.41 364.38 592.04 3.4.59 6.81.85 10.22.85 3.44 0 6.87-.26 10.22-.85 14.83-2.63 366.96-69.9 366.96-592.04V221.42a55.9 55.9 0 0 0-18.38-41.29zm-39.41 182.54c0 480.9-319.39 536.4-319.39 536.4s-316.83-55.48-316.83-536.4V221.42s10.92.76 28.63.76c30.3 0 81.28-2.17 130.15-13.93 80.02-19.2 158.05-98.33 158.05-98.33s81.5 79.14 161.43 98.33c48.92 11.75 99.02 13.93 129.36 13.93 17.64 0 28.6-.76 28.6-.76v141.25zM689.53 333.4L465.67 552.22 354.64 443.66c-13.77-13.46-36.15-13.46-49.95 0a33.99 33.99 0 0 0 0 48.81l129.53 126.6c1.5 2.58 3.38 5 5.64 7.2a35.58 35.58 0 0 0 25.81 10.08c9.31.22 18.71-3.15 25.85-10.09a34.22 34.22 0 0 0 5.6-7.19L739.5 382.2a33.99 33.99 0 0 0 0-48.8 35.9 35.9 0 0 0-49.96 0zm0 0"></path></svg>`;
export const notProtectedIcon = `<svg class="not-protected" viewBox="0 0 1024 1024" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M520.61 955.222a57.116 57.116 0 0 1-9.846.868c-3.292 0-6.582-.3-9.845-.868-14.307-2.581-351.225-68.822-351.225-583.199V232.888c0-15.404 6.42-30.104 17.679-40.617a55.876 55.876 0 0 1 37.409-15.01c-1.144.108 10.6.72 28.188.72 23.175 0 69.325-1.576 112.19-12.118 65.493-16.06 132.422-87.596 134.679-89.118a55.87 55.87 0 0 1 30.925-9.346 55.68 55.68 0 0 1 30.95 9.375c18.603 12.446 82.543 75.503 137.942 89.089 42.892 10.542 88.175 12.118 111.374 12.118 17.58 0 29.367-.618 28.217-.722a55.699 55.699 0 0 1 37.355 14.956 55.595 55.595 0 0 1 17.705 40.673v139.135c0 514.377-339.392 580.618-353.698 583.199zm298-722.334s-10.555.734-27.58.734c-29.211 0-77.511-2.144-124.671-13.72-77.05-18.907-155.595-96.859-155.595-96.859s-75.202 77.952-152.33 96.86c-47.11 11.575-96.252 13.719-125.464 13.719-17.053 0-27.576-.734-27.576-.734v139.135c0 473.757 305.37 528.425 305.37 528.425s307.845-54.668 307.845-528.425V232.888zM630.011 603.702c-10.875 10.862-28.51 10.862-39.385 0l-78.771-78.693-78.771 78.693c-10.876 10.862-28.509 10.862-39.385 0-10.878-10.867-10.878-28.485 0-39.35l78.77-78.69-78.77-78.692c-10.878-10.865-10.878-28.48 0-39.344 10.876-10.868 28.509-10.868 39.385 0l78.77 78.691 78.772-78.691c10.875-10.868 28.51-10.868 39.385 0 10.878 10.864 10.878 28.48 0 39.344l-78.77 78.692 78.77 78.69c10.878 10.865 10.878 28.483 0 39.35zM204.782 177.26c.11-.01.336-.016.694-.016-.232 0-.463.013-.694.016zm614.465 0c-.213-.004-.425-.016-.638-.016.329 0 .532.005.638.015z"/></svg>`;
const planIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><polygon points="16 1 16 6 22 6 16 1"/><path d="M16.4,21.3a0.9,0.9,0,0,1-.6.3H15.6L15,21.4l-2.6-2.5a0.4,0.4,0,0,1,0-.6l0.7-.9h0.5l1.6,1.4h0.5L18,16.4V16H12v6h6V19Z"/><path d="M22.4,11.9L22,11.6V7H15V1H5V24H22V15.1l0.2-.2a2.8,2.8,0,0,0,.4-1.1V12.8A1.2,1.2,0,0,0,22.4,11.9ZM7,9H20v1H7V9Zm0,2H20v1H7V11ZM19,23H11V15h8v0.3l2.5-2.7h0.1c0.1,0,.1.1,0.1,0.2v0.9a1.8,1.8,0,0,1-.3.7L19,17.6V23Z"/></svg>`
const schedulePolicyIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M16.8,11.9A4.8,4.8,0,0,0,12,16.7a4.8,4.8,0,0,0,9.5,0A4.8,4.8,0,0,0,16.8,11.9Zm0,8.4a3.6,3.6,0,0,1-3.7-3.6,3.7,3.7,0,1,1,7.3,0A3.6,3.6,0,0,1,16.8,20.3Zm.4-3.2,1.4,1.5-.6.5-1.6-1.6h0V14.3h.8Zm-6.6.4h-.2V15.7h.2c0-.3.1-.5.1-.8h-.3V13.1h1.1l.7-.7H10.4V10.6h2.5v1.1l.8-.5v-.6h5.4v.6l.8.4V4.5a.9.9,0,0,0-.9-.9H4.4a.9.9,0,0,0-.9.9V17.3a1,1,0,0,0,.9,1h6.4C10.7,18,10.7,17.7,10.6,17.5ZM17,8h2.1V9.8H17ZM13.7,8h2.5V9.8H13.7ZM10.4,8h2.5V9.8H10.4Zm-4,9.5h-2V15.7H6.4Zm0-2.6H4.3V13.1H6.4Zm0-2.5H4.3V10.6H6.4Zm0-2.6H4.3V8H6.4Zm3.3,7.7H7.2V15.7H9.7Zm0-2.6H7.2V13.1H9.7Zm0-5.1H7.2V8H9.7Z"/></svg>`
const storagePolicyIcon = `<svg  xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M23.71,21.54,21,16.19l.5-.76a1.1,1.1,0,0,0,0-1l-.5-.76v-.92a1,1,0,0,0-.42-.84l-.84-.41-.42-.84a.9.9,0,0,0-.84-.5h-.92l-.83-.42-.42-.17-.51.17-.83.42h-.92a.83.83,0,0,0-.76.5l-.5.84-.84.41a1,1,0,0,0-.42.84v.92l-.5.76a1.1,1.1,0,0,0,0,1l.5.76L8.88,21.54a.77.77,0,0,0,.09.93.9.9,0,0,0,.75.41h.09l1.75-.16.93,1.5a.88.88,0,0,0,.75.42h.08a.83.83,0,0,0,.76-.5l2-3.94h.41l2,3.94a.84.84,0,0,0,.76.5h.08a.91.91,0,0,0,.76-.42l1-1.5,1.68.16h.08a1,1,0,0,0,.84-.41A1,1,0,0,0,23.71,21.54Zm-3.6-5.61v1.18l-1,.58-.59,1H17.34l-1,.67-1.09-.67H14.08l-.59-1-1-.58V15.93l-.59-1,.59-1V12.75l1-.58.59-1h1.17l1.09-.59,1,.59h1.17l.59,1,1,.58v1.17l.58,1ZM19.27,15a2.93,2.93,0,1,1-2.93-2.93A2.93,2.93,0,0,1,19.27,15Z"/><path d="M.83,15.4v2.5A3.57,3.57,0,0,0,2,20.4a9.37,9.37,0,0,0,4.1,2.27l2.24-4A13,13,0,0,1,.83,15.4Z"/><path d="M16.57,7.43A7.08,7.08,0,0,1,20.48,8.6a3.72,3.72,0,0,0,1.35-2.7c0-3-4.7-5.5-10.5-5.5S.83,2.87.83,5.9c0,2.84,4.1,5.17,9.35,5.47A7.15,7.15,0,0,1,16.57,7.43Z"/><path d="M9.42,14.58a7.15,7.15,0,0,1,.22-1.74c-3.85-.3-7.06-1.6-8.81-3.44v2.5c0,2.62,3.57,4.85,8.33,5.38l.5-.88A7.26,7.26,0,0,1,9.42,14.58Z"/></svg>`
const subclientPolicyIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M21.2,10a1,1,0,0,0-.9-.4h-.4V8.9a1.3,1.3,0,0,0-1.4-1.2H9.9V7.3A1.4,1.4,0,0,0,8.5,5.9H4.9A1.4,1.4,0,0,0,3.5,7.3V17.9a1.1,1.1,0,0,0,.3.8,1.1,1.1,0,0,0,.9.4H18.5A1.5,1.5,0,0,0,20,17.9L21.5,11A1.2,1.2,0,0,0,21.2,10ZM4.9,6.8H8.5a.5.5,0,0,1,.5.5v.9a.4.4,0,0,0,.4.4h9.1c.3,0,.5.2.5.3v.6H6.5a1.7,1.7,0,0,0-1.6,1.3l-.5,2.6V7.3A.5.5,0,0,1,4.9,6.8Z"/></svg>`
const regionIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path class="b" d="M14.646,16.422,19,24l4.354-7.578A4.942,4.942,0,0,0,24,14.011a5,5,0,1,0-10,0A4.942,4.942,0,0,0,14.646,16.422ZM19,11.582a2.5,2.5,0,1,1-2.5,2.5A2.5,2.5,0,0,1,19,11.582Z"/><path class="b" d="M16.489,21.637a9.706,9.706,0,0,1-1.263.463,12.936,12.936,0,0,0,.923-1.054l-.544-.948a11.32,11.32,0,0,1-2.237,2.341c-.123.011-.244.03-.368.036V19.017a13.771,13.771,0,0,1,2.133.261l-.642-1.118c-.491-.066-.984-.124-1.491-.142V13h.092a5.973,5.973,0,0,1,.262-1H13V6.982a14.555,14.555,0,0,0,3.544-.557,11.536,11.536,0,0,1,.728,1.842,5.973,5.973,0,0,1,.988-.206c-.111-.342-.228-.68-.361-1.008L17.9,7c-.121-.3-.25-.6-.394-.887a13.445,13.445,0,0,0,1.848-.864A9.913,9.913,0,0,1,20.791,7h.01a10.1,10.1,0,0,1,.862,1.642,6.032,6.032,0,0,1,2.092,1.724A11.437,11.437,0,0,0,22.562,7h0l-.013-.021a11.42,11.42,0,0,0-1.884-2.552q-.358-.363-.748-.691a11.434,11.434,0,0,0-5.762-2.6A11.582,11.582,0,0,0,13,1.025C12.833,1.018,12.669,1,12.5,1s-.333.018-.5.025a11.582,11.582,0,0,0-1.158.111,11.434,11.434,0,0,0-5.762,2.6q-.389.328-.748.691A11.447,11.447,0,0,0,1.025,12c-.007.167-.025.331-.025.5s.018.333.025.5a11.446,11.446,0,0,0,3.308,7.573c.238.242.488.472.747.691a11.435,11.435,0,0,0,5.761,2.6A11.63,11.63,0,0,0,12,23.975c.167.007.331.025.5.025s.333-.018.5-.025a11.63,11.63,0,0,0,1.159-.111,11.194,11.194,0,0,0,2.851-.821c.077-.033.151-.07.226-.106ZM18.546,4.561a12.628,12.628,0,0,1-1.517.659,12.557,12.557,0,0,0-1.8-2.32A9.954,9.954,0,0,1,18.546,4.561ZM13,2.525c.124.006.245.025.368.036a11.41,11.41,0,0,1,2.671,2.974A13.581,13.581,0,0,1,13,5.983ZM9.774,2.9a12.557,12.557,0,0,0-1.8,2.32,12.628,12.628,0,0,1-1.517-.659A9.954,9.954,0,0,1,9.774,2.9ZM5.643,5.249a13.445,13.445,0,0,0,1.848.864A14.224,14.224,0,0,0,6.029,12h-3.5A9.952,9.952,0,0,1,5.643,5.249ZM2.525,13h3.5a14.224,14.224,0,0,0,1.462,5.887,13.445,13.445,0,0,0-1.848.864A9.952,9.952,0,0,1,2.525,13Zm3.929,7.439a12.628,12.628,0,0,1,1.517-.659,12.557,12.557,0,0,0,1.8,2.32A9.954,9.954,0,0,1,6.454,20.439ZM12,22.475c-.124-.006-.245-.025-.368-.036a11.41,11.41,0,0,1-2.671-2.974A13.581,13.581,0,0,1,12,19.017Zm0-4.457a14.555,14.555,0,0,0-3.544.557A13.225,13.225,0,0,1,7.03,13H12ZM12,12H7.03A13.225,13.225,0,0,1,8.456,6.425,14.555,14.555,0,0,0,12,6.982Zm0-6.017a13.581,13.581,0,0,1-3.039-.448,11.41,11.41,0,0,1,2.671-2.974c.123-.011.244-.03.368-.036Z"/></svg>`
const arrayIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M2,1V6H23V1H2ZM12,4H4V3h8V4Zm7,0H18V3h1V4Z"/><path d="M2,7v5H23V7H2Zm10,3H4V9h8v1Zm7,0H18V9h1v1Z"/><path d="M2,13v5H23V13H2Zm10,3H4V15h8v1Zm7,0H18V15h1v1Z"/><polygon points="15 22 15 21 13 21 13 19.5 12 19.5 12 21 10 21 10 22 2 22 2 23 10 23 10 24 15 24 15 23 23 23 23 22 15 22"/></svg>`
const alertIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M12.5,3L1,22h23L12.5,3z M13.5,20h-2v-2h2V20z M11.5,16v-6h2v6H11.5z"/></svg>`
const backupsetIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M23.802 18.809H13.404v-2.793c0-.551-.426-.999-.951-.999H3.612V1.23c0-.127.108-.234.236-.234h19.718c.128 0 .236.107.236.234v6.871c.333-.064.67-.11 1.009-.149V1.23A1.24 1.24 0 0023.566 0H3.848c-.687 0-1.245.552-1.245 1.23v13.788H.951c-.393 0-.749.269-.885.669a.867.867 0 00-.066.33V40h26.55c.67 0 1.346-.497 1.57-1.155l4.595-13.459c.13-.38.088-.769-.113-1.066a1.093 1.093 0 00-.926-.469H7.087c-.671 0-1.346.496-1.571 1.155l-4.47 13.095V16.124h11.312v2.793c0 .551.426.999.951.999h14.74c.289 0 .523-.248.523-.553 0-.305-.235-.553-.523-.553h-3.238v-8.234c-.34.049-.677.111-1.009.191v8.042zM2.074 38.787L6.63 25.442c.068-.2.335-.396.539-.396h24.38l.019.001-.006.019-4.555 13.344c-.068.2-.335.396-.539.396H2.088l-.019-.001a.167.167 0 01.005-.018z"/><path d="M26.38 8.611a12.886 12.886 0 00-9.655 4.33V8.609a.544.544 0 00-.547-.541.544.544 0 00-.547.541v5.584c0 .299.245.541.547.541h5.227a.544.544 0 00.547-.541.544.544 0 00-.547-.541H17.55a11.79 11.79 0 018.831-3.958c6.482 0 11.756 5.216 11.756 11.627 0 3.78-1.869 7.337-4.999 9.516a.538.538 0 00-.133.754.549.549 0 00.762.131c3.421-2.381 5.463-6.269 5.463-10.401 0-7.008-5.764-12.71-12.85-12.71zM6.056 5.54h15.302v.92H6.056zM6.056 2.873h15.302v.92H6.056z"/></svg>`
const ibmiServerIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M2.819 10.021H22.5v1.064H2.819zM2.819 6.723H22.5v1.064H2.819zM2.819 3.372H22.5v1.064H2.819zM2.819 13.319H22.5v1.064H2.819zM10.585 28.458a2.128 2.128 0 104.257 0 2.128 2.128 0 00-4.257 0z"/><path d="M28 16c-1.038 0-2.039.146-3 .393V1.543C25 .711 24.342.029 23.511 0H1.489A1.543 1.543 0 000 1.543v34.149c0 .832.658 1.514 1.489 1.543h18.849a11.99 11.99 0 01-1.11-1.064H1.489v-.001a.48.48 0 01-.426-.479V1.543a.48.48 0 01.426-.479H23.51a.48.48 0 01.426.479v15.178C19.312 18.388 16 22.801 16 28c0 3.161 1.231 6.027 3.228 8.17.35.375.715.736 1.11 1.064A11.95 11.95 0 0028 40c6.627 0 12-5.373 12-12s-5.373-12-12-12zm0 22.848c-5.982 0-10.848-4.866-10.848-10.848S22.018 17.152 28 17.152 38.848 22.018 38.848 28 33.982 38.848 28 38.848z"/><path d="M19.429 32.562c2.488.277 10.23.415 14.93 2.281a17.746 17.746 0 002.281-2.281H19.429zM28.415 23.507c.622 0 1.175-.553 1.175-1.175v-.069c-.069-.622-.553-1.106-1.175-1.106h-.069c-.622 0-1.106.553-1.106 1.175s.553 1.175 1.175 1.175zM27.447 24.959h1.935v6.359h-1.935z"/></svg>`
const instanceIcon =`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M32.394 7.492H7.183v24.973h25.211V7.492zM9.122 9.546h21.333v20.865H9.122V9.546zM17.69 0h-2v5.549h2V0zm-6.056 0h-2v5.549h2V0zm12.324 0h-2v5.549h2V0zm6.197 0h-2v5.549h2V0zM40 22.238h-5.634v2H40v-2zm0 5.897h-5.634v2H40v-2zm0-12.14h-5.634v2H40v-2zm0-6.104h-5.634v2H40v-2zM5.634 22.238H0v2h5.634v-2zm0 5.897H0v2h5.634v-2zm0-12.14H0v2h5.634v-2zm0-6.104H0v2h5.634v-2zm15.961 24.56V40h2v-5.549h-2zm5.985 0V40h2v-5.549h-2zm-12.323 0V40h2v-5.549h-2zm-6.198 0V40h2v-5.549h-2z"/></svg>`
const libraryIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M33.073 0H6.927A2.31 2.31 0 004.62 2.307v36.924a.769.769 0 101.538 0v-.769h27.684v.769a.769.769 0 101.538 0V2.307A2.31 2.31 0 0033.073 0zm.769 33.067v3.857H6.158V32.31h27.684v.757zm0-2.307H6.158v-4.602h27.684v4.602zm0-6.247H6.158v-4.614h27.684v4.614zm0-6.152H6.158v-4.614h27.684v4.614zm0-6.057H6.158V7.69h27.684v4.614zm0-6.152H6.158V2.307c0-.425.344-.769.769-.769h26.146c.425 0 .769.344.769.769v3.845z"/><path d="M13.079 3.076h-1.538a.769.769 0 100 1.538h1.538a.769.769 0 100-1.538zM11.541 10.766h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM28.459 3.076h-1.538a.769.769 0 100 1.538h1.538a.769.769 0 100-1.538zM26.921 10.766h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM11.541 16.918h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM11.541 23.082h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM11.541 29.234h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM26.921 16.918h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM26.921 23.082h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM26.921 29.234h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM11.541 35.386h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM26.921 35.386h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538z"/></svg>`
const mediaAgentIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M22.119 31.223a2.128 2.128 0 104.257 0 2.128 2.128 0 00-4.257 0z"/><path d="M35.045 2.766H24.384c.245.33.428.683.531 1.064h10.13a.48.48 0 01.426.479v34.149a.48.48 0 01-.426.479H13.023a.48.48 0 01-.426-.479V18.534c-.304-.01-.662-.027-1.064-.053v19.976c0 .832.658 1.514 1.489 1.543h22.021a1.542 1.542 0 001.489-1.543V4.308a1.54 1.54 0 00-1.487-1.542z"/><path d="M34.034 16.489h-10.71c-.603.414-1.364.77-2.289 1.064h12.999v-1.064zM34.034 13.138h-9v.44c0 .216-.033.421-.071.623h9.071v-1.063zM14.353 19.787h19.681v1.064H14.353zM14.353 23.085h19.681v1.064H14.353z"/><g><path d="M18.683.552C16.179.027 13.536 0 13.032 0c-.504 0-3.146.027-5.649.551-3.55.744-5.35 2.159-5.35 4.206v8.507c0 2.047 1.8 3.463 5.35 4.207 2.503.525 5.144.551 5.649.551s3.147-.025 5.651-.55c3.551-.744 5.351-2.16 5.351-4.207V4.758c0-2.047-1.8-3.462-5.351-4.206zm4.351 12.649c0 2.641-5.981 3.6-10.002 3.6-4.019-.001-9.998-.96-9.998-3.601v-2c.944.692 2.265 1.234 3.965 1.619 2.672.605 5.494.636 6.033.636s3.361-.031 6.035-.635c1.701-.385 3.023-.927 3.967-1.619v2zm0-4.774c0 2.798-5.981 3.814-10.002 3.814-4.019 0-9.998-1.016-9.998-3.814V7c.944.734 2.265 1.308 3.965 1.716 2.673.641 5.494.674 6.033.674s3.361-.033 6.035-.674c1.701-.408 3.023-.982 3.967-1.716v1.427zM13.032 8c-4.019 0-9.998-.905-9.998-3.4 0-2.494 5.979-3.399 9.998-3.399 4.02 0 10.002.905 10.002 3.399 0 2.495-5.982 3.4-10.002 3.4z"/><path d="M13.17 3.632c-.246 0-2.402.026-2.402.93 0 .903 2.157.929 2.402.929.246 0 2.403-.026 2.403-.929 0-.904-2.157-.93-2.403-.93z"/></g></svg>`
const serverGroupIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M34.072 0H16.455a1.235 1.235 0 00-1.192 1.234V9h.851V1.234a.384.384 0 01.34-.383h17.617a.382.382 0 01.34.383v27.319a.384.384 0 01-.34.383h-8.282v.851h8.282a1.233 1.233 0 001.191-1.234V1.234A1.232 1.232 0 0034.072 0z"/><path d="M25.789 21.102v3.327a1.702 1.702 0 000-3.327zM25.789 11.255h7.474v.851h-7.474zM17.518 9h6.75c.431 0 .817.181 1.094.468h7.901v-.851H17.518V9zM17.518 5.979h15.745v.851H17.518zM17.518 3.298h15.745v.851H17.518zM24.737 38.766V11.447c0-.665-.527-1.211-1.192-1.234H5.928c-.57.02-1.017.432-1.139.967-.02.089-.053.173-.053.267v27.319c0 .665.527 1.211 1.191 1.234h17.617c.321-.011.607-.148.82-.358.229-.225.373-.532.373-.876zM5.588 11.447a.384.384 0 01.34-.383h17.617a.382.382 0 01.34.383v27.319a.384.384 0 01-.34.383H5.928a.382.382 0 01-.34-.383V11.447z"/><g><path d="M14.907 31.277a1.702 1.702 0 100 3.404 1.702 1.702 0 000-3.404zM6.992 21.468h15.745v.851H6.992zM6.992 16.191h15.745v.851H6.992zM6.992 13.511h15.745v.851H6.992zM6.992 18.83h15.745v.851H6.992z"/></g></svg>`
const storagePoolIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M36.579 27.579c-.508 0-.921.471-.921 1.053v8.21c0 .582-.413 1.053-.921 1.053H5.263c-.508 0-.921-.471-.921-1.053v-8.21c0-.582-.413-1.053-.921-1.053s-.921.471-.921 1.053v8.21C2.5 38.583 3.739 40 5.263 40h29.474c1.524 0 2.763-1.417 2.763-3.158v-8.21c0-.582-.413-1.053-.921-1.053z"/><path d="M32 23.409V4.599c0-.015 0-.03-.008-.045v-.075C31.992.216 21.998 0 19.996 0 17.994 0 8 .217 8 4.479c0 .045.008.082.008.119v.03s-.008 6.592 0 13.199c0 3.838.008 6.899.025 9.101.017 2.665.025 3.718.074 4.181h-.008c0 3.158 6.846 4.584 11.707 4.584 4.877 0 12.119-1.456 12.194-4.592v-7.674-.018zM9.39 15.497c1.492.556 5.575 1.876 10.795 1.876 3.168 0 6.753-.496 10.422-1.932v7.606c-10.712 4.506-21.093.096-21.199.052l-.008-.002c-.005-2.299-.008-4.916-.01-7.6zm21.217-1.432c-10.677 4.462-21.019.146-21.217.063l.002-7.297c2.818 1.993 9.063 2.12 10.603 2.12 1.541 0 7.794-.127 10.612-2.12v7.234zM14.047 1.762c2.628-.485 5.413-.508 5.94-.508.535 0 3.32.022 5.948.508 2.126.396 4.663 1.18 4.663 2.71 0 1.531-2.538 2.322-4.663 2.71-2.628.485-5.413.508-5.948.508-.536 0-3.32-.022-5.94-.508-2.126-.396-4.663-1.18-4.663-2.71.008-1.523 2.538-2.314 4.663-2.71zm5.751 32.671c-4.869 0-10.315-1.419-10.315-3.322 0-.045-.008-.082-.016-.127-.031-.403-.051-2.953-.062-6.508 1.497.563 5.577 1.894 10.789 1.894 3.157 0 6.736-.501 10.414-1.945v6.664c-.05 1.85-5.949 3.344-10.81 3.344z"/></svg>`
const subclientIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M39.77 16.19c-.247-.365-.66-.574-1.134-.574H8.527c-.821 0-1.648.608-1.923 1.414L1.469 32.07V6.154h13.664V9.479c0 .726.565 1.317 1.258 1.317h18.048c.405 0 .735-.346.735-.771 0-.426-.33-.772-.735-.772H16.601V5.928c0-.726-.564-1.317-1.258-1.317H1.258c-.522 0-.993.355-1.173.883A1.156 1.156 0 000 5.928V35.39h32.36c.821 0 1.648-.608 1.923-1.414l5.626-16.48c.159-.466.108-.942-.139-1.306zm-1.266.909l-5.581 16.346c-.083.245-.411.486-.66.486H2.399l-.023-.001.007-.023 5.58-16.346c.084-.245.411-.486.661-.486h29.864l.023.001-.007.023z"/></svg>`
const unixClusterIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M27.73 36.079c-.523.349-1.02.735-1.487 1.154a3.85 3.85 0 01-.661.495.661.661 0 01-.992-.33c-.148-.314-.19-.658-.176-1.002a10.3 10.3 0 01-4.946 1.268c-5.38 0-9.805-4.083-10.361-9.324-.82-.99-.78-2.02.115-3.804a33.754 33.754 0 013.305-7.421c.496-.66.165-1.484.496-2.474 1.983 2.474 3.966 1.814 5.949.495.826-.66 1.322-.66 1.652.33.251.501.482 1.001.709 1.499 4.865.881 8.557 5.135 8.557 10.261 0 1.596-.368 3.102-1.008 4.455.044.02.09.034.133.059l4.925 2.774c.036-.44-.331-.901-1.088-1.405v-.165a5.44 5.44 0 01-2.479-4.947 15.15 15.15 0 00-3.305-10.719 16.14 16.14 0 01-3.966-10.719 6.583 6.583 0 00-1.157-3.958A6.453 6.453 0 0014.839.292c-2.479.66-3.635 2.309-3.635 5.277a44.714 44.714 0 00.331 5.607 4.773 4.773 0 01-1.322 4.287c-2.809 2.803-3.305 6.926-5.453 10.224a2.134 2.134 0 000 1.154v.33a2.97 2.97 0 01-2.809 3.298c-1.652.33-2.148.989-1.652 2.638a7.06 7.06 0 010 1.814c-.991 1.979.661 2.474 2.313 2.803a29.12 29.12 0 015.949 1.979c1.105.482 2.39.29 3.305-.495 3.14-2.144 6.61-1.154 9.915-.989l.496.495a3.31 3.31 0 004.296.825c.181-.084.348-.196.496-.33a29.614 29.614 0 013.988-2.627l-2.084-1.174-1.243.671zM17.815 5.736h.165a1.323 1.323 0 011.652.33c.791.857.926 2.131.331 3.133a.496.496 0 01-.661.33c-.331 0-.331-.33 0-.66.331-.66.496-1.484-.496-1.649-.991-.165-1.157.495-1.652 1.319V8.21a1.814 1.814 0 01.661-2.474zm-1.817 4.453l2.644.989c.059.051.115.106.165.165l-2.974 1.649a.665.665 0 01-.496 0 4.624 4.624 0 01-1.818-1.484l1.818-1.319a.661.661 0 01.661 0zm-3.14-4.123a.993.993 0 011.322 0 2.47 2.47 0 01.661 2.803c-.826-.33-.496-1.649-1.487-1.649-.991 0-.165 1.319-.826 1.979a2.469 2.469 0 01.33-3.133zM8.915 37.889l-.023.004a1.152 1.152 0 01-.496 0 14.931 14.931 0 01-1.983-.824 10.764 10.764 0 00-2.644-.66h-.826c-.331 0-.331-.33-.331-.66v-.33a3.292 3.292 0 000-1.979c0-.33 0-.495.496-.495l1.157-.33c.439-.11.804-.413.992-.825.096-.227.207-.447.33-.66 0 0 .331-.33.496 0 .367.291.7.623.992.989l1.157 1.814c.496.495.661 1.154.992 1.649.309.261.539.604.661.989a1.157 1.157 0 01-.97 1.318z"/><path d="M39.739 39.042l-2.823-1.59-8.44-4.755a.513.513 0 00-.744.584.507.507 0 00.242.308l8.942 5.038 2.321 1.308a.51.51 0 10.502-.893zM19.469 17.973c-5.095 0-9.239 4.151-9.239 9.254 0 5.102 4.145 9.253 9.239 9.253 5.094 0 9.239-4.151 9.239-9.253 0-5.103-4.145-9.254-9.239-9.254zm0 17.483c-4.531 0-8.217-3.691-8.217-8.229 0-4.538 3.686-8.23 8.217-8.23 4.531 0 8.217 3.692 8.217 8.23-.001 4.537-3.687 8.229-8.217 8.229z"/><path d="M14.532 22.282h3.949v3.953h-3.949zM14.532 28.217h3.949v3.953h-3.949zM20.456 22.282h3.949v3.953h-3.949zM20.456 28.217h3.949v3.953h-3.949z"/></svg>`
const userGroupIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M20.84 23.476a6.313 6.313 0 01-.277-.807l-.017-.068a6.422 6.422 0 01-.398-.621c-.734-.334-1.489-.565-2.144-.774-1.44-.457-2.791-1.03-3.315-1.666l.071-1.063c.252-.11 1.209-1.282 1.461-2.257.252-.974.506-1.155.506-1.155 1.17-1.477.217-2.651.217-2.651v-3.03l.002-.082-.002-.082v-.087l-.003.002c-.099-2.415-2.351-4.342-5.116-4.342-2.828 0-5.122 2.019-5.122 4.511 0 .054.002.103.003.155v2.981s-.957 1.172.217 2.651c0 0 .252.181.504 1.153.254.974 1.211 2.146 1.463 2.257 0 0 .064.485.059.805-.348.729-1.845 1.386-3.461 1.899-1.652.525-3.941 1.165-4.917 3.341-.976 2.177-.449 3.644-.263 3.79.518.41 4.158.995 7.113 1.155a43.854 43.854 0 006.136.1c.103-.304.209-.61.344-.913 1.572-3.506 4.99-4.586 6.826-5.167l.113-.035zm-8.099 4.93a5.458 5.458 0 00-.069.159c-.499.017-.945.025-1.383.025-1.305 0-2.587-.055-3.858-.166-2.574-.139-5.256-.564-6.288-.85-.051-.436-.014-1.241.449-2.273.704-1.571 2.444-2.12 3.979-2.605l.221-.07c2.532-.804 3.883-1.628 4.382-2.672.086-.179.132-.375.135-.574a7.906 7.906 0 00-.073-1.031 1.382 1.382 0 00-.619-.979c-.229-.226-.779-.983-.914-1.502-.212-.818-.482-1.397-.819-1.756-.367-.496-.26-.813-.189-.923.248-.258.312-.518.312-.876V9.258l-.001-.052-.003-.107c0-1.788 1.736-3.243 3.87-3.243 2.06 0 3.795 1.403 3.867 3.126l.002.043.002.068-.002.088v3.108c0 .318.109.626.31.873.003.003.247.336-.187.925-.339.36-.609.939-.821 1.759-.134.519-.682 1.273-.91 1.5-.363.235-.6.63-.63 1.07l-.073 1.09c-.024.352.088.7.312.972.655.797 1.943 1.48 4.051 2.149l.154.049c.28.089.577.183.878.287-2.046.812-4.68 2.311-6.085 5.443z"/><path d="M39.425 30.098c-.976-2.176-3.266-2.814-4.917-3.341-1.44-.457-2.791-1.03-3.315-1.666l.071-1.063c.252-.11 1.209-1.282 1.461-2.257.252-.974.506-1.155.506-1.155 1.17-1.477.217-2.651.217-2.651v-3.028l.002-.082-.002-.082v-.09l-.003.002c-.098-2.413-2.35-4.34-5.115-4.34-2.828 0-5.122 2.019-5.122 4.511 0 .054.002.103.003.155v2.981s-.957 1.172.217 2.651c0 0 .252.181.504 1.153.254.974 1.21 2.146 1.463 2.257 0 0 .064.487.059.805-.348.729-1.845 1.386-3.461 1.899-1.652.525-3.941 1.165-4.917 3.341-.976 2.177-.449 3.644-.263 3.79.518.41 4.158.995 7.113 1.155 1.165.104 2.461.164 3.833.164 1.177 0 2.299-.044 3.332-.122h.07c3.054 0 7.922-.717 8.527-1.197.186-.148.713-1.612-.263-3.79zm-.69 2.867c-1.234.338-4.88.878-7.544.878h-.07c-.034 0-.069.001-.103.004a43.425 43.425 0 01-3.262.119c-1.305 0-2.566-.054-3.797-.163-2.533-.137-5.174-.555-6.189-.837-.051-.43-.014-1.221.442-2.237.693-1.546 2.406-2.087 3.917-2.564l.217-.069c2.492-.791 3.822-1.603 4.313-2.63.084-.177.13-.369.133-.565a7.972 7.972 0 00-.071-1.014 1.365 1.365 0 00-.609-.965c-.225-.223-.767-.968-.9-1.479-.209-.806-.474-1.375-.806-1.728-.362-.489-.256-.8-.186-.908.244-.254.307-.51.307-.862v-3.01l-.001-.058-.002-.098c-.002-1.761 1.706-3.193 3.807-3.193 2.028 0 3.736 1.38 3.807 3.077l.002.042.001.071-.002.085v3.058c0 .313.108.616.305.859.003.003.243.331-.184.911-.334.354-.599.925-.808 1.732-.132.511-.671 1.253-.896 1.476-.358.231-.591.62-.62 1.054l-.072 1.073c-.023.347.087.689.307.957.645.784 1.912 1.457 3.986 2.115l.23.073c1.507.477 3.214 1.018 3.906 2.56.455 1.015.492 1.807.442 2.236z"/></svg>`
const windowsClusterIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M33 18.833v14.019l-2.684-.371 2.379 1.338L34 34V17.817l-9.741.158c.537.281 1.043.609 1.52.975L33 18.833zM34 16.183V0L15.441 2.673l.297 13.659L34 16.183zM33 1.154v14.037l-16.284.132-.256-11.787L33 1.154zM13.808 2.969L0 4.751v11.581h13.808V2.969zm-1 12.363H1V5.63l11.808-1.524v11.226zM1 28.24v-9.561l11.808.127v.359c.317-.261.654-.496 1-.719v-.63L0 17.668V29.1l9.545 1.437a10.41 10.41 0 01-.294-1.055L1 28.24zM39.739 39.042l-2.827-1.59-8.453-4.755a.513.513 0 00-.744.584.507.507 0 00.242.308l8.955 5.038 2.325 1.308a.513.513 0 00.502-.893z"/><path d="M28.691 27.227c0-5.103-4.151-9.254-9.253-9.254s-9.253 4.151-9.253 9.254c0 5.102 4.151 9.253 9.253 9.253s9.253-4.151 9.253-9.253zm-9.253 8.229c-4.538 0-8.229-3.691-8.229-8.229 0-4.538 3.692-8.23 8.229-8.23 4.537 0 8.229 3.692 8.229 8.23 0 4.537-3.692 8.229-8.229 8.229z"/><path d="M14.493 22.282h3.955v3.953h-3.955zM14.493 28.217h3.955v3.953h-3.955zM20.426 22.282h3.955v3.953h-3.955zM20.426 28.217h3.955v3.953h-3.955z"/></svg>`
const entityIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M10.024 1.657a.514.514 0 01.457-.514h23.657a.514.514 0 01.457.514V19h1.143V1.657A1.657 1.657 0 0034.138 0H10.481a1.657 1.657 0 00-1.6 1.657V19h1.143V1.657z"/><path d="M11.91 4.143h21.143v1.143H11.91zM11.91 7.743h21.143v1.143H11.91zM12.022 34.059h21.143v1.143H12.022zM12.022 30.459h21.143v1.143H12.022zM11.91 11.286h21.143v1.143H11.91z"/><path d="M34.595 38.343a.514.514 0 01-.457.514H10.481a.514.514 0 01-.457-.514V28H8.881v10.343a1.657 1.657 0 001.6 1.657h23.657a1.657 1.657 0 001.6-1.657V28h-1.143v10.343zM11.91 14.829h21.143v1.143H11.91zM5.98 23.17c-.003-.008-.01-.013-.013-.021a.608.608 0 00-.12-.184l-1.013-1.014-3.007-3.01a.64.64 0 00-.513-.263.626.626 0 00-.373 1.125l3.584 3.601L.96 26.969c-.278.242-.311.635-.081.899a.616.616 0 00.428.213.57.57 0 00.454-.151.553.553 0 00.068-.069l4.021-4.022a.614.614 0 00.175-.435l-.003-.018a.638.638 0 00-.042-.216zM39.062 24.264l-3.831-4.08a.51.51 0 00-.306-.118.497.497 0 00-.418.172l-3.36 3.556-3.372-3.557a.529.529 0 00-.738-.038l-.043.044-3.377 3.594-3.374-3.591a.532.532 0 00-.368-.179.516.516 0 00-.417.171l-3.371 3.568-3.362-3.559a.53.53 0 00-.747-.04l-.028.026-3.78 4.014a.672.672 0 00-.001.904c.099.107.229.17.369.176a.503.503 0 00.377-.137l.041-.041 3.37-3.587 3.34 3.568a.584.584 0 00.412.192.542.542 0 00.399-.153l.069-.102 3.3-3.506 3.373 3.59a.55.55 0 00.794-.001l3.372-3.589.092.098 3.273 3.514c.221.207.57.205.789-.008l.019-.038c.017-.027.029-.049.044-.069l3.305-3.496 3.373 3.59a.529.529 0 00.745.039l.037-.039a.666.666 0 000-.888z"/></svg>`
const cloudAppIcon=`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M35.901 15.078a6.165 6.165 0 00-6.13-6.74c-.691 0-1.366.115-2.016.343a8.96 8.96 0 00-15.911.175 5.537 5.537 0 00-.572-.03 5.836 5.836 0 00-5.826 6.001A5.834 5.834 0 000 20.641a5.836 5.836 0 005.829 5.829h13.408v5.86c0 .483.391.874.874.874H22v1.995c0 .483.391.874.874.874h13.253a.874.874 0 00.874-.874v-9.465a5.83 5.83 0 003-5.092 5.866 5.866 0 00-4.1-5.564zM21.153 32.204a.916.916 0 01-.916-.916V20.12c0-.506.41-.916.916-.916h11.168c.506 0 .916.41.916.916v11.168c0 .506-.41.916-.916.916H21.153zM36 34.157c0 .506-.41.916-.916.916H23.916a.916.916 0 01-.916-.916v-.953h10.363a.874.874 0 00.874-.874V22.072h.847c.506 0 .916.41.916.916v11.169zm1-10.026v-2.185a.874.874 0 00-.874-.874h-1.89v-1.995a.874.874 0 00-.874-.874H20.11a.874.874 0 00-.874.874v6.078H5.829a4.52 4.52 0 01-4.515-4.515 4.52 4.52 0 014.515-4.514c.083 0 .165.007.246.013l.051.004a.658.658 0 00.695-.76 4.568 4.568 0 01-.065-.73 4.52 4.52 0 014.515-4.515c.271 0 .546.027.839.082a.658.658 0 00.724-.383 7.646 7.646 0 0114-.049.659.659 0 00.88.328 4.788 4.788 0 012.057-.464A4.85 4.85 0 0134.51 15.5a.656.656 0 00.566.788c.149.018.3.035.457.051a4.542 4.542 0 013.153 4.302c0 1.414-.666 2.662-1.686 3.49z"/><path d="M27.65 26.713h4v3.998h-4zM27.65 20.71h4v3.998h-4zM21.65 20.71h4v3.998h-4zM21.65 26.713h4v3.998h-4z"/></svg>`
const distributedDatabaseIcon =`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M39.556 15.923h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44v-7.118a.442.442 0 00-.444-.44zm-.444 7.118H32.82v-6.238h6.292v6.238zM29.652 9.012c.287 0 .52-.231.52-.515a.518.518 0 00-.52-.515h-4.157a.518.518 0 00-.52.515v10.93h-3.894v1.03h3.894v10.93c0 .284.233.515.52.515h4.157c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-3.638V20.457h3.638c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-3.638V9.012h3.638zM39.556 4.001h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44V4.441a.442.442 0 00-.444-.44zm-.444 7.118H32.82V4.881h6.292v6.238zM39.556 28.001h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44v-7.118a.442.442 0 00-.444-.44zm-.444 7.118H32.82v-6.238h6.292v6.238zM20 25.056v-17.1c0-.014 0-.027-.007-.041v-.068c0-3.876-8.328-4.072-9.997-4.072C8.328 3.775 0 3.972 0 7.848c0 .041.007.075.007.109v.027s-.007 5.993 0 12c0 3.489.007 6.271.021 8.274.014 2.423.021 3.38.062 3.801H.082c0 2.871 5.705 4.167 9.756 4.167 4.065 0 10.1-1.324 10.161-4.174v-6.976l.001-.02zM1.159 17.864c1.243.506 4.646 1.705 8.996 1.705 2.64 0 5.627-.451 8.685-1.756v6.914c-8.927 4.096-17.577.088-17.665.048l-.007-.002c-.006-2.09-.008-4.47-.009-6.909zm17.681-1.302c-8.898 4.056-17.516.133-17.681.057 0-2.253 0-4.523.002-6.633 2.348 1.812 7.552 1.928 8.836 1.928 1.284 0 6.495-.115 8.843-1.928v6.576zM5.039 5.377c2.191-.441 4.511-.461 4.951-.461.446 0 2.767.02 4.957.462 1.771.36 3.886 1.072 3.886 2.464 0 1.391-2.115 2.111-3.886 2.464-2.19.441-4.511.462-4.957.462-.446 0-2.767-.02-4.95-.462-1.771-.36-3.886-1.072-3.886-2.464.006-1.386 2.114-2.105 3.885-2.465zm4.793 29.701c-4.058 0-8.596-1.29-8.596-3.02 0-.041-.007-.075-.014-.115-.026-.366-.042-2.684-.052-5.916 1.248.512 4.648 1.722 8.991 1.722 2.63 0 5.614-.456 8.678-1.768v6.058c-.041 1.681-4.957 3.039-9.007 3.039z"/></svg>`
const edgeDriveIcon =`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M39.647 23.301l.012-.005-7.183-14.995C31.806 6.903 30.313 6 28.673 6H11.327c-1.64 0-3.133.903-3.803 2.301L.341 23.296l.012.005A2.906 2.906 0 000 24.667v6.222C0 32.605 1.495 34 3.333 34h33.333C38.505 34 40 32.605 40 30.889v-6.222c0-.493-.134-.952-.353-1.366zM9.045 8.936c.402-.839 1.298-1.381 2.282-1.381h17.345c.984 0 1.88.542 2.282 1.381l6.061 12.652c-.116-.011-.229-.033-.349-.033H3.333c-.119 0-.232.021-.349.033L9.045 8.936zm29.288 21.953c0 .857-.748 1.556-1.667 1.556H3.333c-.919 0-1.667-.698-1.667-1.556v-6.222c0-.857.748-1.555 1.667-1.555h33.333c.919 0 1.667.698 1.667 1.555v6.222z"/><path d="M34.151 26.444c-.921 0-1.667.697-1.667 1.556s.746 1.556 1.667 1.556 1.667-.697 1.667-1.556-.746-1.556-1.667-1.556zM29 26.444c-.921 0-1.667.697-1.667 1.556s.746 1.556 1.667 1.556 1.667-.697 1.667-1.556-.746-1.556-1.667-1.556zM4.182 27.429h21.143v1.143H4.182z"/></svg>`
const distributedFsIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M29.652 9.012c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-4.157a.518.518 0 00-.52.515v10.93H23.61v1.03h1.365v10.93c0 .284.233.515.52.515h4.157c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-3.638V20.457h3.638c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-3.638V9.012h3.638zM39.556 15.923h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44v-7.118a.442.442 0 00-.444-.44zm-.444 7.118H32.82v-6.238h6.292v6.238zM39.556 4.001h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44V4.441a.442.442 0 00-.444-.44zm-.444 7.118H32.82V4.881h6.292v6.238zM39.556 28.001h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44v-7.118a.442.442 0 00-.444-.44zm-.444 7.118H32.82v-6.238h6.292v6.238zM1.014 21.357v-9.288h7.654v1.839c0 .469.362.85.807.85h10.339c.28 0 .507-.24.507-.534a.522.522 0 00-.507-.534H9.683v-1.84c0-.469-.362-.85-.807-.85H.807c-.351 0-.642.241-.753.571A.738.738 0 000 11.85v9.506c0 .056.011.109.03.157.065.217.25.378.477.378.28 0 .507-.24.507-.534z"/><path d="M22.218 17.548H4.971c-.471 0-.944.352-1.102.819L.646 27.911a.857.857 0 00.079.756.765.765 0 00.651.333h17.248c.47 0 .944-.352 1.102-.819l3.223-9.545a.857.857 0 00-.081-.756.764.764 0 00-.65-.332zm-.375 1l-3.104 9.193c-.046.138-.228.273-.367.273H1.747A.074.074 0 011.751 28l3.104-9.193c.047-.138.229-.273.368-.273h16.625l-.005.014z"/></svg>`
const objectStorageIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 50 50"><path d="M44.952 22l.017-.517c0-4.354-3.542-7.895-7.895-7.895-.802 0-1.592.122-2.354.363-2-3.594-5.78-5.813-9.9-5.813-4.255 0-8.084 2.32-10.053 6.074-4.326-.334-8 3.132-8.028 7.417C2.926 22 0 25.206 0 29.066a7.5 7.5 0 0 0 7.487 7.488h9.153a1.1 1.1 0 0 0 1.097-1.098 1.1 1.1 0 0 0-1.097-1.097H7.487a5.3 5.3 0 0 1-5.293-5.294 5.3 5.3 0 0 1 5.293-5.292c.083 0 .165.006.267.013l.092.006a1.08 1.08 0 0 0 .88-.357 1.09 1.09 0 0 0 .271-.914 5.38 5.38 0 0 1-.076-.855 5.3 5.3 0 0 1 5.293-5.293 5.17 5.17 0 0 1 .986.096 1.1 1.1 0 0 0 1.206-.641c1.457-3.346 4.755-5.5 8.402-5.5a9.18 9.18 0 0 1 8.376 5.45 1.1 1.1 0 0 0 .62.583 1.11 1.11 0 0 0 .851-.035 5.64 5.64 0 0 1 2.419-.546 5.71 5.71 0 0 1 5.577 6.885 1.1 1.1 0 0 0 .949 1.315l.5.048a5.34 5.34 0 0 1 3.705 5.047 5.3 5.3 0 0 1-5.294 5.294h-9.108a1.1 1.1 0 0 0-1.098 1.097 1.1 1.1 0 0 0 1.098 1.098h9.108a7.5 7.5 0 0 0 7.488-7.488c.001-3.18-2.064-6.05-5.047-7.077zm-16.36 20.044h-7.166c-.42 0-.762-.342-.762-.762v-7.166c0-.42.342-.762.762-.762h7.166c.42 0 .762.342.762.762v7.166a.76.76 0 0 1-.762.762zM22.5 40.188h5v-5h-5v5zm8.986-9.508a4.71 4.71 0 0 1-4.704-4.704 4.71 4.71 0 0 1 4.704-4.704 4.71 4.71 0 0 1 4.704 4.704 4.71 4.71 0 0 1-4.704 4.704zm0-7.703c-1.654 0-3 1.346-3 3s1.346 3 3 3 3-1.346 3-3-1.346-3-3-3zM18.563 31.07a.76.76 0 0 1-.66-.381l-4.6-7.986c-.136-.236-.136-.527 0-.762a.76.76 0 0 1 .66-.381h9.22a.76.76 0 0 1 .66.381c.136.236.136.526 0 .762l-4.6 7.986c-.136.235-.388.38-.66.38zm-3-7.735l3 5.196 3-5.196h-6z"/></svg>`;
const O365MailboxIcon = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" xml:space="preserve"><g><g transform="translate(0.000000,641.000000) scale(0.100000,-0.100000)"><path d="M3459.4,5900.3C2152.8,5646.4,861.7,5395.6,590.8,5343L100,5248.6V1457.2c0-3594.7,1.6-3789.8,27.9-3797.6c13.9-4.6,1294.2-274,2843.9-597.6C4521.5-3263,5804.9-3532.4,5825-3537l34.1-7.7v4955.5c0,2726.3-4.6,4954-10.8,4954C5840.4,6363.2,4766.1,6154.2,3459.4,5900.3z M3217.9,3130.7c243.1-35.6,431.9-130,614.6-309.6c288-281.8,435-642.5,478.4-1171.9c41.8-521.7-65-1024.8-292.6-1376.3c-181.1-280.2-387-442.8-682.7-534.1c-99.1-31-148.6-37.2-332.8-37.2c-246.1,0-359.2,26.3-557.3,128.5c-150.2,77.4-391.7,320.5-486.1,489.2c-88.2,154.8-164.1,357.6-207.5,548c-44.9,205.9-49.5,786.5-6.2,1001.6c106.8,537.2,357.6,930.4,723,1134.8C2677.6,3119.9,2957.8,3167.9,3217.9,3130.7z"/><path d="M2866.5,2474.3c-216.7-60.4-387-275.6-478.4-605.3c-31-109.9-34.1-159.5-34.1-456.7c0-295.7,3.1-346.8,34.1-456.7c74.3-269.4,213.6-470.6,385.5-557.3c80.5-41.8,105.3-46.4,236.9-46.4c136.2,0,156.4,4.6,250.8,51.1c204.4,100.6,337.5,318.9,401,653.3c32.5,167.2,24.8,599.1-13.9,780.3c-61.9,294.1-207.5,521.7-387,606.9C3157.6,2492.9,2979.5,2506.8,2866.5,2474.3z"/><path d="M6230.6,3290.2l1.5-972.2l335.9-209c198.2-123.9,351.4-209,374.7-209c26.3,0,532.6,332.8,1497,983.1l1459.9,983.1l-10.8,54.2c-21.7,123.8-119.2,257-227.6,308.1c-65,32.5-78.9,32.5-1747.8,32.5H6230.6V3290.2z"/><path d="M8432,2109c-1164.2-772.5-1455.3-959.8-1495.5-959.8c-34,0-83.6,23.2-157.9,74.3c-58.8,40.3-205.9,140.9-326.7,224.5l-221.4,151.7V283.7v-1317.5h1607c1836.1,0,1737-6.2,1894.9,136.3c78.9,71.2,130,174.9,151.7,298.8c18.6,116.1,21.7,3667.5,4.6,3667.5C9881.1,3068.8,9226.2,2636.9,8432,2109z"/></g></g></svg>`;
const O365SharePointIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 50 50"><path d="M43.9,18.3c-1.6-3-3.9-5.4-6.9-6.9c-0.4-3.4-3.2-6.1-6.9-6.1c-0.4,0-0.8,0-1.3,0.1V0.1L0,5.1v39.2l28.9,5.1v-4.9        c0.4,0.1,0.8,0.1,1.3,0.1c3.5,0,6.5-2.6,6.9-6.1c3-1.4,5.4-3.9,6.9-6.9c3.4-0.4,6.1-3.2,6.1-6.7C50,21.6,47.4,18.7,43.9,18.3z         M28.9,18.8c0.4,0.1,0.8,0.1,1.3,0.1c1.8,0,3.4-0.6,4.7-1.8c1.3,0.8,2.5,1.9,3.2,3.2c-1.2,1.3-1.8,2.8-1.8,4.7        c0,1.7,0.6,3.4,1.8,4.7c-0.8,1.3-1.9,2.5-3.2,3.2c-1.3-1.2-2.8-1.8-4.7-1.8c-0.4,0-0.8,0-1.3,0.1V18.8z M18.8,30.5        c-1.3,3.6-6.2,3.9-9.2,2.3c-0.5-0.3-0.6-0.3-0.6-0.8s0-0.9,0-1.4c0-0.8,0-1.4,0-2.2c0.9,1,1.9,1.7,3.2,1.9c0.9,0.3,2.2,0.1,2.7-0.9        c1.3-2.3-2.3-3.5-3.6-4.5c-1.9-1.6-2.8-3.9-2.2-6.3c0.6-2.3,2.8-3.6,5.3-3.8c1.2-0.1,2.3,0,3.5,0.4c0.3,0.1,0.4,0.1,0.4,0.4        c0,0.3,0,0.5,0,0.8c0,1,0,2.1,0,3c-1.3-1-3.9-1.8-5.3-0.6c-0.6,0.5-0.8,1.4-0.5,2.1c0.3,0.8,1,1.2,1.7,1.6c1.4,0.9,3,1.6,3.9,3        C19.3,26.9,19.4,29,18.8,30.5z M43.1,30.1c-0.1,0-0.3,0-0.4,0c-1.4,3.4-4,6.1-7.4,7.4c0,0.1,0,0.3,0,0.4c0,2.8-2.3,5.2-5.2,5.2        c-0.4,0-0.8,0-1.3-0.1V33c0.4-0.1,0.8-0.1,1.3-0.1c1.8,0,3.4,0.9,4.3,2.2c2.6-1.2,4.7-3.1,5.7-5.7c-1.4-0.9-2.2-2.5-2.2-4.1        c0-1.8,0.9-3.2,2.2-4.1c-1.2-2.6-3.1-4.7-5.7-5.7c-0.9,1.4-2.5,2.2-4.3,2.2c-0.4,0-0.8,0-1.3-0.1v-10c0.4-0.1,0.8-0.1,1.3-0.1        c2.8,0,5.2,2.3,5.2,5.2c0,0.1,0,0.3,0,0.4c3.4,1.4,6.1,4,7.4,7.4c0.1,0,0.3,0,0.4,0c2.8,0,5.2,2.3,5.2,5.2        C48.3,27.8,46,30.1,43.1,30.1z"/></svg>`;
const O365OneDriveIcon = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" xml:space="preserve"><g><path d="M325,517c23.9-96.1,110.2-166.3,212.7-166.3c60.6,0,117.3,24.7,158.4,67.7c17.3-5.6,37.6-9.9,55.7-10.3v-6.4c0-121.6-90.4-220.3-201.9-220.3c-79.7,0-148,50.9-180.8,124c-24.2-16.4-52.5-26.2-83-26.2c-87.5,0-158.3,77.3-158.3,172.6c0,10.3,1.2,20.3,2.8,30c-67.5,6.7-120.3,75.7-120.3,150.9c0,0.8,0.2,1.4,0.2,2.2c0,0.7-0.4,1.4-0.4,2.1c0,30.1,10.5,57.7,27.5,79.9c24.1,32.4,61.8,52.4,104.9,52.4h61.8c-12.1-23.9-19.5-50.6-19.5-79.1C184.6,605.3,244.9,534,325,517z M886.6,611.6c-1.2,0-2.5,0.3-3.7,0.4c0.3-3.6,1.1-7.2,1.1-10.9c0-72.1-58.5-130.5-130.6-130.5c-28.7,0-55,9.5-76.6,25.3c-26.8-49.7-78.6-83.9-139.1-83.9c-87.6,0-158.6,71-158.6,158.6c0,1.1,0.3,2.1,0.3,3.2c-5.8-0.9-11.6-1.8-17.6-1.8c-65.4,0-118.3,53-118.3,118.3c0,8.2,0.8,16.2,2.4,23.9c11.2,59.3,63.1,104.3,125.7,104.3h524.6v-0.9c52.5-5,93.8-48.7,93.8-102.5C990,657.9,943.7,611.6,886.6,611.6z"/></g></svg>`;
const distributedIdaIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M29.652 9.012c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-4.157a.518.518 0 00-.52.515v10.93h-3.894v1.03h3.894v10.93c0 .284.233.515.52.515h4.157c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-3.638V20.457h3.638c.287 0 .52-.231.52-.515s-.233-.515-.52-.515h-3.638V9.012h3.638zM39.556 15.923h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44v-7.118a.442.442 0 00-.444-.44zm-.444 7.118H32.82v-6.238h6.292v6.238zM39.556 4.001h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44V4.441a.442.442 0 00-.444-.44zm-.444 7.118H32.82V4.881h6.292v6.238zM39.556 28.001h-7.18a.442.442 0 00-.444.44v7.118c0 .243.199.44.444.44h7.18a.442.442 0 00.444-.44v-7.118a.442.442 0 00-.444-.44zm-.444 7.118H32.82v-6.238h6.292v6.238zM18.809 5.106H1.191A1.235 1.235 0 000 6.34v27.32c0 .665.527 1.211 1.191 1.234h17.617A1.235 1.235 0 0020 33.66V6.34c0-.665-.527-1.211-1.191-1.234zm0 28.937H1.191a.382.382 0 01-.34-.383V6.34a.384.384 0 01.34-.383h17.617a.382.382 0 01.34.383v27.32h.001a.384.384 0 01-.34.383z"/><path d="M2.255 16.362H18v.851H2.255zM2.255 13.723H18v.851H2.255zM10.17 26.17a1.702 1.702 0 100 3.404 1.702 1.702 0 000-3.404zM2.255 11.085H18v.851H2.255zM2.255 8.404H18v.851H2.255z"/></svg>`
const hypervisorIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M34.323 2.857H19.047c.067.36.017.725-.142 1.061h15.418a.476.476 0 01.424.478v34.065a.479.479 0 01-.424.478H12.356a.476.476 0 01-.424-.478V17H10.87v21.461c0 .83.657 1.51 1.486 1.539h21.967a1.54 1.54 0 001.486-1.539V4.396c0-.83-.657-1.51-1.486-1.539z"/><path d="M21.429 31.245a2.122 2.122 0 104.244 0 2.122 2.122 0 00-4.244 0zM19 11.047h14.315v1.061H19zM13.682 17.627h19.633v1.061H13.682zM20.333 14.337L18 14.346v1.052h15.315v-1.061zM20 7.704h13.315v1.061H20zM12.669 15.956a.556.556 0 00.34-.513v-1.359a6.256 6.256 0 001.172-.486l.961.961a.554.554 0 00.788 0l1.805-1.805a.553.553 0 00.122-.603.553.553 0 00-.122-.184l-.961-.961c.201-.374.364-.766.486-1.173h1.359a.557.557 0 00.557-.557V6.724a.555.555 0 00-.557-.557H17.26a6.293 6.293 0 00-.486-1.173l.961-.961a.553.553 0 00.122-.603.553.553 0 00-.122-.184L15.93 1.441a.553.553 0 00-.184-.122c-.034-.014-.071-.014-.107-.021-.034-.007-.068-.02-.102-.02a.556.556 0 00-.394.163l-.961.961a6.312 6.312 0 00-1.172-.486V.557A.557.557 0 0012.453 0H9.899a.557.557 0 00-.557.557v1.359a6.217 6.217 0 00-1.172.486l-.961-.961a.567.567 0 00-.185-.122c-.034-.014-.071-.014-.107-.021-.034-.007-.068-.02-.102-.02a.556.556 0 00-.394.163L4.616 3.246a.553.553 0 000 .787l.961.961a6.35 6.35 0 00-.486 1.173H3.733a.555.555 0 00-.557.557v2.553c0 .308.25.557.557.557h1.358c.122.406.285.799.486 1.173l-.961.961a.56.56 0 000 .788l1.805 1.805a.554.554 0 00.788 0l.961-.961c.374.201.766.364 1.173.486v1.359a.555.555 0 00.556.555h2.553c.077 0 .15-.015.217-.044zm-.707-2.238a.575.575 0 00-.034.195V15.2h-1.505v-1.287a.586.586 0 00-.455-.568 5.45 5.45 0 01-1.719-.713.571.571 0 00-.262-.076c-.031-.002-.062-.008-.093-.006-.018.001-.035.007-.053.011a.57.57 0 00-.315.152l-.91.91-1.064-1.064.911-.91a.582.582 0 00.08-.724 5.437 5.437 0 01-.713-1.719.578.578 0 00-.568-.454H3.976V7.248h1.287a.575.575 0 00.363-.128c.1-.08.174-.194.204-.327.137-.61.377-1.188.713-1.719a.582.582 0 00-.08-.723l-.911-.91 1.064-1.064.911.91c.088.088.2.132.316.152.017.003.034.009.052.011.031.002.062-.004.093-.006a.567.567 0 00.261-.076 5.46 5.46 0 011.719-.713.582.582 0 00.454-.568V.8h1.505v1.287c0 .068.012.134.034.195a.574.574 0 00.328.325c.033.014.058.04.093.048a5.42 5.42 0 011.718.712.572.572 0 00.354.082c.018-.001.035-.007.053-.01a.572.572 0 00.316-.152l.23-.23.68-.68 1.064 1.064-.91.91a.581.581 0 00-.08.723c.335.53.575 1.108.712 1.719.06.266.296.455.568.455h1.287v1.504h-1.287a.583.583 0 00-.568.455 5.425 5.425 0 01-.712 1.719.581.581 0 00.08.723l.911.911-1.064 1.064-.911-.911a.57.57 0 00-.316-.151c-.018-.003-.035-.009-.053-.01a.577.577 0 00-.355.082 5.464 5.464 0 01-1.718.712.578.578 0 00-.419.372z"/><path d="M13.885 7.984a2.68 2.68 0 00-.412-1.419 2.702 2.702 0 00-2.297-1.29 2.712 2.712 0 00-2.709 2.709c0 .708.279 1.348.725 1.831.489.53 1.181.868 1.956.876.01 0 .018.003.028.003.394 0 .766-.089 1.104-.241a2.71 2.71 0 001.605-2.469zm-2.71 1.785c-.48 0-.914-.192-1.235-.501a1.776 1.776 0 01-.55-1.284c0-.975.786-1.767 1.757-1.782.01 0 .018-.003.028-.003.419 0 .799.151 1.104.393.18.143.33.318.444.519.147.259.238.554.238.873 0 .984-.801 1.785-1.786 1.785z"/></svg>`
const storagePoolCloudIcon = `<svg class="add-new-placeholder" xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 24 24"><path d="M22,9a4,4,0,0,0-.11-.5,3.54,3.54,0,0,0-.62-1.22l-.19-.22-.2-.21A3.55,3.55,0,0,0,17.51,6a3.66,3.66,0,0,0-1.37.71,4,4,0,0,0-.44.41l-.25,0a4.9,4.9,0,0,0-3.51-1.5h-.09A5.09,5.09,0,0,0,7.92,7.52,4,4,0,0,0,6,7H6a3.88,3.88,0,0,0-3.83,3.38A4,4,0,0,0,3.95,18H15.13a4,4,0,0,0,3.4-2h1.82A3.72,3.72,0,0,0,24,12.28,3.71,3.71,0,0,0,22,9Zm-4.15,6a3,3,0,0,1-2.77,2H4a3,3,0,0,1-3-3,3,3,0,0,1,1.9-2.81.38.38,0,0,0,.21-.34A2.86,2.86,0,0,1,6,8H6a3,3,0,0,1,1.85.64.35.35,0,0,0,.22.08h.06a.35.35,0,0,0,.24-.16,4,4,0,0,1,3.46-1.94h.1a3.93,3.93,0,0,1,3.93,3.85c0,.11,0,.21,0,.31a.33.33,0,0,0,.23.34A3,3,0,0,1,17.89,15Zm4.55-1.08A2.68,2.68,0,0,1,20.34,15H18.92a4,4,0,0,0-2.06-4.61s0-.07,0-.1A4.9,4.9,0,0,0,16.13,8a.32.32,0,0,0,.18-.1,2.88,2.88,0,0,1,1.46-1h0a2.54,2.54,0,0,1,.69-.1,2.58,2.58,0,0,1,1.78.72l.13.14.14.17a2.69,2.69,0,0,1,.55,1.55.33.33,0,0,0,.21.31A2.73,2.73,0,0,1,23,12.29,2.67,2.67,0,0,1,22.44,13.93Z"></path></svg>`
const hyperscaleIcon = `<svg class="add-new-placeholder" xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 25 25"><path d="M2,16v2.5A3.6,3.6,0,0,0,3.2,21c1.7,1.8,5.3,3,9.3,3s7.6-1.2,9.3-3A3.6,3.6,0,0,0,23,18.5V16c-2,2.1-5.9,3.5-10.5,3.5S4,18.1,2,16Z"></path><ellipse cx="12.5" cy="6.5" rx="10.5" ry="5.5"></ellipse><path d="M12.5,13.5C7.9,13.5,4,12.1,2,10v2.5c0,3,4.7,5.5,10.5,5.5S23,15.5,23,12.5V10C21,12.1,17.1,13.5,12.5,13.5Z"></path></svg>`
const gSuiteIcon =`<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="200" height="120" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 512 127"><path d="M94.106 35.928c-3.982-4.069-8.31-7.185-12.9-9.35-4.588-2.164-10.388-3.203-17.054-3.203-5.368 0-10.476.952-15.238 2.857-4.761 1.905-8.917 4.588-12.466 8.051-3.636 3.463-6.493 7.706-8.571 12.64-2.078 4.935-3.117 10.39-3.117 16.45 0 6.06 1.04 11.514 3.117 16.448 2.078 4.935 4.935 9.09 8.57 12.554a39.604 39.604 0 0 0 12.64 8.138c4.762 1.904 9.957 2.857 15.41 2.857 5.801 0 10.91-.78 15.238-2.424 4.329-1.645 8.051-3.896 11.168-6.667 2.078-1.904 3.982-4.242 5.627-7.012 1.645-2.857 2.944-5.974 3.896-9.437h-36.62V57.052h59.735c.347 1.386.606 3.03.866 5.108s.346 3.983.346 5.974c0 8.224-1.212 15.67-3.636 22.51-2.424 6.839-6.146 12.812-10.995 18.093-5.454 5.8-11.947 10.216-19.565 13.42-7.619 3.202-16.363 4.76-26.146 4.76-8.83 0-17.141-1.558-24.933-4.76-7.792-3.204-14.631-7.62-20.518-13.247-5.8-5.627-10.39-12.293-13.852-19.998C1.645 81.207 0 72.636 0 63.459s1.731-17.661 5.108-25.453c3.376-7.792 7.965-14.458 13.852-20.085 5.8-5.627 12.64-9.956 20.518-13.16C47.356 1.559 55.668 0 64.41 0c10.043 0 18.96 1.731 26.665 5.194 7.705 3.463 14.371 8.225 19.999 14.285L94.106 35.93zm153.496 55.754c0 10.649-3.896 19.22-11.687 25.713-7.878 6.32-17.488 9.523-28.83 9.523-10.042 0-18.96-2.944-26.664-8.83-7.705-5.888-12.986-13.94-15.93-24.068l14.89-6.147c1.04 3.636 2.425 6.926 4.243 9.87 1.818 2.943 3.896 5.453 6.32 7.531a29.633 29.633 0 0 0 8.051 4.935c2.944 1.212 6.06 1.818 9.35 1.818 7.1 0 12.986-1.818 17.488-5.54 4.502-3.637 6.753-8.572 6.753-14.632 0-5.108-1.905-9.436-5.627-13.072-3.463-3.463-10.043-6.926-19.653-10.216-9.696-3.463-15.756-5.887-18.18-7.1-12.9-6.579-19.306-16.189-19.306-29.002 0-8.917 3.55-16.535 10.648-22.855 7.273-6.32 16.103-9.523 26.665-9.523 9.264 0 17.315 2.337 24.068 7.099 6.753 4.675 11.341 10.475 13.592 17.488l-14.458 5.973c-1.385-4.502-4.069-8.31-8.051-11.254-3.983-3.03-8.917-4.502-14.631-4.502-6.147 0-11.255 1.731-15.41 5.108-4.156 3.116-6.234 7.272-6.234 12.293 0 4.156 1.645 7.792 4.935 10.822 3.636 3.03 11.514 6.666 23.548 10.822 12.294 4.155 21.124 9.35 26.405 15.41 5.108 6.06 7.705 13.506 7.705 22.336zm86.488 32.465H319.2v-11.514h-.693c-2.338 4.07-6.06 7.445-10.909 10.216-4.934 2.684-10.042 4.069-15.323 4.069-10.216 0-18.008-2.944-23.462-8.744-5.454-5.8-8.225-14.112-8.225-24.847v-52.29h15.584v51.251c.346 13.592 7.185 20.345 20.518 20.345 6.233 0 11.428-2.51 15.583-7.532 4.156-5.021 6.234-11.081 6.234-18.094v-45.97h15.583v83.11zM369.672 12.38c0 3.03-1.039 5.627-3.203 7.792-2.165 2.164-4.762 3.203-7.792 3.203-3.03 0-5.627-1.039-7.792-3.203-2.164-2.165-3.203-4.762-3.203-7.792 0-3.03 1.039-5.627 3.203-7.792 2.165-2.164 4.762-3.203 7.792-3.203 3.03 0 5.627 1.04 7.792 3.203 2.164 2.165 3.203 4.762 3.203 7.792zm-3.203 28.656v83.111h-15.584v-83.11h15.584zm47.875 84.497c-6.753 0-12.38-2.078-16.882-6.234-4.502-4.155-6.752-10.042-6.84-17.488v-46.49h-14.63V41.036h14.544V15.583h15.584v25.453h20.345v14.285H406.12v41.382c0 5.541 1.039 9.264 3.203 11.255 2.164 1.991 4.588 2.944 7.272 2.944 1.212 0 2.424-.174 3.636-.433 1.212-.26 2.251-.693 3.29-1.126l4.935 13.939c-3.896 1.471-8.658 2.25-14.112 2.25zm58.351 1.298c-12.207 0-22.25-4.155-30.214-12.553-7.878-8.398-11.86-18.96-11.86-31.686 0-12.64 3.808-23.202 11.514-31.6 7.705-8.397 17.488-12.64 29.521-12.64 12.294 0 22.163 3.983 29.436 11.948C508.364 58.264 512 69.433 512 83.804l-.173 1.731H446.55c.26 8.138 2.943 14.718 8.138 19.653 5.194 4.934 11.428 7.445 18.7 7.445 9.956 0 17.748-4.935 23.375-14.89l13.938 6.752c-3.722 7.013-8.917 12.467-15.496 16.45-6.667 3.895-14.199 5.886-22.51 5.886zM447.762 72.55h47.702c-.433-5.8-2.77-10.562-7.012-14.371-4.242-3.81-9.956-5.714-17.055-5.714-5.887 0-10.909 1.818-15.15 5.454-4.33 3.723-7.1 8.571-8.485 14.631z" fill="#737373"></path></svg>`
const office365Icon =`<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 50 50"><polygon points="40.1 39.6 40.1 39.6 40.1 10.5 29.6 7.5 10.9 14.5 10.9 14.5 10.9 35.6 17.3 33.1 17.3 16 29.6 13 29.6 38.1 10.9 35.6 29.6 42.5 29.6 42.5 40.1 39.6 40.1 39.6 40.1 39.6"></polygon></svg>`
const keyMangementServerIcon =`<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M20.243,11c0.004-0.512,0.008-1.124,0.008-1.75C20.251,4.701,16.55,1,12,1C7.451,1,3.75,4.701,3.75,9.25c0,0.523-0.004,1.18-0.009,1.75H3v14h18V11H20.243z M5.25,9.25C5.25,5.528,8.278,2.5,12,2.5c3.723,0,6.751,3.028,6.751,6.75c0,0.627-0.004,1.239-0.008,1.75h-1.644c0.006-0.569,0.012-1.223,0.012-1.75c0-2.817-2.293-5.108-5.111-5.108c-2.817,0-5.109,2.292-5.109,5.108c0,0.522-0.003,1.178-0.007,1.75H5.241C5.246,10.429,5.25,9.773,5.25,9.25z M15.599,11H8.384c0.003-0.572,0.007-1.228,0.007-1.75c0-1.99,1.619-3.608,3.609-3.608c1.991,0,3.611,1.619,3.611,3.608C15.61,9.777,15.605,10.433,15.599,11z M14,21h-4l1-2.5c-0.669-0.299-1-0.925-1-1.655C10,15.826,10.896,15,12.001,15S14,15.826,14,16.845c0,0.731-0.332,1.357-1,1.655L14,21z"></path></svg>`
const tapeIcon =`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"><path d="M33.073 0H6.927A2.31 2.31 0 004.62 2.307v36.924a.769.769 0 101.538 0v-.769h27.684v.769a.769.769 0 101.538 0V2.307A2.31 2.31 0 0033.073 0zm.769 33.067v3.857H6.158V32.31h27.684v.757zm0-2.307H6.158v-4.602h27.684v4.602zm0-6.247H6.158v-4.614h27.684v4.614zm0-6.152H6.158v-4.614h27.684v4.614zm0-6.057H6.158V7.69h27.684v4.614zm0-6.152H6.158V2.307c0-.425.344-.769.769-.769h26.146c.425 0 .769.344.769.769v3.845z"/><path d="M13.079 3.076h-1.538a.769.769 0 100 1.538h1.538a.769.769 0 100-1.538zM11.541 10.766h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM28.459 3.076h-1.538a.769.769 0 100 1.538h1.538a.769.769 0 100-1.538zM26.921 10.766h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM11.541 16.918h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM11.541 23.082h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM11.541 29.234h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM26.921 16.918h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM26.921 23.082h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM26.921 29.234h1.538a.769.769 0 00.769-.769l-.001-.006.001-.006a.769.769 0 00-.769-.769h-1.538a.769.769 0 00-.769.769l.001.006-.001.006c0 .425.344.769.769.769zM11.541 35.386h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538zM26.921 35.386h1.538a.769.769 0 100-1.538h-1.538a.769.769 0 100 1.538z"/></svg>`
const reportIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M10,17.88H7.59v-6H10ZM16.72,4.52,18.6,2.07A11.82,11.82,0,0,0,13.79.43V3.51A8.72,8.72,0,0,1,16.72,4.52Z"></path><path d="M13.65,17.88H11.24V9.66h2.41Zm7.69-5.48a9.16,9.16,0,0,1-.19,1.88l2.79,1.54a12.05,12.05,0,0,0-3.85-12.7L18.21,5.58A8.91,8.91,0,0,1,21.34,12.4Z"></path><path d="M17.35,17.88H14.94V7.11h2.41Zm-5,3.47A8.95,8.95,0,0,1,12,3.46V.38a12,12,0,1,0,11.3,17.17L20.57,16A9,9,0,0,1,12.4,21.35Z"></path></svg>`
const rolesIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M15,13.6H14.8a6.1,6.1,0,0,1-2.5-1.3V11.5a3.8,3.8,0,0,0,1.1-1.7,1.7,1.7,0,0,1,.4-0.9,1.6,1.6,0,0,0,.2-2V4.5h0A3.7,3.7,0,0,0,10,1,3.7,3.7,0,0,0,6.1,4.4h0V6.8a1.6,1.6,0,0,0,.2,2,1.7,1.7,0,0,1,.4.9,3.8,3.8,0,0,0,1.1,1.7,5.3,5.3,0,0,1,0,.6c-0.3.6-1.4,1.1-2.6,1.5s-3,.9-3.8,2.6S1.1,18.9,1.2,19a19.6,19.6,0,0,0,5.4.9h5.5l2.9-.2V13.6Z"></path><path d="M21,16H20V12H16V24h8V16H21Zm2,6H17V21h6v1Zm0-2H17V19h6v1Zm0-2H17V17h6v1Z"></path><polygon points="21 12 21 15 24 15 21 12"></polygon><polygon points="21 12 21 15 24 15 21 12"></polygon></svg>`
const salesforceIcon =`<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 59.1 40" style="enable-background:new 0 0 59.1 40;" xml:space="preserve">
<path d="M58.9,16.2C57.7,8,49.6,3,41.6,5.5c-0.5,0.2-0.9,0-1.2-0.4c-0.1-0.1-0.1-0.2-0.2-0.2C36.7,0.7,30.3,0,26,3.3
	c-0.8,0.6-0.8,0.6-1.7-0.1c-2.7-2.6-6.6-3.7-10.4-3c-0.1,0-0.2,0-0.4,0C7,1.5,2.7,7.8,4.1,14.1c0.1,0.4,0,0.7-0.2,0.9
	C1.4,17,0,19.9,0,23c0,5.9,4.8,10.7,11,10.7c0.1,0,0.4,0,0.5,0c0.8-0.2,1.2,0.1,1.5,0.8c2,3.5,5.2,5.4,9.2,5.4s7.1-1.7,9.3-4.8
	c0.1-0.2,0.2-0.6,0.7-0.5c4,0.8,7.4-0.2,10.2-3.3c0.2-0.2,0.5-0.4,0.8-0.2c1.5,0.2,3.1,0.2,4.5,0C54.9,30,60,23.1,58.9,16.2z
	 M10.3,21.2c-0.2,0-0.5,0-0.7,0c-0.6,0-1.2-0.1-1.7-0.4c-0.4-0.1-0.4-0.4-0.2-0.7c0.2-0.5,0.4-0.2,0.6,0c0.5,0.2,1.1,0.4,1.7,0.2
	c0.2,0,0.6-0.2,0.6-0.5c0-0.4-0.2-0.5-0.5-0.6c-0.5-0.1-0.9-0.2-1.3-0.5c-0.6-0.1-0.9-0.7-0.9-1.3s0.5-1.2,1.2-1.3
	c0.7-0.2,1.5-0.1,2.2,0.2c0.2,0.1,0.4,0.2,0.2,0.5c-0.1,0.2-0.2,0.5-0.6,0.2C10.4,17,9.9,17,9.4,17c-0.2,0-0.5,0.1-0.6,0.5
	c0,0.4,0.1,0.5,0.4,0.6c0.5,0.1,0.8,0.2,1.3,0.5c0.8,0.2,1.2,0.7,1.2,1.4C11.6,20.5,11.1,21.1,10.3,21.2z M17,19.3v0.2
	c0,1.5,0,1.5-1.5,1.7c-0.6,0.1-1.2,0-1.8-0.1s-1.1-0.7-1.1-1.3c-0.1-0.6,0.2-1.2,0.8-1.4c0.6-0.2,1.2-0.4,1.9-0.4
	c0.2,0,0.5,0.2,0.6-0.1c0-0.4-0.1-0.6-0.5-0.7c-0.6-0.2-1.3-0.1-1.9,0c-0.2,0.1-0.5,0.2-0.6-0.1c-0.1-0.4-0.1-0.5,0.2-0.6
	c0.8-0.2,1.7-0.4,2.5-0.1c0.7,0.1,1.3,0.7,1.2,1.4C17,18.3,17,18.7,17,19.3z M19.1,20.6c0,0.5-0.2,0.5-0.6,0.5s-0.6-0.1-0.6-0.5
	c0.1-1.1,0-2.1,0-3.2s0-2.1,0-3.2c0-0.5,0.1-0.6,0.6-0.6c0.5,0,0.5,0.1,0.5,0.5C19.1,16.3,19.1,18.5,19.1,20.6z M24.7,19
	c-0.5-0.1-0.9,0-1.4,0h-1.2c-0.7,0-0.7,0.1-0.5,0.7c0.2,0.4,0.6,0.6,1.1,0.7c0.5,0.1,0.9,0,1.4-0.1c0.5-0.1,0.5,0.2,0.6,0.5
	c0.1,0.4-0.1,0.4-0.2,0.5c-0.9,0.2-1.9,0.2-2.7,0c-0.8-0.2-1.4-1.1-1.4-1.9c0-1.1,0.1-2,1.2-2.5c0.8-0.5,1.9-0.5,2.6,0.1
	c0.7,0.5,0.8,1.2,0.8,2C25.1,18.9,25,19.1,24.7,19z M28,21.2c-0.6,0-1.2-0.1-1.7-0.4c-0.4-0.1-0.4-0.4-0.2-0.7
	c0.1-0.4,0.4-0.2,0.6-0.1c0.5,0.2,1.1,0.4,1.7,0.4c0.2,0,0.5-0.2,0.6-0.5c0-0.4-0.2-0.5-0.5-0.5C28,19.3,27.5,19.2,27,19
	c-0.6-0.1-0.9-0.7-0.9-1.3c0-0.7,0.5-1.2,1.2-1.3c0.7-0.2,1.5-0.1,2.2,0.1c0.2,0.1,0.5,0.2,0.2,0.6c-0.1,0.4-0.2,0.4-0.6,0.2
	c-0.5-0.2-0.9-0.2-1.4-0.2c-0.2,0-0.5,0.1-0.6,0.5c0,0.2,0.1,0.5,0.5,0.6c0.4,0.1,0.8,0.2,1.2,0.4c0.9,0.4,1.3,0.8,1.2,1.5
	c0,0.5-0.8,1.1-1.7,1.1C28.2,21.2,28.1,21.2,28,21.2z M33.5,17.1c-0.6-0.1-0.7,0.1-0.8,0.7c-0.2,1.4-0.5,3-0.8,4.4
	c-0.2,1.3-1.3,1.9-2.4,1.7c-0.2,0-0.5,0-0.5-0.4c0.1-0.4,0-0.6,0.5-0.6c0.9,0,1.2-0.2,1.4-1.2c0.2-1.4,0.5-3,0.7-4.5
	c-0.4-0.2-1.1,0.1-0.7-0.7c0-0.2,0.1-0.4,0.4-0.2c0.6,0.1,0.6-0.2,0.7-0.6c0.4-1.4,1.2-2,2.5-1.9c0.2,0,0.5,0,0.5,0.2
	c-0.1,0.2,0,0.7-0.5,0.6c-0.8,0-1.1,0.2-1.3,0.9c-0.1,0.5,0,0.6,0.5,0.6c0.2,0,0.7-0.2,0.6,0.4C34.1,17,34,17.1,33.5,17.1z
	 M36.8,21.2c-1.5,0-2.5-0.9-2.5-2.5c0-1.5,0.9-2.6,2.5-2.6c1.5,0,2.5,0.9,2.5,2.5C39.2,20.2,38.4,21.2,36.8,21.2z M43.2,16.5
	c0,0.2,0,0.6-0.5,0.7c-1.3,0.1-1.4,0.4-1.5,1.7c0,0.7,0,1.3,0,1.9c0,0.5-0.2,0.5-0.6,0.5c-0.4,0-0.5-0.1-0.5-0.5c0-0.7,0-1.4,0-2.1
	c0-0.6,0-1.2,0-1.9c0-0.2-0.1-0.5,0.1-0.5c0.2,0,0.7-0.2,0.8,0.1c0.1,0.2,0.2,0.2,0.4,0.1c0.4-0.2,0.8-0.4,1.3-0.2
	C43,16.3,43.3,16.2,43.2,16.5z M47.2,21.1c-0.4,0-0.6,0.1-0.9,0.1c-1.7,0-2.5-0.7-2.7-1.9c-0.2-1.4,0.4-2.5,1.5-2.8
	c0.7-0.2,1.4-0.2,2.1,0c0.2,0,0.4,0.1,0.2,0.4c-0.1,0.2,0,0.5-0.5,0.5c-0.2,0-0.6-0.1-0.8-0.1c-0.8,0-1.4,0.5-1.5,1.2
	c0,0,0,0.1,0,0.2c-0.1,1.4,0.7,2.1,2.1,1.9c0.2,0,0.5-0.2,0.6,0c0.1,0.1,0.2,0.4,0.2,0.6C47.6,21.1,47.3,21,47.2,21.1z M52.8,18.6
	c0,0.4-0.2,0.4-0.5,0.4c-0.5,0-0.9,0-1.4,0c-0.4,0-0.8,0-1.2,0c-0.6,0-0.6,0.2-0.4,0.7c0.2,0.5,0.7,0.7,1.2,0.7
	c0.5,0.1,0.9,0,1.4-0.1c0.4-0.1,0.5,0.1,0.5,0.4c0.1,0.2,0,0.5-0.2,0.5c-0.8,0.2-1.7,0.2-2.6,0c-0.9-0.2-1.5-1.1-1.5-2
	c-0.1-0.9,0.1-1.9,1.1-2.5c0.8-0.5,1.9-0.6,2.6-0.1C52.5,17,52.9,17.7,52.8,18.6z"></path>
<path d="M15.7,18.9c-0.5-0.1-1.1-0.1-1.5,0.1c-0.2,0.1-0.5,0.5-0.5,0.7c0,0.4,0.2,0.6,0.5,0.7c0.2,0,0.4,0.1,0.6,0.1l0.8-0.1
	c0.4,0,0.4-0.2,0.2-0.5C15.8,19.5,16.2,19,15.7,18.9z"></path>
<path d="M51,17.1c-0.5-0.2-1.2-0.1-1.5,0.4c-0.1,0.1-0.2,0.5-0.2,0.6c0.1,0.2,0.4,0.1,0.6,0.1s0.4,0,0.6,0c0.1,0,0.2,0,0.4,0
	c0.2,0,0.7,0.2,0.7-0.2C51.6,17.6,51.4,17.2,51,17.1z"></path>
<path d="M23.4,17.2C22.9,17,22.4,17,22,17.3c-0.2,0.2-0.5,0.5-0.4,0.7c0.1,0.2,0.5,0.1,0.7,0.1c0.1,0,0.2,0,0.5,0s0.4,0,0.5,0
	c0.2,0,0.7,0.2,0.7-0.1S23.7,17.3,23.4,17.2z"></path>
<path d="M36.7,17c-0.6,0-1.1,0.4-1.2,0.8c-0.1,0.5-0.1,1.1,0,1.7c0.1,0.5,0.6,0.9,1.2,0.8c0.8,0,1.3-0.6,1.3-1.8
	c0-0.2,0-0.5-0.1-0.7C37.8,17.3,37.3,17,36.7,17z"></path>
</svg>`

const cassndraIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path d="M50.513 26.616c.46 5.3-7.89 10.358-18.658 11.277S12.01 35.255 11.55 29.955s7.89-10.358 18.658-11.277c10.745-.92 19.844 2.614 20.304 7.938" fill="#bbe6fb"/><g fill="#fff"><path d="M30.5 19.283c-4.114-.073-8.906 1.573-12.487 3.098-.363 1.065-.58 2.202-.58 3.388 0 6.292 5.687 11.398 12.705 11.398s12.73-5.082 12.73-11.398c0-1.984-.58-3.872-1.573-5.493-2.856-.436-6.8-.92-10.793-.993"/><path d="M30.16 19.283c-2.275-.145-6.195 1.04-9.462 2.226a9.44 9.44 0 0 0-.774 3.799c0 5.518 5.01 9.995 10.285 9.995 5.25 0 9.898-4.477 10.285-9.995.12-1.79-.484-3.485-1.355-4.937-3.365-.58-6.946-.943-8.98-1.088"/></g><path d="M24.33 24.607c.3-.63.702-.92 1.113-1.428-.048-.12-.145-.532-.145-.653a1.11 1.11 0 0 1 1.113-1.113 1.07 1.07 0 0 1 .41.073c1.863-1.428 4.308-2.033 6.776-1.476l.653.17c-2.42-.34-5.18.532-7.042 2.033.048.145.218.508.218.678 0 .63-.4.774-1.016.774-.145 0-.266-.024-.4-.073-.4.557-.944 1.646-1.186 2.323 1.04.92 1.96 1.258 3.17 1.718 0-.048.048-.12.048-.17 0-1.863 1.646-3.388 3.5-3.388 1.67 0 3.073 1.2 3.34 2.807.847-.532 1.646-.944 2.25-1.718-.145-.17-.3-.678-.3-.92 0-.557.46-1.016 1.016-1.016.073 0 .145 0 .242.024a8.76 8.76 0 0 0 .702-2.033c-2.928-2.178-8.6-1.863-8.6-1.863s-4.5-.242-7.55 1.258c.217 1.404.797 2.807 1.67 3.993m13.994-.847a1.79 1.79 0 0 1 .411.508c.266.484-.266.944-.847.944-.048 0-.12 0-.17-.024-.63.992-1.742 2.25-2.735 2.904 1.525.242 2.952.847 4.066 1.8.823-1.476 1.452-3.63 1.452-5.445 0-1.38-.605-2.396-1.525-3.146-.024.75-.435 1.8-.653 2.468m-12.292 9.39c.508-1.404 1.742-2.468 2.928-3.412-.17-.242-.436-.823-.532-1.1-1.428-.436-2.686-1.258-3.678-2.323 0 .024-.024.073-.024.097a7.06 7.06 0 0 0-.12 2.468 1.48 1.48 0 0 1 1.21 1.452c0 .436-.387 1.04-.678 1.33a6.8 6.8 0 0 0 .895 1.476m-.098 1.162c-.605-.605-1.016-1.8-1.404-2.54-.073 0-.145.024-.218.024-.823 0-1.67-.678-1.476-1.476.097-.436.4-.726.895-.968-.12-.92-.145-2.202.073-3.146.048-.266.194-.387.266-.653-.895-1.307-1.476-3.05-1.476-4.767V20.6c-1.525.774-2.662 1.96-2.662 3.848 0 4.187 2.42 8.3 6.002 9.898v-.025m8.834-5.794a3.41 3.41 0 0 1-3.194 2.275c-.8 0-1.525-.266-2.08-.726-1.186.92-2.275 2.54-2.807 3.97.242.266.4.484.702.726.823.218 1.984 0 2.88 0 3.606 0 6.824-1.597 8.664-4.43-1.26-.87-2.712-1.694-4.164-1.815" fill="#373535"/><path d="M24.232 25.1a8.73 8.73 0 0 1 1.041-1.718 1.1 1.1 0 0 1-.073-.387 1.11 1.11 0 0 1 1.113-1.113 1.07 1.07 0 0 1 .41.073c1.863-1.428 4.308-2.033 6.776-1.476l.653.17c-2.42-.34-4.937.4-6.8 1.912.048.145.097.3.097.436a1.11 1.11 0 0 1-1.113 1.113c-.145 0-.266-.024-.4-.073-.4.557-.774 1.186-1.016 1.863.895.944 1.984 1.718 3.194 2.154v-.17a3.4 3.4 0 0 1 3.388-3.388c1.67 0 3.073 1.2 3.34 2.807.847-.532 1.573-1.2 2.202-2a.97.97 0 0 1-.242-.63c0-.557.46-1.016 1.016-1.016.073 0 .145 0 .242.024a8.76 8.76 0 0 0 .702-2.033c-2.928-2.178-8.6-1.863-8.6-1.863s-4.5-.242-7.55 1.258c.17 1.476.75 2.88 1.62 4.065M38.46 23.93c.218.194.34.46.34.75 0 .557-.46 1.016-1.016 1.016-.048 0-.12 0-.17-.024-.63.992-1.476 1.84-2.468 2.468a8.14 8.14 0 0 1 3.969 1.791 10.29 10.29 0 0 0 1.307-5.009c0-1.38-.605-2.396-1.525-3.146-.05.75-.195 1.477-.437 2.154m-12.292 9.534a8.06 8.06 0 0 1 2.565-3.582c-.17-.242-.315-.484-.4-.774-1.428-.436-2.686-1.258-3.678-2.323 0 .024-.024.073-.024.097a7.06 7.06 0 0 0-.12 2.468 1.48 1.48 0 0 1 .726 2.541c.24.557.58 1.1.943 1.573m-.244.823c-.605-.605-1.113-1.283-1.5-2.033-.073 0-.145.024-.218.024-.823 0-1.476-.653-1.476-1.476 0-.58.34-1.1.823-1.33a7.76 7.76 0 0 1 .145-2.783c.048-.266.145-.532.218-.8a8.17 8.17 0 0 1-1.428-4.622v-.194c-1.525.774-2.662 1.96-2.662 3.848 0 4.187 2.493 7.792 6.074 9.4.024 0 .024 0 .024-.024M34.662 29a3.41 3.41 0 0 1-3.194 2.275c-.8 0-1.525-.266-2.08-.726-1.186.92-2.08 2.178-2.638 3.606.242.266.508.508.774.75a10.12 10.12 0 0 0 2.589.339c3.606 0 6.8-1.863 8.64-4.695-1.2-.87-2.637-1.428-4.1-1.55" fill="#1287b1"/><path d="M34.783 28.14l3.122-.75-3.146-.17 2.565-1.936-2.904 1.04 1.96-2.735-2.735 1.815.944-3.194-1.863 2.638-.048-3.34-1.234 2.977-1.016-3 .048 3.533-1.767-3.17.968 3.364-2.88-2.08 2.25 2.83-3.582-1.307 2.807 2.08-3.606.12 3.703.944-3.703.798 3.654.266-3.073 1.96 3.17-1.137-2.202 2.783L29 30.22l-.992 3.727 2.154-3.05-.3 3.582 1.2-3.267 1.04 3.412.242-3.436 1.55 2.928-.92-3.34 2.807 2.178-1.815-2.783 3.098 1.2L34.7 29.06l3.17.242-3.097-1.162z" fill="#fff"/><g fill="#373535"><path d="M1.46 34.117c9.704-9.704 17.448-12.705 24.5-14.06.92-.17 1.113-2.226 1.113-2.226s.12 1.5.774 1.694 1.5-2.347 1.5-2.347-.774 2.275 0 2.42c.774.12 2.226-2.226 2.226-2.226s-.58 2.01-.194 2.154c.387.12 2.347-2.928 2.347-2.928s-1.162 2.01-.073 2.226c1.113.194 2.735-1.38 2.735-1.38s-1.258 1.428-.702 1.646c2.42.847 4.356-2.275 4.356-2.275s-.46 1.38-1.62 2.88c2.54.653 4.43-3.17 4.43-3.17l-1.888 3.824c.968.484 4.864-4.017 4.864-4.017s-2.01 3.51-3.194 4.235c.653.532 3-1.573 3-1.573s-1.888 2.347-1.162 2.468c1.04.847 4.888-4.356 4.888-4.356s-1.5 3.073-3.703 5.47c1.84.944 6.437-4.985 6.437-4.985s-.12 1.888-3.46 4.888c2.468-.315 5.663-5.01 5.663-5.01s-1.162 3.51-3.97 6.002c2.42-.242 6.316-6.244 6.316-6.244s-1.5 4.162-4.55 6.582c3.388.75 8.276-4.308 8.276-4.308s-1.912 3.582-4.43 5.058c2.807 1.065 6.655-3.364 6.655-3.364s-3.848 5.93-9.97 5.663c-2.01-.097-8.083-6.098-21.102-5.614-17.226.627-20.856 7.936-30.052 12.872" fill-opacity=".35"/><path d="M1.847 33.39c9.704-9.704 17.448-12.705 24.5-14.06.92-.17 1.113-2.226 1.113-2.226s.12 1.5.774 1.694 1.5-2.347 1.5-2.347-.774 2.275 0 2.42c.774.12 2.226-2.226 2.226-2.226s-.58 2.01-.194 2.154c.387.12 2.347-2.928 2.347-2.928s-1.162 2.01-.073 2.226c1.113.194 2.735-1.38 2.735-1.38s-1.258 1.428-.702 1.646c2.42.847 4.356-2.275 4.356-2.275s-.46 1.38-1.62 2.88c2.54.653 4.43-3.17 4.43-3.17l-1.888 3.824c.968.532 4.888-3.97 4.888-3.97s-2.01 3.51-3.194 4.235c.653.46 3-1.62 3-1.62s-1.888 2.347-1.162 2.468c1.04.847 4.888-4.356 4.888-4.356s-1.525 3.073-3.727 5.47c1.84.92 6.46-5.01 6.46-5.01s-.12 1.888-3.46 4.888c2.468-.315 5.663-5.01 5.663-5.01s-1.162 3.51-3.97 6.002c2.42-.242 6.316-6.244 6.316-6.244s-1.5 4.162-4.55 6.582c3.388.75 8.276-4.308 8.276-4.308s-1.912 3.582-4.43 5.058c2.812 1.063 6.66-3.365 6.66-3.365s-3.848 5.93-9.97 5.663c-2.01-.097-8.083-6.098-21.102-5.614-17.23.652-20.885 7.937-30.08 12.897"/><path d="M1.218 35.182c5.13 2.565 9.825-.387 15.73 1.283 4.5 1.258 9.97 2.83 17.4 1.742 7.43-1.065 13.77-4.308 16.82-10.067.944-2.565 4.792.58 4.792.58s-2.807-1.162-2.735-.63c.073.557 4.21 2.468 4.21 2.468s-3.75-1.162-3.51-.3c.218.87 4.695 4.404 4.695 4.404s-5.106-3.824-5.518-3.29c-.436.532 2.154 2.638 2.154 2.638s-4.26-2.638-5.76-1.863c-1.09.557 4.43 4.162 4.43 4.162s-3.582-2.735-4.43-2.01 4.04 6.582 4.04 6.582-5.566-6.002-6.123-5.71 1.525 3.17 1.525 3.17-2.7-3-3.46-2.493c-.75.532 3.92 8.3 3.92 8.3s-5.058-7.962-7.163-6.63c3.267 7.187 2.057 8.204 2.057 8.204s-.41-7.333-4.5-7.14c-2.057.097.968 5.47.968 5.47s-2.783-4.913-4.646-4.816c3.412 6.486 2.202 9.1 2.202 9.1s.557-5.542-4.066-8.615c1.767 1.573-1.113 8.615-1.113 8.615s2.517-10.382-1.863-8.397c-.702.315-.048 5.18-.048 5.18s-.87-5.566-2.202-5.276c-.774.17-4.888 7.72-4.888 7.72s3.364-8.155 2.347-7.817c-.75.242-2.154 3.606-2.154 3.606s.678-3.315 0-3.51-4.5 3.51-4.5 3.51 2.83-3.315 2.347-4.017c-.75-1.04-1.597-1.09-2.638-.678-1.5.58-3.51 3.315-3.51 3.315s2.01-2.783 1.67-3.8c-.557-1.67-6.34 3.22-6.34 3.22s3.412-3.22 2.638-3.92c-.774-.678-5.034-.484-6.34-.484-3.897.05-5.252-.87-6.438-1.815" fill-opacity=".35"/><path d="M1 34.6c5.13 2.565 9.825-.387 15.73 1.283 4.5 1.258 9.97 2.83 17.4 1.742 7.43-1.065 13.77-4.308 16.82-10.067.944-2.565 4.792.58 4.792.58s-2.807-1.162-2.735-.63c.073.557 4.21 2.468 4.21 2.468s-3.75-1.162-3.51-.3c.218.87 4.695 4.404 4.695 4.404s-5.058-3.848-5.47-3.315 2.154 2.638 2.154 2.638-4.26-2.638-5.76-1.863c-1.09.557 4.43 4.162 4.43 4.162s-3.582-2.735-4.43-2.01 4.04 6.582 4.04 6.582-5.542-6.002-6.098-5.71 1.525 3.17 1.525 3.17-2.76-2.977-3.51-2.468c-.75.532 3.896 8.3 3.896 8.3s-5.058-7.986-7.14-6.655c3.29 7.212 2.057 8.228 2.057 8.228s-.41-7.333-4.5-7.14c-2.057.097.968 5.47.968 5.47s-2.76-4.888-4.622-4.792c3.412 6.486 2.202 9.1 2.202 9.1s.557-5.542-4.066-8.615C35.85 40.748 32.97 47.8 32.97 47.8s2.517-10.382-1.863-8.397c-.702.315-.048 5.18-.048 5.18s-.87-5.566-2.202-5.276c-.774.17-4.888 7.72-4.888 7.72s3.364-8.155 2.347-7.817c-.75.242-2.154 3.606-2.154 3.606s.678-3.315 0-3.51-4.5 3.51-4.5 3.51 2.83-3.315 2.347-4.017c-.75-1.04-1.597-1.09-2.638-.678-1.5.58-3.51 3.315-3.51 3.315s2.01-2.783 1.67-3.8c-.557-1.67-6.34 3.22-6.34 3.22s3.412-3.22 2.638-3.92c-.774-.678-5.034-.484-6.34-.484-3.947.024-5.302-.896-6.488-1.84"/></g></svg>`
const mongodbIcon = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 64 64"><g fill-rule="evenodd"><use xlink:href="#B" fill="#fff"/><use xlink:href="#B" fill="#a6a385"/><use xlink:href="#C" fill="#fff"/><use xlink:href="#C" fill="#499d4a"/><use xlink:href="#D" fill="#fff"/><use xlink:href="#D" fill="#58aa50"/></g><defs ><path id="B" d="M33.525 63l-1.784-.564s.218-8.414-3.045-9.018c-2.175-2.335.348-99.04 8.18-.322 0 0-2.697 1.248-3.176 3.382-.522 2.093-.174 6.522-.174 6.522h0z"/><path id="C" d="M34.482 54.868s15.618-9.5 11.964-29.27C42.922 11.226 34.613 6.516 33.7 4.704c-1-1.288-1.958-3.543-1.958-3.543l.653 39.978c0 .04-1.35 12.24 2.088 13.73"/><path id="D" d="M30.828 55.39s-14.66-9.26-13.79-25.565C17.864 13.52 28.218 5.51 30.22 4.06c1.305-1.288 1.35-1.772 1.436-3.06.913 1.812.74 27.095.87 30.074.39 11.474-.697 22.143-1.697 24.317h0z"/></defs></svg>`
const hadoopIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path d="M23.848 19l-4.123.67-3.76 1.65-3.195 2-3.04 3.7-1.717 1.82-1.66.612-.44-1.074.768-1.11.173-1.563.514.02.562.513-.152-1.593-.623-.418.02-.607-1.476.835-1.338 1.58-.28 1.41.572 1.13.533 1.917 1.084.513 1.14-.056 1.08-.628-.72 3.658.72 4.07-.794 1.88-2.6 2.8.462 1.674 1.232 1.94 2.323 1.635 1.232.17 1.37.046-.855 3.51 3.143 1.288 3.916.515 1.34-.876.103-2.37 1.495-2.473.103-1.958 3.607.258 3.35-.31-3.35 2 .567 2.422 2.112 3.298 2.06.876 1.65-.67.67-1.34 3.453-2.628.67.567 5.41.206 1.082-.876.103-1.546-.36-.67-.258-4.174-1.803-3.607.31-1.597 1.082.567 3.04 2.834 1.494.103 1.65-.67 1.65-1.237.827-2.68 4.844.31 2.937-1.134 2.37-2.216 1.7-3.195.412-3.76-.36-4.38-.927-3.916-.928-1.237-1.288-.412-2.267 2.473-2.06.72-1.804-2.99L50.8 15.61l-.98-.618-3.916-3.246-3.146-1.702-3.143-.255-3.658.618-3.195 1.185-2.216 1.804-1.752 2.113-1.803.515L23.848 19" fill="#ff0"/><g fill="#ffc"><path d="M11.892 28.3c-3.53 4.12-2.746 9.113-1.768 14.005l-1.567-3.958-.577-3.63.165-3.71 1.485-3.542 2.227-3.3 3.464-2.886 3.793-1.567 4.453-.577-4.124 4.7c-3.31 1.074-5.263 1.797-7.55 4.467"/><path d="M28.515 15.76c-2.455 2.395-3.793 4.2-5.358 7.005l-3.546 5.916c-.594 1-.65 1.84-.828 2.995l-1.732-2.062.825-2.474 2.804-5.033 5.938-5.855 1.896-.495m12.124-5.932c-1.966.737-5.23.98-5.458 3.234-.16 1.605.12 2.408 1.087 4.103-2.386-2.47-2.976-2.087-7.587-1.32l1.98-2.804 3.464-2.144 4.453-1 2.062-.083"/></g><g fill="#cc0"><path d="M46.063 40.347c.656.404.64.697.53.974l1.55-.62 1.004-1.347.745-1.92-.952-.716-4.158.53-.3.84.09 1.195.4.708.62.3.487.044m-.39-7.115c-2.085.602-2.067.768-2.685 2.836.813-1.303 1.415-1.96 2.685-2.836m13.865-15.48c-.37.17-.73.254-.963.593-.5.73-.924 1.344-1.75 1.856-.413.258-.845.425-1.286.563-.365.114-.585.012-.896.236l.554.097h1.22l1.507-.93.885-.93.73-1.483M26.33 22.383c-.82 2.245-1.537 4.17-2.78 6.2 1.592-1.716 2.558-3.174 3.47-5.114.354-.754.42-1.638 1.4-1.31.044.753.204 1.507.248 2.257.533-3.822 2.037-5.42 5.532-6.904l-2.965.354-2.788.62-1.372 1.994-.753 1.903"/><path d="M33.096 22.29c.754 3.55 1.84 6.952 2.31 10.556.306 2.34.34 3.467-.84 5.487-1.288-.083-2.087.062-3.333.47-4.958 1.625-7.805 4.015-11.143-.802l3.2 1.508 2.28-.45 4.027-2.345 3.142-.62 1.018-4.245-.753-5.62-.09-2.655.178-1.284m8.54 21.95c-.416 2.882.96 4.43.4 5.227-.16.225-.38.62-.624.726-.872.385-2.07-.072-2.155.153h-2.876l-1.15-.487 1.77-2.08 1.726-3.762 1.106-3.806h.578l1.24 4.027"/><path d="M36.802 35.863c.233 1.31.64 1.62 1.255 2.886-.4 2.067-1.068 4.524-1.86 6.348-.334.77-.603 1.193-1.193 1.787-.997 1.004-2 1.878-3.127 2.75-.812.626-1.38.312-2.38.17-.426.772-.543 1.2-1.328 1.593-1.206.602-2.284-.696-3.23-1.46l2.05 3.2 1.416 1.328 1.195.177 1.593-.974.84-1.593 1.77-1.328 2.17-1.86 1.372-1.945 1.24-2.3 1.594-4.78.133-1.815-1.994-.885-1.516-1.298m-15.873 9.218c2.233 0 4.592-.122 6.638-1.063.58-.868 1.15-1.58 1.86-2.345-.644 1.217-.847 1.906-1.018 3.275l-.664.974-5.045.133-1.638-.177-.177-.177.045-.62m-.31-1.55l-.173-1.572c-.382 2.297-.3 3.837-1.347 5.894-.79.915-1.762 1.747-2.876 2.193.094.564.122.917.068 1.33-.196 1.488-3.172.83-4.396.77l5.892 1.517 1.328-.53.443-2.567 1.24-2.3.22-1.416-.4-3.32m-3.318-12.965c-.062 1.117-.134 1.58.36 2.57.626 1.254 1.395 2.432 2.075 3.67l.22-2.478-2.655-3.76m-9.082 8.436l-.575 1.223c.528 1.776.996 2.9 2 4.452-.175.63-.306.903-.708 1.416-.884-.136-1.668-.175-2.564-.172l2.965 2.3 1.46-.266 1.46-1.46-2.08-3.23-1.96-4.262m51.334-21.84c.602 2.708 1.38 5.207 1.306 7.98-.09 3.403-.754 7.7-3.904 9.753-3.53 2.298-7.676 1.21-11.55.226l4.735 1.945 4.426.22 3.01-.885 2.346-1.945 1.77-3.717.664-4.293-.53-4.206-.974-4.158-1.297-.922M6.855 25.236c-1.603 1.045-2.232 1.5-2.057 3.435l.48 1.737.68.462.84.28 1.518-.36.78-2.416-2.157 1.06h-.5l-.56-.86.68-1 .36-1.897.462.14.56.44-.08-.998-.38-.64-.38-.32-.24.94M42.817 10c1.422 1.32 3.17 2.47 4.307 4.084.438.625.93.945-.007 1.827 1-.283 1.358-.252 2.15-.156 1.442.175 2.793 2.224 2.88 3.696-.017.137-.4.45-1.515.757-.024.043-.63-.083-.614-.042.116.317.27.365.507.514.05.353.084.896.325 1.282.7-.013 1.387.064 2.074.2.23.384.196.767.177 1.15l.797-.133-.22-1.815.708-1.195-1.018-2.302-1.945-1.86-.187-.01-2.2-1.344-3.574-2.922L42.82 10m2.398 10.906c-.073.13-.188.34-.334.486.592.56.885.936 1.096 1.726l-2 .998-1.7 1.63c-.746-.402-.932-.7-1.293-1.476-.42.11-.82.218-1.166.09.22.002.355-.053.576-.2l1.082-1.124 1.91-1.448 1.25-.407c.16-.066.427-.224.586-.292"/><path d="M47.063 22.903c-2.13 1.148-4.172 2.302-5.26 4.48-.001-2.766 2.777-3.983 5.26-4.48m-5.685-5.44c-1.58 1.08-2.7 3.257-2.56 5.38-.515-1.837-.333-3.574 1.25-4.843l.8-.4.5-.146"/></g><path d="M62.673 22.472c-.287-1.8-.763-3.566-1.423-4.83-.08-.155-.203-.31-.354-.46a3.63 3.63 0 0 0-1.313-.802c-.53-.183-1.094-.22-1.537.012a1.24 1.24 0 0 0-.316.236c-.288.292-.53.647-.775 1.002-.27.396-.543.793-.87 1.072-.378.323-.85.52-1.296.698-.188-.455-.413-.893-.674-1.31-.305-.486-.652-.94-1.033-1.396-.28-.335-.596-.637-.944-.9-.33-.25-.666-.463-1.06-.708-1.052-.656-1.948-1.445-2.862-2.247l-1.245-1.07c-2.18-1.794-4.2-2.665-6.38-2.8-2.156-.136-4.432.457-7.12 1.588-1.297.546-2.26 1.19-3.1 1.97-.802.742-1.482 1.595-2.23 2.593-.438.03-.82.095-1.214.253-.434.173-.87.455-1.394.916l-1.07.99-.942.948c-2.447.393-4.44.827-6.226 1.52-1.824.705-3.436 1.678-5.09 3.146a13.41 13.41 0 0 0-1.772 1.902c-.503.658-.933 1.35-1.313 2.08L8.1 27.93c-.35.315-.722.58-1.143.74h0l-.354.145c-.012-.007-.02-.043-.036-.1.6-.573.694-1.413.75-2.25.072.086.14.195.213.303l.258.37.407.514.146-.64c.12-.537.2-1.252.07-1.872-.09-.402-.277-.76-.602-1.015l.1-.23.297-.783.178-.503-.525.09c-.7.122-2.2.947-3.258 2.044-.393.407-.73.858-.952 1.33-.23.492-.334 1.007-.244 1.522.078.45.303.892.712 1.31l.217.797a5.36 5.36 0 0 0 .289.743c.308.64.798 1.03 1.366 1.216.457.147.96.154 1.46.045-.097.56-.158 1.144-.18 1.783a23.08 23.08 0 0 0 .091 2.829l.1.775.118.71-.7 1.934-1.838 1.824-.215.207c-.6.577-.718.69-.548 1.706.11.65.32 1.277.628 1.86.292.56.69 1.106 1.196 1.614.632.634 1.668 1.42 2.753 1.833.62.236 1.26.35 1.86.255l-.094.277-.316.778c-.736 1.613.02 2.456 1.196 2.992.587.267 1.285.45 1.934.62l.433.114c.77.208 2.096.59 3.307.666 1.324.084 2.517-.2 2.837-1.378.126-.47.2-.832.23-1.185.028-.328.017-.656-.02-1.07.377-.836.535-1.072.813-1.475l.14-.205c.296-.438.434-.75.485-1.1.05-.34.007-.675-.053-1.2l-.027-.215c.762.1 1.53.15 2.298.157l1.156-.03-.444.23c-1.022.526-1.065 1.52-.745 2.546.288.924.882 1.867 1.255 2.44.783 1.207 1.53 2.228 2.436 2.783.95.582 2.034.65 3.435-.107.712-.386.937-.78 1.24-1.31l.308-.512c.292-.195 1.027-.8 1.746-1.394l.765-.63c.2.14.42.237.697.303.36.086.79.125 1.304.162.385.028 1.64.027 2.45.027l.584.001c.837.005 1.513-.04 2.023-.328.544-.31.867-.855.937-1.835.03-.438.036-.704-.024-.977-.056-.257-.167-.49-.356-.83l-.07-2.618c-.015-.53-.073-.96-.18-1.386-.106-.42-.26-.825-.462-1.3l-.36-.925-.248.09.248-.09v-.001l-.6-1.424.047-.306 1.155 1.113c.525.506 1.005.965 1.568 1.297.583.344 1.238.543 2.087.503.888-.042 1.84-.413 2.622-.993.757-.56 1.365-1.313 1.618-2.147l.395-1.3c1.246.212 2.583.28 3.875.144 1.246-.13 2.45-.448 3.49-1.002 1.526-.815 2.67-2.014 3.493-3.44h0c.92-1.592 1.434-3.468 1.63-5.4.157-1.548.07-3.653-.25-5.683h0l-.004-.006zm-16.14 13.012c-.718-.24-1.217-.594-1.848-.992.172.774.25 1.592.02 2.365-.363 1.225-.95 3.234.716 3.598.634.14.92.12 1.815-.34a3.37 3.37 0 0 1-1.586.032 1.03 1.03 0 0 1-.816-.707c.157.114.414.175.85.28 1.234.297 2.407-.297 2.64-1.152.134-.5.11-.762.395-1.444l.8.22-.46 1.495c-.396 1.293-1.94 2.334-3.305 2.313-1.26-.022-2.06-.812-2.93-1.587l-1.75-1.55c-1.57-.495-2.828-1.074-4.284-2.152 1.036 1.216 1.74 1.893 3.185 2.5-.2 2.144-.956 3.708-1.59 5.76-.288.928-2.558 4.644-3.185 5.01-.45.258-3.26 2.625-3.787 2.938-.394.523-.74 1.245-1.33 1.558-1.804.954-2.963-.872-3.933-2.414-.442-.705-1.67-2.727-.6-3.294 1.01-.535 1.58-.918 2.6-1.596.152.276.412.543.584.82l-.113-.906c-.068-.547-.065-.99-.024-1.54l.126-1.6c-.156.542-.466 1.084-.62 1.625l-.143.554a18.24 18.24 0 0 1-6.931.09l-.478-2.392c-.046.717-.016 2.7-.02 3.81-.003.86-.04 1.155-.483 1.887-.415.685-.59.84-1.173 2 .05.73.05 1.216-.145 1.907-.323 1.152-3.58.26-4.438.024-1.058-.292-3.245-.72-2.695-2.13.486-1.24.79-2.55 1.027-4.287-1.938-2.792-3.74-6.618-4.086-10.008-.27-2.63-.108-4.25.462-5.857.903-2.55 2.165-4.76 4.19-6.537 2.734-2.405 5.288-3.367 9.288-3.976-.962 1.077-1.913 2.213-2.95 3.436-1.05 1.236-1.674 2.484-2.34 3.836-.92 1.867-.9 2.578.32 4.217 1.052 1.4 1.62 2.048 2.08 3.428-.38.782-.517 1.443-.645 2.51 1.288 1.408 2.246 2.373 3.496 2.67 1.227.292 2.25.235 3.35-.326 2.438-1.247 4.694-2.856 7.444-2.923 1.272-3.128 1.144-5.742.535-8.768-.417-2.067-.585-4.024-.714-6.13-.516 2.17-.613 4.078-.23 6.24.46 2.605.82 5.483-.463 7.772-2.487.2-4.618 1.703-6.86 2.864-.9.467-1.84.512-2.836.238-.926-.254-1.55-.867-2.547-2.017-.016-1.155.245-1.687.775-2.733.852-1.68 1.792-3.242 2.824-4.894-1.264 1.525-2.46 2.8-3.453 4.333-.38-1.083-.924-1.633-1.824-2.852-.88-1.19-.97-1.712-.316-3.09.66-1.385 1.222-2.603 2.347-3.818 1.945-2.1 3.726-4.437 5.852-6.505 1.155-1.123 1.624-1.084 3.155-1.316 1.384-.2 2.736-.475 4.147-.802-1.365.127-2.685.174-4.012.207l-.04.001c1.308-1.67 2.067-2.6 4.19-3.524 5.23-2.27 8.552-2.516 12.66.936 1.065.895 1.994 1.764 3.074 2.536a3.9 3.9 0 0 0-1.175.279c.543-.103 1.17-.001 1.734.102a13.56 13.56 0 0 0 .487.301c.762.45 1.195.697 1.7 1.415.545.76 1 1.517 1.4 2.353-.263-.094-.482-.17-.68-.23-.148-.068-.306-.1-.468-.126a1.45 1.45 0 0 0-.908.212l-.032.015c-.422.205-1.075.44-1.512.5.223.077.716.106.948.014.03-.013.062-.023.095-.03-.255.432-.27.965-.038 1.41.04.095.095.18.156.243a12.59 12.59 0 0 0-.614.249c.974-.146 1.853-.174 2.804-.05l.185.94-.382.03c-.45-.36-.95-.3-1.636-.143-2.083.475-1.594 1.644-2.552 3.405.995-1.216.92-2.49 2.542-2.873.378-.09.635-.202.89-.163-.46.23-.858.615-1.016 1.06-.445 1.257-.17 2.316-.658 3.5.608-1.05.642-2.073 1.184-3.178.195-.396.916-1.03 1.362-1.04l.365-.008c.107.7.172 1.392.13 1.97-.073 1.05-.348 2.608-.512 3.205.55-.705.798-2.2 1.04-3.25.25-1.095.187-2.41-.032-3.585-.3-1.614 1.36-1.35 2.326-2.112.71-.56 1.198-1.452 1.848-2.085.645-.627 1.66.292 1.914.907 1.1 2.66 1.6 6.85 1.313 9.532-.326 3.01-1.78 6.297-4.436 7.78-3.385 1.89-7.376.735-10.74-.398h0l-.006.004zm-4.8 13.37c-.1 1.24-.524 1.324-1.615 1.305l-2.97-.06c-.705-.06-1.105-.122-1.32-.285 1.112-.816 3-4.185 3.37-5.345.4-1.225.816-2.295 1.133-3.427.146.473.26.942.473 1.445.354.84.528 1.362.553 2.26l.08 2.853c.305.532.352.646.298 1.254h0zm-33.453-9.4c.706 2.442 1.91 4.84 3.242 6.856v.035c-.084.347-.18.684-.383.956-.953 1.275-3.377-.596-4.078-1.312-.767-.783-1.28-1.7-1.402-2.58-.09-.632-.002-.65.438-1.098l1.8-1.812.392-1.046.001.001zM6.92 24.088c-.18.39-.31.683-.397.986-.38 1.312.172 2.484-1.02 3.436.56 1.13.534 1.58 1.837 1.058.502-.202.917-.486 1.29-.818-.18.465-.344.936-.494 1.412l-.074.24c-.93.395-2.157.647-2.625-.333-.228-.475-.356-.942-.522-1.542-1.532-1.59.76-3.688 2.008-4.44h0-.002zm.754 1.684c-.2-.2-.34-.318-.584-.3.02-.155.048-.31.087-.46l.063-.222c.318.185.4.52.436.973h0-.002zm45.996-5.936l.17.372c-.05.034-.1.07-.13.107-.073-.177-.185-.337-.32-.47l.28-.008zM9.385 27.05h0zm-4.993 1.687h0zm16.784 17.547h0zm13.826 4.128h0zm5.616-10.68h0zM7.08 28.958h0l-.01-.027.01.027zm53.94 4.434h0l.007.004-.007-.004zM1.666 28.578c.244-2.764.78-3.957 2.747-6.037-2.462 1.736-3.077 2.524-2.747 6.037M1.03 26.32c.27-1.244.524-1.713 1.29-2.734-1.242.87-1.405 1.226-1.29 2.734M29.928 8.98c-1.475.355-1.757.63-2.2 2.075.705-1.06 1.112-1.404 2.2-2.075m2.327-.21c-2.927.717-3.787 1.227-4.76 4.62 1.235-2.484 2.17-3.4 4.76-4.62m6.303 12.365c.312-1.382.866-2.713 3.015-3.744-2.845.712-3.38 1.907-3.015 3.744m18.1.096c1.685-.6 2.497-1.955 2.9-3.55-.66 1.336-1.677 2.453-3.06 3.137-.742.365-1.216.24-2.044.16.842.242 1.376.547 2.203.252m-11.477 1.354a1.91 1.91 0 0 0-1.073-.974c.413-.22.82-.452 1.136-.74-.928.43-2.008.325-2.803.862-.7.473-1.67 1.974-2.38 2.6.516-.2 1.013-.547 1.47-.912.002.28.065.555.186.807.186.39.486.686.84.87-.263.345-.473.728-.622 1.136a10.92 10.92 0 0 1 5.172-3.341 5.56 5.56 0 0 0-1.752.292c-.023-.213-.082-.42-.174-.613m-1.952 12.15l-.222 1.35.593-1.468c.218-.475.34-.52.8-.77l1.248-.6-1.276.237c-.9.152-1.005.368-1.144 1.253M27.88 18.66c-1.045 1.03-2.056 4.57-2.38 5.984.5-1.176 1.786-4.465 2.765-5.302.27-.23.462-.373.662-.477-.7 1.175-.65 1.467-.404 3.04.21-1.6.762-2.22 1.67-3.413.995-.25 1.927-.55 2.948-.948l-3.454.358c-.967.092-1.123.076-1.81.754"/><path d="M42.088 24.682a.8.8 0 0 1 .379-1.066c.4-.2.88-.02 1.07.378.018.038.032.077.044.115-.38.283-.73.615-1.023 1a.89.89 0 0 1-.469-.428m8.907-3.446c.032-.33.313-.573.642-.54s.572.33.54.66a.6.6 0 0 1-.052.191c-.3.052-.603.14-.914.254-.13-.133-.233-.376-.215-.566" fill="#ffc"/></svg>`
const splunkIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path d="M54.87 25.896c0-.108-.054-.108-.217-.108h-.1v.27h.108c.1 0 .218-.054.218-.163zm-40.15 2.767c-.65 0-1.302.326-1.682.868a4.13 4.13 0 0 0-.597 2.387c-.054.814.163 1.628.597 2.333a1.84 1.84 0 0 0 1.682.814c.38 0 .76-.1 1.03-.326a2.39 2.39 0 0 0 .65-.814c.162-.326.27-.705.38-1.085.054-.38.108-.705.108-1.085.054-.814-.163-1.573-.597-2.28a1.67 1.67 0 0 0-1.573-.813z"/><path d="M0 0v64h64V0H0zm9.13 33.818c0 .38-.054.76-.217 1.085a2.03 2.03 0 0 1-.705.814c-.326.217-.65.434-1.03.543-.434.11-.868.217-1.302.217-.543 0-1.03-.054-1.52-.217S3.38 35.825 3 35.445l.76-1.248a5.12 5.12 0 0 0 .977.651 1.17 1.17 0 0 0 .868.217c.326 0 .65-.11.922-.27.217-.217.38-.488.326-.76 0-.11 0-.27-.054-.38-.054-.163-.108-.27-.217-.38-.163-.163-.326-.27-.488-.434l-.76-.543-.705-.543c-.217-.163-.434-.326-.597-.543s-.326-.434-.434-.65a2.24 2.24 0 0 1-.163-.868c0-.325.054-.705.217-.977s.38-.543.65-.76.597-.38.922-.488c.38-.11.814-.163 1.194-.163.434 0 .922.054 1.356.163s.814.326 1.194.543l-.705 1.085c-.434-.326-.922-.488-1.465-.488-.27 0-.543.054-.76.217s-.326.38-.326.597.11.488.27.65c.27.27.597.543.922.76l1.085.868c.27.217.488.434.705.705.163.217.27.434.326.65.11.273.163.545.11.762zm9.875-.272c-.217.543-.488 1.085-.868 1.52a3.96 3.96 0 0 1-2.984 1.356c-.27 0-.488 0-.76-.054-.217-.054-.434-.11-.65-.217s-.434-.27-.597-.434l-.65-.65V40.6h-2.28V27.47h2.28v1.248c.38-.488.814-.868 1.356-1.14a3.64 3.64 0 0 1 1.682-.38c.543 0 1.085.11 1.573.326s.868.488 1.248.868.65.868.814 1.41l.163 1.845c0 .65-.108 1.3-.325 1.897zm3.635 2.713h-2.28V23.4h2.28v12.86zm9.766 0h-2.224v-1.194a5.2 5.2 0 0 1-1.356 1.085c-.488.217-1.085.326-1.628.326-.597 0-1.194-.11-1.736-.434-.488-.27-.814-.705-1.03-1.194a1.01 1.01 0 0 1-.108-.38c-.054-.163-.054-.326-.11-.488 0-.217-.054-.434-.054-.597V27.47h2.28v4.992c0 .326 0 .705.054 1.03.054.217.11.434.217.65.27.488.868.814 1.41.76.76.054 1.52-.38 1.8-1.085.11-.217.163-.434.163-.597.054-.326.054-.65.054-.977V27.47h2.28v8.79zm10.037-5.046v4.992l-2.28.054v-5.046c0-.326 0-.705-.054-1.03-.054-.217-.11-.434-.217-.65-.27-.488-.868-.814-1.41-.76-.38 0-.76.11-1.14.27-.326.163-.543.488-.705.814-.11.217-.163.434-.163.65-.054.326-.054.65-.054.977v4.72H34.09V27.47h2.333v1.194a5.2 5.2 0 0 1 1.356-1.085c.488-.217 1.085-.326 1.628-.326.597 0 1.194.11 1.736.434.488.27.814.705 1.03 1.194.054.11.11.27.11.38.054.163.054.326.11.488 0 .217.054.434.054.597l-.001.867zm7.433 5.21l-3.472-4.83v4.666h-2.333V23.4h2.333v7.542h.217l3.093-3.58 1.736.76-2.93 3.147 3.472 4.395-2.116.76zm4.83-11.123c.434 0 .76.38.76.814s-.38.76-.814.76a.74.74 0 0 1-.76-.76.8.8 0 0 1 .814-.814zM61 32.515l-7 3.472v-1.52l5.426-2.66L54 29.15v-1.573l7 3.528v1.4z"/><path d="M54.706 26.7a.66.66 0 0 0 .651-.651c0-.326-.326-.597-.65-.65a.66.66 0 0 0-.651.651.66.66 0 0 0 .651.651zm-.325-1.03h.27c.11 0 .163 0 .27.054.054.054.11.108.054.163 0 .11-.054.217-.163.217.11 0 .163.11.163.217 0 .054 0 .163.054.217h-.163c-.054-.054-.054-.163-.054-.217 0-.11-.054-.163-.163-.163h-.108v.38h-.163v-.868z"/></svg>`
const netappIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 25 25"><defs><style>.cls-1{fill:#005cab;}</style></defs><title>All_brand_logos_Vector_2019</title><g id="NetApp"><polygon class="cls-1" points="0 1.49 0 1.54 0 23.54 10 23.54 10 10.54 15 10.54 15 23.54 25 23.54 25 1.54 0 1.49"/></g></svg>`;
const netwareIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 25 25"><defs><style>.cls-1{fill:#cd202a;fill-rule:evenodd;}</style></defs><title>All_brand_logos_Vector_2019</title><path class="cls-1" d="M3.31,24.18H.75V1L2.54,2.86,19.08,5.48,3.05,1h.44l17.4,2.75L11.9,1H24.44V24.18H5.34L9.67,15h-2L5.83,19.09,3.84,15H1.73L4.79,21.1Zm10.34-1.77a3.22,3.22,0,0,0,3.17-2.23l-1.67-.3a1.62,1.62,0,0,1-1.5.94,1.49,1.49,0,0,1-1.29-.68,2.23,2.23,0,0,1-.31-1.2h4.82v-.17a4.58,4.58,0,0,0-.78-2.8,2.92,2.92,0,0,0-2.51-1.17,3.11,3.11,0,0,0-2.42,1,4,4,0,0,0-1,2.81,3.79,3.79,0,0,0,1,2.79,3.18,3.18,0,0,0,2.46,1Zm6.64,0a2.53,2.53,0,0,0,1.93-.76,2.48,2.48,0,0,0,.71-1.81,2.28,2.28,0,0,0-.32-1.19,3.25,3.25,0,0,0-1.64-1l-.43-.15C20,17.29,20,17,20,16.83c0-.35.27-.58.7-.58a1.4,1.4,0,0,1,1.05.48l.9-1.17a3,3,0,0,0-2.06-.76,2.42,2.42,0,0,0-1.67.51,2.17,2.17,0,0,0-.67,1.61,2,2,0,0,0,.49,1.38,3.37,3.37,0,0,0,1.38.85l.42.17a.78.78,0,0,1,.56.72.79.79,0,0,1-.89.78A2,2,0,0,1,18.74,20l-.95,1.22a3.15,3.15,0,0,0,2.5,1.18m-8.18-4.75.08-.34a1.5,1.5,0,0,1,2.88,0l.08.34Zm.75-4.24.76-1.18-2.57-.67Zm-2.6-2.66,4.43-.08-6.5-2Zm5.91-2L5.7,6.09,7.76,8.2Zm1.39-1.64L2.88,3.21,5.27,5.66Z"/></svg>`;
const blankIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="0" height="0" viewBox="0 0 0 0"></svg>`;

const routerCommcellIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128" fill="#0b2e44"><path d="M54.2 92.2c0-16.7 10.8-30.9 25.8-36V3.9A3.84 3.84 0 0 0 76.1 0H3.9A3.84 3.84 0 0 0 0 3.9v120.3c0 2.1 1.7 3.9 3.9 3.9h72.3c.7 0 1.3-.2 1.9-.5-14-5.7-23.9-19.4-23.9-35.4zM8 21.8h63v3.7H8v-3.7zm0 11.5h63V37H8v-3.7zm0 11.3h63v3.7H8v-3.7zM8 56h63v3.7H8V56zm31.7 41.5c-4 0-7.3-3.3-7.3-7.3s3.3-7.3 7.3-7.3 7.3 3.3 7.3 7.3-3.3 7.3-7.3 7.3zM93 57.2c-19.3 0-35 15.7-35 35s15.7 35 35 35 35-15.7 35-35-15.7-35-35-35zm0 66.8c-17.5 0-31.7-14.2-31.7-31.7S75.5 60.5 93 60.5s31.7 14.2 31.7 31.7S110.5 124 93 124z"/><circle cx="93.3" cy="92.4" r="4.5"/><path d="M93.4 63.6l-6.1 7c-.3.3-.3.9 0 1.2s.9.3 1.2 0l4.6-5.3v16.8h1.7V66.5l4.6 5.3c.3.3.9.3 1.2 0s.3-.9 0-1.2l-6.1-7c-.2-.2-.4-.3-.7-.2 0-.1-.3 0-.4.2zm-9.3 28.7l-7-6.1c-.3-.3-.9-.3-1.2 0s-.3.9 0 1.2l5.3 4.6H64.3v1.7h16.9l-5.3 4.6c-.3.3-.3.9 0 1.2s.9.3 1.2 0l7-6.1c.2-.2.3-.4.2-.7 0 0 0-.2-.2-.4z" stroke="#0b2e44" stroke-width=".5" stroke-miterlimit="10"/><path d="M94.7 121.2l6.1-7c.3-.3.3-.9 0-1.2s-.9-.3-1.2 0l-4.6 5.3v-16.8h-1.7v16.9l-4.6-5.3c-.3-.3-.9-.3-1.2 0s-.3.9 0 1.2l6.1 7c.2.2.4.3.7.2 0 0 .2-.1.4-.3z"/><path d="M122.1 92.3l-7-6.1c-.3-.3-.9-.3-1.2 0s-.3.9 0 1.2l5.3 4.6h-16.8v1.7h16.9l-5.3 4.6c-.3.3-.3.9 0 1.2s.9.3 1.2 0l7-6.1c.2-.2.3-.4.2-.7-.1 0-.1-.2-.3-.4z" stroke="#0b2e44" stroke-width=".5" stroke-miterlimit="10"/></svg>`;
const IdpCommcellIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128" fill="#0b2e44"><path d="M54.2 92.2c0-16.7 10.8-30.9 25.8-36V3.9A3.84 3.84 0 0 0 76.1 0H3.9A3.84 3.84 0 0 0 0 3.9v120.3c0 2.1 1.7 3.9 3.9 3.9h72.3c.7 0 1.3-.2 1.9-.5-14-5.7-23.9-19.4-23.9-35.4zM8 21.8h63v3.7H8v-3.7zm0 11.5h63V37H8v-3.7zm0 11.3h63v3.7H8v-3.7zM8 56h63v3.7H8V56zm31.7 41.5c-4 0-7.3-3.3-7.3-7.3s3.3-7.3 7.3-7.3 7.3 3.3 7.3 7.3-3.3 7.3-7.3 7.3zM93 57.2c-19.3 0-35 15.7-35 35s15.7 35 35 35 35-15.7 35-35-15.7-35-35-35zm0 66.8c-17.5 0-31.7-14.2-31.7-31.7S75.5 60.5 93 60.5s31.7 14.2 31.7 31.7S110.5 124 93 124zm24.8-27.1c-.1-.3-.4-.5-.6-.6L91.9 85.8c-.1-4.8-3-9-7.4-10.9-1.5-.6-3-.9-4.6-.9h0c-1.6 0-3.1.3-4.6.9a11.54 11.54 0 0 0-6.5 6.5c-1.2 3-1.2 6.2 0 9.2a11.54 11.54 0 0 0 6.5 6.5c1.5.6 3 .9 4.6.9 3.1 0 6.1-1.2 8.3-3.3l10.9 4.5-.6 1.3c-.3.6 0 1.3.6 1.5l4.9 2-1.2 2.8c-.1.3-.1.6 0 .9s.4.5.6.6l7.3 3c.1.1.3.1.5.1.1 0 .3 0 .4-.1.3-.1.5-.4.7-.6l5.4-13.1c.2-.1.2-.4.1-.7zM91.4 86.2l7.5 3.1-7.5-3.1v-.9.9zM79.9 74.6h0zm0 22.9s-.1 0 0 0h0zm8-4.9zm15.8 15.4a.78.78 0 0 1-.4-.4c.1.2.3.4.4.4l7.3 3-7.3-3zm7 .9l-5.1-2.1 1.2-2.8c.3-.6 0-1.3-.6-1.6l-4.9-2 .6-1.3c.3-.6 0-1.3-.6-1.5l-12.7-5.3c-.1-.1-.3-.1-.5-.1-.3 0-.7.1-.9.4-1.8 2-4.4 3.1-7.1 3.1-1.3 0-2.5-.2-3.7-.7-4.9-2-7.2-7.7-5.2-12.6 1-2.4 2.8-4.2 5.2-5.2 1.2-.5 2.4-.7 3.7-.7s2.5.2 3.7.7c3.8 1.6 6.1 5.3 5.9 9.4 0 .5.3 1 .7 1.2L115.2 98l-4.5 10.9zm-10.2-8.3l.7-1.8c0-.1.1-.2.1-.3 0 .1 0 .2-.1.3l-.7 1.8zm16.9-3l-5.4 13.1 5.4-13.1c0-.1.1-.2.1-.3-.1.1-.1.2-.1.3zM81.6 81.8c-.6-.2-1.2-.3-1.8-.3-1.9 0-3.6 1.1-4.3 2.9a4.27 4.27 0 0 0 0 3.5 5.07 5.07 0 0 0 2.5 2.5c.6.2 1.2.3 1.8.3s1.2-.1 1.8-.4a5.07 5.07 0 0 0 2.5-2.5 4.27 4.27 0 0 0 0-3.5c-.4-1.1-1.3-2-2.5-2.5zm-1.7.2h0zm-1.1 6.6c-.2-.1-.3-.2-.5-.3.2.2.4.3.5.3.3.1.7.2 1 .2-.3 0-.6 0-1-.2zm3.1-1.6c-.2.6-.7 1-1.2 1.2-.3.1-.6.2-.9.2s-.6-.1-.9-.2c-.6-.2-1-.7-1.2-1.2-.2-.6-.2-1.2 0-1.7.3-.8 1.2-1.4 2.1-1.4.3 0 .6.1.8.2.6.2 1 .7 1.2 1.2.4.5.4 1.1.1 1.7z"/></svg>`;

cvCommonModule.constant('SERVER_ICONS',{
    'ALL': activeServerIcon,
    'WINDOWS': windowsIcon,
    'WINDOWS_COLOR': windowsColorIcon,
    'UNIX': linuxIcon,
    'NAS': nasIcon,
	'QUMULO': qumuloIcon,
	'NUTANIX': nutanixIcon,
	'CLUSTER': clusterIcon,
	'IBMI': ibmiIcon,
	'GPFS': gpfsIcon,
	'GLUSTERFS': glusterFSIcon,
	'LUSTRE': lustreIcon,
	'OPENVMS': openVMSIcon,
    'SERVER': serverIcon,
    'DEVICE': deviceIcon,
    'VM': vmIcon,
    'NETAPP': netappIcon,
    'NETWARE' : netwareIcon,
    'UNKNOWN' : blankIcon
});

cvCommonModule.constant('USER_ICONS',{
    'USER': userIcon
})

cvCommonModule.constant('BIGDATA_ICONS',{
    'HADOOP': hadoopIcon,
	'CASSANDRA': cassndraIcon,
	'MONGODB': mongodbIcon,
	'SPLUNK': splunkIcon,
})

cvCommonModule.constant('SOLUTION_ICONS',{
	'ALL': activeServerIcon,
	'FILE_SERVERS': fileServersIcon,
	'VSA': virtualizationIcon,
	'ENDPOINT': endPointIcon,
	'DBS': dbsIcon,
	'EXCHANGE': exchangeIcon,
	'ARCHIVING': archivingIcon,
	'ARCHIVE': archivingIcon,
	'EBS': oracleEBSIcon,
	'CAPPS': cloudAppsIcon,
	'SHAREPOINT': sharePointIcon,
	'COMPLIANCE': governanceAppsIcon,
	'ACTIVE_DIRECTORY': activeDirectoryIcon,
	'BIGDATA_APPS': bigDataAppsIcon

})

cvCommonModule.constant('GRID_ICONS',{
    'COMPANIES_GRID_EMPTY': companiesGridEmpty
})

cvCommonModule.constant('MAINTANENCE_ICONS',{
    'COPY_SOFTWARE': copySoftwareIcon,
	'DOWNLOAD_SOFTWARE': downloadSoftwareIcon,
	'INSTALL_UPDATES': installUpdateIcon,
	'DR_BACKUP': drBackupIcon,
	'HTTP_PROXY': httpProxyIcon,
	'INTERNET_OPTIONS': internetOptionsIcon,
	'WEB_DOMAINS': webdomainsIcon
})

cvCommonModule.constant('ENTITY_ICONS',{
	'FILE_SERVERS': fileServersIcon,
	'LAPTOP' : deviceIcon,
	'PLAN' : planIcon,
	'SERVER':serverIcon,
	'USER':userIcon,
	'VM':vmIcon,
	'SCHEDULE_POLICY': schedulePolicyIcon,
	'STORAGE_POLICY': storagePolicyIcon,
	'SUBCLIENT_POLICY': subclientPolicyIcon,
	'ALERT': alertIcon,
	'ARRAY': arrayIcon,
	'REGION': regionIcon,
	'BACKUPSET':backupsetIcon,
	'IBMI_SERVER': ibmiServerIcon,
	'INSTANCE' : instanceIcon,
	'LIBRARY':libraryIcon,
	'MEDIA_AGENT':mediaAgentIcon,
	'SERVER_GROUP':serverGroupIcon,
	'STORAGE_POOL':storagePoolIcon,
	'SUBCLIENT': subclientIcon,
	'UNIX_CLUSTER':unixClusterIcon,
	'USER_GROUP': userGroupIcon,
	'WINDOWS_CLUSTER':windowsClusterIcon,
	'ENTITY':entityIcon,
	'CLOUD_APP':cloudAppIcon,
	'DISTRIBUTE_DATABASE':distributedDatabaseIcon,
	'EDGE_DRIVE':edgeDriveIcon,
	'DISTRIBUTED_FS':distributedFsIcon,
	'DISTRIBUTED_IDA':distributedIdaIcon,
	'HYPERVISOR':hypervisorIcon,
	'STRORAGE_POOL_CLOUD' : storagePoolCloudIcon,
	'HYPERSCALE' : hyperscaleIcon,
	'OFFICE365' : office365Icon,
	'GSUITE':gSuiteIcon,
	'KEY_MANAGEMENT_SERVER':keyMangementServerIcon,
	'ARCHIVING': archivingIcon,
	'DATABASE':dbsIcon,
	'TAPE':tapeIcon,
	'REPORT': reportIcon,
	'EXCHANGE': exchangeIcon,
	'ACTIVE_DIRECTORY':activeDirectoryIcon,
	'SALESFORCE':salesforceIcon,
	'ROLE':rolesIcon,
	'OBJECT_STORAGE': objectStorageIcon,
	'O365_ONE_DRIVE': O365OneDriveIcon,
	'O365_SHARE_POINT': O365SharePointIcon,
	'O365_MAILBOX': O365MailboxIcon,
	'LDAP': LDAPIcon,
	'SAML': SAMLIcon,
	'COMPANY': companyIcon
})

cvCommonModule.constant('COMMCELL_ICONS', {
	'ROUTER_COMMCELL': routerCommcellIcon,
	'IDP_COMMCELL': IdpCommcellIcon
})

export default cvCommonModule;
