/**
 * Drag and drop for grid and other components
 * @author: ssubash
 */
export default class DragDrop {
	constructor(element, options) {
		this.options = options;
		this.element = element;
	}

	build() {
		const options = this._buildOptions();
		this.element.kendoSortable(options);
	}

	_buildOptions() {
		const options = {};
		options.filter = this.options.filter || '>tbody >tr';
		options.hint = this.options.hint || function() {};
		options.cursor = this.options.cursor || 'move';
		options.placeholder = this.options.placeholder || function() {};
		options.change = this.options.change || function() {};
		options.axis = this.options.axis || 'y';
		return options;
	}
}
