import { cvCommonModule } from "common/js/modules";
import "common/js/reorder.svc.js";

const serverFilterTEMPLATE = `
    <div class="uib-dropdown cv-server-filter dropdown cv-k-header-dropdown" is-open="ctrl.isOpen" on-toggle="ctrl.showSearch && ctrl.dropDownToggled(open)" ng-attr-dropdown-append-to="ctrl.appendToEl" data-uib-dropdown data-ng-show="ctrl.showUp">
        <span class="cv-k-header-dropdown-label">{{ctrl.filterLabel}}</span>
        <a class="uib-dropdown-toggle dropdown-toggle" data-uib-dropdown-toggle>
            <span class="dropdownArrow right"></span>
            <span>{{ctrl.curObj.label}}</span>
        </a>
        <ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 ng-style:ctrl.styleAttr" data-ng-class="{'cv-dropdown-style-append-to-body': !ctrl.appendToElementId, 'cv-server-filter': !ctrl.appendToElementId, '{{ctrl.dropdownTemplateClass}}' : ctrl.dropdownTemplateClass}">
            <div ng-if="ctrl.showSearch">    
                <li class="server-list search-container" ng-click="ctrl.preventClose($event)">
                    <span class="glyphicon glyphicon-search search-icon"></span>
                    <input placeholder="{{ctrl.searchOptions.searchInputPlaceholder}}" type="text" class="search-input" ng-model="ctrl.searchInput" ng-model-options="{ debounce: 500 }" ng-change="ctrl.searchList(ctrl.searchInput)" >
                    <a ng-class="{'icon-invisible': !ctrl.searchInput}" class="k-icon k-i-close" ng-click="ctrl.clearSearch()" title="Clear"></a>
                </li>
                <li class="empty-list-info" ng-show="ctrl.isListEmpty">
                    <span ng-bind="ctrl.searchOptions.emptySearchMessage"></span>
                </li>
            </div>
            <li class="server-list" data-ng-show="!option.hidden" data-ng-repeat="option in ctrl.filterList | orderBy: ctrl.getRank" data-ng-click="ctrl.changeAction(option)" data-ng-class="[option.cssClass, {selected:  option.key === ctrl.curObj.key}]">
                <a ng-class="{'crop': ctrl.widthLimit}" href="" title="{{option.label}}" ><span data-ng-if="option.icon" class="margin-right-10"  data-ng-bind-html="option.icon"></span>{{option.label}}</a>
            </li>
        </ul>
    </div>
`;

export class CVServerFilter {
    constructor($interval) {
        this.restrict = 'E',
        this.template = serverFilterTEMPLATE,
		this.bindToController = true,
        this.controllerAs = 'ctrl',
        this.controller = CVServerFilterController,
        this.scope = {
            filterLabel: '@',
            filterList : '=',
            gridReorderDisabled: '=?',
            filterCurrent: '=',
            appendToElementId: '@',
            scrollThreshold: '=',
            toolbarTemplateClass: '@?',
            dropdownTemplateClass: '@?',
            widthLimit: '=?',
            searchOptions: '=?' //Object{showSearch, emptySearchMessage, searchInputPlaceholder}
        },
        this.$interval = $interval;
        this.link = this._link.bind(this);
    }

    

    _link(scope, element, attrs, ctrl) {
        let parentName = '.cv-k-grid-header';
        const updateDOM = () => {
            if(angular.element(`.${ctrl.toolbarTemplateClass}`).length > 0) {
                parentName = `.${ctrl.toolbarTemplateClass}`;
            }
            const parent = angular.element(parentName);
            if(parent.length > 0) {
                parent.append(element);
                ctrl.showUp = true;
                if(timeoutId){this.$interval.cancel(timeoutId);}
                const container = parent.parents('[cv-kendo-grid-container]');
                const grid = container.data('cvKendoGrid');
                ctrl.addSelfToKendoGrid(grid);
            }
        }
        const timeoutId = this.$interval(updateDOM, 1000);
    }
}

class CVServerFilterController {
    constructor($scope, cvLoc, $sce, reorderService, userPrefService, $timeout) {
        this.$scope = $scope,
        this.cvLoc = cvLoc;
        this.$sce = $sce;
        this.reorderService = reorderService;
        this.userPrefService = userPrefService;
        this.$timeout = $timeout;
        this.dismissDropDown = this._dismissDropDown.bind(this);
    }

    $onInit() {
        if (this.appendToElementId) {
            this.appendToEl = angular.element(`#${this.appendToElementId}`);
        } else {
            this.appendToEl = angular.element('body');
            $('.wrapper-view').on('scroll', this.dismissDropDown);
        }
        this.toolbarTemplateClass = this.toolbarTemplateClass || 'cv-server-filter-type';
        this.dropdownTemplateClass = this.dropdownTemplateClass ? this.dropdownTemplateClass : false;
        this.changeAction = this._changeAction.bind(this);

        if (_.get(this, 'searchOptions.showSearch')) {
            this.showSearch = true;
            this.searchOptions.searchInputPlaceholder =  this.searchOptions.searchInputPlaceholder || this.cvLoc('label.search');
            this.searchOptions.emptySearchMessage = this.searchOptions.emptySearchMessage || this.cvLoc('label.noResultsFound');
        }

        var self = this;
        /* Fix for current obj not updated when changed externally (Programatically) */
        this.$scope.$watch(angular.bind(self, () => self.filterCurrent), (nv) => {
            if (nv !== undefined) {
                self.curObj = self.filterList[nv];
            }
        });

        this.orderMap = {};
        this.getRank = this._getRank.bind(this);

        // Sort filterList alphabetically by default.
        // 'All' is a special case where it will be listed first.
        let labels = _.map(self.filterList, val => ({
            label: val ? val.label : '',
            upperLabel: val ? _.toUpper(val.label) : '',
            rank: _.get(val, 'rank')
        }));
        const allLabel = _.toUpper(this.cvLoc('viewname.all'));
        labels.sort((a, b) => {
            if (a.upperLabel === allLabel) {
                return -1;
            } else if (b.upperLabel === allLabel) {
                return 1;
            }
            return a.upperLabel.localeCompare(b.upperLabel);
        });
        labels = _.sortBy(labels, 'rank');
        labels.forEach((label, index) => {
            this.orderMap[label.label] = index;
        });

        _.forOwn(self.filterList,(val,ind)=>{
        	if(angular.isUndefined(val)){val={};}
            if(angular.isUndefined(val.key)){val.key = ind;}
            val.icon = this._allowInlineStyle(val.icon);
        })
        this.filterLabel = _.isEmpty(this.filterLabel) ? this.cvLoc('Type') : this.filterLabel;
        this.reorderLabel = `${this.cvLoc('label.reorder')} ${this.filterLabel}`;
        if (!this.id) {
            this.id = this.filterLabel;
        }
        this.curObj = this.filterList ? self.filterList[0] : null;
        if( !_.isEmpty(self.filterCurrent)) {
            const temp = _.filter(self.filterList,(val)=>_.toUpper(val.key) === _.toUpper(self.filterCurrent.state));
            if(temp.length > 0) {
                self.curObj = temp[0];
            }

            if(self.filterCurrent.reload && self.curObj){self.curObj.action(self.curObj);}
        }

        if (self.scrollThreshold > 0){self.styleAttr = {
		    'max-height': `${self.scrollThreshold}px`,
		    'overflow-y': 'auto'
        };}
        
        if (self.widthLimit) {
            self.styleAttr = self.styleAttr || {};
            self.styleAttr.maxWidth = `${self.widthLimit}px`;
        }
                
        this._onDestroy();
    }

    _allowInlineStyle(icon) {
        return this.$sce.trustAsHtml(icon);
    }

    _getRank(obj) {
        return this.orderMap[obj.label];
    }

    _changeAction(obj) {
        this.curObj = obj;
        this.curObj.action(obj, this.filterList.indexOf(obj));
        this.showSearch && this.clearSearch();
    }

    async reorderFilterList() {
        let reorderedList = [];
        let unorderedObjects = [];
        this.filterList.forEach(obj => {
            const rank = this._getRank(obj);
            if (_.isUndefined(rank) || _.isNull(rank)) {
                unorderedObjects.push(obj);
            } else {
                reorderedList[rank] = obj;
            }
        });
        reorderedList = reorderedList.concat(unorderedObjects);
        reorderedList = reorderedList.filter(obj => obj);
        try {
            reorderedList = await this.reorderService.openModal({
                list: reorderedList
            });
        } catch (e) {
            // Reorder cancelled
            return;
        }
        this.orderMap = {};
        reorderedList.forEach((obj, index) => {
            this.orderMap[obj.label] = index;
        });
        let value = JSON.stringify(this.orderMap);
        await this.userPrefService.putAdditionalPref(this.grid.tableName, this.orderPrefKey, value);
        this.grid.getViewSvc().putAdditionalPref(this.orderPrefKey, value);
        this.grid.getViewSvc().updateTablePrefs(false, null);
    }

    preventClose(event) {
        event.stopPropagation();
    }

    searchList(searchInput) {

        this.isListEmpty = true;
        const allLabel = _.toUpper(this.cvLoc('viewname.all'));

        _.forEach(this.filterList, item => {
             // 'All' is a special case which is not included in search
            if (allLabel === _.toUpper(item.label)) {
                item.hidden = !!searchInput;
                return;
            }

            if (_.includes(_.toUpper(item.label), _.toUpper(searchInput))) {
                item.hidden = false;
                this.isListEmpty = false;
            } else {
                item.hidden = true;
            }
        })
    }
    
    clearSearch() {
        if (!_.isEmpty(this.searchInput)) {

            this.isListEmpty = false;
            this.searchInput = '';
            
            _.forEach(this.filterList, item => {
                item.hidden = false;
            });
        }
    }

    dropDownToggled(isOpened) {
        !isOpened && this.clearSearch();
    }

    addSelfToKendoGrid(grid) {
        this.grid = grid;

        const _addSelfToKendoGrid = () => {
            grid.gridContextMenu.insertBefore({
                id: `reorderServerFilter_${this.id}`,
                label: this.reorderLabel,
                onSelect: event => {
                    this.reorderFilterList();
                },
            }, 'resetColumns');
            this.orderPrefKey = `${grid.tableName}_serverFilterOrder_${this.id}`;
            const orderString = grid.getViewSvc().getAdditionalPref(this.orderPrefKey);
            try {
                this.orderMap = JSON.parse(orderString);
            } catch(e) {}
            if (!angular.isObject(this.orderMap)) {
                this.orderMap = {};
            }
        };

        if (grid.isBuildFinished()) {        	
           	 if(!this.gridReorderDisabled) {
        		 _addSelfToKendoGrid();
        	}
        } else {
            // Build has not finished, run _addSelfToKendoGrid after build finish
            const originalAfterGridInitialize = grid.callbacks.afterGridInitialize;
            grid.callbacks.afterGridInitialize = () => {
                  	 if(!this.gridReorderDisabled) {
               		 _addSelfToKendoGrid();
               	 }
                originalAfterGridInitialize.call(grid, { grid });
            };
        }
    }

    _dismissDropDown() {
        if (this.isOpen) {
            this.$timeout(() => {
                this.isOpen = false;
            });
        }
    }

    _onDestroy() {
        this.$scope.$on('$destroy', () => {
            $('.wrapper-view').off('scroll', this.dismissDropDown);
        });
    }
}

CVServerFilterController.$inject = ['$scope', 'cvLoc', '$sce', 'reorderService', 'userPrefService', '$timeout'];
cvCommonModule.directive('cvServerFilter', ['$interval', ($interval) => new CVServerFilter($interval)]);

export default cvCommonModule;