import { cvCommonModule } from "common/js/modules";
const MONITOR_TEMPLATE = `
<li class="monitor-noti-item-wrapper no-padding no-blick">
<a class="monitor-noti-item cv-flex space-between vertical-center full-width" data-ng-click="obj.onClick()" data-ng-href="{{obj.link}}" target="{{obj.target}}">
<div class="cv-flex vertical-center eventsIconSelector" data-ng-class="{'two-layer':obj.subtitle}">
    <span data-ng-if="type == 'job'" class="monitor-noti-icon monitoring-noti-svg margin-right-10" data-ng-bind-html="svg"></span>
    <span data-ng-if="type != 'job'" class="margin-right-10"><span class="{{obj.state}}"></span></span>
    <span class="monitor-noti-item-text" >
        <div class="noti-sub-text" data-ng-if="obj.subtitle" data-ng-bind="obj.subtitle"></div>
        <div class="noti-main-text crop" data-ng-bind="obj.title" title="{{obj.title}}"></div>
    </span>
</div>
<div data-ng-if="obj.info" class="monitor-noti-item-info crop " data-ng-class="{'optional-text': obj.subtitle}" data-ng-bind="obj.info"></div>
</a>
</li>`;

const FAILED_ICON = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10" fill="#fa0d0d"><path d="M9.1677,3.0623,6.9792.9294A.6282.6282,0,0,0,6.5413.751h-3.11a.6122.6122,0,0,0-.4359.1784L.8082,3.0584a.6347.6347,0,0,0-.1892.4508V6.507a.6267.6267,0,0,0,.1892.4468l2.1875,2.129a.6278.6278,0,0,0,.4359.1784H6.5424a.612.612,0,0,0,.4368-.1784l2.1865-2.129a.6272.6272,0,0,0,.1912-.4468V3.5092A.6277.6277,0,0,0,9.1677,3.0623ZM4.9929,2.43c.2655,0,.419.1367.419.4636v.001c0,.2725-.08.959-.1852,1.9814L5.1276,5.8868H4.8552L4.7561,4.8763c-.109-1.0244-.1922-1.7119-.1922-1.9814C4.5639,2.5719,4.7274,2.43,4.9929,2.43ZM4.99,7.5819a.48.48,0,1,1,.48-.4795A.4835.4835,0,0,1,4.99,7.5819Z" transform="translate(0.0121 -0.0061)"/></svg>`;
const INFO_ICON = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10" fill="#2f4f66"><path d="M8.31 1.8l-.07-.07A4.44 4.44 0 0 0 5.13.46h-.24a4.46 4.46 0 0 0-3.1 1.26l-.1.09a4.46 4.46 0 0 0 0 6.39l.08.08a4.46 4.46 0 0 0 3.11 1.26h.24a4.46 4.46 0 0 0 3.1-1.26l.1-.08a4.46 4.46 0 0 0 0-6.4zM5.25 7.5a.4.4 0 0 1-.3.1.36.36 0 0 1-.4-.37.4.4 0 0 1 .1-.28.38.38 0 0 1 .3-.11.4.4 0 0 1 .3.11.4.4 0 0 1 .1.28.38.38 0 0 1-.1.27zm1.18-3.3a1.99 1.99 0 0 1-.22.4 2.54 2.54 0 0 1-.31.38 6.2 6.2 0 0 1-.34.31 1 1 0 0 0-.16.2.8.8 0 0 0-.09.18.84.84 0 0 0-.03.2v.25h-.66v.01a3.67 3.67 0 0 1 .02-.41.94.94 0 0 1 .07-.3.96.96 0 0 1 .17-.24l.28-.28.24-.25a3.03 3.03 0 0 0 .23-.27 1.52 1.52 0 0 0 .17-.3.88.88 0 0 0 .06-.33.74.74 0 0 0-.22-.58.92.92 0 0 0-.63-.2 1.28 1.28 0 0 0-.32.03.82.82 0 0 0-.28.13.62.62 0 0 0-.26.53H3.5a1.16 1.16 0 0 1 .13-.53 1.14 1.14 0 0 1 .32-.4 1.47 1.47 0 0 1 .47-.25 1.95 1.95 0 0 1 .6-.08 2.11 2.11 0 0 1 .63.09 1.28 1.28 0 0 1 .47.26 1.14 1.14 0 0 1 .3.41 1.48 1.48 0 0 1 .1.56 1.28 1.28 0 0 1-.09.47z"/></svg>`;
const WARN_ICON = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10" fill="#febc11"><path d="M9.3 9.06H.7a.34.34 0 0 1-.29-.16.34.34 0 0 1 0-.34l4.3-7.45a.33.33 0 0 1 .58 0l4.3 7.45a.34.34 0 0 1 0 .34.34.34 0 0 1-.29.16zM5 7a.48.48 0 0 0-.48.48.49.49 0 0 0 .48.44.48.48 0 0 0 .47-.48A.47.47 0 0 0 5 7zm0-4.23c-.28 0-.43.16-.43.47s.29 3 .29 3h.24s.29-2.79.29-3-.14-.47-.39-.47z"/></svg>`;
const RUNNING_ICON = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 200" fill="#1dd641"><path d="M193.89 110l-.7-8.28a5 5 0 0 0-4.86-4.61l-5.06-.11a36 36 0 0 0-4.21-8.3l2.76-4.15a5 5 0 0 0-.9-6.65l-6.35-5.36a5 5 0 0 0-6.69.18l-3.5 3.28a36.64 36.64 0 0 0-9.38-3l-1-4.83a5.06 5.06 0 0 0-5.36-4l-8.28.7a5.06 5.06 0 0 0-4.62 4.86l-.16 4.91a36.25 36.25 0 0 0-8.92 4.7l-4.19-2.78a5 5 0 0 0-6.63.94l-5.36 6.39a5 5 0 0 0 .18 6.69l3.67 3.91a37.34 37.34 0 0 0-2.7 8.94l-5.24 1.07a5.07 5.07 0 0 0-4 5.36l.7 8.28a5.06 5.06 0 0 0 4.86 4.62l5.66.18a37 37 0 0 0 4 7.65l-3.16 4.78a5 5 0 0 0 1 6.63l6.34 5.36a5 5 0 0 0 6.69-.18l4.15-3.89a36.63 36.63 0 0 0 8.52 2.78l1.15 5.68a5.07 5.07 0 0 0 5.36 4l8.28-.71a5 5 0 0 0 4.62-4.85l.18-5.56a37.49 37.49 0 0 0 8.52-4.31l4.57 3a5 5 0 0 0 6.63-.95l5.36-6.35a5 5 0 0 0-.18-6.69l-3.69-3.9a36.63 36.63 0 0 0 2.91-9l5-1a5.06 5.06 0 0 0 4.03-5.43zm-45 25.48a26 26 0 1 1 26-26 26 26 0 0 1-25.97 26.02zm-36.15 13.01l-3.27-.43a30.12 30.12 0 0 0-2.76-7.05l2-2.5a5 5 0 0 0-.31-6.69l-3.56-3.64a5 5 0 0 0-6.69-.47l-2.44 1.88a29.85 29.85 0 0 0-7.33-3.19l-.33-3.16a5 5 0 0 0-5-4.51l-5.1-.06a5 5 0 0 0-4.95 4.39l-.4 3.14a30.68 30.68 0 0 0-7.6 3.1l-2.51-2.05a5 5 0 0 0-6.69.3l-3.67 3.59a5 5 0 0 0-.46 6.69l2.15 2.78a29.52 29.52 0 0 0-2.88 7l-3.54.39a5 5 0 0 0-4.52 5l-.06 5.1a5 5 0 0 0 4.39 5l3.75.49a29.5 29.5 0 0 0 2.66 6.51l-2.42 3a5 5 0 0 0 .31 6.69l3.56 3.64a5 5 0 0 0 6.69.47l3-2.32a29.4 29.4 0 0 0 6.69 2.92l.41 3.87a5 5 0 0 0 5 4.51l5.1.06a5 5 0 0 0 5.04-4.38l.46-3.67a29.89 29.89 0 0 0 7.25-2.82l2.82 2.28a5 5 0 0 0 6.69-.3l3.65-3.57a5 5 0 0 0 .46-6.69l-2.15-2.8a29.24 29.24 0 0 0 3.06-7.05l3.34-.34a5 5 0 0 0 4.52-5l.06-5.1a5 5 0 0 0-4.42-5.01zm-32.16 27.36a20.28 20.28 0 1 1 20.27-20.27 20.27 20.27 0 0 1-20.27 20.27z"/><path d="M112.9 51.35l-7.08-.82A44 44 0 0 0 101.55 40l4.36-5.5a5.1 5.1 0 0 0-.39-6.77L97 19.26a5.08 5.08 0 0 0-6.77-.39l-5.3 4.23a45 45 0 0 0-11.06-4.63l-.81-6.91a5.08 5.08 0 0 0-5-4.51H56a5.09 5.09 0 0 0-5.06 4.51l-.8 6.91a44.68 44.68 0 0 0-11.35 4.8l-5.54-4.4a5.11 5.11 0 0 0-6.77.39L18 27.76a5.08 5.08 0 0 0-.38 6.77l4.63 5.86A44.16 44.16 0 0 0 18 51l-7.41.85a5.09 5.09 0 0 0-4.52 5v12A5.1 5.1 0 0 0 10.61 74l7.81.91a46.27 46.27 0 0 0 4.09 9.71l-4.93 6.22a5.1 5.1 0 0 0 .42 6.77l8.5 8.5a5.08 5.08 0 0 0 6.77.39l6.19-4.9a44.78 44.78 0 0 0 10.09 4.27l.93 8a5.09 5.09 0 0 0 5.06 4.51h12a5.09 5.09 0 0 0 5.06-4.51l.89-7.68a45.12 45.12 0 0 0 10.82-4.37l6 4.74a5.1 5.1 0 0 0 6.77-.39l8.5-8.5a5.08 5.08 0 0 0 .39-6.77l-4.7-5.9a43.92 43.92 0 0 0 4.45-10.64l7.18-.83a5.08 5.08 0 0 0 4.51-5v-12a5.09 5.09 0 0 0-4.51-5.18zM62.31 95.49a33.07 33.07 0 1 1 33.07-33.07 33.08 33.08 0 0 1-33.07 33.07z"/></svg>`;
const PENDING_ICON = `<svg fill="#ffb100" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8.32 8.32"><path d="M3.81 5.2h.7v.7h-.7zm0-2.77h.7V4.5h-.7zM4.16.69a3.47 3.47 0 1 0 3.47 3.47A3.46 3.46 0 0 0 4.16.69zm0 6.24a2.77 2.77 0 1 1 2.77-2.77 2.77 2.77 0 0 1-2.77 2.77z"/></svg>`;
const COMPLETE_ICON = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8.3 8.3" fill="#1DD641"><path d="M4.2,0.7C4.2,0.7,4.2,0.7,4.2,0.7c-1.9,0-3.5,1.6-3.5,3.5c0,1.9,1.6,3.5,3.5,3.5c1.9,0,3.5-1.6,3.5-3.5C7.6,2.2,6.1,0.7,4.2,0.7z M4.2,6.9c-1.5,0-2.8-1.2-2.8-2.8c0-1.5,1.2-2.8,2.8-2.8c1.5,0,2.8,1.2,2.8,2.8C6.9,5.7,5.7,6.9,4.2,6.9z"/><polygon points="6.1,3.5 5.6,3 3.9,4.7 3.2,4 2.7,4.4 3.9,5.7 "/></svg>`;

const MonitoringNotif = [
    function() {
        return {
            restrict: 'E',
            template: MONITOR_TEMPLATE,
            replace:true,
            scope: {
                obj:'=',
                type: '@'
            },
            link: function(scope,ele,attr,ctrl) {
                switch(scope.obj.state) {
                    case 'failed': 
                    case 'critical':
                    		scope.svg = FAILED_ICON; break;
                    case 'info':
                    		scope.svg = INFO_ICON; break;
                    case 'warning': 
                    case 'major':
                    case 'minor':
                    		scope.svg = WARN_ICON; break;
                    case 'running': scope.svg = RUNNING_ICON; break;
                    case 'pending': scope.svg = PENDING_ICON; break;
                    case 'complete': scope.svg = COMPLETE_ICON; break;
                }
            }
        }
    }
]

cvCommonModule.directive('monitorNotiItem', MonitoringNotif);
export default cvCommonModule;
