const toggleTEMPLATE = `
<div class="cv-material-input-wrapper cv-toggle-wrapper " data-ng-class="{disabled: ctrl.isDisabled}" data-ng-click="ctrl.clickToggle();$event.preventDefault()">
    <input name="{{ctrl.toggleName}}" type="checkbox" data-ng-model="ctrl.toggleModel" class="hidden cv-toggle-check"/>
    <div class="cv-material-toggle cv-toggle" data-ng-class="{'isOff': !ctrl.toggleModel, 'isOn': ctrl.toggleModel}">
        <div class="cv-material-toggle-bar"></div>
        <div class="cv-material-toggle-round"></div>
    </div>
    <span class="cv-toggle-label" data-ng-if="ctrl.toggleLabel">
        <cv-help-text data-ng-if="ctrl.helpText || ctrl.helpTemplate" help-label="{{ctrl.toggleLabel}}" help-text="ctrl.helpText" ng-attr-help-direction="{{ctrl.helpDirection}}" help-time="ctrl.helpTime" help-template="{{ctrl.helpTemplate}}"></cv-help-text>
        <span data-ng-if="!ctrl.helpText && !ctrl.helpTemplate">{{ctrl.toggleLabel | localizedString}}</span>
    </span>
</div>
`;

class CvToggleDirective {
	constructor() {
		(this.restrict = 'E'),
			(this.template = toggleTEMPLATE),
			(this.bindToController = true),
			(this.replace = true),
			(this.controllerAs = 'ctrl'),
			(this.scope = {
				property: '=',
				onClick: '&',
				toggleLabel: '@',
				toggleName: '@',
				toggleModel: '=?',
				helpText: '=?',
				helpTime: '=?',
				helpTemplate: '@?',
				helpDirection: '@',
				isDisabled: '=',
				value: '='
			});
	}

	controller() {
		this.$onInit = () => {
			this.toggleModel = this.value === (this.property ? this.property.true : true);

			this.clickToggle = () => {
				this.toggleModel = !this.toggleModel;
				this.value = this.property ? this.property[this.toggleModel ? 'true' : 'false'] : this.toggleModel;

				if (this.onClick) {
					this.onClick({
						data: this.value
					});
				}
			};
		};
	}
}

export default ['cvToggle', () => new CvToggleDirective()];
