const radioTEMPLATE = `
<span class="cv-material-input-wrapper" data-ng-disabled="ctrl.isDisabled" data-ng-click="ctrl.clickRadio()">
    <input name="{{ctrl.radioName}}" type="radio" data-ng-model="ctrl.radioModel" data-ng-value="ctrl.value"/>
    <span data-ng-if="!ctrl.helpText" class="cv-material-label" data-ng-if="ctrl.radioLabel">{{ctrl.radioLabel | localizedString}}</span>
    <cv-help-text class="cv-material-label" data-ng-if="ctrl.helpText" help-label="ctrl.radioLabel" help-text="ctrl.helpText"></cv-help-text>
</span>
`;

class CvRadioButton {
    constructor() {
        this.restrict = "E",
            this.template = radioTEMPLATE,
            this.bindToController = true,
            this.controllerAs = 'ctrl',
            this.controller = CvRadiobuttonController,
            this.scope = {
                onClick: '&',
                radioLabel: '@',
                radioName: '@',
                isDisabled: '=',
                radioModel: '=',
                value: '=',
                helpText: '='
            }
    }

    link(scope, ele, attrs, ctrl) {
        scope.cvLoc = ctrl.cvLoc;
        if (!ctrl.value) {
            ctrl.value = "radioButton";
        }

        if (!attrs.radioName) {
            ctrl.radioName = "radioButton1";
        }
    }
}

class CvRadiobuttonController {
    constructor(cvLoc) {
        this.cvLoc = cvLoc;

    }

    clickRadio() {
        if (this.isDisabled) return;

        this.radioModel = this.value;
        if (this.onClick) this.onClick({
            data: this.value
        });
    }
}

CvRadiobuttonController.$inject = ['cvLoc'];
export default ['cvRadio', () => new CvRadioButton()];
