const RADIO_GROUP_TEMPLATE = `
<span class="cv-material-group-wrapper" data-ng-class="{vertical: ctrl.isVertical}" data-ng-disabled="ctrl.isDisabled">
    <span class="cv-material-input-wrapper" data-ng-repeat="obj in ctrl.radioObj track by $index" data-ng-disabled="obj.disabled" data-ng-click="ctrl.clickRadio(obj.value)">
        <input name="{{ctrl.radioName}}" type="radio" data-ng-model="ctrl.radioModel" data-ng-value="obj.value"/>
        <span data-ng-if="!obj.helpText" class="cv-material-label">{{obj.label | localizedString }}</span>
        <cv-help-text class="cv-material-label" data-ng-if="obj.helpText" help-label="{{obj.label}}" help-text="obj.helpText" help-direction="{{obj.helpDirection}}"></cv-help-text>
        <cv-call-out data-ng-if="obj.callOut" html-template="obj.callOut.template" label="{{obj.callOut.label}}" trigger="{{obj.callOut.trigger}}" placement="{{obj.callOut.placement}}"></cv-call-out>
    </span>
</span>
`;

class CvRadioBoxGroup {
    constructor() {
        this.restrict = "E",
        this.template = RADIO_GROUP_TEMPLATE,
        this.bindToController = true,
        this.controllerAs = 'ctrl',
        this.controller = CvRadioBoxGroupController,
        this.scope = {
            onClick: '&',
            radioName: '@',
            radioObj: '=',
            isDisabled: '=',
            radioModel: '=',
            isVertical: '@'
        }
    }

}

class CvRadioBoxGroupController {

    clickRadio(value) {
        this.radioModel = value;
        if (this.onClick) this.onClick({
            data: value
        });
    }
}

export default ['cvRadioGroup', () => new CvRadioBoxGroup()];
