const checkboxTEMPLATE = `
<div class="cv-material-input-wrapper cv-checkbox-wrapper"  data-ng-disabled="ctrl.isDisabled">
    <input type="checkbox" name="{{ctrl.checkboxName}}" id="{{ctrl.checkboxId}}" data-ng-model="ctrl.checkboxModel" data-ng-change="ctrl.clickCheckBox()" />
    <label for="{{ctrl.checkboxId}}" class="cv-material-label cv-checkbox-label">
        <span data-ng-if="!ctrl.helpText">{{ctrl.checkboxLabel | localizedString }} </span>
        <cv-help-text class="cv-material-label" data-ng-if="ctrl.helpText" help-label="{{ctrl.checkboxLabel}}" help-text="ctrl.helpText"></cv-help-text>
    </label>
</div>
`;

class CvCheckbox {
    constructor() {
        this.restrict = "E";
        this.template = checkboxTEMPLATE;
        this.bindToController = true;
        this.controllerAs = 'ctrl';
        this.controller = CvCheckboxController;
        this.scope = {
            checkClick: '&',
            checkboxLabel: '=',
            checkboxName: '@',
            checkboxId: '@',
            isDisabled: '=',
            checkboxModel: '=',
            helpText: '=',
            value: '='
        }
    }

    link(scope, ele, attrs, ctrl) {
        if(attrs.checkboxLabel && !ctrl.checkboxLabel) ctrl.checkboxLabel = attrs.checkboxLabel;
        if (!attrs.checkboxId) ctrl.checkboxId = "cvCheckbox-" + Math.random().toString(36).substr(2, 9);
        if (attrs.value && !ctrl.value) ctrl.value = attrs.value;
    }
}

class CvCheckboxController {
    constructor() {
    }

    clickCheckBox() {
        const obj = {
            'data': this.value,
            'state': this.checkboxModel
       };
       if(this.checkClick) this.checkClick({'data':obj});
    }
}

export default ['cvCheckbox', () => new CvCheckbox()];
