import ContextMenu from 'common/js/kendocontextmenu';
const app = angular.module('cvCommon');

const templateCommcell = `
<div id="commcell-setting-toggle" data-ng-show="ccCtrl.multiComcellList.length > 1" data-ng-click="ccCtrl.initializeDropdown()">
    <a class="header-menu-item use-before-pesudo">
        <span class="header-menu-small-size header-svg"><svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 25 25"><path d="M1.5 12.7l4.4-2.6 4.5 2.6v5.1l-4.5 2.6-4.4-2.6v-5.1zM6.5 4l4.4-2.6L15.4 4v5.1l-4.5 2.6-4.4-2.6V4zM22.5 18.5l1-.4a4.7 4.7 0 0 0-.8-2l-1 .4-.6-.6.4-1a4.7 4.7 0 0 0-2-.8l-.4 1h-.8l-.4-1a4.7 4.7 0 0 0-2 .8l.4 1-.6.6-1-.4a4.7 4.7 0 0 0-.8 2l1 .4v.8l-1 .4a4.7 4.7 0 0 0 .8 2l1-.4.6.6-.4 1a4.7 4.7 0 0 0 2 .8l.4-1h.8l.4 1a4.7 4.7 0 0 0 2-.8l-.4-1 .6-.6 1 .4a4.7 4.7 0 0 0 .8-2l-1-.4zM18.9 21a2.2 2.2 0 1 1 2.2-2.2 2.2 2.2 0 0 1-2.2 2.2zm1.4-2.2a1.4 1.4 0 1 1-1.4-1.4 1.4 1.4 0 0 1 1.3 1.4z"/><path d="M18.9 13l1.5.2v-.5L16 10.1l-4.4 2.6v5.1l1.6.9a5.8 5.8 0 0 1 5.7-5.7z"/></svg></span>
        <span class="header-menu-no-small-size crop">
            <span data-ng-show="ccCtrl.selectedCommcell.length === ccCtrl.multiComcellList.length" data-ng-bind="ccCtrl.labelAllCommcell"></span>
            <span data-ng-show="ccCtrl.selectedCommcell.length !== ccCtrl.multiComcellList.length">
                {{ccCtrl.selectedCommcell[0].CCHostName}}
                <span data-ng-show="ccCtrl.selectedCommcell.length > 1">({{ccCtrl.selectedCommcell.length-1}})</span>
            </span>
            <span class="k-icon k-i-arrow-60-down header-menu-arrow">
        </span>
    </a>
</div>
<ul id="commcell-setting-dropdown" class="header-dropdown">
    <li  data-ng-if="ccCtrl.isMultiCommcellAggregatedView">
        <a id="COMMCELL-ALL" data-context-menu-option="ALL" data-ng-bind="ccCtrl.selectAllLabel"></a>
    </li>
    <li data-ng-repeat="commcell in ccCtrl.multiComcellList track by $index" data-ng-class="{'check-selected':commcell.checked}">
        <a ng-attr-id="{{'Commcell-'+$index}}" data-context-menu-option="{{$index}}">
            <span data-ng-bind="commcell.label"></span>
        </a>
    </li>
</ul>
`


const CommcellSettingDropdown = [
    function () {
        return {
            restrict: 'E',
            template: templateCommcell,
            bindToController: true,
            controllerAs: 'ccCtrl',
            controller: ['cvLoc', 'settingsService', '$rootScope','$scope','cvMultiCommcell','$location','$state','cvUtil',
                function (cvLoc, settingsService, $rootScope, $scope, cvMultiCommcell, $location, $state, cvUtil) {
                    const ctrl = this;
                    this.$onInit = () => {
                        ctrl.multiComcellList = [];
                        ctrl.labelAllCommcell = cvLoc('label.multiCommCellDropdownDefaultName');
                        const allCommcells = {CCHostName: ctrl.labelAllCommcell, id: -1};
                        // click listener to kendo context menu
                        ctrl.onActionItemSelect = ({optionId,contextMenu}) =>{
                            if(!ctrl.isMultiCommcellAggregatedView) {
                                selectSingleCommcell(contextMenu, +optionId);
                                return;
                            }

                            let result = (optionId === 'COMMCELL-ALL') ? toggleAllSelection() : toggleSelection(optionId);
                            changeLabel(...result);
                            if(!ctrl.selectedCommcell.length){
                                result = toggleAllSelection(true);
                                changeLabel(...result);
                            } 
                            
                            ctrl.selectAllLabel = ctrl.selectedCommcell.length === ctrl.commcellData.length ? cvLoc('label.selectNone') : cvLoc('label.selectAll');
                            $scope.$apply();
                        }

                        // Toggle selected state UI when the commcell mode is not multiple
                        function selectSingleCommcell(menu, optionId) {
                            toggleAllSelection(false, optionId);

                            _.forEach(menu.element.children(), ({classList}, ind) => {
                                classList.remove('check-selected');
                                if (ind === optionId) classList.add('check-selected');
                            })
                            ctrl.selectedCommcell = [ctrl.commcellData[optionId]];
                            changeCommcell(ctrl.selectedCommcell);
                        }

                        // Toggle all commcell selection (select all / select current commcell)
                        function toggleAllSelection(val,commcell) {
                            let state = val;
                            if (_.isUndefined(state)) state = ctrl.selectedCommcell.length !== ctrl.commcellData.length;
                            const cInd = +commcell || ctrl.currentCommcellIndex;
                            ctrl.multiComcellList.forEach((obj,ind)=>{
                                toggleOneCommcell(ind, (ind === cInd) ? true : state);
                            });
                            return [state];
                        }

                        // Parse selected commcell id and change its state
                        function toggleSelection(id) {
                            const ind = id.split('Commcell-').pop();
                            const [obj,checked] = toggleOneCommcell(ind);
                            return [checked,obj];
                        }

                        // Toggle selected commcell state 
                        function toggleOneCommcell(ind,state) {
                            if(_.isUndefined(state) || ctrl.multiComcellList[ind].checked !== state) {
                                ctrl.multiComcellList[ind].checked = !ctrl.multiComcellList[ind].checked;
                                ctrl.multiComcellList[ind].cssClass = state ? 'check-selected' : '';
                            }

                            return [ctrl.commcellData[ind], ctrl.multiComcellList[ind].checked];
                        }

                        // Change label on the header to show selected commcell
                        function changeLabel(state,obj) {
                            
                            if(_.isUndefined(obj)){
                                ctrl.selectedCommcell = state ? ctrl.commcellData : [ctrl.commcellData[ctrl.currentCommcellIndex]];
                                return;
                            }

                            if(state) ctrl.selectedCommcell.push(obj);
                            else ctrl.selectedCommcell = ctrl.selectedCommcell.filter(({id})=>obj.id !== id);
                            
                        }
                        
                        // When the commcell selection is finalized, it change the commcell setting & refresh the page to load data with new commcell setting.
                        function changeCommcell(arr) {
                            if(_.isEqual(ctrl.oriSelectedCommcell,arr)){
                                ctrl.changedCommcell = false;
                                return;
                            }
                            const cnParameter = arr.map(({CCHostName})=>CCHostName);
                            settingsService.clearCache();

                            //set cvMultiCommcell 
                            cvMultiCommcell.setselectedCClength(cnParameter.length);
                            cvMultiCommcell.setSelectedCommcell(cnParameter);
                            cvMultiCommcell.setMultiSelection(cnParameter > 1);
                            
                            ctrl.changedCommcell = true;
                            ctrl.oriSelectedCommcell = [...arr];
                            $state.go('.',{'companyId': undefined, '_cn':cnParameter.length === 1 ? `${cnParameter}` : undefined}, {
                                location: true,
                                reload: true,
                                notify: true
                            });

                            // $rootScope.$broadcast("CHANGE_COMMCELL", {});
                        }

                        // Replace all a tag's link following commcell setting
                        function resetAtag(cnParameter) {
                            const eles = document.querySelectorAll("a[href]");
                            eles.forEach((node)=>{
                                const href = node.getAttribute('href');
                                if(href === '#' || !href.length || href === "javascript:void(0);") return;
                                let new_href = '';
                                if(cnParameter.length === 1) {
                                    //remove _cn
                                    if(cvUtil.getParameterByName('_cn',href) !=='') {
                                        new_href = href.replace(/(_cn=)[^\&]+/, '$1' + cnParameter);
                                    }else {
                                        const append = href.indexOf('?') > -1 ? '&' : '?';
                                        new_href = `${href}${append}_cn=${cnParameter}`; 
                                    }
                                }else {
                                    new_href = cvUtil.removeParamsFromURLString('_cn',href);
                                }
                                node.setAttribute('href',new_href);

                            })
                        }

                        ctrl.initializeDropdown = () =>{
                            if (ctrl.commcellMenu) return;
                            ctrl.inializeContextmenu();
                            ctrl.commcellMenu.open();
                        }

                        // When the commcell option is multiple, it prevent the dropdown from closing when an item is selected
                        ctrl.preventClose = (event) =>{
                            if(!event.event) event.preventDefault();
                            else if(ctrl.isMultiCommcellAggregatedView) changeCommcell(ctrl.selectedCommcell);
                        }

                        // Change url & a tag with the commcell setting change
                        function locationChangeSuccess(evt) {
                            let optionId = [];

                            let paramObj = $location.search();
                            paramObj = _.isEmpty(paramObj['_cn']) ? [] : window.decodeURIComponent(paramObj['_cn']).split(',');
                            if (!ctrl.changeCommcell && paramObj.length) {
                                let idList = [];
                                let isValid = _.every(paramObj,(name)=>{
                                    const id = ctrl.commcellData.findIndex(({CCHostName}) => CCHostName === name);
                                    idList.push(id);
                                    return id > -1;
                                });

                                if(isValid) {
                                    if (idList.length === 1 && ctrl.oriSelectedCommcell[0].id === ctrl.commcellData[idList[0]].id) isValid = false;
                                    else if (idList.length > 1 && !ctrl.isMultiCommcellAggregatedView) isValid = false;
                                }

                                if (isValid) optionId = idList;
                            }

                            if(!optionId.length) {
                                $location.search('_cn', ctrl.oriSelectedCommcell.length === 1  ? ctrl.oriSelectedCommcell[0].CCHostName : null);
                            }else if(optionId.length === 1) {
                                selectSingleCommcell(ctrl.commcellMenu, ...optionId);
                            }else {
                                ctrl.selectedCommcell = [];
                                for(let ind of optionId) {
                                    const result = toggleSelection(ind);
                                    changeLabel(...result);
                                }
                                changeCommcell(ctrl.selectSingleCommcell);
                                $location.search('_cn', null);
                            }

                            resetAtag(ctrl.oriSelectedCommcell.map(({CCHostName})=>CCHostName));
                        }

                        ctrl.inializeContextmenu = function() {
                            const options = {
                                target: '#commcell-setting-toggle',
                                showOn: 'click touch',
                                cssClass: 'header-dropdown commcell-setting-dropdown',
                                onSelect: ctrl.onActionItemSelect,
                                options: ctrl.multiComcellList
                            }

                            if(ctrl.isMultiCommcellAggregatedView){
                                delete options.options;
                                options.onClose = ctrl.preventClose;
                                options.element = $("#commcell-setting-dropdown");
                            }
                            

                            ctrl.commcellMenu = new ContextMenu(options);
                            ctrl.commcellMenu.build();
                        }

                        ctrl.init = function() {
                            ctrl.commcellData = _.get(cv, 'sessionContext.dataSourceList', []);
                            if (ctrl.commcellData.length < 2) return;
                            ctrl.commcellData.forEach((obj) => obj.checked = obj.id === +cv.ccId);
                            ctrl.currentCommcellIndex = ctrl.commcellData.findIndex(({id})=>id === +cv.ccId);
                            ctrl.oriSelectedCommcell = ctrl.commcellData.filter(({checked})=>checked);
                            ctrl.isMultiCommcellAggregatedView = _.get(cv, 'additionalSettings.AdminConsole.multiCommCellAggregatedView',false);
                            ctrl.selectAllLabel =  ctrl.isMultiCommcellAggregatedView ? cvLoc('label.selectNone') : cvLoc('label.selectAll');
                            if(ctrl.isMultiCommcellAggregatedView) ctrl.oriSelectedCommcell = ctrl.commcellData;
                            ctrl.selectedCommcell = [...ctrl.oriSelectedCommcell];
                            ctrl.multiComcellList = ctrl.multiComcellList.concat(ctrl.commcellData .map(({CCHostName,checked},ind)=>({
                                id: ind,
                                label: `${cvLoc('label.nav.commCell')}- ${CCHostName}`,
                                cssClass: checked ? 'check-selected' : '',
                                checked : checked || ctrl.isMultiCommcellAggregatedView
                            })));

                            $scope.$on('$locationChangeSuccess',locationChangeSuccess);
                        }

                        ctrl.init();
                        if (!ctrl.isMultiCommcellAggregatedView) ctrl.inializeContextmenu();
                    };
                }
            ]
        }
    }
]

app.directive('commcellsettingDropdown', CommcellSettingDropdown)
export default app;