var element;
var tokenTitleData = {text:"Token",value:""};
export function createTokenDropDown(elem, cvLoc, editor) {
	var blankData = [
		{text: cvLoc('editor.token'), value: ''}
	];

	element = elem;
	element.kendoDropDownList({
		dataSource: blankData,
		dataTextField: "text",
		dataValueField: "value",
		change: onDropDownChange,
		close: onDropDownClose,
		open: onTokenToolDropdownOpen,
		dataBound: onTokenToolDataBound
	});


	function onDropDownChange(e) {
		// insert the selected token
		editor.exec("inserthtml", { value: e.sender.value() });
	}

	function onDropDownClose(e) {
		// reinsert and select the "Token" title
		e.sender.dataSource.insert(0, tokenTitleData);
		element.data("kendoDropDownList").select(0);
	}

	function onTokenToolDropdownOpen(e) {
		// prevent the word "Token" from displaying in the dropdown list
		e.sender.dataSource.remove(e.sender.dataSource.at(0));
		var x = element.data("kendoDropDownList").wrapper.find(".k-input");
		x.html(tokenTitleData.text);
	}

	function onTokenToolDataBound() {
		$(this.items()).each(function(index, item) {
	        var model = element.data("kendoDropDownList").dataItem(index);
	        if (model.title) {
	        	$(item).attr("title", model.title);
	        }
	    });
	}

}

export function getAndProcessTokens(data, getTokens, processTokens) {
	var tokenPromise = getTokens(data);
	tokenPromise.then(function(result){
		var processedTokens = processTokens(result);
		setTokens(processedTokens);
	});
}
export function setTokens(tokenData) {
	tokenData.unshift(tokenTitleData); // The dropdown always displays the word "Token"
	var ds = new kendo.data.DataSource({data : tokenData});
	var dropdownlist = element.data("kendoDropDownList");
	dropdownlist.setDataSource(ds);
}
