import EventEmitter from 'eventemitter3';
import CvWizardEvent from 'common/js/directives/cv-wizard/cvWizardEvent.js';

/**
 * This class represents the data structure and logic of a wizard.
 */
export default class CvWizardStep extends EventEmitter {
	/**
	 * 
	 * @param {Object} options The config
	 * @param {string} [options.id] The unique id of this step
	 * @param {string} [options.title]
	 * @param {boolean} [options.completed=false]
	 * @param {boolean} [options.active=false]
	 */
	constructor(options) {
		super();
		this.id = options.id || _.uniqueId('CvWizardStep');
		this._title = options.title || "";
		this._completed = !!options.completed;
		// TODO support hiding steps
		this._active = false;
	}
	
	_emitEvent(type, oldStepId, newStepId) {
		this.emit(type, new CvWizardEvent(type, {
			oldStepId,
			newStepId,
		}));
	}
	
	enter(oldStepId) {
		this._active = true;
		this._emitEvent(CvWizardStep.EVENT.STEP_ENTER, oldStepId, this.getId());
	}
	
	leave(newStepId) {
		this._emitEvent(CvWizardStep.EVENT.STEP_LEAVE, this.getId(), newStepId);
		this._active = false;
	}
	
	getId() {
		return this.id;
	}
	
	getTitle() {
		return this._title;
	}
	
	isActive() {
		return this._active;
	}
	
	isCompleted() {
		return this._completed;
	}
	
	setCompleted(completed) {
		this._completed = completed;
	}
};
Object.defineProperty(CvWizardStep, 'EVENT', {
	writable: false,
	value: Object.freeze({
		STEP_ENTER: 'stepEnter',
		STEP_LEAVE: 'stepLeave',
		STEP_DESTROY: 'stepDestroy',
	}),
});
