export default class CvWizardEvent {
    constructor(type, details, cancelable=false) {
        this.type = type;
        this.details = details;
        this.cancelable = cancelable;
        this._defaultPrevented = false;
    }

    isDefaultPrevented() {
        return this._defaultPrevented;
    }

    preventDefault() {
        if (!this.cancelable) {
            return;
        }
        this._defaultPrevented = true;
    }
};
