import 'common/js/directives/cv-wizard/cv-wizard-button.directive.js';
import { cvCommonModule } from "common/js/modules";
import CvWizardStep from 'common/js/directives/cv-wizard/cvWizardStep.js';

export class CvWizardStepDirective {
    constructor() {
        this.restrict = 'E';
        this.templateUrl = appUtil.appRoot + 'adminConsole/partials/cvWizardStep.jsp';
        this.require = '^cvWizard';
        this.bindToController = true;
        this.controller = CvWizardStepController;
        this.controllerAs = 'wizStepCtrl';
        this.scope = {
            id: '@?cvId',
            templateUrl: '@?cvTemplateUrl',
            controllerName: '@cvController',
            controllerAs: '@cvControllerAs',
            title: '@cvTitle',
            completed: '=?cvCompleted',
        };
    }
    
    link(scope, element, attrs, wizCtrl) {
        const wizStepCtrl = scope.wizStepCtrl;

        wizStepCtrl.wizard = wizCtrl.wizard;
        wizStepCtrl.wizardId = wizCtrl.wizard.getId();
        
        // We manually add these attributes here instead of through the .jsp so
        // that these attributes will be in place by the time
        // wizCtrl.refreshStepOrder() is called
        const stepElement = element.find('.cv-wizard-step');
        stepElement.attr('id', wizStepCtrl.step.getId());
        stepElement.attr('cv-wizard-step-parent', wizStepCtrl.wizardId);
        wizStepCtrl.stepElement = stepElement;
        
        // Compile the step
        const locals = wizCtrl.createStepControllerLocals(wizStepCtrl.step);
        wizStepCtrl.compile(element, locals.scope, locals.stepServiceInstance);
        
        // Add self to the wizard
        wizStepCtrl.wizard.addStep(wizStepCtrl.step);
        wizCtrl.refreshStepOrder();
    }
};

export class CvWizardStepController {
    static $inject = ['$scope', '$compile'];
    constructor($scope, $compile) {
        this.$scope = $scope;
        this.$compile = $compile;
        
        this.hiddenDefaultButtonTypes = new Set();
    }
    
    $onInit() {
        if (!this.id) {
            this.id = _.uniqueId('CvWizardStep');
        }
        this.step = new CvWizardStep({
            id: this.id,
            title: this.title,
            completed: this.completed, // TODO bind
        });
        
        this.$scope.$on('$destroy', () => {
            // Remove the cv-wizard-step-parent attribute to prevent the step
            // from being picked up by the cv-wizard's refreshStepOrder function
            this.stepElement.removeAttr('cv-wizard-step-parent');
            this.stepServiceInstance._deregisterWizardListeners();
            this.$scope.$emit(CvWizardStep.EVENT.STEP_DESTROY, {
                wizardId: this.wizardId,
                stepId: this.id,
            });
        });
    }
    
    /**
     * Compiles the step using the specified controller and templateUrl. The
     * stepServiceInstance will be exposed on the scope
     * @param {Element} element 
     * @param {Object} stepContentScope 
     * @param {CvWizardStepInstanceService} stepServiceInstance 
     */
    compile(element, stepContentScope, stepServiceInstance) {
        this.stepServiceInstance = stepServiceInstance;
        // Add the stepServiceInstance to the step scope:
        stepContentScope.$cvWizardStepInstance = stepServiceInstance;
        
        let controllerExpression = this.controllerName;
        if (controllerExpression && this.controllerAs) {
            controllerExpression += ` as ${this.controllerAs}`;
        }
        let stepTemplate = `
            <ng-controller ng-controller="${controllerExpression}">
                <ng-include src="'${this.templateUrl}'"></ng-include>
            </ng-controller>
        `;
        // TODO inject $cvWizardStepInstance as a service
        const compiledStep = this.$compile(stepTemplate)(stepContentScope);
        element.find('.cv-wizard-step-content').first().append(compiledStep);
    }
    
    hideDefaultButton(type) {
        this.hiddenDefaultButtonTypes.add(type);
    }
    
    isDefaultButtonHidden(type) {
        return this.hiddenDefaultButtonTypes.has(type);
    }
    
    isActive() {
        return this.step.isActive();
    }
    
    isSkippingEnabled() {
        return this.wizard.isSkippingEnabled();
    }
    
    isFirstStep() {
        const firstStep = this.wizard.getFirstStep();
        if (!firstStep) {
            return true;
        }
        return firstStep.getId() === this.step.getId();
    }
    
    isLastStep() {
        const lastStep = this.wizard.getLastStep();
        if (!lastStep) {
            return false;
        }
        return lastStep.getId() === this.step.getId();
    }
};

cvCommonModule.directive('cvWizardStep', () => new CvWizardStepDirective());
