const cvTileEditTEMPLATE = `
<div class="pageDetailColumn inline-editor" data-ng-disabled="ctrl.isDisabled || ctrl.isProcess">
<div class="inline-editor-input">
<span data-ng-class="{hidden: ctrl.isEditmode}" class="crop" data-ng-bind="ctrl.value" ></span>
<span class="full-width" data-ng-class="{hidden: !ctrl.isEditmode, 'error-input': ctrl.hasError }" data-ng-transclude></span>
<div class="grid-tile-accordion-more error no-padding" data-ng-if="ctrl.hasError">{{ctrl.errorMsg | localizedString}}</div>
</div>
<span>
    <span data-ng-class="{hidden: ctrl.isEditmode || !ctrl.enableEdit}" class="cv-flex">
        <a data-ng-if="!ctrl.noInlineEdit" class="inline-editor-button inline-pencil cv-flex vertical-center horizontal-center" data-ng-click="ctrl.toggleEdit()">
        <svg width="16px" height="16px" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a1 1 0 0 0 0-1.41l-2.34-2.34a1 1 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/></svg>
        </a>
        <a data-ng-if="ctrl.noInlineEdit" class="inline-editor-button" data-ng-click="ctrl.editFunc()"><span class="k-icon k-i-gear"></span></a>
    </span>
    <span data-ng-class="{hidden: !ctrl.isEditmode}" class="cv-flex">
        <a class="inline-editor-button" data-ng-click="ctrl.closeEdit()"><span class="k-icon k-i-close"></span></a>
        <a class="inline-editor-button" data-ng-click="ctrl.saveEdit()"><span  class="k-icon k-i-check"></span></a>
    </span>
</span>
</div>
`

class CvTileEdit {
    constructor(){
        this.restrict = 'E';
        this.template = cvTileEditTEMPLATE;
        this.replace = true;
        this.bindToController = true;
        this.controller = CvTileEditController;
        this.controllerAs = 'ctrl';
        this.transclude = true;
        this.scope = {
            value: '=',
            isDisabled: '=?',
            noInlineEdit:'=?',
            editFunc:'&?',
            enableEdit:'=?'
        }
    }

    link(scope,attr,ele,ctrl){
        ctrl.init();
    }
}

class CvTileEditController {
    constructor($q, cvLoc) {
        this.$q = $q;
        this.cvLoc = cvLoc;
    }

    init() {
    	if(_.isUndefined(this.enableEdit)) this.enableEdit = true;
    	if(_.isUndefined(this.value) || this.value === "" ) this.value = this.cvLoc('label.noDataAvailable');
    }

    toggleEdit() {
        this.isEditmode = !(this.isEditmode || false);
    }

    saveEdit() {
        const self = this;
        self.hasError = false;
        self.isProcess = true;
        if (_.isFunction(self.editFunc)) {
            self.$q((resolve)=>{
                resolve(self.editFunc());
            }).then((val)=>{
                if (_.isUndefined(val) || val === true || val.status === 200) self.isEditmode = !self.isEditmode;
                else self.changeErrorstate(val);
            }).catch(val => self.changeErrorstate(val.statusText)).finally(() => {
                self.isProcess = false;
            })
        }else {
            self.isEditmode = !self.isEditmode;
            self.isProcess = false;
        }
    }

    changeErrorstate(msg) {
        this.hasError = true;
        this.errorMsg = 'generic_error';
        if (typeof msg === 'string') this.errorMsg = msg;
    }

    closeEdit() {
        this.isEditmode = !this.isEditmode;
        this.hasError = false;
    }
}

CvTileEditController.$inject = ['$q', 'cvLoc'];
export default ['cvTileEdit', () => new CvTileEdit()];