var cvCommon = angular.module('cvCommon');

/**
 * This directive is to be used for having dropdown with create button next to it *
 * 
 * @param {list}
 *            selectedOption:result where seelcted list is stored
 * @param {string}
 *            onClickCreateButton:function to be triggered when new button is clicked
 * @param {list}
 *            optionList:data used for displaying multi select
 * @param {string}
 *            buttonLabel:Display name of button for creating new data
 * 
 */

cvCommon.directive('selectWithCreate',['cvUtil','cvLoc', function (cvUtil,cvLoc) {
  return {
    restrict: 'E',
    templateUrl: appUtil.appRoot + 'common/partials/selectWithCreateButton.jsp',
    scope: {
      'selectedOption': '=',
      'optionList': '=',
      'isRequired': '=',
      'hasError': '=',
      'onClickCreateButton': '=',
      'keyLabel': '@',
      'keyId': '@',
      'placeholder': '@',
      'selectId': '@',
      'selectName': '@',
      'selectDisabled': '=',
      'buttonLabel': '@',
      'credLang':'=',
      'formName':'=',
      'istevenName':'=',
      'requiredErrorMessage':'@'
    },
    link : function(scope, ele, attrs) {

      scope.buttonLabel=scope.buttonLabel||cvLoc('createNew');
      scope.keyLabel = scope.keyLabel || 'label';
      scope.keyId = scope.keyId || 'id';
      //scope.localLang = cvUtil.getIStevenLocLabels();
      //scope.localLang.nothingSelected = scope.placeholder;

      scope.handlerOpenCreateModal = () => {
        scope.onClickCreateButton && scope.onClickCreateButton();
      }
      

      
    }
  }
}]);
