import { cvCommonModule } from 'common/js/modules';

const HelpTextTEMPLATE = `
<span aria-labelledby= "{{ctrl.helpLabelText}}" aria-describedby="{{ctrl.helpText | localizedString}}">
    <span data-ng-if="!ctrl.useIcon" uib-tooltip="{{ctrl.helpText | localizedString}}" uib-tooltip-template="{{ctrl.helpTemplate}}" tooltip-class="cv-help-text" tooltip-placement="{{ctrl.helpDirection || 'right'}}" tooltip-popup-close-delay="{{ctrl.helpTime}}" >
        <span class="help-label" ng-bind="ctrl.helpLabelText"></span>
    </span>
    <span data-ng-if="ctrl.useIcon" class="has-icon">
        <span class="help-label" ng-bind="ctrl.helpLabelText"></span>
        <span class="help-icon" data-ng-if="ctrl.useIcon" uib-tooltip="{{ctrl.helpText | localizedString}}" uib-tooltip-template="{{ctrl.helpTemplate}}" tooltip-class="cv-help-text" tooltip-placement="{{ctrl.helpDirection || 'right'}}"  tooltip-popup-close-delay="{{ctrl.helpTime}}" >
            <span data-ng-class="{'glyphicon glyphicon-info-sign': !ctrl.helpIcon, 'glyphicon {{ctrl.helpIcon}}' : ctrl.helpIcon}"></span>
        </span>
    </span> 
</span>`;

class cvHelpText {
	constructor() {
		(this.bindToController = true), (this.controllerAs = 'ctrl');
		(this.scope = {
			useIcon: '@',
			helpIcon: '@',
			helpDirection: '@',
			helpLabel: '@',
			helpLabelLocalized: '@',
			helpText: '=?',
			helpTime: '=?',
			helpTemplate: '@?'
		}),
			(this.template = HelpTextTEMPLATE);
		this.controller = cvHelpTextController;
	}
	link(scope, ele, attrs, ctrl) {
		if (_.isUndefined(ctrl.helpText)) {
			ctrl.helpText = attrs.helpText;
		}
	}
}

class cvHelpTextController {
	constructor($scope, cvUtil) {
		this.$onInit = () => {
			this.helpTime = this.helpTime || 1000;
			this.useIcon = this.useIcon ? true : !_.isUndefined(this.helpIcon);
			this.helpLabelText = this.helpLabelLocalized
				? this.helpLabelLocalized
				: cvUtil.getLocalizedString(this.helpLabel);
		};
	}
}

cvHelpTextController.$inject = ['$scope', 'cvUtil'];

cvCommonModule.directive('cvHelpText', () => new cvHelpText());
export default cvCommonModule;
