//import { acAppUsersModule } from "common/js/modules";
//import { cvCommonModule } from "common/js/common";
//var cvCommon = cvCommonModule;
var cvCommon = angular.module('cvCommon');

var compareTo = function() {
	return {
		require : "ngModel",
		scope : {
			otherModelValue : "=cvCompareTo"
		},
		link : function(scope, element, attributes, ngModel) {

			ngModel.$validators.cvCompareTo = function(modelValue) {
				return modelValue == scope.otherModelValue;
			};

			scope.$watch("otherModelValue", function() {
				ngModel.$validate();
			});
		}
	};
};

cvCommon.directive("cvCompareTo", compareTo);
/**
 * This directive is to be used for username and password UI component
 *
 * @param {boolean}
 *            isEdit - Optional parameter.
 * @param {boolean}
 *            isOptional - Optional parameter. If set to true, username, password and confirmPassword fields
 *            will not be validated
 * @param {string}
 *            passwordComplexity - Optional parameter. It can take values as 1, 2 or 3. 1 refers to no
 *            Complexity level none. 2 refers to complexity level medium. 3 refers to complexity level high.
 *            Refer cvCommon constant PASSWORD_COMPLEXITY_LEVEL It will override the complexity level set at
 *            the CommCell level. If this parameter is not provided and at commcell level too the setting is
 *            not found, complexity level will default to 1.
 * @param {object}
 *            userNameInfo - optional parameter to customize username and password labels and also to convey
 *            if username is email. In such case email validation kicks in. Sample value of this parameter is
 *            like below $scope.userNameInfo = { 'label' : cvLoc('label.cloudEmail'), 'requiredError' :
 *            cvLoc('error.validEmailAddress'), 'type' : 'Email', 'passwordLabel' : cvLoc('label.newPassword') };
 *
 *
 * @param {boolean}
 *            validateOnBlur - optional parameter. Default value is false. If set to true, validation for
 *            username/email, password and confirm password will happen on blur instead of when the model is
 *            dirty (i.e. as and when user types in). Validation on form submit will continue to work as
 *            before.
 *
 *
 *
 *
 */
cvCommon
		.directive(
				'cvCredentialDirective',
				[
						'cvLoc',
						'REGEX',
						'PASSWORD_COMPLEXITY_LEVEL',
						function(cvLoc, REGEX, PASSWORD_COMPLEXITY_LEVEL) {
							return {
								restrict : 'E',
								templateUrl : cv.contextPath + '/common/partials/cv-credential-template.jsp',
								scope : {
									credentials : '=',
									formName : '=',
									isEdit : '=?',
									needConfirm : '=?',
									inputName : '=?',
									isOptional : '=?',
									isPasswordOptional : '=?',
									rowClass : '@',
									passwordComplexity : '@',
									userNameInfo : '=',
									passwordRequiredOnEdit : '=?',
									validateOnBlur : "@",
									labelClass: '=',
									inputClass: '='
								},
								link : function($scope, ele, attrs) {
									//TO DO: need to check bootstrapper
									const isNotEmpty = function(value) {
										return angular.isDefined(value) && value !== null && value.length > 0;
									}

									const defaultInputName = [ 'username', 'password', 'confirmPassword' ];

									if (!attrs.inputName) {
										$scope.inputName = angular.copy(defaultInputName);
									}
									if ($scope.isEdit === undefined) {
										$scope.isEdit = isNotEmpty($scope.credentials[$scope.inputName[0]]);
									}
									if (!attrs.isOptional) {
										$scope.isOptional = false;
									}
									if (!attrs.rowClass) {
										$scope.rowClass = false;
									}
									if (!attrs.needConfirm) {
										$scope.needConfirm = true;
									}
									if(!attrs.isPasswordOptional) {
										$scope.isPasswordOptional = false;
									}
									if (!attrs.validateOnBlur) {
										$scope.validateOnBlur = false;
									}
									if($scope.passwordRequiredOnEdit === undefined)
										$scope.passwordRequiredOnEdit = false;





									$scope.passwordKeep = $scope.isEdit && ((!$scope.passwordRequiredOnEdit && !$scope.isOptional) || $scope.isPasswordOptional)  ? cvLoc('label.passwordKeep') : '';

									$scope.isPasswordRequired = $scope.passwordKeep === '' && !$scope.isPasswordOptional;

									const setPasswordComplexity = function() {
										//No need to validate password in either of the below two conditions. Hence set the level to none
										//1. if password fields are optional
										//2. if in edit mode without any changes to the password or confirm password input

										//Default complexity level is none
										$scope.complexity = PASSWORD_COMPLEXITY_LEVEL.NONE;
										//No need to find and set complexity if credentials are optional. IN that case default none will not enforce any pattern checks
										if (!($scope.isOptional)) {
											if ($scope.passwordComplexity === PASSWORD_COMPLEXITY_LEVEL.NONE
													|| $scope.passwordComplexity === PASSWORD_COMPLEXITY_LEVEL.MEDIUM
													|| $scope.passwordComplexity === PASSWORD_COMPLEXITY_LEVEL.STRONG) {
												$scope.complexity = $scope.passwordComplexity;
											}
											//if param is not supplied, set it based on CommCell setting
											else if (cvApp && cvApp.globalParams
													&& cvApp.globalParams.passwordComplexityLevel) {
												$scope.complexity = cvApp.globalParams.passwordComplexityLevel;
											}
										}

										if ($scope.complexity == PASSWORD_COMPLEXITY_LEVEL.MEDIUM) {
											$scope.passwordPatternError = cvLoc('error.passwordComplexityMedium');
										} else if ($scope.complexity == PASSWORD_COMPLEXITY_LEVEL.STRONG) {
											$scope.passwordPatternError = cvLoc('error.passwordComplexityStrong');
										}
									}
									setPasswordComplexity();

									var updateEmailPattern;
									$scope.emailPattern = (updateEmailPattern = function() {
										var regexp = REGEX.EMAIL;
										return {
											test : function(value) {
												//email pattern validation should be done only when the field is not optional and when type is email
												if ($scope.isOptional === false && $scope.userNameInfo
														&& $scope.userNameInfo.type === 'Email') {
													return regexp.test(value);
												}
												return true;
											}
										};
									})();

									var updatePasswordPattern;
									$scope.passwordPattern = (updatePasswordPattern = function() {
										var regexp = REGEX.PASSWORD_COMPLEXITY[$scope.complexity];
										return {
											test : function(value) {
												//on ng-change, required validation is applied or ignored.
												//Pattern validation should be applied only if required validation is applicable.
												if ($scope.isOptional === true) {
													return true;
												}
												//In edit mode if both the password fields are empty, there is no need to validate password
												if ($scope.isEdit
														&& !(isNotEmpty($scope.credentials[$scope.inputName[1]]) || isNotEmpty($scope.credentials[$scope.inputName[2]]))) {
													return true;
												}

												return regexp.test(value);
											}
										};
									})();

									const ignorePasswordsValidation = function() {
										$scope.isPasswordRequired = false;
										$scope.passwordPattern = updatePasswordPattern();
									}

									const applyPasswordsValidation = function() {
										$scope.isPasswordRequired = !$scope.isPasswordOptional;
										$scope.passwordPattern = updatePasswordPattern();
									}

									const updatePwdValidationAndPlaceHolder = function() {

										if ($scope.isOptional) {
											ignorePasswordsValidation();
											return;
										}

										var passwordsModified = isNotEmpty($scope.credentials[$scope.inputName[1]])
												|| isNotEmpty($scope.credentials[$scope.inputName[2]]);
										if (!$scope.passwordRequiredOnEdit && $scope.isEdit && !passwordsModified) {
											$scope.passwordKeep = cvLoc('label.passwordKeep');
											ignorePasswordsValidation();
											return;
										}

										$scope.passwordKeep = '';
										applyPasswordsValidation();
									};

									$scope.passwordsChanged = updatePwdValidationAndPlaceHolder();

									//if isOptional value changes, re-check if password pattern validation is required
									$scope.$watch('isOptional', function() {
										updatePwdValidationAndPlaceHolder();
									});

								}

							}
						} ]);

//export default app;